/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.ext;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsClassLoaderNode;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsDefaultTerminalSpec;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDependencyScopePattern;
import net.thevpc.nuts.NutsExecutorComponent;
import net.thevpc.nuts.NutsExtensionAlreadyRegisteredException;
import net.thevpc.nuts.NutsExtensionInformation;
import net.thevpc.nuts.NutsExtensionNotFoundException;
import net.thevpc.nuts.NutsFetchCommand;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdType;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsInstallerComponent;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsServiceLoader;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSessionTerminal;
import net.thevpc.nuts.NutsTerminalSpec;
import net.thevpc.nuts.NutsTextFormatStyle;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceExtension;
import net.thevpc.nuts.NutsWorkspaceInitInformation;
import net.thevpc.nuts.runtime.bundles.collections.ListMap;
import net.thevpc.nuts.runtime.bundles.parsers.StringTokenizerUtils;
import net.thevpc.nuts.runtime.core.DefaultNutsClassLoader;
import net.thevpc.nuts.runtime.core.NutsWorkspaceFactory;
import net.thevpc.nuts.runtime.core.config.NutsWorkspaceConfigManagerExt;
import net.thevpc.nuts.runtime.core.filters.CoreFilterUtils;
import net.thevpc.nuts.runtime.core.io.NutsFormattedPrintStream;
import net.thevpc.nuts.runtime.core.terminals.DefaultNutsSessionTerminal;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.core.util.CoreNutsDependencyUtils;
import net.thevpc.nuts.runtime.core.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.standalone.DefaultNutsServiceLoader;
import net.thevpc.nuts.runtime.standalone.DefaultNutsWorkspaceFactory;
import net.thevpc.nuts.runtime.standalone.config.NutsWorkspaceConfigBoot;
import net.thevpc.nuts.runtime.standalone.ext.DefaultNutsExtensionInformation;
import net.thevpc.nuts.runtime.standalone.ext.DefaultNutsWorkspaceExtension;
import net.thevpc.nuts.runtime.standalone.util.NutsClassLoaderUtils;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsBootWorkspaceFactory;
import net.thevpc.nuts.spi.NutsComponent;
import net.thevpc.nuts.spi.NutsDescriptorContentParserComponent;
import net.thevpc.nuts.spi.NutsRepositoryFactoryComponent;
import net.thevpc.nuts.spi.NutsSystemTerminalBase;
import net.thevpc.nuts.spi.NutsTransportComponent;
import net.thevpc.nuts.spi.NutsWorkspaceArchetypeComponent;

public class DefaultNutsWorkspaceExtensionModel {
    private NutsLogger LOG;
    private final Set<Class> SUPPORTED_EXTENSION_TYPES = new HashSet<Class>(Arrays.asList(NutsFormattedPrintStream.class, NutsSystemTerminalBase.class, NutsSessionTerminal.class, NutsDescriptorContentParserComponent.class, NutsExecutorComponent.class, NutsInstallerComponent.class, NutsRepositoryFactoryComponent.class, NutsTransportComponent.class, NutsWorkspace.class, NutsWorkspaceArchetypeComponent.class));
    private final ListMap<String, String> defaultWiredComponents = new ListMap();
    private final Set<String> exclusions = new HashSet<String>();
    private final NutsWorkspace ws;
    private final NutsBootWorkspaceFactory bootFactory;
    private final NutsWorkspaceFactory objectFactory;
    private DefaultNutsClassLoader workspaceExtensionsClassLoader;
    private Map<NutsURLClassLoaderKey, DefaultNutsClassLoader> cachedClassLoaders = new HashMap<NutsURLClassLoaderKey, DefaultNutsClassLoader>();
    private Map<NutsId, NutsWorkspaceExtension> extensions = new HashMap<NutsId, NutsWorkspaceExtension>();
    private Set<NutsId> loadedExtensionIds = new LinkedHashSet<NutsId>();
    private Set<URL> loadedExtensionURLs = new LinkedHashSet<URL>();
    private Set<NutsId> unloadedExtensions = new LinkedHashSet<NutsId>();

    public DefaultNutsWorkspaceExtensionModel(NutsWorkspace ws, NutsBootWorkspaceFactory bootFactory, String[] excludedExtensions, NutsSession bootSession) {
        this.ws = ws;
        this.objectFactory = new DefaultNutsWorkspaceFactory(ws);
        this.bootFactory = bootFactory;
        this.setExcludedExtensions(excludedExtensions, bootSession);
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = this.ws.log().setSession(session).of(DefaultNutsWorkspaceExtensionModel.class);
        }
        return this.LOG;
    }

    public boolean isExcludedExtension(NutsId excluded) {
        return this.exclusions.contains(excluded.getShortName());
    }

    public void setExcludedExtensions(String[] excluded, NutsSession session) {
        this.exclusions.clear();
        if (excluded != null) {
            for (String ex : excluded) {
                for (String e : StringTokenizerUtils.split(ex, ",; ")) {
                    NutsId ee = this.ws.id().parser().parse(e);
                    if (ee == null) continue;
                    this.exclusions.add(ee.getShortName());
                }
            }
        }
    }

    public List<NutsExtensionInformation> findWorkspaceExtensions(NutsSession session) {
        return this.findWorkspaceExtensions(this.ws.getApiVersion().toString(), session);
    }

    public List<NutsExtensionInformation> findWorkspaceExtensions(String version, NutsSession session) {
        if (version == null) {
            version = this.ws.getApiVersion().toString();
        }
        NutsId id = this.ws.getApiId().builder().setVersion(version).build();
        return this.findExtensions(id, "extensions", session);
    }

    public List<NutsExtensionInformation> findExtensions(String id, String extensionType, NutsSession session) {
        return this.findExtensions(this.ws.id().parser().setLenient(false).parse(id), extensionType, session);
    }

    public List<NutsExtensionInformation> findExtensions(NutsId id, String extensionType, NutsSession session) {
        if (id.getVersion().isBlank()) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"missing version", (Object[])new Object[0]));
        }
        ArrayList<NutsExtensionInformation> ret = new ArrayList<NutsExtensionInformation>();
        ArrayList<String> allUrls = new ArrayList<String>();
        for (String r : this.getExtensionRepositoryLocations(id)) {
            String url = r + "/" + CoreIOUtils.getPath(id, "." + extensionType, '/');
            allUrls.add(url);
            URL u = this.expandURL(url, session);
            if (u == null) continue;
            NutsExtensionInformation[] s = new NutsExtensionInformation[]{};
            try (InputStreamReader rr = new InputStreamReader(NutsWorkspaceUtils.of(session).openURL(u));){
                s = (NutsExtensionInformation[])this.ws.elem().setContentType(NutsContentType.JSON).parse((Reader)rr, DefaultNutsExtensionInformation[].class);
            }
            catch (IOException ex) {
                this._LOGOP(session).level(Level.SEVERE).error((Throwable)ex).log("failed to parse NutsExtensionInformation from {0} : {1}", new Object[]{u, ex});
            }
            if (s == null) continue;
            for (NutsExtensionInformation nutsExtensionInfo : s) {
                ((DefaultNutsExtensionInformation)nutsExtensionInfo).setSource(u.toString());
                ret.add(nutsExtensionInfo);
            }
        }
        boolean latestVersion = true;
        if (latestVersion && ret.size() > 1) {
            return CoreFilterUtils.filterNutsExtensionInfoByLatestVersion(ret);
        }
        return ret;
    }

    public List<RegInfo> buildRegInfos(NutsSession session) {
        ArrayList<RegInfo> a = new ArrayList<RegInfo>();
        Set<Class> loadedExtensions = this.getExtensionTypes(NutsComponent.class, session);
        for (Class extensionImpl : loadedExtensions) {
            for (Class extensionPointType : this.resolveComponentTypes(extensionImpl)) {
                a.add(new RegInfo(extensionPointType, extensionImpl, null));
            }
        }
        return a;
    }

    public void onInitializeWorkspace(NutsWorkspaceInitInformation info, ClassLoader bootClassLoader, NutsSession session) {
        this.objectFactory.discoverTypes(this.ws.id().setSession(session).parser().parse(info.getRuntimeBootDependencyNode().getId()), info.getRuntimeBootDependencyNode().getURL(), bootClassLoader, session);
        for (NutsClassLoaderNode idurl : info.getExtensionBootDependencyNodes()) {
            this.objectFactory.discoverTypes(this.ws.id().setSession(session).parser().parse(idurl.getId()), idurl.getURL(), bootClassLoader, session);
        }
        this.workspaceExtensionsClassLoader = new DefaultNutsClassLoader("workspaceExtensionsClassLoader", session.getWorkspace(), bootClassLoader);
    }

    public boolean installWorkspaceExtensionComponent(Class extensionPointType, Object extensionImpl, NutsSession session) {
        if (NutsComponent.class.isAssignableFrom(extensionPointType)) {
            if (extensionPointType.isInstance(extensionImpl)) {
                return this.registerInstance(extensionPointType, extensionImpl, session);
            }
            throw new ClassCastException(extensionImpl.getClass().getName());
        }
        throw new ClassCastException(NutsComponent.class.getName());
    }

    public Set<Class> discoverTypes(NutsId id, ClassLoader classLoader, NutsSession session) {
        URL url = this.ws.fetch().setId(id).setSession(session).setContent(true).getResultContent().getURL();
        return this.objectFactory.discoverTypes(id, url, classLoader, session);
    }

    public <T extends NutsComponent<B>, B> NutsServiceLoader<T, B> createServiceLoader(Class<T> serviceType, Class<B> criteriaType, NutsSession session) {
        return this.createServiceLoader(serviceType, criteriaType, null);
    }

    public <T extends NutsComponent<B>, B> NutsServiceLoader<T, B> createServiceLoader(Class<T> serviceType, Class<B> criteriaType, ClassLoader classLoader, NutsSession session) {
        return new DefaultNutsServiceLoader<T, B>(session, serviceType, criteriaType, classLoader);
    }

    public <T extends NutsComponent<V>, V> T createSupported(Class<T> type, V supportCriteria, NutsSession session) {
        return this.objectFactory.createSupported(type, supportCriteria, session);
    }

    public <T extends NutsComponent<V>, V> T createSupported(Class<T> type, V supportCriteria, Class[] constructorParameterTypes, Object[] constructorParameters, NutsSession session) {
        return this.objectFactory.createSupported(type, supportCriteria, constructorParameterTypes, constructorParameters, session);
    }

    public <T extends NutsComponent<V>, V> List<T> createAllSupported(Class<T> type, V supportCriteria, NutsSession session) {
        return this.objectFactory.createAllSupported(type, supportCriteria, session);
    }

    public <T> List<T> createAll(Class<T> type, NutsSession session) {
        return this.objectFactory.createAll(type, session);
    }

    public Set<Class> getExtensionTypes(Class extensionPoint, NutsSession session) {
        return this.objectFactory.getExtensionTypes(extensionPoint, session);
    }

    public List<Object> getExtensionObjects(Class extensionPoint, NutsSession session) {
        return this.objectFactory.getExtensionObjects(extensionPoint);
    }

    public boolean isRegisteredType(Class extensionPointType, String name, NutsSession session) {
        return this.objectFactory.isRegisteredType(extensionPointType, name, session);
    }

    public boolean isRegisteredInstance(Class extensionPointType, Object extensionImpl, NutsSession session) {
        return this.objectFactory.isRegisteredInstance(extensionPointType, extensionImpl, session);
    }

    public boolean registerInstance(Class extensionPointType, Object extensionImpl, NutsSession session) {
        if (!this.isRegisteredType(extensionPointType, extensionImpl.getClass().getName(), session) && !this.isRegisteredInstance(extensionPointType, extensionImpl, session)) {
            this.objectFactory.registerInstance(extensionPointType, extensionImpl, session);
            return true;
        }
        this._LOGOP(session).level(Level.FINE).verb(NutsLogVerb.WARNING).log("Bootstrap Extension Point {0} => {1} ignored. Already registered", new Object[]{extensionPointType.getName(), extensionImpl.getClass().getName()});
        return false;
    }

    public boolean registerType(Class extensionPointType, Class extensionType, NutsId source, NutsSession session) {
        if (!this.isRegisteredType(extensionPointType, extensionType.getName(), session) && !this.isRegisteredType(extensionPointType, extensionType, session)) {
            this.objectFactory.registerType(extensionPointType, extensionType, source, session);
            return true;
        }
        this._LOGOP(session).level(Level.FINE).verb(NutsLogVerb.WARNING).log("Bootstrap Extension Point {0} => {1} ignored. Already registered", new Object[]{extensionPointType.getName(), extensionType.getName()});
        return false;
    }

    public boolean isRegisteredType(Class extensionPointType, Class extensionType, NutsSession session) {
        return this.objectFactory.isRegisteredType(extensionPointType, extensionType, session);
    }

    public boolean isLoadedExtensions(NutsId id, NutsSession session) {
        return this.loadedExtensionIds.stream().anyMatch(x -> x.getShortName().equals(id.getShortName()));
    }

    public List<NutsId> getLoadedExtensions(NutsSession session) {
        return new ArrayList<NutsId>(this.loadedExtensionIds);
    }

    public void loadExtension(NutsId extension, NutsSession session) {
        this.loadExtensions(session, extension);
    }

    public void unloadExtension(NutsId extension, NutsSession session) {
        this.unloadExtensions(new NutsId[]{extension}, session);
    }

    public List<NutsId> getConfigExtensions(NutsSession session) {
        if (this.getStoredConfig().getExtensions() != null) {
            return Collections.unmodifiableList(new ArrayList<NutsWorkspaceConfigBoot.ExtensionConfig>(this.getStoredConfig().getExtensions()).stream().map(NutsWorkspaceConfigBoot.ExtensionConfig::getId).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    public void loadExtensions(NutsSession session, NutsId ... extensions) {
        NutsWorkspaceUtils.checkSession(this.ws, session);
        boolean someUpdates = false;
        for (NutsId extension : extensions) {
            if (extension == null || this.loadedExtensionIds.contains(extension = extension.builder().setVersion("").build())) continue;
            if (this.unloadedExtensions.contains(extension)) {
                this.loadedExtensionIds.add(extension);
                someUpdates = true;
                continue;
            }
            NutsDefinition def = (NutsDefinition)this.ws.search().setSession(session).addId(extension).setTargetApiVersion(this.ws.getApiVersion()).setContent(true).setDependencies(true).setDependencyFilter(CoreNutsDependencyUtils.createJavaRunDependencyFilter(session)).setLatest(true).getResultDefinitions().required();
            if (def == null || def.getContent() == null) {
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"extension not found: %s", (Object[])new Object[]{extension}));
            }
            if (def.getType() != NutsIdType.EXTENSION) {
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"not an extension: ", (Object[])new Object[]{extension}));
            }
            this.workspaceExtensionsClassLoader.add(NutsClassLoaderUtils.definitionToClassLoaderNode(def, session));
            this.objectFactory.discoverTypes(def.getId(), def.getContent().getURL(), this.workspaceExtensionsClassLoader, session);
            this.loadedExtensionIds.add(extension);
            this._LOGOP(session).verb(NutsLogVerb.SUCCESS).style(NutsTextFormatStyle.CSTYLE).formatted(true).log("extension %s loaded", new Object[]{def.getId()});
            someUpdates = true;
        }
        if (someUpdates) {
            this.updateLoadedExtensionURLs(session);
        }
    }

    private void updateLoadedExtensionURLs(NutsSession session) {
        this.loadedExtensionURLs.clear();
        for (NutsDefinition def : this.ws.search().addIds(this.loadedExtensionIds.toArray(new NutsId[0])).setTargetApiVersion(this.ws.getApiVersion()).setSession(session).setContent(true).setDependencies(true).setDependencyFilter(CoreNutsDependencyUtils.createJavaRunDependencyFilter(session)).setLatest(true).getResultDefinitions().list()) {
            this.loadedExtensionURLs.add(def.getContent().getURL());
        }
    }

    public void unloadExtensions(NutsId[] extensions, NutsSession session) {
        boolean someUpdates = false;
        for (NutsId extension : extensions) {
            NutsId u = this.loadedExtensionIds.stream().filter(x -> x.getShortName().equals(extension.getShortName())).findFirst().orElse(null);
            if (u == null) continue;
            if (session.isPlainTrace()) {
                session.out().printf("extensions %s unloaded\n", new Object[]{u});
            }
            this.loadedExtensionIds.remove(u);
            this.unloadedExtensions.add(u);
            someUpdates = true;
        }
        if (someUpdates) {
            this.updateLoadedExtensionURLs(session);
        }
    }

    public NutsWorkspaceExtension[] getWorkspaceExtensions() {
        return this.extensions.values().toArray(new NutsWorkspaceExtension[0]);
    }

    public NutsWorkspaceExtension wireExtension(NutsId id, NutsFetchCommand options) {
        NutsSessionTerminal newTerminal;
        NutsSession session = options.getSession();
        NutsWorkspaceUtils.checkSession(this.ws, session);
        NutsSession searchSession = session.setTrace(Boolean.valueOf(false));
        if (id == null) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"extension Id could not be null", (Object[])new Object[0]));
        }
        NutsId wired = CoreNutsUtils.findNutsIdBySimpleName(id, this.extensions.keySet());
        if (wired != null) {
            throw new NutsExtensionAlreadyRegisteredException(session, id, wired.toString());
        }
        this._LOGOP(session).level(Level.FINE).verb(NutsLogVerb.UPDATE).formatted().log("installing extension {0}", new Object[]{id});
        NutsDefinition nutsDefinitions = (NutsDefinition)this.ws.search().copyFrom(options).setSession(searchSession).addId(id).setSession(session).setOptional(Boolean.valueOf(false)).addScope(NutsDependencyScopePattern.RUN).setDependencyFilter(CoreNutsDependencyUtils.createJavaRunDependencyFilter(session)).setDependencies(true).setLatest(true).getResultDefinitions().required();
        if (!this.isLoadedClassPath(nutsDefinitions, session)) {
            this.workspaceExtensionsClassLoader.add(NutsClassLoaderUtils.definitionToClassLoaderNode(nutsDefinitions, session));
        }
        DefaultNutsWorkspaceExtension workspaceExtension = new DefaultNutsWorkspaceExtension(id, nutsDefinitions.getId(), this.workspaceExtensionsClassLoader);
        this.objectFactory.discoverTypes(nutsDefinitions.getId(), nutsDefinitions.getContent().getURL(), workspaceExtension.getClassLoader(), session);
        this.extensions.put(id, workspaceExtension);
        this._LOGOP(session).level(Level.FINE).verb(NutsLogVerb.UPDATE).formatted().log("extension {0} installed successfully", new Object[]{id});
        NutsDefaultTerminalSpec spec = new NutsDefaultTerminalSpec();
        if (session.getTerminal() != null) {
            spec.put("ignoreClass", session.getTerminal().getClass());
        }
        if ((newTerminal = this.createTerminal((NutsTerminalSpec)spec, session)) != null) {
            this._LOGOP(session).level(Level.FINE).verb(NutsLogVerb.UPDATE).formatted().log("extension {0} changed Terminal configuration. Reloading Session Terminal", new Object[]{id});
            session.setTerminal(newTerminal);
        }
        return workspaceExtension;
    }

    /*
     * Exception decompiling
     */
    private boolean isLoadedClassPath(NutsDefinition file, NutsSession session) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 18[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<Class> resolveComponentTypes(Class o) {
        ArrayList<Class> a = new ArrayList<Class>();
        if (o != null) {
            HashSet<Class> v = new HashSet<Class>();
            Stack s = new Stack();
            s.push(o);
            while (!s.isEmpty()) {
                Class c = (Class)s.pop();
                v.add(c);
                if (this.SUPPORTED_EXTENSION_TYPES.contains(c)) {
                    a.add(c);
                }
                for (Class<?> aa : c.getInterfaces()) {
                    if (v.contains(aa)) continue;
                    s.push(aa);
                }
                Class sc = c.getSuperclass();
                if (sc == null || v.contains(sc)) continue;
                s.push(sc);
            }
        }
        return a;
    }

    public NutsSessionTerminal createTerminal(NutsTerminalSpec spec, NutsSession session) {
        NutsSystemTerminalBase termb = this.createSupported(NutsSystemTerminalBase.class, spec, session);
        if (termb == null) {
            throw new NutsExtensionNotFoundException(session, NutsSystemTerminalBase.class, "TerminalBase");
        }
        if (spec != null && spec.get("ignoreClass") != null && spec.get("ignoreClass").equals(termb.getClass())) {
            return null;
        }
        return new DefaultNutsSessionTerminal(session, termb);
    }

    public URL[] getExtensionURLLocations(NutsId nutsId, String appId, String extensionType, NutsSession session) {
        ArrayList<URL> bootUrls = new ArrayList<URL>();
        for (String r : this.getExtensionRepositoryLocations(nutsId)) {
            String url = r + "/" + CoreIOUtils.getPath(nutsId, "." + extensionType, '/');
            URL u = this.expandURL(url, session);
            bootUrls.add(u);
        }
        return bootUrls.toArray(new URL[0]);
    }

    public String[] getExtensionRepositoryLocations(NutsId appId) {
        String repos = this.ws.env().getEnv("bootstrapRepositoryLocations", "") + ";";
        ArrayList<String> urls = new ArrayList<String>();
        for (String r : StringTokenizerUtils.split(repos, "; ")) {
            if (NutsUtilStrings.isBlank((CharSequence)r)) continue;
            urls.add(r);
        }
        return urls.toArray(new String[0]);
    }

    protected URL expandURL(String url, NutsSession session) {
        try {
            url = this.ws.io().expandPath(url);
            if (CoreIOUtils.isPathHttp(url)) {
                return new URL(url);
            }
            if (CoreIOUtils.isPathFile(url)) {
                return CoreIOUtils.toPathFile(url, session).toUri().toURL();
            }
            return new File(url).toURI().toURL();
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    private NutsWorkspaceConfigManagerExt configExt() {
        return NutsWorkspaceConfigManagerExt.of(this.ws.config());
    }

    private NutsWorkspaceConfigBoot getStoredConfig() {
        return this.configExt().getModel().getStoredConfigBoot();
    }

    public synchronized DefaultNutsClassLoader getNutsURLClassLoader(String name, ClassLoader parent, NutsSession session) {
        if (parent == null) {
            parent = this.workspaceExtensionsClassLoader;
        }
        return new DefaultNutsClassLoader(name, session.getWorkspace(), parent);
    }

    public NutsWorkspace getWorkspace() {
        return this.ws;
    }

    private static class NutsURLClassLoaderKey {
        private final URL[] urls;
        private final ClassLoader parent;

        public NutsURLClassLoaderKey(URL[] urls, ClassLoader parent) {
            this.urls = urls;
            this.parent = parent;
        }

        public int hashCode() {
            int hash = 3;
            hash = 13 * hash + Arrays.deepHashCode(this.urls);
            hash = 13 * hash + Objects.hashCode(this.parent);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NutsURLClassLoaderKey other = (NutsURLClassLoaderKey)obj;
            if (!Arrays.deepEquals(this.urls, other.urls)) {
                return false;
            }
            return Objects.equals(this.parent, other.parent);
        }
    }

    public static class RegInfo {
        Class extensionPointType;
        Class extensionTypeImpl;
        NutsId extensionId;

        public RegInfo(Class extensionPointType, Class extensionTypeImpl, NutsId extensionId) {
            this.extensionPointType = extensionPointType;
            this.extensionTypeImpl = extensionTypeImpl;
            this.extensionId = extensionId;
        }

        public NutsId getExtensionId() {
            return this.extensionId;
        }

        public Class getExtensionPointType() {
            return this.extensionPointType;
        }

        public Class getExtensionTypeImpl() {
            return this.extensionTypeImpl;
        }
    }
}

