/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.executors;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import net.thevpc.nuts.NutsContent;
import net.thevpc.nuts.NutsDefaultContent;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsExecutionContext;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsExecutorComponent;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSingleton;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsSupportLevelContext;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.core.model.DefaultNutsDefinition;
import net.thevpc.nuts.runtime.core.util.CoreArrayUtils;
import net.thevpc.nuts.runtime.standalone.executors.JavaExecutorComponent;

@NutsSingleton
public class JavaSourceExecutorComponent
implements NutsExecutorComponent {
    public static NutsId ID;
    NutsWorkspace ws;

    public NutsId getId() {
        return ID;
    }

    public int getSupportLevel(NutsSupportLevelContext<NutsDefinition> nutsDefinition) {
        this.ws = nutsDefinition.getWorkspace();
        if (ID == null) {
            ID = this.ws.id().parser().parse("net.thevpc.nuts.exec:exec-java-src");
        }
        if ("java".equals(((NutsDefinition)nutsDefinition.getConstraints()).getDescriptor().getPackaging())) {
            return 11;
        }
        return -1;
    }

    public void dryExec(NutsExecutionContext executionContext) throws NutsExecutionException {
        NutsDefinition nutMainFile = executionContext.getDefinition();
        Path javaFile = nutMainFile.getPath();
        NutsWorkspace ws = executionContext.getWorkspace();
        String folder = "__temp_folder";
        NutsPrintStream out = executionContext.getTraceSession().out();
        out.println((NutsString)executionContext.getWorkspace().text().forStyled("compile", NutsTextStyle.primary4()));
        out.printf("%s%n", new Object[]{executionContext.getWorkspace().commandLine().create(new String[]{"embedded-javac", "-d", "<temp-folder>", javaFile.toString()})});
        JavaExecutorComponent cc = new JavaExecutorComponent();
        NutsDefinition d = executionContext.getDefinition();
        d = new DefaultNutsDefinition(d, executionContext.getTraceSession());
        ((DefaultNutsDefinition)d).setContent((NutsContent)new NutsDefaultContent(executionContext.getTraceSession().getWorkspace().io().path(folder), false, true));
        String fileName = javaFile.getFileName().toString();
        NutsExecutionContext executionContext2 = NutsWorkspaceExt.of(executionContext.getWorkspace()).createExecutionContext().setAll(executionContext).setDefinition(d).setExecutorArguments(CoreArrayUtils.concatArrays(executionContext.getExecutorArguments(), {"--main-class", new File(fileName.substring(fileName.length() - ".java".length())).getName(), "--class-path", folder.toString()})).setFailFast(true).setTemporary(true).build();
        cc.dryExec(executionContext2);
    }

    public void exec(NutsExecutionContext executionContext) {
        NutsDefinition nutMainFile = executionContext.getDefinition();
        Path javaFile = nutMainFile.getPath();
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        NutsWorkspace ws = executionContext.getWorkspace();
        Path folder = Paths.get(ws.io().tmp().setSession(executionContext.getTraceSession()).createTempFolder("jj"), new String[0]);
        int res = compiler.run(null, null, null, "-d", folder.toString(), javaFile.toString());
        if (res != 0) {
            throw new NutsExecutionException(executionContext.getTraceSession(), NutsMessage.cstyle((String)"compilation failed", (Object[])new Object[0]), res);
        }
        JavaExecutorComponent cc = new JavaExecutorComponent();
        NutsDefinition d = executionContext.getDefinition();
        d = new DefaultNutsDefinition(d, executionContext.getTraceSession());
        ((DefaultNutsDefinition)d).setContent((NutsContent)new NutsDefaultContent(executionContext.getTraceSession().getWorkspace().io().path(folder.toString()), false, true));
        String fileName = javaFile.getFileName().toString();
        NutsExecutionContext executionContext2 = NutsWorkspaceExt.of(executionContext.getWorkspace()).createExecutionContext().setAll(executionContext).setDefinition(d).setExecutorArguments(CoreArrayUtils.concatArrays(executionContext.getExecutorArguments(), {"--main-class", new File(fileName.substring(fileName.length() - ".java".length())).getName(), "--class-path", folder.toString()})).setFailFast(true).setTemporary(true).build();
        cc.exec(executionContext2);
    }
}

