/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.executors;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsApplications;
import net.thevpc.nuts.NutsClassLoaderNode;
import net.thevpc.nuts.NutsCommandlineFamily;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsExecutionContext;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsExecutorComponent;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsLogConfig;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSingleton;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsSupportLevelContext;
import net.thevpc.nuts.NutsTextManager;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceOptionsBuilder;
import net.thevpc.nuts.runtime.bundles.collections.StringKeyValueList;
import net.thevpc.nuts.runtime.bundles.io.IProcessExecHelper;
import net.thevpc.nuts.runtime.core.DefaultNutsClassLoader;
import net.thevpc.nuts.runtime.core.util.CoreBooleanUtils;
import net.thevpc.nuts.runtime.core.util.CoreNumberUtils;
import net.thevpc.nuts.runtime.core.util.ProcessExecHelper;
import net.thevpc.nuts.runtime.standalone.executors.AbstractSyncIProcessExecHelper;
import net.thevpc.nuts.runtime.standalone.executors.ClassloaderAwareRunnable;
import net.thevpc.nuts.runtime.standalone.executors.JavaExecutorOptions;
import net.thevpc.nuts.runtime.standalone.ext.DefaultNutsWorkspaceExtensionManager;

@NutsSingleton
public class JavaExecutorComponent
implements NutsExecutorComponent {
    public static NutsId ID;
    NutsWorkspace ws;

    public NutsId getId() {
        return ID;
    }

    public void exec(NutsExecutionContext executionContext) {
        this.execHelper(executionContext).exec();
    }

    public void dryExec(NutsExecutionContext executionContext) throws NutsExecutionException {
        this.execHelper(executionContext).dryExec();
    }

    public int getSupportLevel(NutsSupportLevelContext<NutsDefinition> nutsDefinition) {
        String shortName;
        this.ws = nutsDefinition.getWorkspace();
        if (ID == null) {
            ID = this.ws.id().parser().parse("net.thevpc.nuts.exec:java");
        }
        if ("net.thevpc.nuts.exec:exec-java".equals(shortName = ((NutsDefinition)nutsDefinition.getConstraints()).getId().getShortName())) {
            return 11;
        }
        if ("java".equals(shortName)) {
            return 11;
        }
        if ("jar".equals(((NutsDefinition)nutsDefinition.getConstraints()).getDescriptor().getPackaging())) {
            return 11;
        }
        return -1;
    }

    public IProcessExecHelper execHelper(NutsExecutionContext executionContext) {
        String bootArgumentsString;
        NutsDefinition def = executionContext.getDefinition();
        NutsWorkspace ws = executionContext.getWorkspace();
        Path contentFile = def.getPath();
        JavaExecutorOptions joptions = new JavaExecutorOptions(def, executionContext.isTemporary(), executionContext.getArguments(), executionContext.getExecutorArguments(), NutsUtilStrings.isBlank((CharSequence)executionContext.getCwd()) ? System.getProperty("user.dir") : executionContext.getCwd(), executionContext.getTraceSession());
        NutsSession execSession = executionContext.getExecSession();
        switch (executionContext.getExecutionType()) {
            case EMBEDDED: {
                return new EmbeddedProcessExecHelper(def, execSession, joptions, execSession.out());
            }
        }
        StringKeyValueList runnerProps = new StringKeyValueList();
        if (executionContext.getExecutorDescriptor() != null) {
            runnerProps.add(executionContext.getExecutorDescriptor().getProperties());
        }
        if (executionContext.getEnv() != null) {
            runnerProps.add(executionContext.getEnv());
        }
        HashMap<String, String> osEnv = new HashMap<String, String>();
        NutsWorkspaceOptionsBuilder options = ws.env().getBootOptions().builder();
        options.setDry(Boolean.valueOf(execSession.isDry()));
        options.setGui(Boolean.valueOf(execSession.isGui()));
        options.setOutLinePrefix(execSession.getOutLinePrefix());
        options.setErrLinePrefix(execSession.getErrLinePrefix());
        options.setDebug(Boolean.valueOf(execSession.isDebug()));
        options.setTrace(Boolean.valueOf(execSession.isTrace()));
        options.setBot(Boolean.valueOf(execSession.isBot()));
        options.setCached(Boolean.valueOf(execSession.isCached()));
        options.setIndexed(Boolean.valueOf(execSession.isIndexed()));
        options.setConfirm(execSession.getConfirm());
        options.setTransitive(Boolean.valueOf(execSession.isTransitive()));
        options.setOutputFormat(execSession.getOutputFormat());
        if (null == options.getTerminalMode()) {
            options.setTerminalMode(execSession.getTerminal().out().mode());
        } else {
            switch (options.getTerminalMode()) {
                case FILTERED: {
                    break;
                }
                case INHERITED: {
                    break;
                }
                default: {
                    options.setTerminalMode(execSession.getTerminal().out().mode());
                }
            }
        }
        NutsVersion nutsDependencyVersion = null;
        for (String s : joptions.getClassPathNidStrings()) {
            if (s.startsWith("net.thevpc.nuts:nuts#")) {
                String v = s.substring("net.thevpc.nuts:nuts#".length());
                nutsDependencyVersion = executionContext.getWorkspace().version().parser().parse(v);
                continue;
            }
            Pattern pp = Pattern.compile(".*[/\\\\]nuts-(?<v>[0-9.]+)[.]jar");
            Matcher mm = pp.matcher(s);
            if (!mm.find()) continue;
            String v = mm.group("v");
            nutsDependencyVersion = executionContext.getWorkspace().version().parser().parse(v);
            break;
        }
        options.setExpireTime(execSession.getExpireTime());
        Filter logFileFilter = execSession.getLogFileFilter();
        Filter logTermFilter = execSession.getLogTermFilter();
        Level logTermLevel = execSession.getLogTermLevel();
        Level logFileLevel = execSession.getLogFileLevel();
        if (logFileFilter != null || logTermFilter != null || logTermLevel != null || logFileLevel != null) {
            NutsLogConfig lc = options.getLogConfig();
            lc = lc == null ? new NutsLogConfig() : lc.copy();
            if (logTermLevel != null) {
                lc.setLogTermLevel(logTermLevel);
            }
            if (logFileLevel != null) {
                lc.setLogFileLevel(logFileLevel);
            }
            if (logTermFilter != null) {
                lc.setLogTermFilter(logTermFilter);
            }
            if (logFileFilter != null) {
                lc.setLogFileFilter(logFileFilter);
            }
        }
        if (!NutsUtilStrings.isBlank((CharSequence)(bootArgumentsString = options.formatter().setExported(true).setApiVersion(nutsDependencyVersion == null ? null : nutsDependencyVersion.toString()).setCompact(true).getBootCommandLine().formatter().setCommandlineFamily(NutsCommandlineFamily.BASH).toString()))) {
            osEnv.put("nuts_boot_args", bootArgumentsString);
            joptions.getJvmArgs().add("-Dnuts.boot.args=" + bootArgumentsString);
        }
        Properties sysProperties = System.getProperties();
        for (Object k : sysProperties.keySet()) {
            String sk = (String)k;
            if (!sk.startsWith("nuts.export.")) continue;
            joptions.getJvmArgs().add("-D" + sk + "=" + sysProperties.getProperty(sk));
        }
        int maxDepth = Math.abs(CoreNumberUtils.convertToInteger(sysProperties.getProperty("nuts.export.watchdog.max-depth"), 24));
        if (maxDepth > 64) {
            maxDepth = 64;
        }
        int currentDepth = CoreNumberUtils.convertToInteger(sysProperties.getProperty("nuts.export.watchdog.depth"), -1);
        if (++currentDepth > maxDepth) {
            System.err.println("[[Process Stack Overflow Error]]");
            System.err.println("it is very likely that you executed an infinite process creation recursion in your program.");
            System.err.println("at least " + currentDepth + " (>=" + maxDepth + ") processes were created.");
            System.err.println("are you aware of such misconception ?");
            System.err.println("sorry but we need to end all of this disgracefully...");
            System.exit(233);
        }
        ArrayList<NutsString> xargs = new ArrayList<NutsString>();
        ArrayList<String> args = new ArrayList<String>();
        NutsTextManager txt = execSession.getWorkspace().text();
        xargs.add((NutsString)txt.forPlain(joptions.getJavaHome()));
        xargs.addAll(joptions.getJvmArgs().stream().map(arg_0 -> ((NutsTextManager)txt).forPlain(arg_0)).collect(Collectors.toList()));
        args.add(joptions.getJavaHome());
        args.addAll(joptions.getJvmArgs());
        String jdb = ws.env().getOption("jdb", null);
        if (jdb != null) {
            boolean suspend = true;
            int port = 5005;
            block19: for (String arg : jdb.split("[ ,]")) {
                if ((arg = arg.trim()).length() <= 0) continue;
                if (arg.matches("[0-9]+")) {
                    port = Integer.parseInt(arg);
                    continue;
                }
                switch (arg) {
                    case "suspend": {
                        suspend = true;
                        continue block19;
                    }
                    case "no-suspend": {
                        suspend = false;
                        continue block19;
                    }
                    case "!suspend": {
                        suspend = false;
                    }
                }
            }
            String ds = "-agentlib:jdwp=transport=dt_socket,server=y,suspend=" + (suspend ? (char)'y' : 'n') + ",address=" + port;
            xargs.add((NutsString)txt.forPlain(ds));
            args.add(ds);
        }
        if (joptions.isJar()) {
            xargs.add((NutsString)txt.forPlain("-jar"));
            xargs.add(ws.id().formatter(def.getId()).format());
            args.add("-jar");
            args.add(contentFile.toString());
        } else {
            xargs.add((NutsString)txt.forPlain("--nuts-path"));
            xargs.add(txt.builder().appendJoined((Object)";", joptions.getClassPathNidStrings()).immutable());
            xargs.add((NutsString)txt.forPlain(joptions.getMainClass()));
            args.add("-classpath");
            args.add(String.join((CharSequence)File.pathSeparator, joptions.getClassPathStrings()));
            args.add(joptions.getMainClass());
        }
        xargs.addAll(joptions.getApp().stream().map(arg_0 -> ((NutsTextManager)txt).forPlain(arg_0)).collect(Collectors.toList()));
        args.addAll(joptions.getApp());
        return new JavaProcessExecHelper(execSession, execSession, xargs, joptions, ws, executionContext, def, args, osEnv);
    }

    private static class JavaProcessExecHelper
    extends AbstractSyncIProcessExecHelper {
        private final NutsSession execSession;
        private final List<NutsString> xargs;
        private final JavaExecutorOptions joptions;
        private final NutsWorkspace ws;
        private final NutsExecutionContext executionContext;
        private final NutsDefinition def;
        private final List<String> args;
        private final HashMap<String, String> osEnv;

        public JavaProcessExecHelper(NutsSession ns, NutsSession execSession, List<NutsString> xargs, JavaExecutorOptions joptions, NutsWorkspace ws, NutsExecutionContext executionContext, NutsDefinition def, List<String> args, HashMap<String, String> osEnv) {
            super(ns);
            this.execSession = execSession;
            this.xargs = xargs;
            this.joptions = joptions;
            this.ws = ws;
            this.executionContext = executionContext;
            this.def = def;
            this.args = args;
            this.osEnv = osEnv;
        }

        @Override
        public void dryExec() {
            NutsPrintStream out = this.execSession.out();
            out.println("[dry] ==[nuts-exec]== ");
            for (int i = 0; i < this.xargs.size(); ++i) {
                NutsString xarg = this.xargs.get(i);
                out.println("\t\t " + xarg);
            }
            String directory = NutsUtilStrings.isBlank((CharSequence)this.joptions.getDir()) ? null : this.ws.io().expandPath(this.joptions.getDir());
            ProcessExecHelper.ofDefinition(this.def, this.args.toArray(new String[0]), this.osEnv, directory, this.executionContext.getExecutorProperties(), this.joptions.isShowCommand(), true, this.executionContext.getSleepMillis(), this.executionContext.isInheritSystemIO(), false, NutsUtilStrings.isBlank((CharSequence)this.executionContext.getRedirectOutputFile()) ? null : new File(this.executionContext.getRedirectOutputFile()), NutsUtilStrings.isBlank((CharSequence)this.executionContext.getRedirectInputFile()) ? null : new File(this.executionContext.getRedirectInputFile()), this.executionContext.getRunAs(), this.executionContext.getTraceSession(), this.execSession).dryExec();
        }

        @Override
        public int exec() {
            return this.preExec().exec();
        }

        private ProcessExecHelper preExec() {
            if (this.joptions.isShowCommand() || CoreBooleanUtils.getSysBoolNutsProperty("show-command", false)) {
                NutsPrintStream out = this.execSession.out();
                out.printf("%s %n", new Object[]{this.ws.text().forStyled("nuts-exec", NutsTextStyle.primary1())});
                for (int i = 0; i < this.xargs.size(); ++i) {
                    NutsString xarg = this.xargs.get(i);
                    out.println("\t\t " + xarg);
                }
            }
            String directory = NutsUtilStrings.isBlank((CharSequence)this.joptions.getDir()) ? null : this.ws.io().expandPath(this.joptions.getDir());
            return ProcessExecHelper.ofDefinition(this.def, this.args.toArray(new String[0]), this.osEnv, directory, this.executionContext.getExecutorProperties(), this.joptions.isShowCommand(), true, this.executionContext.getSleepMillis(), this.executionContext.isInheritSystemIO(), false, NutsUtilStrings.isBlank((CharSequence)this.executionContext.getRedirectOutputFile()) ? null : new File(this.executionContext.getRedirectOutputFile()), NutsUtilStrings.isBlank((CharSequence)this.executionContext.getRedirectInputFile()) ? null : new File(this.executionContext.getRedirectInputFile()), this.executionContext.getRunAs(), this.executionContext.getTraceSession(), this.execSession);
        }

        @Override
        public Future<Integer> execAsync() {
            return this.preExec().execAsync();
        }
    }

    static class ClassloaderAwareRunnableImpl2
    extends ClassloaderAwareRunnable {
        private final Class<?> cls;
        private final JavaExecutorOptions joptions;
        private final NutsId id;

        public ClassloaderAwareRunnableImpl2(NutsId id, ClassLoader classLoader, Class<?> cls, NutsSession session, JavaExecutorOptions joptions) {
            super(session.copy(), classLoader);
            this.id = id;
            this.cls = cls;
            this.joptions = joptions;
        }

        @Override
        public Object runWithContext() throws Throwable {
            Method mainMethod = null;
            if (this.cls.getName().equals("net.thevpc.nuts.Nuts")) {
                mainMethod = this.cls.getMethod("run", NutsSession.class, String[].class);
                mainMethod.setAccessible(true);
                NutsApplications.getSharedMap().put("nuts.embedded.application.id", this.id);
                mainMethod.invoke(null, this.getSession(), this.joptions.getApp().toArray(new String[0]));
                return null;
            }
            boolean isNutsApp = false;
            Object nutsApp = null;
            try {
                mainMethod = this.cls.getMethod("run", NutsSession.class, String[].class);
                mainMethod.setAccessible(true);
                for (Class<?> pi : this.cls.getInterfaces()) {
                    if (!pi.getName().equals("net.thevpc.nuts.NutsApplication")) continue;
                    isNutsApp = true;
                    break;
                }
                block3: for (Class<?> p = this.cls.getSuperclass(); !isNutsApp && p != null; p = p.getSuperclass()) {
                    if (p.getName().equals("net.thevpc.nuts.NutsApplication") || p.getName().equals("net.vpc.app.nuts.NutsApplication")) {
                        isNutsApp = true;
                        break;
                    }
                    for (Class<?> pi : this.cls.getInterfaces()) {
                        if (!pi.getName().equals("net.thevpc.nuts.NutsApplication")) continue;
                        isNutsApp = true;
                        continue block3;
                    }
                }
                if (isNutsApp) {
                    isNutsApp = false;
                    nutsApp = this.cls.getConstructor(new Class[0]).newInstance(new Object[0]);
                    isNutsApp = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (isNutsApp) {
                NutsApplications.getSharedMap().put("nuts.embedded.application.id", this.id);
                mainMethod.invoke(nutsApp, this.getSession().copy(), this.joptions.getApp().toArray(new String[0]));
            } else {
                System.setProperty("nuts.boot.args", this.getSession().getWorkspace().env().getBootOptions().formatter().setExported(true).setCompact(true).getBootCommandLine().formatter().setCommandlineFamily(NutsCommandlineFamily.BASH).toString());
                mainMethod = this.cls.getMethod("main", String[].class);
                mainMethod.invoke(null, new Object[]{this.joptions.getApp().toArray(new String[0])});
            }
            return null;
        }
    }

    static class EmbeddedProcessExecHelper
    extends AbstractSyncIProcessExecHelper {
        private NutsDefinition def;
        private JavaExecutorOptions joptions;
        private NutsPrintStream out;

        public EmbeddedProcessExecHelper(NutsDefinition def, NutsSession session, JavaExecutorOptions joptions, NutsPrintStream out) {
            super(session);
            this.def = def;
            this.joptions = joptions;
            this.out = out;
        }

        @Override
        public void dryExec() {
            NutsTextManager text = this.getSession().getWorkspace().text();
            ArrayList<String> cmdLine = new ArrayList<String>();
            cmdLine.add("embedded-java");
            cmdLine.add("-cp");
            cmdLine.add(String.join((CharSequence)":", this.joptions.getClassPathStrings()));
            cmdLine.add(this.joptions.getMainClass());
            cmdLine.addAll(this.joptions.getApp());
            this.getSession().out().printf("[dry] %s%n", new Object[]{text.builder().append((Object)"exec", NutsTextStyle.pale()).append((Object)" ").append((Object)this.getSession().getWorkspace().commandLine().create(cmdLine))});
        }

        @Override
        public int exec() {
            NutsSession session = this.getSession();
            if ((session = session.copy()).out() != null) {
                session.out().resetLine();
            }
            DefaultNutsClassLoader classLoader = null;
            Throwable th = null;
            try {
                classLoader = ((DefaultNutsWorkspaceExtensionManager)session.getWorkspace().extensions()).getModel().getNutsURLClassLoader(this.def.getId().toString(), null, session);
                for (NutsClassLoaderNode n : this.joptions.getClassPath()) {
                    classLoader.add(n);
                }
                Class<?> cls = Class.forName(this.joptions.getMainClass(), true, classLoader);
                new ClassloaderAwareRunnableImpl2(this.def.getId(), classLoader, cls, session, this.joptions).runAndWaitFor();
                return 0;
            }
            catch (InvocationTargetException e) {
                th = e.getTargetException();
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | MalformedURLException e) {
                th = e;
            }
            catch (Throwable ex) {
                th = ex;
            }
            if (th != null) {
                if (!(th instanceof NutsExecutionException)) {
                    throw new NutsExecutionException(session, NutsMessage.cstyle((String)"error executing %s : %s", (Object[])new Object[]{this.def.getId(), th}), th);
                }
                NutsExecutionException nex = (NutsExecutionException)th;
                if (nex.getExitCode() != 0) {
                    throw new NutsExecutionException(session, NutsMessage.cstyle((String)"error executing %s : %s", (Object[])new Object[]{this.def.getId(), th}), th);
                }
            }
            return 0;
        }
    }
}

