/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.config.compat.v506;

import java.nio.file.Paths;
import java.util.List;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUserConfig;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.config.NutsWorkspaceConfigApi;
import net.thevpc.nuts.runtime.standalone.config.NutsWorkspaceConfigBoot;
import net.thevpc.nuts.runtime.standalone.config.NutsWorkspaceConfigMain;
import net.thevpc.nuts.runtime.standalone.config.NutsWorkspaceConfigRuntime;
import net.thevpc.nuts.runtime.standalone.config.NutsWorkspaceConfigSecurity;
import net.thevpc.nuts.runtime.standalone.config.compat.AbstractNutsVersionCompat;
import net.thevpc.nuts.runtime.standalone.config.compat.CompatUtils;
import net.thevpc.nuts.runtime.standalone.config.compat.v506.NutsWorkspaceConfigBoot506;

public class NutsVersionCompat506
extends AbstractNutsVersionCompat {
    public NutsVersionCompat506(NutsWorkspace ws, String apiVersion) {
        super(ws, apiVersion, 506);
    }

    @Override
    public NutsWorkspaceConfigBoot parseConfig(byte[] bytes, NutsSession session) {
        return this.parseConfig506(bytes).toWorkspaceConfig();
    }

    @Override
    public NutsWorkspaceConfigApi parseApiConfig(NutsSession session) {
        NutsWorkspaceConfigApi cc = new NutsWorkspaceConfigApi();
        cc.setApiVersion(this.getApiVersion());
        NutsWorkspaceConfigBoot506 c = this.parseConfig506(CompatUtils.readAllBytes(Paths.get(this.getWorkspace().locations().getWorkspaceLocation(), new String[0]).resolve("nuts-workspace.json")));
        if (c != null) {
            cc.setApiVersion(c.getApiVersion());
            cc.setRuntimeId(c.getRuntimeId());
            cc.setJavaCommand(c.getJavaCommand());
            cc.setJavaOptions(c.getJavaOptions());
        }
        return cc;
    }

    @Override
    public NutsWorkspaceConfigRuntime parseRuntimeConfig(NutsSession session) {
        NutsWorkspaceConfigRuntime cc = new NutsWorkspaceConfigRuntime();
        NutsWorkspaceConfigBoot506 c = this.parseConfig506(CompatUtils.readAllBytes(Paths.get(this.getWorkspace().locations().getWorkspaceLocation(), new String[0]).resolve("nuts-workspace.json")));
        if (c != null) {
            cc.setDependencies(c.getRuntimeDependencies());
            cc.setId(c.getRuntimeId());
        }
        return cc;
    }

    @Override
    public NutsWorkspaceConfigSecurity parseSecurityConfig(NutsSession session) {
        NutsWorkspaceConfigSecurity cc = new NutsWorkspaceConfigSecurity();
        NutsWorkspaceConfigBoot506 c = this.parseConfig506(CompatUtils.readAllBytes(Paths.get(this.getWorkspace().locations().getWorkspaceLocation(), new String[0]).resolve("nuts-workspace.json")));
        if (c != null) {
            cc.setSecure(c.isSecure());
            cc.setAuthenticationAgent(c.getAuthenticationAgent());
            List<NutsUserConfig> users = c.getUsers();
            cc.setUsers(CompatUtils.copyNutsUserConfigArray(users == null ? null : users.toArray(new NutsUserConfig[0])));
        }
        return cc;
    }

    @Override
    public NutsWorkspaceConfigMain parseMainConfig(NutsSession session) {
        NutsWorkspaceConfigMain cc = new NutsWorkspaceConfigMain();
        NutsWorkspaceConfigBoot506 c = this.parseConfig506(CompatUtils.readAllBytes(Paths.get(this.getWorkspace().locations().getWorkspaceLocation(), new String[0]).resolve("nuts-workspace.json")));
        if (c != null) {
            c.setRepositories(CompatUtils.copyNutsRepositoryRefList(c.getRepositories()));
            c.setCommandFactories(CompatUtils.copyNutsCommandAliasFactoryConfigList(c.getCommandFactories()));
            c.setEnv(CompatUtils.copyProperties(c.getEnv()));
            c.setSdk(CompatUtils.copyNutsSdkLocationList(c.getSdk()));
            c.setImports(CompatUtils.copyStringList(c.getImports()));
        }
        return cc;
    }

    private NutsWorkspaceConfigBoot506 parseConfig506(byte[] bytes) {
        return (NutsWorkspaceConfigBoot506)((Object)this.getWorkspace().elem().setContentType(NutsContentType.JSON).parse(bytes, NutsWorkspaceConfigBoot506.class));
    }
}

