/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.config.compat.v502;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.thevpc.nuts.NutsRepositoryConfig;
import net.thevpc.nuts.NutsRepositoryRef;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsStoreLocationStrategy;
import net.thevpc.nuts.NutsUserConfig;
import net.thevpc.nuts.runtime.standalone.NutsStoreLocationsMap;

public class NutsRepositoryConfig502
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String uuid;
    private String name;
    private String type;
    private String location;
    private String programsStoreLocation = null;
    private String configStoreLocation = null;
    private String varStoreLocation = null;
    private String libStoreLocation = null;
    private String logStoreLocation = null;
    private String tempStoreLocation = null;
    private String cacheStoreLocation = null;
    private String runStoreLocation = null;
    private NutsStoreLocationStrategy storeLocationStrategy = null;
    private String groups;
    private Map<String, String> env;
    private List<NutsRepositoryRef> mirrors;
    private List<NutsUserConfig> users;
    private boolean indexEnabled;
    private String authenticationAgent;

    public NutsRepositoryConfig502() {
    }

    public NutsRepositoryConfig502(NutsRepositoryConfig502 other) {
        this.name = other.getName();
        this.uuid = other.getUuid();
        this.location = other.getLocation();
        this.type = other.getType();
        this.groups = other.getGroups();
        this.programsStoreLocation = other.programsStoreLocation;
        this.configStoreLocation = other.configStoreLocation;
        this.varStoreLocation = other.varStoreLocation;
        this.libStoreLocation = other.libStoreLocation;
        this.logStoreLocation = other.logStoreLocation;
        this.tempStoreLocation = other.tempStoreLocation;
        this.cacheStoreLocation = other.cacheStoreLocation;
        this.storeLocationStrategy = other.storeLocationStrategy;
        this.indexEnabled = other.indexEnabled;
        this.authenticationAgent = other.authenticationAgent;
        this.mirrors = other.getMirrors() == null ? null : new ArrayList<NutsRepositoryRef>(other.getMirrors());
        ArrayList<NutsUserConfig> arrayList = this.users = other.getUsers() == null ? null : new ArrayList<NutsUserConfig>(other.getUsers());
        if (other.getEnv() == null) {
            this.env = null;
        } else {
            this.env = new LinkedHashMap<String, String>();
            this.env.putAll(other.getEnv());
        }
    }

    public NutsRepositoryConfig502(String name, String location, String type) {
        this.name = name;
        this.location = location;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public NutsRepositoryConfig502 setName(String name) {
        this.name = name;
        return this;
    }

    public String getUuid() {
        return this.uuid;
    }

    public NutsRepositoryConfig502 setUuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public NutsRepositoryConfig502 setType(String type) {
        this.type = type;
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    public NutsRepositoryConfig502 setLocation(String location) {
        this.location = location;
        return this;
    }

    public String getProgramsStoreLocation() {
        return this.programsStoreLocation;
    }

    public NutsRepositoryConfig502 setProgramsStoreLocation(String programsStoreLocation) {
        this.programsStoreLocation = programsStoreLocation;
        return this;
    }

    public String getConfigStoreLocation() {
        return this.configStoreLocation;
    }

    public NutsRepositoryConfig502 setConfigStoreLocation(String configStoreLocation) {
        this.configStoreLocation = configStoreLocation;
        return this;
    }

    public String getVarStoreLocation() {
        return this.varStoreLocation;
    }

    public NutsRepositoryConfig502 setVarStoreLocation(String varStoreLocation) {
        this.varStoreLocation = varStoreLocation;
        return this;
    }

    public String getLibStoreLocation() {
        return this.libStoreLocation;
    }

    public NutsRepositoryConfig502 setLibStoreLocation(String libStoreLocation) {
        this.libStoreLocation = libStoreLocation;
        return this;
    }

    public String getLogStoreLocation() {
        return this.logStoreLocation;
    }

    public NutsRepositoryConfig502 setLogStoreLocation(String logStoreLocation) {
        this.logStoreLocation = logStoreLocation;
        return this;
    }

    public String getTempStoreLocation() {
        return this.tempStoreLocation;
    }

    public NutsRepositoryConfig502 setTempStoreLocation(String tempStoreLocation) {
        this.tempStoreLocation = tempStoreLocation;
        return this;
    }

    public String getCacheStoreLocation() {
        return this.cacheStoreLocation;
    }

    public NutsRepositoryConfig502 setCacheStoreLocation(String cacheStoreLocation) {
        this.cacheStoreLocation = cacheStoreLocation;
        return this;
    }

    public String getRunStoreLocation() {
        return this.runStoreLocation;
    }

    public NutsRepositoryConfig502 setRunStoreLocation(String runStoreLocation) {
        this.runStoreLocation = runStoreLocation;
        return this;
    }

    public NutsStoreLocationStrategy getStoreLocationStrategy() {
        return this.storeLocationStrategy;
    }

    public NutsRepositoryConfig502 setStoreLocationStrategy(NutsStoreLocationStrategy storeLocationStrategy) {
        this.storeLocationStrategy = storeLocationStrategy;
        return this;
    }

    public String getGroups() {
        return this.groups;
    }

    public NutsRepositoryConfig502 setGroups(String groups) {
        this.groups = groups;
        return this;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public NutsRepositoryConfig502 setEnv(Map<String, String> env) {
        this.env = env;
        return this;
    }

    public List<NutsRepositoryRef> getMirrors() {
        return this.mirrors;
    }

    public NutsRepositoryConfig502 setMirrors(List<NutsRepositoryRef> mirrors) {
        this.mirrors = mirrors;
        return this;
    }

    public NutsRepositoryConfig502 setUsers(List<NutsUserConfig> users) {
        this.users = users;
        return this;
    }

    public List<NutsUserConfig> getUsers() {
        return this.users;
    }

    public boolean isIndexEnabled() {
        return this.indexEnabled;
    }

    public NutsRepositoryConfig502 setIndexEnabled(boolean indexEnabled) {
        this.indexEnabled = indexEnabled;
        return this;
    }

    public String getAuthenticationAgent() {
        return this.authenticationAgent;
    }

    public NutsRepositoryConfig502 setAuthenticationAgent(String authenticationAgent) {
        this.authenticationAgent = authenticationAgent;
        return this;
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + Objects.hashCode(this.uuid);
        hash = 59 * hash + Objects.hashCode(this.name);
        hash = 59 * hash + Objects.hashCode(this.type);
        hash = 59 * hash + Objects.hashCode(this.location);
        hash = 59 * hash + Objects.hashCode(this.programsStoreLocation);
        hash = 59 * hash + Objects.hashCode(this.configStoreLocation);
        hash = 59 * hash + Objects.hashCode(this.varStoreLocation);
        hash = 59 * hash + Objects.hashCode(this.libStoreLocation);
        hash = 59 * hash + Objects.hashCode(this.logStoreLocation);
        hash = 59 * hash + Objects.hashCode(this.tempStoreLocation);
        hash = 59 * hash + Objects.hashCode(this.cacheStoreLocation);
        hash = 59 * hash + Objects.hashCode(this.runStoreLocation);
        hash = 59 * hash + Objects.hashCode(this.storeLocationStrategy);
        hash = 59 * hash + Objects.hashCode(this.groups);
        hash = 59 * hash + Objects.hashCode(this.env);
        hash = 59 * hash + Objects.hashCode(this.mirrors);
        hash = 59 * hash + Objects.hashCode(this.users);
        hash = 59 * hash + (this.indexEnabled ? 1 : 0);
        hash = 59 * hash + Objects.hashCode(this.authenticationAgent);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NutsRepositoryConfig502 other = (NutsRepositoryConfig502)obj;
        if (this.indexEnabled != other.indexEnabled) {
            return false;
        }
        if (!Objects.equals(this.uuid, other.uuid)) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.type, other.type)) {
            return false;
        }
        if (!Objects.equals(this.location, other.location)) {
            return false;
        }
        if (!Objects.equals(this.programsStoreLocation, other.programsStoreLocation)) {
            return false;
        }
        if (!Objects.equals(this.configStoreLocation, other.configStoreLocation)) {
            return false;
        }
        if (!Objects.equals(this.varStoreLocation, other.varStoreLocation)) {
            return false;
        }
        if (!Objects.equals(this.libStoreLocation, other.libStoreLocation)) {
            return false;
        }
        if (!Objects.equals(this.logStoreLocation, other.logStoreLocation)) {
            return false;
        }
        if (!Objects.equals(this.tempStoreLocation, other.tempStoreLocation)) {
            return false;
        }
        if (!Objects.equals(this.cacheStoreLocation, other.cacheStoreLocation)) {
            return false;
        }
        if (!Objects.equals(this.runStoreLocation, other.runStoreLocation)) {
            return false;
        }
        if (!Objects.equals(this.groups, other.groups)) {
            return false;
        }
        if (!Objects.equals(this.authenticationAgent, other.authenticationAgent)) {
            return false;
        }
        if (this.storeLocationStrategy != other.storeLocationStrategy) {
            return false;
        }
        if (!Objects.equals(this.env, other.env)) {
            return false;
        }
        if (!Objects.equals(this.mirrors, other.mirrors)) {
            return false;
        }
        return Objects.equals(this.users, other.users);
    }

    public String toString() {
        return "NutsRepositoryConfig{uuid=" + this.uuid + ", name=" + this.name + ", type=" + this.type + ", location=" + this.location + ", programsStoreLocation=" + this.programsStoreLocation + ", configStoreLocation=" + this.configStoreLocation + ", varStoreLocation=" + this.varStoreLocation + ", libStoreLocation=" + this.libStoreLocation + ", logStoreLocation=" + this.logStoreLocation + ", tempStoreLocation=" + this.tempStoreLocation + ", cacheStoreLocation=" + this.cacheStoreLocation + ", runStoreLocation=" + this.runStoreLocation + ", storeLocationStrategy=" + this.storeLocationStrategy + ", groups=" + this.groups + ", env=" + this.env + ", mirrors=" + this.mirrors + ", users=" + this.users + ", indexEnabled=" + this.indexEnabled + ", authenticationAgent=" + this.authenticationAgent + '}';
    }

    public NutsRepositoryConfig toRepositoryConfig() {
        NutsRepositoryConfig c = new NutsRepositoryConfig();
        c.setConfigVersion("0.5.2");
        c.setAuthenticationAgent(this.authenticationAgent);
        c.setEnv(this.env);
        c.setGroups(this.groups);
        c.setIndexEnabled(this.indexEnabled);
        c.setLocation(this.location);
        c.setMirrors(this.mirrors);
        c.setName(this.name);
        c.setStoreLocationStrategy(this.storeLocationStrategy);
        c.setType(this.type);
        c.setStoreLocations(new NutsStoreLocationsMap(null).set(NutsStoreLocation.APPS, this.programsStoreLocation).set(NutsStoreLocation.CONFIG, this.configStoreLocation).set(NutsStoreLocation.VAR, this.varStoreLocation).set(NutsStoreLocation.LOG, this.logStoreLocation).set(NutsStoreLocation.TEMP, this.tempStoreLocation).set(NutsStoreLocation.CACHE, this.cacheStoreLocation).set(NutsStoreLocation.LIB, this.libStoreLocation).toMap());
        return c;
    }
}

