/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsArchFamily;
import net.thevpc.nuts.NutsDesktopEnvironmentFamily;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdBuilder;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilPlatforms;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceInitInformation;
import net.thevpc.nuts.runtime.bundles.common.CorePlatformUtils;
import net.thevpc.nuts.runtime.core.app.DefaultNutsArgument;
import net.thevpc.nuts.runtime.core.common.DefaultObservableMap;
import net.thevpc.nuts.runtime.core.common.ObservableMap;
import net.thevpc.nuts.runtime.core.config.NutsWorkspaceConfigManagerExt;
import net.thevpc.nuts.runtime.core.parser.DefaultNutsIdParser;
import net.thevpc.nuts.runtime.standalone.config.ConfigEventType;
import net.thevpc.nuts.runtime.standalone.config.DefaultNutsWorkspaceConfigManager;
import net.thevpc.nuts.runtime.standalone.config.NutsWorkspaceConfigMain;
import net.thevpc.nuts.runtime.standalone.gui.CoreNutsUtilGui;
import net.thevpc.nuts.runtime.standalone.util.NutsJavaSdkUtils;

public class DefaultNutsWorkspaceEnvManagerModel {
    private NutsWorkspace workspace;
    private Map<String, String> options = new LinkedHashMap<String, String>();
    protected ObservableMap<String, Object> userProperties;
    private NutsId platform;
    private NutsId os;
    private NutsOsFamily osFamily;
    private NutsId[] desktopEnvironments;
    private NutsDesktopEnvironmentFamily[] osDesktopEnvironmentFamilies;
    private NutsDesktopEnvironmentFamily osDesktopEnvironmentFamily;
    private NutsId arch;
    private NutsId osdist;
    private NutsArchFamily archFamily = NutsArchFamily.getArchFamily();

    public DefaultNutsWorkspaceEnvManagerModel(NutsWorkspace ws, NutsWorkspaceInitInformation info, NutsSession session) {
        this.workspace = ws;
        this.userProperties = new DefaultObservableMap<String, Object>();
        String[] properties = info.getOptions().getProperties();
        if (properties != null) {
            for (String property : properties) {
                if (property == null) continue;
                DefaultNutsArgument a = new DefaultNutsArgument(property);
                String key = a.getStringKey();
                String value = a.getStringValue();
                this.options.put(key, value == null ? "" : value);
            }
        }
        DefaultNutsIdParser nip = new DefaultNutsIdParser(session);
        this.os = nip.parse(CorePlatformUtils.getPlatformOs(this.workspace));
        String platformOsDist = CorePlatformUtils.getPlatformOsDist(this.workspace);
        if (platformOsDist == null) {
            platformOsDist = "default";
        }
        this.osdist = nip.parse(platformOsDist);
        this.platform = NutsJavaSdkUtils.of(session).createJdkId(System.getProperty("java.version"), session);
        this.arch = session.getWorkspace().id().parser().parse(System.getProperty("os.arch"));
    }

    NutsWorkspaceConfigMain getStoreModelMain() {
        return ((DefaultNutsWorkspaceConfigManager)this.workspace.config()).getModel().getStoreModelMain();
    }

    public Map<String, String> getEnvMap() {
        LinkedHashMap<String, String> p = new LinkedHashMap<String, String>();
        if (this.getStoreModelMain().getEnv() != null) {
            p.putAll(this.getStoreModelMain().getEnv());
        }
        p.putAll(this.options);
        return p;
    }

    public String getOption(String property) {
        return this.getOption(property, null);
    }

    public String getEnv(String property) {
        return this.getEnv(property, null);
    }

    public Integer getEnvAsInt(String property, Integer defaultValue) {
        String t = this.getEnv(property);
        try {
            return Integer.parseInt(t);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public Integer getOptionAsInt(String property, Integer defaultValue) {
        String t = this.getOption(property);
        try {
            return Integer.parseInt(t);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public Boolean getEnvAsBoolean(String property, Boolean defaultValue) {
        String t = this.getEnv(property);
        if (t != null) {
            try {
                return NutsUtilStrings.parseBoolean((String)t, (Boolean)false, (Boolean)false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public Boolean getOptionAsBoolean(String property, Boolean defaultValue) {
        String t = this.getOption(property);
        if (t != null) {
            try {
                return NutsUtilStrings.parseBoolean((String)t, (Boolean)true, (Boolean)false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public String getOption(String property, String defaultValue) {
        if (this.options.containsKey(property)) {
            return this.options.get(property);
        }
        return defaultValue;
    }

    public String getEnv(String property, String defaultValue) {
        if (this.options.containsKey(property)) {
            return this.options.get(property);
        }
        Map<String, String> env = this.getStoreModelMain().getEnv();
        if (env == null) {
            return defaultValue;
        }
        String o = env.get(property);
        if (NutsUtilStrings.isBlank((CharSequence)o)) {
            return defaultValue;
        }
        return o;
    }

    public void setEnv(String property, String value, NutsSession session) {
        Map<String, String> env = this.getStoreModelMain().getEnv();
        if (NutsUtilStrings.isBlank((CharSequence)value)) {
            if (env != null && env.containsKey(property)) {
                env.remove(property);
                NutsWorkspaceConfigManagerExt.of(this.workspace.config()).getModel().fireConfigurationChanged("env", session, ConfigEventType.MAIN);
            }
        } else {
            String old;
            if (env == null) {
                env = new LinkedHashMap<String, String>();
                this.getStoreModelMain().setEnv(env);
            }
            if (!value.equals(old = env.get(property))) {
                env.put(property, value);
                NutsWorkspaceConfigManagerExt.of(this.workspace.config()).getModel().fireConfigurationChanged("env", session, ConfigEventType.MAIN);
            }
        }
    }

    public NutsId getArch() {
        return this.arch;
    }

    public NutsArchFamily getArchFamily() {
        return this.archFamily;
    }

    public NutsOsFamily getOsFamily() {
        if (this.osFamily == null) {
            this.osFamily = NutsUtilPlatforms.getPlatformOsFamily();
        }
        return this.osFamily;
    }

    public NutsId[] getDesktopEnvironments(NutsSession session) {
        if (this.desktopEnvironments == null) {
            this.desktopEnvironments = this.getDesktopEnvironments0(session);
        }
        return this.desktopEnvironments;
    }

    public boolean isGraphicalDesktopEnvironment() {
        return CoreNutsUtilGui.isGraphicalDesktopEnvironment();
    }

    protected NutsId[] getDesktopEnvironments0(NutsSession session) {
        if (!this.isGraphicalDesktopEnvironment()) {
            return new NutsId[]{session.getWorkspace().id().builder().setArtifactId("none").build()};
        }
        String _XDG_SESSION_DESKTOP = System.getenv("XDG_SESSION_DESKTOP");
        String _XDG_CURRENT_DESKTOP = System.getenv("XDG_CURRENT_DESKTOP");
        if (!NutsUtilStrings.isBlank((CharSequence)_XDG_SESSION_DESKTOP) && !NutsUtilStrings.isBlank((CharSequence)_XDG_SESSION_DESKTOP)) {
            String[] supportedSessions = new LinkedHashSet(Arrays.stream(_XDG_CURRENT_DESKTOP.trim().split(":")).map(x -> x.trim().toLowerCase()).filter(x -> x.length() > 0).collect(Collectors.toList())).toArray(new String[0]);
            String sd = _XDG_SESSION_DESKTOP.toLowerCase();
            ArrayList<NutsId> a = new ArrayList<NutsId>();
            for (int i = 0; i < supportedSessions.length; ++i) {
                NutsIdBuilder nb = session.getWorkspace().id().builder().setArtifactId(supportedSessions[i]);
                if ("kde".equals(sd)) {
                    String _KDE_FULL_SESSION = System.getenv("KDE_FULL_SESSION");
                    String _KDE_SESSION_VERSION = System.getenv("KDE_SESSION_VERSION");
                    if (_KDE_FULL_SESSION != null && "true".equals(_KDE_FULL_SESSION.trim())) {
                        nb.setProperty("full", "true");
                    }
                    if (_KDE_SESSION_VERSION != null) {
                        nb.setProperty("version", _KDE_SESSION_VERSION.trim());
                    }
                }
                String _XDG_SESSION_TYPE = System.getenv("XDG_SESSION_TYPE");
                String _XSESSION_IS_UP = System.getenv("XSESSION_IS_UP");
                String _XDG_SESSION_CLASS = System.getenv("XDG_SESSION_CLASS");
                if (_XDG_SESSION_TYPE != null) {
                    nb.setProperty("type", _XDG_SESSION_TYPE.trim().toLowerCase());
                }
                if (_XDG_SESSION_TYPE != null) {
                    nb.setProperty("class", _XDG_SESSION_CLASS.trim().toLowerCase());
                }
                a.add(nb.build());
            }
            if (a.isEmpty()) {
                a.add(session.getWorkspace().id().builder().setArtifactId("unknown").build());
            }
            return a.toArray(new NutsId[0]);
        }
        if (NutsUtilPlatforms.getPlatformOsFamily() == NutsOsFamily.WINDOWS) {
            return new NutsId[]{session.getWorkspace().id().builder().setArtifactId("windows").build()};
        }
        return new NutsId[]{session.getWorkspace().id().builder().setArtifactId("unknown").build()};
    }

    public NutsDesktopEnvironmentFamily[] getDesktopEnvironmentFamilies(NutsSession session) {
        if (this.osDesktopEnvironmentFamilies == null) {
            this.osDesktopEnvironmentFamilies = this.getDesktopEnvironmentFamilies0(session);
        }
        return this.osDesktopEnvironmentFamilies;
    }

    public NutsDesktopEnvironmentFamily[] getDesktopEnvironmentFamilies0(NutsSession session) {
        NutsId[] desktopEnvironments = this.getDesktopEnvironments(session);
        LinkedHashSet<NutsDesktopEnvironmentFamily> all = new LinkedHashSet<NutsDesktopEnvironmentFamily>();
        for (NutsId desktopEnvironment : desktopEnvironments) {
            all.add(NutsDesktopEnvironmentFamily.parseLenient((String)desktopEnvironment.getShortName()));
        }
        return all.toArray(new NutsDesktopEnvironmentFamily[0]);
    }

    public NutsDesktopEnvironmentFamily getDesktopEnvironmentFamily(NutsSession session) {
        if (this.osDesktopEnvironmentFamily == null) {
            this.osDesktopEnvironmentFamily = this.getDesktopEnvironmentFamily0(session);
        }
        return this.osDesktopEnvironmentFamily;
    }

    public NutsDesktopEnvironmentFamily getDesktopEnvironmentFamily0(NutsSession session) {
        NutsDesktopEnvironmentFamily[] all = this.getDesktopEnvironmentFamilies(session);
        if (all.length == 0) {
            return NutsDesktopEnvironmentFamily.UNKNOWN;
        }
        boolean unknown = false;
        boolean none = false;
        block4: for (NutsDesktopEnvironmentFamily f : all) {
            switch (f) {
                case UNKNOWN: {
                    unknown = true;
                    continue block4;
                }
                case NONE: {
                    none = true;
                    continue block4;
                }
                default: {
                    return f;
                }
            }
        }
        if (none) {
            return NutsDesktopEnvironmentFamily.NONE;
        }
        return NutsDesktopEnvironmentFamily.UNKNOWN;
    }

    public NutsId getOs() {
        return this.os;
    }

    public NutsId getPlatform(NutsSession session) {
        return this.platform;
    }

    public NutsId getOsDist() {
        return this.osdist;
    }

    public Map<String, Object> getProperties() {
        return this.userProperties;
    }

    public Object getProperty(String property, Object defaultValue) {
        Object v = this.userProperties.get(property);
        if (v != null) {
            return v;
        }
        return defaultValue;
    }

    public Integer getPropertyAsInt(String property, Integer defaultValue) {
        Object t = this.getProperty(property, null);
        try {
            if (t instanceof Number) {
                return ((Number)t).intValue();
            }
            if (t instanceof CharSequence) {
                return Integer.parseInt(t.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public String getPropertyAsString(String property, String defaultValue) {
        Object t = this.getProperty(property, null);
        if (t != null) {
            return t.toString();
        }
        return defaultValue;
    }

    public Boolean getPropertyAsBoolean(String property, Boolean defaultValue) {
        Object t = this.getProperty(property, null);
        try {
            if (t instanceof Boolean) {
                return (boolean)((Boolean)t);
            }
            if (t instanceof Number) {
                return ((Number)t).doubleValue() != 0.0;
            }
            if (t instanceof CharSequence) {
                return NutsUtilStrings.parseBoolean((String)t.toString(), (Boolean)false, (Boolean)false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public Object getProperty(String property) {
        return this.getProperty(property, null);
    }

    public <T> T getOrCreateProperty(Class<T> property, Supplier<T> supplier) {
        return this.getOrCreateProperty(property.getName(), supplier);
    }

    public <T> T getOrCreateProperty(String property, Supplier<T> supplier) {
        Object o = this.getProperty(property);
        if (o != null) {
            return (T)o;
        }
        o = supplier.get();
        this.setProperty(property, o);
        return (T)o;
    }

    public void setProperty(String property, Object value) {
        if (value == null) {
            this.userProperties.remove(property);
        } else {
            this.userProperties.put(property, value);
        }
    }

    public NutsWorkspace getWorkspace() {
        return this.workspace;
    }
}

