/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thevpc.nuts.NutsArchFamily;
import net.thevpc.nuts.NutsDesktopEnvironmentFamily;
import net.thevpc.nuts.NutsDesktopIntegrationItem;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsLauncherOptions;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSupportCondition;
import net.thevpc.nuts.NutsSupportMode;
import net.thevpc.nuts.NutsUnsupportedEnumException;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspaceEnvManager;
import net.thevpc.nuts.NutsWorkspaceOptions;
import net.thevpc.nuts.runtime.standalone.config.DefaultNutsWorkspaceConfigManager;
import net.thevpc.nuts.runtime.standalone.config.DefaultNutsWorkspaceConfigModel;
import net.thevpc.nuts.runtime.standalone.config.DefaultNutsWorkspaceEnvManagerModel;
import net.thevpc.nuts.runtime.standalone.config.NutsWorkspaceConfigMain;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.NdiScriptOptions;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.NutsSettingsNdiSubCommand;
import net.thevpc.nuts.runtime.standalone.wscommands.settings.subcommands.ndi.SystemNdi;

public class DefaultNutsWorkspaceEnvManager
implements NutsWorkspaceEnvManager {
    public static final Pattern UNIX_USER_DIRS_PATTERN = Pattern.compile("^\\s*(?<k>[A-Z_]+)\\s*=\\s*(?<v>.*)$");
    private final DefaultNutsWorkspaceEnvManagerModel model;
    private NutsSession session;

    public DefaultNutsWorkspaceEnvManager(DefaultNutsWorkspaceEnvManagerModel model) {
        this.model = model;
    }

    NutsWorkspaceConfigMain getStoreModelMain() {
        this.checkSession();
        return this.model.getStoreModelMain();
    }

    public Map<String, String> getEnvMap() {
        this.checkSession();
        return this.model.getEnvMap();
    }

    public String getEnv(String property, String defaultValue) {
        this.checkSession();
        return this.model.getEnv(property, defaultValue);
    }

    public String getEnv(String property) {
        this.checkSession();
        return this.model.getOption(property);
    }

    public Integer getEnvAsInt(String property, Integer defaultValue) {
        this.checkSession();
        return this.model.getEnvAsInt(property, defaultValue);
    }

    public Boolean getEnvAsBoolean(String property, Boolean defaultValue) {
        this.checkSession();
        return this.model.getEnvAsBoolean(property, defaultValue);
    }

    public NutsWorkspaceEnvManager setEnv(String property, String value) {
        this.checkSession();
        this.model.setEnv(property, value, this.session);
        return this;
    }

    public Map<String, Object> getProperties() {
        this.checkSession();
        return this.model.getProperties();
    }

    public Integer getPropertyAsInt(String property, Integer defaultValue) {
        this.checkSession();
        return this.model.getPropertyAsInt(property, defaultValue);
    }

    public String getPropertyAsString(String property, String defaultValue) {
        this.checkSession();
        return this.model.getPropertyAsString(property, defaultValue);
    }

    public Boolean getPropertyAsBoolean(String property, Boolean defaultValue) {
        this.checkSession();
        return this.model.getPropertyAsBoolean(property, defaultValue);
    }

    public Object getProperty(String property) {
        this.checkSession();
        return this.model.getProperty(property);
    }

    public <T> T getOrCreateProperty(String property, Supplier<T> supplier) {
        this.checkSession();
        return this.model.getOrCreateProperty(property, supplier);
    }

    public <T> T getOrCreateProperty(Class<T> property, Supplier<T> supplier) {
        this.checkSession();
        return this.model.getOrCreateProperty(property, supplier);
    }

    public Object getProperty(String property, Object defaultValue) {
        this.checkSession();
        return this.model.getProperty(property, defaultValue);
    }

    public NutsWorkspaceEnvManager setProperty(String property, Object value) {
        this.checkSession();
        this.model.setProperty(property, value);
        return this;
    }

    public NutsWorkspaceOptions getBootOptions() {
        this.checkSession();
        return this._configModel().getOptions(this.getSession());
    }

    public NutsOsFamily getOsFamily() {
        return this.model.getOsFamily();
    }

    public NutsId getDesktopEnvironment() {
        return this.getDesktopEnvironments()[0];
    }

    public NutsId[] getDesktopEnvironments() {
        return this.model.getDesktopEnvironments(this.session);
    }

    public NutsDesktopEnvironmentFamily getDesktopEnvironmentFamily() {
        return this.model.getDesktopEnvironmentFamily(this.session);
    }

    public NutsDesktopEnvironmentFamily[] getDesktopEnvironmentFamilies() {
        return this.model.getDesktopEnvironmentFamilies(this.session);
    }

    public NutsId getPlatform() {
        return this.model.getPlatform(this.session);
    }

    public NutsId getOs() {
        return this.model.getOs();
    }

    public NutsId getOsDist() {
        return this.model.getOsDist();
    }

    public NutsId getArch() {
        return this.model.getArch();
    }

    public NutsArchFamily getArchFamily() {
        return this.model.getArchFamily();
    }

    public String getOption(String property) {
        this.checkSession();
        return this.model.getOption(property);
    }

    public String getOption(String property, String defaultValue) {
        this.checkSession();
        return this.model.getOption(property, defaultValue);
    }

    public Boolean getOptionAsBoolean(String property, Boolean defaultValue) {
        this.checkSession();
        return this.model.getOptionAsBoolean(property, defaultValue);
    }

    public Integer getOptionAsInt(String property, Integer defaultValue) {
        this.checkSession();
        return this.model.getOptionAsInt(property, defaultValue);
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsWorkspaceEnvManager setSession(NutsSession session) {
        this.session = session;
        return this;
    }

    public ClassLoader getBootClassLoader() {
        this.checkSession();
        return this._configModel().getBootClassLoader();
    }

    public URL[] getBootClassWorldURLs() {
        this.checkSession();
        return this._configModel().getBootClassWorldURLs();
    }

    public String getBootRepositories() {
        this.checkSession();
        return this._configModel().getBootRepositories();
    }

    public long getCreationStartTimeMillis() {
        this.checkSession();
        return this._configModel().getCreationStartTimeMillis();
    }

    public long getCreationFinishTimeMillis() {
        this.checkSession();
        return this._configModel().getCreationFinishTimeMillis();
    }

    public long getCreationTimeMillis() {
        this.checkSession();
        return this._configModel().getCreationTimeMillis();
    }

    public boolean isGraphicalDesktopEnvironment() {
        return this.model.isGraphicalDesktopEnvironment();
    }

    public NutsSupportMode getDesktopIntegrationSupport(NutsDesktopIntegrationItem item) {
        NutsSupportMode q;
        String o;
        this.checkSession();
        if (item == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"missing item", (Object[])new Object[0]));
        }
        String optionName = null;
        switch (item) {
            case DESKTOP: {
                optionName = "system-desktop-launcher";
                break;
            }
            case MENU: {
                optionName = "system-menu-launcher";
                break;
            }
            case SHORTCUT: {
                optionName = "system-custom-launcher";
            }
        }
        if (optionName != null && !NutsUtilStrings.isBlank((CharSequence)(o = this.getOption(optionName, null))) && (q = NutsSupportMode.parseLenient((String)o, null, null)) != null) {
            return q;
        }
        switch (this.getOsFamily()) {
            case LINUX: {
                switch (item) {
                    case DESKTOP: {
                        return NutsSupportMode.SUPPORTED;
                    }
                    case MENU: {
                        return NutsSupportMode.PREFERRED;
                    }
                    case SHORTCUT: {
                        return NutsSupportMode.PREFERRED;
                    }
                }
                break;
            }
            case UNIX: {
                return NutsSupportMode.UNSUPPORTED;
            }
            case WINDOWS: {
                switch (item) {
                    case DESKTOP: {
                        return NutsSupportMode.PREFERRED;
                    }
                    case MENU: {
                        return NutsSupportMode.PREFERRED;
                    }
                    case SHORTCUT: {
                        return NutsSupportMode.PREFERRED;
                    }
                }
                break;
            }
            case MACOS: {
                return NutsSupportMode.UNSUPPORTED;
            }
            case UNKNOWN: {
                return NutsSupportMode.UNSUPPORTED;
            }
        }
        return NutsSupportMode.UNSUPPORTED;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Path getDesktopPath() {
        switch (this.getOsFamily()) {
            case LINUX: 
            case UNIX: 
            case MACOS: {
                File f = new File(System.getProperty("user.home"), ".config/user-dirs.dirs");
                if (f.exists()) {
                    try (BufferedReader r = new BufferedReader(new FileReader(f));){
                        String line;
                        while ((line = r.readLine()) != null) {
                            if ((line = line.trim()).startsWith("#")) continue;
                            Matcher m = UNIX_USER_DIRS_PATTERN.matcher(line);
                            if (m.find()) {
                                String k = m.group("k");
                                if (!k.equals("XDG_DESKTOP_DIR")) continue;
                                String v = m.group("v");
                                if ((v = v.trim()).startsWith("\"")) {
                                    int last = v.indexOf(34, 1);
                                    String s = v.substring(1, last);
                                    s = s.replace("$HOME", System.getProperty("user.home"));
                                    Path path = Paths.get(s, new String[0]);
                                    return path;
                                }
                                Path path = Paths.get(v, new String[0]);
                                return path;
                            }
                            break;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return new File(System.getProperty("user.home"), "Desktop").toPath();
            }
            case WINDOWS: {
                return new File(System.getProperty("user.home"), "Desktop").toPath();
            }
        }
        return new File(System.getProperty("user.home"), "Desktop").toPath();
    }

    public void addLauncher(NutsLauncherOptions launcher) {
        this.checkSession();
        NutsSession session = this.getSession();
        SystemNdi ndi = NutsSettingsNdiSubCommand.createNdi(session);
        if (ndi != null) {
            ndi.addScript(new NdiScriptOptions().setSession(session).setLauncher(launcher.copy()), new String[]{launcher.getId().builder().getFullName()});
        }
    }

    private void checkSession() {
        NutsWorkspaceUtils.checkSession(this.model.getWorkspace(), this.session);
    }

    public DefaultNutsWorkspaceEnvManagerModel getModel() {
        return this.model;
    }

    private DefaultNutsWorkspaceConfigModel _configModel() {
        DefaultNutsWorkspaceConfigManager config = (DefaultNutsWorkspaceConfigManager)this.session.getWorkspace().config();
        return config.getModel();
    }

    public boolean matchCondition(NutsSupportCondition request, NutsSupportMode support) {
        this.checkSession();
        if (request == null) {
            request = NutsSupportCondition.NEVER;
        }
        if (support == null) {
            support = NutsSupportMode.UNSUPPORTED;
        }
        switch (support) {
            case UNSUPPORTED: {
                return false;
            }
            case SUPPORTED: {
                switch (request) {
                    case NEVER: {
                        return false;
                    }
                    case ALWAYS: 
                    case SUPPORTED: {
                        return true;
                    }
                    case PREFERRED: {
                        return false;
                    }
                }
                throw new NutsUnsupportedEnumException(this.getSession(), (Enum)request);
            }
            case PREFERRED: {
                switch (request) {
                    case NEVER: {
                        return false;
                    }
                    case ALWAYS: 
                    case PREFERRED: {
                        return true;
                    }
                    case SUPPORTED: {
                        return false;
                    }
                }
                throw new NutsUnsupportedEnumException(this.getSession(), (Enum)request);
            }
        }
        throw new NutsUnsupportedEnumException(this.getSession(), (Enum)support);
    }
}

