/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.config;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.thevpc.nuts.Nuts;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdParser;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsStoreLocationStrategy;
import net.thevpc.nuts.NutsUtilPlatforms;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceOptions;
import net.thevpc.nuts.boot.NutsBootDescriptor;
import net.thevpc.nuts.boot.NutsBootId;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.NutsHomeLocationsMap;
import net.thevpc.nuts.runtime.standalone.NutsStoreLocationsMap;
import net.thevpc.nuts.runtime.standalone.config.NutsBootConfig;
import net.thevpc.nuts.runtime.standalone.config.NutsWorkspaceConfigApi;
import net.thevpc.nuts.runtime.standalone.config.NutsWorkspaceConfigBoot;
import net.thevpc.nuts.runtime.standalone.config.NutsWorkspaceConfigRuntime;

public final class DefaultNutsWorkspaceCurrentConfig {
    private final Map<String, String> userStoreLocations = new HashMap<String, String>();
    private final Map<String, String> effStoreLocationsMap = new HashMap<String, String>();
    private final Path[] effStoreLocationPath = new Path[NutsStoreLocation.values().length];
    private final Map<String, String> homeLocations = new HashMap<String, String>();
    private final NutsWorkspace ws;
    private String name;
    private NutsId apiId;
    private NutsId bootRuntime;
    private NutsBootDescriptor runtimeBootDescriptor;
    private NutsBootDescriptor[] extensionBootDescriptors;
    private String bootRepositories;
    private String bootJavaCommand;
    private String bootJavaOptions;
    private NutsStoreLocationStrategy storeLocationStrategy;
    private NutsStoreLocationStrategy repositoryStoreLocationStrategy;
    private NutsOsFamily storeLocationLayout;
    private boolean global;

    public DefaultNutsWorkspaceCurrentConfig(NutsWorkspace ws) {
        this.ws = ws;
    }

    public DefaultNutsWorkspaceCurrentConfig merge(NutsWorkspaceOptions c, NutsSession session) {
        if (c.getName() != null) {
            this.name = c.getName();
        }
        if (c.getRuntimeId() != null) {
            this.setRuntimeId(c.getRuntimeId(), session);
        }
        if (c.getJavaCommand() != null) {
            this.bootJavaCommand = c.getJavaCommand();
        }
        if (c.getJavaOptions() != null) {
            this.bootJavaOptions = c.getJavaOptions();
        }
        if (c.getStoreLocationStrategy() != null) {
            this.storeLocationStrategy = c.getStoreLocationStrategy();
        }
        if (c.getRepositoryStoreLocationStrategy() != null) {
            this.repositoryStoreLocationStrategy = c.getRepositoryStoreLocationStrategy();
        }
        if (c.getStoreLocationLayout() != null) {
            this.storeLocationLayout = c.getStoreLocationLayout();
        }
        this.userStoreLocations.putAll(new NutsStoreLocationsMap(c.getStoreLocations()).toMap());
        this.homeLocations.putAll(new NutsHomeLocationsMap(c.getHomeLocations()).toMap());
        this.global |= c.isGlobal();
        return this;
    }

    public void setRuntimeId(String s, NutsSession session) {
        this.bootRuntime = s.contains("#") ? session.getWorkspace().id().parser().parse(s) : session.getWorkspace().id().parser().parse("net.thevpc.nuts:nuts-runtime#" + s);
    }

    public DefaultNutsWorkspaceCurrentConfig mergeRuntime(NutsWorkspaceOptions c, NutsSession session) {
        if (c.getRuntimeId() != null) {
            NutsId nutsId = this.bootRuntime = c.getRuntimeId().contains("#") ? session.getWorkspace().id().parser().parse(c.getRuntimeId()) : session.getWorkspace().id().parser().parse("net.thevpc.nuts:nuts-runtime#" + c.getRuntimeId());
        }
        if (c.getJavaCommand() != null) {
            this.bootJavaCommand = c.getJavaCommand();
        }
        if (c.getJavaOptions() != null) {
            this.bootJavaOptions = c.getJavaOptions();
        }
        return this;
    }

    public DefaultNutsWorkspaceCurrentConfig build(String workspaceLocation, NutsSession session) {
        if (this.storeLocationStrategy == null) {
            this.storeLocationStrategy = NutsStoreLocationStrategy.EXPLODED;
        }
        if (this.repositoryStoreLocationStrategy == null) {
            this.repositoryStoreLocationStrategy = NutsStoreLocationStrategy.EXPLODED;
        }
        Path[] homes = new Path[NutsStoreLocation.values().length];
        for (NutsStoreLocation type : NutsStoreLocation.values()) {
            String ss = NutsUtilPlatforms.getPlatformHomeFolder((NutsOsFamily)this.getStoreLocationLayout(), (NutsStoreLocation)type, this.homeLocations, (boolean)this.isGlobal(), (String)this.getName());
            if (NutsUtilStrings.isBlank((CharSequence)ss)) {
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"missing Home for %s", (Object[])new Object[]{type}));
            }
            homes[type.ordinal()] = Paths.get(ss, new String[0]);
        }
        Map<String, String> storeLocations = this.getStoreLocations();
        block11: for (NutsStoreLocation location : NutsStoreLocation.values()) {
            String typeId = location.id();
            switch (location) {
                default: 
            }
            String typeLocation = storeLocations.get(typeId);
            if (NutsUtilStrings.isBlank((CharSequence)typeLocation)) {
                switch (this.storeLocationStrategy) {
                    case STANDALONE: {
                        storeLocations.put(typeId, Paths.get(workspaceLocation, new String[0]).resolve(location.id()).toString());
                        break;
                    }
                    case EXPLODED: {
                        storeLocations.put(typeId, homes[location.ordinal()].toString());
                    }
                }
                continue;
            }
            if (CoreIOUtils.isAbsolutePath(typeLocation)) continue;
            switch (this.storeLocationStrategy) {
                case STANDALONE: {
                    storeLocations.put(typeId, Paths.get(workspaceLocation, new String[0]).resolve(location.id()).toString());
                    continue block11;
                }
                case EXPLODED: {
                    storeLocations.put(typeId, homes[location.ordinal()].resolve(typeLocation).toString());
                }
            }
        }
        this.effStoreLocationsMap.clear();
        this.effStoreLocationsMap.putAll(storeLocations);
        for (int i = 0; i < this.effStoreLocationPath.length; ++i) {
            this.effStoreLocationPath[i] = Paths.get(this.effStoreLocationsMap.get(NutsStoreLocation.values()[i].id()), new String[0]);
        }
        if (this.apiId == null) {
            this.apiId = session.getWorkspace().id().parser().parse("net.thevpc.nuts:nuts#" + Nuts.getVersion());
        }
        if (this.storeLocationLayout == null) {
            this.storeLocationLayout = session.getWorkspace().env().getOsFamily();
        }
        return this;
    }

    public DefaultNutsWorkspaceCurrentConfig merge(NutsWorkspaceConfigApi c, NutsSession session) {
        NutsIdParser parser = session.getWorkspace().id().parser();
        if (c.getApiVersion() != null) {
            this.apiId = parser.parse("net.thevpc.nuts:nuts#" + c.getApiVersion());
        }
        if (c.getRuntimeId() != null) {
            NutsId nutsId = this.bootRuntime = c.getRuntimeId().contains("#") ? parser.parse(c.getRuntimeId()) : parser.parse("net.thevpc.nuts:nuts-runtime#" + c.getRuntimeId());
        }
        if (c.getJavaCommand() != null) {
            this.bootJavaCommand = c.getJavaCommand();
        }
        if (c.getJavaOptions() != null) {
            this.bootJavaOptions = c.getJavaOptions();
        }
        return this;
    }

    public DefaultNutsWorkspaceCurrentConfig merge(NutsWorkspaceConfigRuntime c, NutsSession session) {
        if (c.getId() != null) {
            this.bootRuntime = session.getWorkspace().id().parser().parse(c.getId());
        }
        if (c.getDependencies() != null) {
            this.runtimeBootDescriptor = new NutsBootDescriptor(NutsBootId.parse((String)this.bootRuntime.toString()), (NutsBootId[])Arrays.stream(c.getDependencies().split(";")).map(x -> NutsBootId.parse((String)x)).toArray(NutsBootId[]::new));
        }
        return this;
    }

    public DefaultNutsWorkspaceCurrentConfig merge(NutsWorkspaceConfigBoot c, NutsSession session) {
        if (c.getName() != null) {
            this.name = c.getName();
        }
        if (c.getStoreLocationStrategy() != null) {
            this.storeLocationStrategy = c.getStoreLocationStrategy();
        }
        if (c.getRepositoryStoreLocationStrategy() != null) {
            this.repositoryStoreLocationStrategy = c.getRepositoryStoreLocationStrategy();
        }
        if (c.getStoreLocationLayout() != null) {
            this.storeLocationLayout = c.getStoreLocationLayout();
        }
        this.userStoreLocations.putAll(new NutsStoreLocationsMap(c.getStoreLocations()).toMap());
        this.homeLocations.putAll(new NutsHomeLocationsMap(c.getHomeLocations()).toMap());
        this.global |= c.isGlobal();
        return this;
    }

    public DefaultNutsWorkspaceCurrentConfig merge(NutsBootConfig c, NutsSession session) {
        this.name = c.getName();
        NutsIdParser parser = session.getWorkspace().id().parser();
        if (c.getApiVersion() != null) {
            this.apiId = parser.parse("net.thevpc.nuts:nuts#" + c.getApiVersion());
        }
        if (c.getRuntimeId() != null) {
            NutsId nutsId = this.bootRuntime = c.getRuntimeId().contains("#") ? parser.parse(c.getRuntimeId()) : parser.parse("net.thevpc.nuts:nuts-runtime#" + c.getRuntimeId());
        }
        if (c.getRuntimeBootDescriptor() != null) {
            this.runtimeBootDescriptor = c.getRuntimeBootDescriptor();
        }
        if (c.getExtensionBootDescriptors() != null) {
            this.extensionBootDescriptors = c.getExtensionBootDescriptors();
        }
        if (c.getBootRepositories() != null) {
            this.bootRepositories = c.getBootRepositories();
        }
        if (c.getJavaCommand() != null) {
            this.bootJavaCommand = c.getJavaCommand();
        }
        if (c.getJavaOptions() != null) {
            this.bootJavaOptions = c.getJavaOptions();
        }
        if (c.getStoreLocationStrategy() != null) {
            this.storeLocationStrategy = c.getStoreLocationStrategy();
        }
        if (c.getRepositoryStoreLocationStrategy() != null) {
            this.repositoryStoreLocationStrategy = c.getRepositoryStoreLocationStrategy();
        }
        if (c.getStoreLocationLayout() != null) {
            this.storeLocationLayout = c.getStoreLocationLayout();
        }
        this.userStoreLocations.putAll(new NutsStoreLocationsMap(c.getStoreLocations()).toMap());
        this.homeLocations.putAll(new NutsHomeLocationsMap(c.getHomeLocations()).toMap());
        this.global |= c.isGlobal();
        return this;
    }

    public NutsBootDescriptor[] getExtensionBootDescriptors() {
        return this.extensionBootDescriptors;
    }

    public DefaultNutsWorkspaceCurrentConfig setExtensionBootDescriptors(NutsBootDescriptor[] extensionBootDescriptors) {
        this.extensionBootDescriptors = extensionBootDescriptors;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public DefaultNutsWorkspaceCurrentConfig setName(String name) {
        this.name = name;
        return this;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public DefaultNutsWorkspaceCurrentConfig setGlobal(boolean global) {
        this.global = global;
        return this;
    }

    public String getApiVersion() {
        return this.getApiId().getVersion().getValue();
    }

    public NutsId getApiId() {
        return this.apiId;
    }

    public DefaultNutsWorkspaceCurrentConfig setApiId(NutsId apiId) {
        this.apiId = apiId;
        return this;
    }

    public NutsId getRuntimeId() {
        return this.bootRuntime;
    }

    public DefaultNutsWorkspaceCurrentConfig setRuntimeId(NutsId bootRuntime) {
        this.bootRuntime = bootRuntime;
        return this;
    }

    public NutsBootDescriptor getRuntimeBootDescriptor() {
        return this.runtimeBootDescriptor;
    }

    public DefaultNutsWorkspaceCurrentConfig setRuntimeBootDescriptor(NutsBootDescriptor runtimeBootDescriptor) {
        this.runtimeBootDescriptor = runtimeBootDescriptor;
        return this;
    }

    public String getBootRepositories() {
        return this.bootRepositories;
    }

    public DefaultNutsWorkspaceCurrentConfig setBootRepositories(String bootRepositories) {
        this.bootRepositories = bootRepositories;
        return this;
    }

    public String getJavaCommand() {
        return this.bootJavaCommand;
    }

    public String getJavaOptions() {
        return this.bootJavaOptions;
    }

    public NutsStoreLocationStrategy getStoreLocationStrategy() {
        return this.storeLocationStrategy;
    }

    public DefaultNutsWorkspaceCurrentConfig setStoreLocationStrategy(NutsStoreLocationStrategy storeLocationStrategy) {
        this.storeLocationStrategy = storeLocationStrategy;
        return this;
    }

    public NutsStoreLocationStrategy getRepositoryStoreLocationStrategy() {
        return this.repositoryStoreLocationStrategy;
    }

    public DefaultNutsWorkspaceCurrentConfig setRepositoryStoreLocationStrategy(NutsStoreLocationStrategy repositoryStoreLocationStrategy) {
        this.repositoryStoreLocationStrategy = repositoryStoreLocationStrategy;
        return this;
    }

    public Map<String, String> getStoreLocations() {
        return new LinkedHashMap<String, String>(this.effStoreLocationsMap);
    }

    public Map<String, String> getHomeLocations() {
        return new LinkedHashMap<String, String>(this.homeLocations);
    }

    public DefaultNutsWorkspaceCurrentConfig setHomeLocations(Map<String, String> homeLocations) {
        this.homeLocations.clear();
        if (homeLocations != null) {
            this.homeLocations.putAll(homeLocations);
        }
        return this;
    }

    public String getStoreLocation(NutsStoreLocation folderType) {
        return this.effStoreLocationPath[folderType.ordinal()].toString();
    }

    public String getHomeLocation(NutsOsFamily layout, NutsStoreLocation folderType) {
        String path = new NutsHomeLocationsMap(this.homeLocations).get(layout, folderType);
        return path;
    }

    public String getHomeLocation(NutsStoreLocation folderType) {
        return Paths.get(NutsUtilPlatforms.getPlatformHomeFolder((NutsOsFamily)this.getStoreLocationLayout(), (NutsStoreLocation)folderType, this.getHomeLocations(), (boolean)this.isGlobal(), (String)this.getName()), new String[0]).toString();
    }

    public NutsOsFamily getStoreLocationLayout() {
        return this.storeLocationLayout;
    }

    public DefaultNutsWorkspaceCurrentConfig setStoreLocationLayout(NutsOsFamily storeLocationLayout) {
        this.storeLocationLayout = storeLocationLayout;
        return this;
    }

    public DefaultNutsWorkspaceCurrentConfig setUserStoreLocations(Map<String, String> userStoreLocations) {
        this.userStoreLocations.clear();
        if (userStoreLocations != null) {
            this.userStoreLocations.putAll(userStoreLocations);
        }
        return this;
    }

    public DefaultNutsWorkspaceCurrentConfig setBootJavaCommand(String bootJavaCommand) {
        this.bootJavaCommand = bootJavaCommand;
        return this;
    }

    public DefaultNutsWorkspaceCurrentConfig setBootJavaOptions(String bootJavaOptions) {
        this.bootJavaOptions = bootJavaOptions;
        return this;
    }

    public String getStoreLocation(String id, NutsStoreLocation folderType, NutsSession session) {
        return this.getStoreLocation(session.getWorkspace().id().parser().parse(id), folderType, session);
    }

    public String getStoreLocation(NutsId id, NutsStoreLocation folderType, NutsSession session) {
        String storeLocation = this.getStoreLocation(folderType);
        if (storeLocation == null) {
            return null;
        }
        switch (folderType) {
            case CACHE: {
                return Paths.get(storeLocation, new String[0]).resolve("id").resolve(session.getWorkspace().locations().getDefaultIdBasedir(id)).toString();
            }
            case CONFIG: {
                return Paths.get(storeLocation, new String[0]).resolve("id").resolve(session.getWorkspace().locations().getDefaultIdBasedir(id)).toString();
            }
        }
        return Paths.get(storeLocation, new String[0]).resolve(session.getWorkspace().locations().getDefaultIdBasedir(id)).toString();
    }
}

