/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.config;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.thevpc.nuts.Nuts;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsAuthenticationAgent;
import net.thevpc.nuts.NutsCommandFactoryConfig;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyScopePattern;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsException;
import net.thevpc.nuts.NutsExtensionNotFoundException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryConfig;
import net.thevpc.nuts.NutsRepositoryManager;
import net.thevpc.nuts.NutsRepositoryRef;
import net.thevpc.nuts.NutsSdkLocation;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsStoreLocationStrategy;
import net.thevpc.nuts.NutsUserConfig;
import net.thevpc.nuts.NutsUtilPlatforms;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceBootConfig;
import net.thevpc.nuts.NutsWorkspaceEvent;
import net.thevpc.nuts.NutsWorkspaceInitInformation;
import net.thevpc.nuts.NutsWorkspaceListManager;
import net.thevpc.nuts.NutsWorkspaceListener;
import net.thevpc.nuts.NutsWorkspaceOptions;
import net.thevpc.nuts.NutsWorkspaceOptionsBuilder;
import net.thevpc.nuts.NutsWorkspaceStoredConfig;
import net.thevpc.nuts.runtime.core.app.DefaultNutsWorkspaceLocationManager;
import net.thevpc.nuts.runtime.core.config.NutsRepositoryConfigManagerExt;
import net.thevpc.nuts.runtime.core.events.DefaultNutsWorkspaceEvent;
import net.thevpc.nuts.runtime.core.model.CoreNutsWorkspaceOptions;
import net.thevpc.nuts.runtime.core.repos.NutsRepositorySelector;
import net.thevpc.nuts.runtime.core.util.CoreBooleanUtils;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.core.util.CoreNutsDependencyUtils;
import net.thevpc.nuts.runtime.core.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.standalone.DefaultNutsWorkspace;
import net.thevpc.nuts.runtime.standalone.DefaultNutsWorkspaceListManager;
import net.thevpc.nuts.runtime.standalone.NutsHomeLocationsMap;
import net.thevpc.nuts.runtime.standalone.NutsStoreLocationsMap;
import net.thevpc.nuts.runtime.standalone.bridges.maven.MavenUtils;
import net.thevpc.nuts.runtime.standalone.config.ConfigEventType;
import net.thevpc.nuts.runtime.standalone.config.DefaultImportManager;
import net.thevpc.nuts.runtime.standalone.config.DefaultNutsSdkManager;
import net.thevpc.nuts.runtime.standalone.config.DefaultNutsWorkspaceBootConfig;
import net.thevpc.nuts.runtime.standalone.config.DefaultNutsWorkspaceCurrentConfig;
import net.thevpc.nuts.runtime.standalone.config.DummyNutsIndexStoreFactory;
import net.thevpc.nuts.runtime.standalone.config.NutsWorkspaceConfigApi;
import net.thevpc.nuts.runtime.standalone.config.NutsWorkspaceConfigBoot;
import net.thevpc.nuts.runtime.standalone.config.NutsWorkspaceConfigMain;
import net.thevpc.nuts.runtime.standalone.config.NutsWorkspaceConfigRuntime;
import net.thevpc.nuts.runtime.standalone.config.NutsWorkspaceConfigSecurity;
import net.thevpc.nuts.runtime.standalone.config.compat.CompatUtils;
import net.thevpc.nuts.runtime.standalone.config.compat.NutsVersionCompat;
import net.thevpc.nuts.runtime.standalone.config.compat.v502.NutsVersionCompat502;
import net.thevpc.nuts.runtime.standalone.config.compat.v506.NutsVersionCompat506;
import net.thevpc.nuts.runtime.standalone.config.compat.v507.NutsVersionCompat507;
import net.thevpc.nuts.runtime.standalone.security.ReadOnlyNutsWorkspaceOptions;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsIndexStoreFactory;
import net.thevpc.nuts.spi.NutsRepositoryFactoryComponent;
import net.thevpc.nuts.spi.NutsWorkspaceArchetypeComponent;

public class DefaultNutsWorkspaceConfigModel {
    public static final boolean NO_M2 = CoreBooleanUtils.getSysBoolNutsProperty("no-m2", false);
    private final DefaultNutsWorkspace ws;
    private final Map<String, NutsUserConfig> configUsers = new LinkedHashMap<String, NutsUserConfig>();
    private NutsLogger LOG;
    protected NutsWorkspaceConfigBoot storeModelBoot = new NutsWorkspaceConfigBoot();
    protected NutsWorkspaceConfigApi storeModelApi = new NutsWorkspaceConfigApi();
    protected NutsWorkspaceConfigRuntime storeModelRuntime = new NutsWorkspaceConfigRuntime();
    protected NutsWorkspaceConfigSecurity storeModelSecurity = new NutsWorkspaceConfigSecurity();
    protected NutsWorkspaceConfigMain storeModelMain = new NutsWorkspaceConfigMain();
    private DefaultNutsWorkspaceCurrentConfig currentConfig;
    private NutsWorkspaceStoredConfig storedConfig = new NutsWorkspaceStoredConfigImpl();
    private ClassLoader bootClassLoader;
    private URL[] bootClassWorldURLs;
    private boolean storeModelBootChanged = false;
    private boolean storeModelApiChanged = false;
    private boolean storeModelRuntimeChanged = false;
    private boolean storeModelSecurityChanged = false;
    private boolean storeModelMainChanged = false;
    private NutsWorkspaceOptions options;
    private NutsWorkspaceInitInformation initOptions;
    private long startCreateTime;
    private long endCreateTime;
    private NutsIndexStoreFactory indexStoreClientFactory;
    private NutsStoreLocationsMap preUpdateConfigStoreLocations;
    private NutsRepositorySelector.SelectorList parsedBootRepositoriesList;

    public DefaultNutsWorkspaceConfigModel(DefaultNutsWorkspace ws, NutsWorkspaceInitInformation initOptions) {
        this.ws = ws;
        this.initOptions = initOptions;
        this.options = this.initOptions.getOptions();
        this.bootClassLoader = initOptions.getClassWorldLoader() == null ? Thread.currentThread().getContextClassLoader() : initOptions.getClassWorldLoader();
        this.bootClassWorldURLs = initOptions.getClassWorldURLs() == null ? null : Arrays.copyOf(initOptions.getClassWorldURLs(), initOptions.getClassWorldURLs().length);
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = session.getWorkspace().log().of(DefaultNutsWorkspaceConfigModel.class);
        }
        return this.LOG;
    }

    public DefaultNutsWorkspaceCurrentConfig getCurrentConfig() {
        return this.currentConfig;
    }

    public NutsWorkspaceStoredConfig stored() {
        return this.storedConfig;
    }

    public ClassLoader getBootClassLoader() {
        return this.bootClassLoader;
    }

    public URL[] getBootClassWorldURLs() {
        return this.bootClassWorldURLs == null ? null : Arrays.copyOf(this.bootClassWorldURLs, this.bootClassWorldURLs.length);
    }

    public boolean isReadOnly() {
        return this.options.isReadOnly();
    }

    public boolean save(boolean force, NutsSession session) {
        if (!force && !this.isConfigurationChanged()) {
            return false;
        }
        NutsWorkspace ws = session.getWorkspace();
        NutsWorkspaceUtils.of(session).checkReadOnly();
        NutsWorkspaceUtils.checkSession(ws, session);
        boolean ok = false;
        ws.security().checkAllowed("save", "save");
        String apiVersionSpecificLocation = ws.locations().getStoreLocation(ws.getApiId(), NutsStoreLocation.CONFIG);
        if (force || this.storeModelBootChanged) {
            Path file = Paths.get(ws.locations().getWorkspaceLocation(), new String[0]).resolve("nuts-workspace.json");
            this.storeModelBoot.setConfigVersion("0.8.0");
            if (this.storeModelBoot.getExtensions() != null) {
                for (NutsWorkspaceConfigBoot.ExtensionConfig extensionConfig : this.storeModelBoot.getExtensions()) {
                    extensionConfig.setConfigVersion(null);
                }
            }
            ws.elem().setContentType(NutsContentType.JSON).setValue((Object)this.storeModelBoot).print(file);
            this.storeModelBootChanged = false;
            ok = true;
        }
        String configVersionSpecificLocation = ws.locations().getStoreLocation(ws.getApiId().builder().setVersion("RELEASE").build(), NutsStoreLocation.CONFIG);
        if (force || this.storeModelSecurityChanged) {
            this.storeModelSecurity.setUsers(this.configUsers.isEmpty() ? null : this.configUsers.values().toArray(new NutsUserConfig[0]));
            Path file = Paths.get(configVersionSpecificLocation, new String[0]).resolve("nuts-security-config.json");
            this.storeModelSecurity.setConfigVersion(this.current().getApiVersion());
            if (this.storeModelSecurity.getUsers() != null) {
                for (NutsUserConfig extension : this.storeModelSecurity.getUsers()) {
                    extension.setConfigVersion(null);
                }
            }
            ws.elem().setSession(session).setContentType(NutsContentType.JSON).setValue((Object)this.storeModelSecurity).print(file);
            this.storeModelSecurityChanged = false;
            ok = true;
        }
        if (force || this.storeModelMainChanged) {
            ArrayList<NutsSdkLocation> plainSdks = new ArrayList<NutsSdkLocation>();
            plainSdks.addAll(Arrays.asList(ws.sdks().find(null, null)));
            this.storeModelMain.setSdk(plainSdks);
            this.storeModelMain.setRepositories(new ArrayList<NutsRepositoryRef>(Arrays.stream(ws.repos().getRepositories()).filter(x -> !x.config().isTemporary()).map(x -> x.config().getRepositoryRef()).collect(Collectors.toList())));
            Path path = Paths.get(configVersionSpecificLocation, new String[0]).resolve("nuts-main-config.json");
            this.storeModelMain.setConfigVersion(this.current().getApiVersion());
            if (this.storeModelMain.getCommandFactories() != null) {
                for (NutsCommandFactoryConfig item : this.storeModelMain.getCommandFactories()) {
                    item.setConfigVersion(null);
                }
            }
            if (this.storeModelMain.getRepositories() != null) {
                for (NutsRepositoryRef item : this.storeModelMain.getRepositories()) {
                    item.setConfigVersion(null);
                }
            }
            if (this.storeModelMain.getSdk() != null) {
                for (NutsSdkLocation item : this.storeModelMain.getSdk()) {
                    item.setConfigVersion(null);
                }
            }
            ws.elem().setSession(session).setContentType(NutsContentType.JSON).setValue((Object)this.storeModelMain).print(path);
            this.storeModelMainChanged = false;
            ok = true;
        }
        if (force || this.storeModelApiChanged) {
            Path afile = Paths.get(apiVersionSpecificLocation, new String[0]).resolve("nuts-api-config.json");
            this.storeModelApi.setConfigVersion(this.current().getApiVersion());
            if (this.storeModelSecurity.getUsers() != null) {
                for (NutsUserConfig item : this.storeModelSecurity.getUsers()) {
                    item.setConfigVersion(null);
                }
            }
            ws.elem().setSession(session).setContentType(NutsContentType.JSON).setValue((Object)this.storeModelApi).print(afile);
            this.storeModelApiChanged = false;
            ok = true;
        }
        if (force || this.storeModelRuntimeChanged) {
            Path runtimeVersionSpecificLocation = Paths.get(ws.locations().getStoreLocation(NutsStoreLocation.CONFIG), new String[0]).resolve("id").resolve(ws.locations().getDefaultIdBasedir(ws.getRuntimeId()));
            Path path = runtimeVersionSpecificLocation.resolve("nuts-runtime-config.json");
            this.storeModelRuntime.setConfigVersion(this.current().getApiVersion());
            ws.elem().setSession(session).setContentType(NutsContentType.JSON).setValue((Object)this.storeModelRuntime).print(path);
            this.storeModelRuntimeChanged = false;
            ok = true;
        }
        NutsException error = null;
        for (NutsRepository repo : ws.repos().getRepositories()) {
            try {
                if (!(repo.config() instanceof NutsRepositoryConfigManagerExt)) continue;
                ok |= ((NutsRepositoryConfigManagerExt)repo.config()).getModel().save(force, session);
            }
            catch (NutsException ex) {
                error = ex;
            }
        }
        if (error != null) {
            throw error;
        }
        return ok;
    }

    public boolean save(NutsSession session) {
        return this.save(true, session);
    }

    public NutsWorkspaceBootConfig loadBootConfig(String _ws, boolean global, boolean followLinks, NutsSession session) {
        String _ws0 = _ws;
        String effWorkspaceName = null;
        String lastConfigPath = null;
        NutsWorkspaceConfigBoot lastConfigLoaded = null;
        boolean defaultLocation = false;
        if (_ws != null && _ws.matches("[a-z-]+://.*")) {
            effWorkspaceName = "remote-bootstrap";
            lastConfigPath = NutsUtilPlatforms.getPlatformHomeFolder(null, null, null, (boolean)global, (String)CoreNutsUtils.resolveValidWorkspaceName(effWorkspaceName));
            lastConfigLoaded = this.parseBootConfig(lastConfigPath, session);
            defaultLocation = true;
            return new DefaultNutsWorkspaceBootConfig(session, _ws0, lastConfigPath, effWorkspaceName, defaultLocation, lastConfigLoaded);
        }
        if (followLinks) {
            NutsWorkspaceConfigBoot configLoaded;
            defaultLocation = CoreNutsUtils.isValidWorkspaceName(_ws);
            int maxDepth = 36;
            for (int i = 0; i < maxDepth && (configLoaded = this.parseBootConfig(lastConfigPath = CoreNutsUtils.isValidWorkspaceName(_ws) ? NutsUtilPlatforms.getPlatformHomeFolder(null, null, null, (boolean)global, (String)CoreNutsUtils.resolveValidWorkspaceName(_ws)) : CoreIOUtils.getAbsolutePath(_ws), session)) != null; ++i) {
                if (NutsUtilStrings.isBlank((CharSequence)configLoaded.getWorkspace())) {
                    lastConfigLoaded = configLoaded;
                    break;
                }
                _ws = configLoaded.getWorkspace();
                if (i < maxDepth - 1) continue;
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"cyclic workspace resolution", (Object[])new Object[0]));
            }
            if (lastConfigLoaded == null) {
                return null;
            }
            effWorkspaceName = CoreNutsUtils.resolveValidWorkspaceName(_ws);
            return new DefaultNutsWorkspaceBootConfig(session, _ws0, lastConfigPath, effWorkspaceName, defaultLocation, lastConfigLoaded);
        }
        defaultLocation = CoreNutsUtils.isValidWorkspaceName(_ws);
        lastConfigPath = CoreNutsUtils.isValidWorkspaceName(_ws) ? NutsUtilPlatforms.getPlatformHomeFolder(null, null, null, (boolean)global, (String)CoreNutsUtils.resolveValidWorkspaceName(_ws)) : CoreIOUtils.getAbsolutePath(_ws);
        lastConfigLoaded = this.parseBootConfig(lastConfigPath, session);
        if (lastConfigLoaded == null) {
            return null;
        }
        effWorkspaceName = CoreNutsUtils.resolveValidWorkspaceName(_ws);
        return new DefaultNutsWorkspaceBootConfig(session, _ws0, lastConfigPath, effWorkspaceName, defaultLocation, lastConfigLoaded);
    }

    public NutsWorkspaceOptionsBuilder optionsBuilder(NutsSession session) {
        return new CoreNutsWorkspaceOptions(session);
    }

    public boolean isExcludedExtension(String extensionId, NutsWorkspaceOptions options, NutsSession session) {
        if (extensionId != null && options != null) {
            NutsId pnid = session.getWorkspace().id().parser().parse(extensionId);
            String shortName = pnid.getShortName();
            String artifactId = pnid.getArtifactId();
            for (String excludedExtensionList : options.getExcludedExtensions()) {
                for (String s : excludedExtensionList.split("[;, ]")) {
                    if (s.length() <= 0 || !s.equals(shortName) && !s.equals(artifactId)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public NutsWorkspaceOptions getOptions(NutsSession session) {
        return new ReadOnlyNutsWorkspaceOptions(this.options, session);
    }

    public NutsId createContentFaceId(NutsId id, NutsDescriptor desc) {
        Map q = id.getProperties();
        q.put("packaging", NutsUtilStrings.trim((String)desc.getPackaging()));
        q.put("face", "content");
        return id.builder().setProperties(q).build();
    }

    public NutsWorkspaceListManager createWorkspaceListManager(String name, NutsSession session) {
        return new DefaultNutsWorkspaceListManager(this.ws, session, name);
    }

    public boolean isSupportedRepositoryType(String repositoryType, NutsSession session) {
        if (NutsUtilStrings.isBlank((CharSequence)repositoryType)) {
            repositoryType = "nuts";
        }
        return session.getWorkspace().extensions().createAllSupported(NutsRepositoryFactoryComponent.class, (Object)new NutsRepositoryConfig().setType(repositoryType)).size() > 0;
    }

    public NutsAddRepositoryOptions[] getDefaultRepositories(NutsSession session) {
        ArrayList<NutsAddRepositoryOptions> all = new ArrayList<NutsAddRepositoryOptions>();
        for (NutsRepositoryFactoryComponent provider : session.getWorkspace().extensions().createAll(NutsRepositoryFactoryComponent.class)) {
            for (NutsAddRepositoryOptions d : provider.getDefaultRepositories(session)) {
                all.add(d);
            }
        }
        Collections.sort(all, new Comparator<NutsAddRepositoryOptions>(){

            @Override
            public int compare(NutsAddRepositoryOptions o1, NutsAddRepositoryOptions o2) {
                return Integer.compare(o1.getOrder(), o2.getOrder());
            }
        });
        return all.toArray(new NutsAddRepositoryOptions[0]);
    }

    public Set<String> getAvailableArchetypes(NutsSession session) {
        HashSet<String> set = new HashSet<String>();
        set.add("default");
        for (NutsWorkspaceArchetypeComponent extension : session.getWorkspace().extensions().createAllSupported(NutsWorkspaceArchetypeComponent.class, null)) {
            set.add(extension.getName());
        }
        return set;
    }

    public String resolveRepositoryPath(String repositoryLocation, NutsSession session) {
        String root = this.getRepositoriesRoot(session);
        return Paths.get(session.getWorkspace().io().expandPath(repositoryLocation, root != null ? root : Paths.get(session.getWorkspace().locations().getStoreLocation(NutsStoreLocation.CONFIG), new String[0]).resolve("repos").toString()), new String[0]).toString();
    }

    public NutsIndexStoreFactory getIndexStoreClientFactory() {
        return this.indexStoreClientFactory;
    }

    public String getBootRepositories() {
        return this.current().getBootRepositories();
    }

    public String getJavaCommand() {
        return this.current().getJavaCommand();
    }

    public String getJavaOptions() {
        return this.current().getJavaOptions();
    }

    public boolean isGlobal() {
        return this.current().isGlobal();
    }

    public long getCreationStartTimeMillis() {
        return this.startCreateTime;
    }

    public long getCreationFinishTimeMillis() {
        return this.endCreateTime;
    }

    public long getCreationTimeMillis() {
        return this.endCreateTime - this.startCreateTime;
    }

    public NutsWorkspaceConfigMain getStoreModelMain() {
        return this.storeModelMain;
    }

    public DefaultNutsWorkspaceCurrentConfig current() {
        if (this.currentConfig == null) {
            throw new IllegalStateException("unable to use workspace.current(). Still in initialize status");
        }
        return this.currentConfig;
    }

    public void setStartCreateTimeMillis(long startCreateTime) {
        this.startCreateTime = startCreateTime;
    }

    public void setCurrentConfig(DefaultNutsWorkspaceCurrentConfig currentConfig) {
        this.currentConfig = currentConfig;
    }

    public void setConfigBoot(NutsWorkspaceConfigBoot config, NutsSession options) {
        this.setConfigBoot(config, options, true);
    }

    public void setConfigApi(NutsWorkspaceConfigApi config, NutsSession session) {
        this.setConfigApi(config, session, true);
    }

    public void setConfigRuntime(NutsWorkspaceConfigRuntime config, NutsSession options) {
        this.setConfigRuntime(config, options, true);
    }

    public void setConfigSecurity(NutsWorkspaceConfigSecurity config, NutsSession session) {
        this.setConfigSecurity(config, session, true);
    }

    public void setConfigMain(NutsWorkspaceConfigMain config, NutsSession session) {
        this.setConfigMain(config, session, true);
    }

    public void setEndCreateTimeMillis(long endCreateTime) {
        this.endCreateTime = endCreateTime;
    }

    public void prepareBootApi(NutsId apiId, NutsId runtimeId, boolean force, NutsSession session) {
        if (apiId == null) {
            throw new NutsNotFoundException(session, apiId);
        }
        Path apiConfigFile = Paths.get(session.getWorkspace().locations().getStoreLocation(apiId, NutsStoreLocation.CONFIG), new String[0]).resolve("nuts-api-config.json");
        if (force || !Files.isRegularFile(apiConfigFile, new LinkOption[0])) {
            LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
            if (runtimeId == null) {
                runtimeId = (NutsId)session.getWorkspace().search().addId("net.thevpc.nuts:nuts-runtime").setRuntime(true).setTargetApiVersion(apiId.getVersion()).setFailFast(false).setLatest(true).getResultIds().first();
            }
            if (runtimeId == null) {
                runtimeId = MavenUtils.of(session).resolveLatestMavenId(session.getWorkspace().id().parser().parse("net.thevpc.nuts:nuts-runtime"), rtVersion -> rtVersion.startsWith(apiId.getVersion().getValue() + "."), session);
            }
            if (runtimeId == null) {
                throw new NutsNotFoundException(session, runtimeId);
            }
            m.put("configVersion", apiId.getVersion().getValue());
            m.put("apiVersion", apiId.getVersion().getValue());
            m.put("runtimeId", runtimeId.getLongName());
            String javaCommand = this.getStoredConfigApi().getJavaCommand();
            String javaOptions = this.getStoredConfigApi().getJavaOptions();
            m.put("javaCommand", javaCommand);
            m.put("javaOptions", javaOptions);
            session.getWorkspace().elem().setContentType(NutsContentType.JSON).setValue(m).print(apiConfigFile);
        }
        this.downloadId(apiId, force, null, true, session);
    }

    public void prepareBootRuntime(NutsId id, boolean force, NutsSession session) {
        this.prepareBootRuntimeOrExtension(id, force, true, session);
    }

    public void prepareBootExtension(NutsId id, boolean force, NutsSession session) {
        this.prepareBootRuntimeOrExtension(id, force, false, session);
    }

    public void prepareBoot(boolean force, NutsSession session) {
        this.prepareBootApi(this.ws.getApiId(), this.ws.getRuntimeId(), force, session);
        this.prepareBootRuntime(this.ws.getRuntimeId(), force, session);
        List<NutsWorkspaceConfigBoot.ExtensionConfig> extensions = this.getStoredConfigBoot().getExtensions();
        if (extensions != null) {
            for (NutsWorkspaceConfigBoot.ExtensionConfig extension : extensions) {
                if (!extension.isEnabled()) continue;
                this.prepareBootExtension(extension.getId(), force, session);
            }
        }
    }

    public boolean isConfigurationChanged() {
        return this.storeModelBootChanged || this.storeModelApiChanged || this.storeModelRuntimeChanged || this.storeModelSecurityChanged || this.storeModelMainChanged;
    }

    public boolean loadWorkspace(NutsSession session) {
        try {
            NutsWorkspaceConfigRuntime rconfig;
            NutsWorkspaceUtils.checkSession(this.ws, session);
            NutsWorkspaceConfigBoot _config = this.parseBootConfig(session);
            if (_config == null) {
                return false;
            }
            DefaultNutsWorkspaceCurrentConfig cconfig = new DefaultNutsWorkspaceCurrentConfig(this.ws).merge(_config, session);
            if (cconfig.getApiId() == null) {
                cconfig.setApiId(session.getWorkspace().id().parser().parse("net.thevpc.nuts:nuts#" + this.initOptions.getApiVersion()));
            }
            if (cconfig.getRuntimeId() == null) {
                cconfig.setRuntimeId(this.initOptions.getRuntimeId() == null ? null : this.initOptions.getRuntimeId().toString(), session);
            }
            if (cconfig.getRuntimeBootDescriptor() == null) {
                cconfig.setRuntimeBootDescriptor(this.initOptions.getRuntimeBootDescriptor());
            }
            if (cconfig.getExtensionBootDescriptors() == null) {
                cconfig.setExtensionBootDescriptors(this.initOptions.getExtensionBootDescriptors());
            }
            if (cconfig.getBootRepositories() == null) {
                cconfig.setBootRepositories(this.initOptions.getBootRepositories());
            }
            cconfig.merge(this.getOptions(session), session);
            this.setCurrentConfig(cconfig.build(session.getWorkspace().locations().getWorkspaceLocation(), session));
            NutsVersionCompat compat = this.createNutsVersionCompat(Nuts.getVersion());
            NutsWorkspaceConfigApi aconfig = compat.parseApiConfig(session);
            if (aconfig != null) {
                cconfig.merge(aconfig, session);
            }
            if ((rconfig = compat.parseRuntimeConfig(session)) != null) {
                cconfig.merge(rconfig, session);
            }
            NutsWorkspaceConfigSecurity sconfig = compat.parseSecurityConfig(session);
            NutsWorkspaceConfigMain mconfig = compat.parseMainConfig(session);
            if (this.options.isRecover() || this.options.isReset()) {
                cconfig.setApiId(session.getWorkspace().id().parser().parse("net.thevpc.nuts:nuts#" + this.initOptions.getApiVersion()));
                cconfig.setRuntimeId(this.initOptions.getRuntimeId() == null ? null : this.initOptions.getRuntimeId().toString(), session);
                cconfig.setRuntimeBootDescriptor(this.initOptions.getRuntimeBootDescriptor());
                cconfig.setExtensionBootDescriptors(this.initOptions.getExtensionBootDescriptors());
                cconfig.setBootRepositories(this.initOptions.getBootRepositories());
            }
            this.setCurrentConfig(cconfig.build(session.getWorkspace().locations().getWorkspaceLocation(), session));
            this.setConfigBoot(_config, session, false);
            this.setConfigApi(aconfig, session, false);
            this.setConfigRuntime(rconfig, session, false);
            this.setConfigSecurity(sconfig, session, false);
            this.setConfigMain(mconfig, session, false);
            this.storeModelBootChanged = false;
            this.storeModelApiChanged = false;
            this.storeModelRuntimeChanged = false;
            this.storeModelSecurityChanged = false;
            this.storeModelMainChanged = false;
            return true;
        }
        catch (RuntimeException ex) {
            if (!session.getWorkspace().env().getBootOptions().isRecover()) {
                throw ex;
            }
            this.onLoadWorkspaceError(ex, session);
            return false;
        }
    }

    public void setBootApiVersion(String value, NutsSession session) {
        if (!Objects.equals(value, this.storeModelApi.getApiVersion())) {
            this.storeModelApi.setApiVersion(value);
            this.fireConfigurationChanged("api-version", session, ConfigEventType.API);
        }
    }

    public void setBootRuntimeId(String value, NutsSession session) {
        if (!Objects.equals(value, this.storeModelApi.getRuntimeId())) {
            this.storeModelApi.setRuntimeId(value);
            this.fireConfigurationChanged("runtime-id", session, ConfigEventType.API);
        }
    }

    public void setBootRuntimeDependencies(String value, NutsSession session) {
        if (!Objects.equals(value, this.storeModelRuntime.getDependencies())) {
            this.storeModelRuntime.setDependencies(value);
            this.setConfigRuntime(this.storeModelRuntime, session, true);
        }
    }

    public void setBootRepositories(String value, NutsSession session) {
        if (!Objects.equals(value, this.storeModelBoot.getBootRepositories())) {
            this.storeModelBoot.setBootRepositories(value);
            this.fireConfigurationChanged("boot-repositories", session, ConfigEventType.API);
        }
    }

    public NutsUserConfig getUser(String userId, NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.ws, session);
        NutsUserConfig _config = this.getSecurity(userId);
        if (_config == null && ("admin".equals(userId) || "anonymous".equals(userId))) {
            _config = new NutsUserConfig(userId, null, null, null);
            this.setUser(_config, session);
        }
        return _config;
    }

    public NutsUserConfig[] getUsers(NutsSession session) {
        return this.configUsers.values().toArray(new NutsUserConfig[0]);
    }

    public void setUser(NutsUserConfig config, NutsSession session) {
        if (config != null) {
            this.configUsers.put(config.getUser(), config);
            this.fireConfigurationChanged("user", session, ConfigEventType.SECURITY);
        }
    }

    public void removeUser(String userId, NutsSession session) {
        NutsUserConfig old = this.getSecurity(userId);
        if (old != null) {
            this.configUsers.remove(userId);
            this.fireConfigurationChanged("users", session, ConfigEventType.SECURITY);
        }
    }

    public void setSecure(boolean secure, NutsSession session) {
        if (secure != this.storeModelSecurity.isSecure()) {
            this.storeModelSecurity.setSecure(secure);
            this.fireConfigurationChanged("secure", session, ConfigEventType.SECURITY);
        }
    }

    public void fireConfigurationChanged(String configName, NutsSession session, ConfigEventType t) {
        ((DefaultImportManager)session.getWorkspace().imports()).getModel().invalidateCache();
        switch (t) {
            case API: {
                this.storeModelApiChanged = true;
                break;
            }
            case RUNTIME: {
                this.storeModelRuntimeChanged = true;
                break;
            }
            case SECURITY: {
                this.storeModelSecurityChanged = true;
                break;
            }
            case MAIN: {
                this.storeModelMainChanged = true;
                break;
            }
            case BOOT: {
                this.storeModelBootChanged = true;
            }
        }
        DefaultNutsWorkspaceEvent evt = new DefaultNutsWorkspaceEvent(session, null, "config." + configName, null, true);
        for (NutsWorkspaceListener workspaceListener : session.getWorkspace().events().getWorkspaceListeners()) {
            workspaceListener.onConfigurationChanged((NutsWorkspaceEvent)evt);
        }
    }

    public NutsWorkspaceConfigApi getStoredConfigApi() {
        if (this.storeModelApi.getApiVersion() == null) {
            this.storeModelApi.setApiVersion(Nuts.getVersion());
        }
        return this.storeModelApi;
    }

    public NutsWorkspaceConfigBoot getStoredConfigBoot() {
        return this.storeModelBoot;
    }

    public NutsWorkspaceConfigSecurity getStoredConfigSecurity() {
        return this.storeModelSecurity;
    }

    public NutsWorkspaceConfigMain getStoredConfigMain() {
        return this.storeModelMain;
    }

    public NutsWorkspace getWorkspace() {
        return this.ws;
    }

    public String getRepositoriesRoot(NutsSession session) {
        return Paths.get(session.getWorkspace().locations().getStoreLocation(NutsStoreLocation.CONFIG), new String[0]).resolve("repos").toString();
    }

    public String getTempRepositoriesRoot(NutsSession session) {
        return Paths.get(session.getWorkspace().locations().getStoreLocation(NutsStoreLocation.TEMP), new String[0]).resolve("repos").toString();
    }

    public boolean isValidWorkspaceFolder(NutsSession session) {
        Path file = Paths.get(session.getWorkspace().locations().getWorkspaceLocation(), new String[0]).resolve("nuts-workspace.json");
        return Files.isRegularFile(file, new LinkOption[0]);
    }

    public NutsAuthenticationAgent createAuthenticationAgent(String authenticationAgent, NutsSession session) {
        NutsWorkspace ws = session.getWorkspace();
        authenticationAgent = NutsUtilStrings.trim((String)authenticationAgent);
        NutsAuthenticationAgent supported = null;
        if (authenticationAgent.isEmpty()) {
            supported = (NutsAuthenticationAgent)ws.extensions().createSupported(NutsAuthenticationAgent.class, (Object)"");
        } else {
            List agents = ws.extensions().createAllSupported(NutsAuthenticationAgent.class, (Object)authenticationAgent);
            for (NutsAuthenticationAgent agent : agents) {
                if (!agent.getId().equals(authenticationAgent)) continue;
                supported = agent;
            }
        }
        if (supported == null) {
            throw new NutsExtensionNotFoundException(session, NutsAuthenticationAgent.class, "AuthenticationAgent");
        }
        NutsWorkspaceUtils.setSession(supported, session);
        return supported;
    }

    public void setUsers(NutsUserConfig[] users, NutsSession session) {
        for (NutsUserConfig u : this.getUsers(session)) {
            this.removeUser(u.getUser(), session);
        }
        for (NutsUserConfig conf : users) {
            this.setUser(conf, session);
        }
    }

    public NutsWorkspaceConfigRuntime getStoredConfigRuntime() {
        return this.storeModelRuntime;
    }

    public NutsId createSdkId(String type, String version, NutsSession session) {
        return NutsWorkspaceUtils.of(session).createSdkId(type, version);
    }

    public void onExtensionsPrepared(NutsSession session) {
        try {
            this.indexStoreClientFactory = (NutsIndexStoreFactory)session.getWorkspace().extensions().createSupported(NutsIndexStoreFactory.class, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.indexStoreClientFactory == null) {
            this.indexStoreClientFactory = new DummyNutsIndexStoreFactory();
        }
    }

    public void setConfigApi(NutsWorkspaceConfigApi config, NutsSession session, boolean fire) {
        NutsWorkspaceConfigApi nutsWorkspaceConfigApi = this.storeModelApi = config == null ? new NutsWorkspaceConfigApi() : config;
        if (fire) {
            this.fireConfigurationChanged("boot-api-config", session, ConfigEventType.API);
        }
    }

    public void setConfigRuntime(NutsWorkspaceConfigRuntime config, NutsSession session, boolean fire) {
        NutsWorkspaceConfigRuntime nutsWorkspaceConfigRuntime = this.storeModelRuntime = config == null ? new NutsWorkspaceConfigRuntime() : config;
        if (fire) {
            this.fireConfigurationChanged("boot-runtime-config", session, ConfigEventType.RUNTIME);
        }
    }

    private void setConfigSecurity(NutsWorkspaceConfigSecurity config, NutsSession session, boolean fire) {
        this.storeModelSecurity = config == null ? new NutsWorkspaceConfigSecurity() : config;
        this.configUsers.clear();
        if (this.storeModelSecurity.getUsers() != null) {
            for (NutsUserConfig s : this.storeModelSecurity.getUsers()) {
                this.configUsers.put(s.getUser(), s);
            }
        }
        this.storeModelSecurityChanged = true;
        if (fire) {
            this.fireConfigurationChanged("config-security", session, ConfigEventType.SECURITY);
        }
    }

    private void setConfigMain(NutsWorkspaceConfigMain config, NutsSession session, boolean fire) {
        this.storeModelMain = config == null ? new NutsWorkspaceConfigMain() : config;
        DefaultNutsSdkManager d = (DefaultNutsSdkManager)session.getWorkspace().sdks();
        d.getModel().setSdks(this.storeModelMain.getSdk().toArray(new NutsSdkLocation[0]), session);
        NutsRepositoryManager repos = session.getWorkspace().repos();
        repos.removeAllRepositories();
        if (this.storeModelMain.getRepositories() != null) {
            for (NutsRepositoryRef ref : this.storeModelMain.getRepositories()) {
                repos.addRepository(CoreNutsUtils.refToOptions(ref));
            }
        }
        this.storeModelMainChanged = true;
        if (fire) {
            this.fireConfigurationChanged("config-main", session, ConfigEventType.MAIN);
        }
    }

    private void setConfigBoot(NutsWorkspaceConfigBoot config, NutsSession session, boolean fire) {
        this.storeModelBoot = config;
        if (NutsUtilStrings.isBlank((CharSequence)config.getUuid())) {
            config.setUuid(UUID.randomUUID().toString());
            fire = true;
        }
        if (fire) {
            this.fireConfigurationChanged("config-master", session, ConfigEventType.BOOT);
        }
    }

    public String getBootClassWorldString(NutsSession session) {
        StringBuilder sb = new StringBuilder();
        for (URL bootClassWorldURL : this.getBootClassWorldURLs()) {
            if (sb.length() > 0) {
                sb.append(File.pathSeparator);
            }
            if (CoreIOUtils.isPathFile(bootClassWorldURL.toString())) {
                File f = CoreIOUtils.toPathFile(bootClassWorldURL.toString(), session).toFile();
                sb.append(f.getPath());
                continue;
            }
            sb.append(bootClassWorldURL.toString().replace(":", "\\:"));
        }
        return sb.toString();
    }

    public String toString() {
        String s1 = "NULL";
        String s2 = "NULL";
        s1 = this.ws.getApiId().toString();
        s2 = String.valueOf(this.ws.getRuntimeId());
        return "NutsWorkspaceConfig{workspaceBootId=" + s1 + ", workspaceRuntimeId=" + s2 + ", workspace=" + (this.currentConfig == null ? "NULL" : "'" + ((DefaultNutsWorkspaceLocationManager)this.ws.locations()).getModel().getWorkspaceLocation() + '\'') + '}';
    }

    public void prepareBootRuntimeOrExtension(NutsId id, boolean force, boolean runtime, NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.ws, session);
        NutsWorkspace ws = session.getWorkspace();
        Path configFile = Paths.get(ws.locations().getStoreLocation(NutsStoreLocation.CACHE), new String[0]).resolve("id").resolve(ws.locations().getDefaultIdBasedir(id)).resolve(runtime ? "nuts-runtime-cache.json" : "nuts-extension-cache.json");
        Path jarFile = Paths.get(ws.locations().getStoreLocation(NutsStoreLocation.LIB), new String[0]).resolve("id").resolve(ws.locations().getDefaultIdBasedir(id)).resolve(ws.locations().getDefaultIdFilename(id.builder().setFaceContent().setPackaging("jar").build()));
        if (!force && Files.isRegularFile(configFile, new LinkOption[0]) && Files.isRegularFile(jarFile, new LinkOption[0])) {
            return;
        }
        ArrayList<NutsId> deps = new ArrayList<NutsId>();
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.put("id", id.getLongName());
        NutsDefinition def = ws.fetch().setId(id).setDependencies(true).setOptional(Boolean.valueOf(false)).addScope(NutsDependencyScopePattern.RUN).setDependencyFilter(CoreNutsDependencyUtils.createJavaRunDependencyFilter(session)).setContent(true).setFailFast(false).setSession(CoreNutsUtils.silent(session)).getResultDefinition();
        if (def == null) {
            this._LOGOP(session).level(Level.CONFIG).verb(NutsLogVerb.WARNING).log("selected repositories ({0}) cannot reach runtime package. fallback to default.", new Object[]{Arrays.stream(ws.repos().setSession(session).getRepositories()).map(NutsRepository::getName).collect(Collectors.joining(", "))});
            HashMap<String, String> defaults = new HashMap<String, String>();
            MavenUtils.DepsAndRepos depsAndRepos = MavenUtils.of(session).loadDependenciesAndRepositoriesFromPomPath(id, this.resolveBootRepositoriesList().resolveSelectors(defaults), session);
            if (depsAndRepos == null) {
                throw new NutsNotFoundException(session, id);
            }
            m.put("dependencies", String.join((CharSequence)";", depsAndRepos.deps));
            if (runtime) {
                m.put("bootRepositories", String.join((CharSequence)";", depsAndRepos.repos));
            }
            for (String dep : depsAndRepos.deps) {
                deps.add(ws.id().parser().parse(dep));
            }
        } else {
            for (NutsDependency nutsDependency : def.getDependencies()) {
                deps.add(nutsDependency.toId());
            }
            m.put("dependencies", def.getDependencies().stream().map(x -> x.toId().getLongName()).collect(Collectors.joining(";")));
            if (runtime) {
                m.put("bootRepositories", (String)def.getDescriptor().getProperties().get("nuts-runtime-repositories"));
            }
        }
        if (force || !Files.isRegularFile(configFile, new LinkOption[0])) {
            ws.elem().setContentType(NutsContentType.JSON).setValue(m).print(configFile);
        }
        this.downloadId(id, force, def != null && def.getContent().getPath() != null ? def.getContent().getFilePath() : null, false, session);
        for (NutsId nutsId : deps) {
            this.downloadId(nutsId, force, null, true, session);
        }
    }

    private void downloadId(NutsId id, boolean force, Path path, boolean fetch, NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.ws, session);
        NutsWorkspace ws = session.getWorkspace();
        String idFileName = ws.locations().getDefaultIdFilename(id.builder().setFaceContent().setPackaging("jar").build());
        Path jarFile = Paths.get(ws.locations().getStoreLocation(NutsStoreLocation.LIB), new String[0]).resolve("id").resolve(ws.locations().getDefaultIdBasedir(id)).resolve(idFileName);
        if (force || !Files.isRegularFile(jarFile, new LinkOption[0])) {
            if (path != null) {
                ws.io().copy().from(path).to(jarFile).setSession(session).run();
            } else {
                NutsDefinition def;
                if (fetch && (def = ws.fetch().setId(id).setDependencies(true).setOptional(Boolean.valueOf(false)).addScope(NutsDependencyScopePattern.RUN).setDependencyFilter(CoreNutsDependencyUtils.createJavaRunDependencyFilter(session)).setSession(session.copy().setTrace(Boolean.valueOf(false))).setContent(true).setFailFast(false).getResultDefinition()) != null && def.getPath() != null) {
                    ws.io().copy().from(def.getPath()).to(jarFile).setSession(session).run();
                    return;
                }
                for (NutsRepositorySelector.Selection pp0 : this.resolveBootRepositoriesList().resolveSelectors(null)) {
                    String pp;
                    NutsAddRepositoryOptions opt = NutsRepositorySelector.createRepositoryOptions(pp0, false, session);
                    String string = pp = opt.getConfig() == null ? opt.getLocation() : opt.getConfig().getLocation();
                    if (CoreIOUtils.isPathHttp(pp)) {
                        try {
                            if (!pp.endsWith("/")) {
                                pp = pp + "/";
                            }
                            ws.io().copy().from(pp + ws.locations().getDefaultIdBasedir(id) + "/" + idFileName).to(jarFile).run();
                            return;
                        }
                        catch (Exception exception) {
                            continue;
                        }
                    }
                    try {
                        ws.io().copy().from(Paths.get(pp, new String[0]).resolve(ws.locations().getDefaultIdBasedir(id)).resolve(idFileName)).to(jarFile).run();
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unable to load %s", (Object[])new Object[]{id}));
            }
        }
    }

    public void onPreUpdateConfig(String confName, NutsSession session) {
        this.preUpdateConfigStoreLocations = new NutsStoreLocationsMap(this.currentConfig.getStoreLocations());
    }

    public void onPostUpdateConfig(String confName, NutsSession session) {
        this.preUpdateConfigStoreLocations = new NutsStoreLocationsMap(this.currentConfig.getStoreLocations());
        DefaultNutsWorkspaceCurrentConfig d = this.currentConfig;
        d.setUserStoreLocations(new NutsHomeLocationsMap(this.storeModelBoot.getStoreLocations()).toMapOrNull());
        d.setHomeLocations(new NutsHomeLocationsMap(this.storeModelBoot.getHomeLocations()).toMapOrNull());
        d.build(this.ws.locations().getWorkspaceLocation(), session);
        NutsStoreLocationsMap newSL = new NutsStoreLocationsMap(this.currentConfig.getStoreLocations());
        for (NutsStoreLocation sl : NutsStoreLocation.values()) {
            Path oldPathObj;
            String newPath;
            String oldPath = this.preUpdateConfigStoreLocations.get(sl);
            if (oldPath.equals(newPath = newSL.get(sl)) || !Files.exists(oldPathObj = Paths.get(oldPath, new String[0]), new LinkOption[0])) continue;
            CoreIOUtils.copyFolder(oldPathObj, Paths.get(newPath, new String[0]));
        }
        this.fireConfigurationChanged(confName, session, ConfigEventType.API);
    }

    private void onLoadWorkspaceError(Throwable ex, NutsSession session) {
        DefaultNutsWorkspaceConfigModel wconfig = this;
        Path file = Paths.get(this.ws.locations().getWorkspaceLocation(), new String[0]).resolve("nuts-workspace.json");
        if (wconfig.isReadOnly()) {
            throw new UncheckedIOException("unable to load config file " + file.toString(), new IOException(ex));
        }
        String fileSuffix = Instant.now().toString();
        fileSuffix = fileSuffix.replace(':', '-');
        String fileName = "nuts-workspace-" + fileSuffix;
        Path logError = Paths.get(this.ws.locations().getStoreLocation(this.ws.getApiId(), NutsStoreLocation.LOG), new String[0]).resolve("invalid-config");
        Path logFile = logError.resolve(fileName + ".error");
        this._LOGOP(session).level(Level.SEVERE).verb(NutsLogVerb.FAIL).log("erroneous workspace config file. Unable to load file {0} : {1}", new Object[]{file, ex});
        try {
            CoreIOUtils.mkdirs(logError);
        }
        catch (Exception ex1) {
            throw new UncheckedIOException("unable to log workspace error while loading config file " + file.toString() + " : " + ex1.toString(), new IOException(ex));
        }
        Path newfile = logError.resolve(fileName + ".json");
        this._LOGOP(session).level(Level.SEVERE).verb(NutsLogVerb.FAIL).log("erroneous workspace config file will be replaced by a fresh one. Old config is copied to {0}\n error logged to  {1}", new Object[]{newfile.toString(), logFile});
        try {
            Files.move(file, newfile, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("unable to load and re-create config file " + file.toString() + " : " + e.toString(), new IOException(ex));
        }
        try (PrintStream o = new PrintStream(logFile.toFile());){
            o.println("workspace.path:");
            o.println(this.ws.locations().getWorkspaceLocation());
            o.println("workspace.options:");
            o.println(wconfig.getOptions(session).formatter().setCompact(false).setRuntime(true).setInit(true).setExported(true).getBootCommandLine());
            for (NutsStoreLocation location : NutsStoreLocation.values()) {
                o.println("location." + location.id() + ":");
                o.println(this.ws.locations().getStoreLocation(location));
            }
            o.println("java.class.path:");
            o.println(System.getProperty("java.class.path"));
            o.println();
            ex.printStackTrace(o);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public NutsUserConfig getSecurity(String id) {
        return this.configUsers.get(id);
    }

    private NutsWorkspaceConfigBoot parseBootConfig(NutsSession session) {
        return this.parseBootConfig(this.ws.locations().getWorkspaceLocation(), session);
    }

    private NutsWorkspaceConfigBoot parseBootConfig(String path, NutsSession session) {
        Path file = Paths.get(path, new String[0]).resolve("nuts-workspace.json");
        byte[] bytes = CompatUtils.readAllBytes(file);
        if (bytes == null) {
            return null;
        }
        try {
            Map a_config0 = (Map)this.ws.elem().setSession(session).setContentType(NutsContentType.JSON).parse(bytes, Map.class);
            String version = (String)a_config0.get("configVersion");
            if (version == null && (version = (String)a_config0.get("createApiVersion")) == null) {
                version = Nuts.getVersion();
            }
            return this.createNutsVersionCompat(version).parseConfig(bytes, session);
        }
        catch (Exception ex) {
            this._LOGOP(session).level(Level.SEVERE).verb(NutsLogVerb.FAIL).log("erroneous workspace config file. Unable to load file {0} : {1}", new Object[]{file, ex});
            throw new UncheckedIOException("unable to load config file " + file.toString(), new IOException(ex));
        }
    }

    private NutsVersionCompat createNutsVersionCompat(String apiVersion) {
        int buildNumber = CoreNutsUtils.getApiVersionOrdinalNumber(apiVersion);
        if (buildNumber < 506) {
            return new NutsVersionCompat502(this.ws, apiVersion);
        }
        if (buildNumber <= 506) {
            return new NutsVersionCompat506(this.ws, apiVersion);
        }
        return new NutsVersionCompat507(this.ws, apiVersion);
    }

    public NutsRepositorySelector.SelectorList resolveBootRepositoriesList() {
        if (this.parsedBootRepositoriesList != null) {
            return this.parsedBootRepositoriesList;
        }
        this.parsedBootRepositoriesList = NutsRepositorySelector.parse(this.options.getRepositories());
        return this.parsedBootRepositoriesList;
    }

    public NutsWorkspaceConfigBoot getStoreModelBoot() {
        return this.storeModelBoot;
    }

    public NutsWorkspaceConfigApi getStoreModelApi() {
        return this.storeModelApi;
    }

    public NutsWorkspaceConfigRuntime getStoreModelRuntime() {
        return this.storeModelRuntime;
    }

    public NutsWorkspaceConfigSecurity getStoreModelSecurity() {
        return this.storeModelSecurity;
    }

    private class NutsWorkspaceStoredConfigImpl
    implements NutsWorkspaceStoredConfig {
        public String getName() {
            return DefaultNutsWorkspaceConfigModel.this.getStoredConfigBoot().getName();
        }

        public NutsStoreLocationStrategy getStoreLocationStrategy() {
            return DefaultNutsWorkspaceConfigModel.this.getStoredConfigBoot().getStoreLocationStrategy();
        }

        public NutsStoreLocationStrategy getRepositoryStoreLocationStrategy() {
            return DefaultNutsWorkspaceConfigModel.this.getStoredConfigBoot().getStoreLocationStrategy();
        }

        public NutsOsFamily getStoreLocationLayout() {
            return DefaultNutsWorkspaceConfigModel.this.getStoredConfigBoot().getStoreLocationLayout();
        }

        public Map<String, String> getStoreLocations() {
            return DefaultNutsWorkspaceConfigModel.this.getStoredConfigBoot().getStoreLocations();
        }

        public Map<String, String> getHomeLocations() {
            return DefaultNutsWorkspaceConfigModel.this.getStoredConfigBoot().getHomeLocations();
        }

        public String getStoreLocation(NutsStoreLocation folderType) {
            return new NutsStoreLocationsMap(DefaultNutsWorkspaceConfigModel.this.getStoredConfigBoot().getStoreLocations()).get(folderType);
        }

        public String getHomeLocation(NutsOsFamily layout, NutsStoreLocation folderType) {
            return new NutsHomeLocationsMap(DefaultNutsWorkspaceConfigModel.this.getStoredConfigBoot().getHomeLocations()).get(layout, folderType);
        }

        public NutsId getApiId() {
            String v = DefaultNutsWorkspaceConfigModel.this.getStoredConfigApi().getApiVersion();
            NutsWorkspace ws = NutsWorkspaceUtils.defaultSession(DefaultNutsWorkspaceConfigModel.this.ws).getWorkspace();
            return v == null ? null : ws.id().parser().parse("net.thevpc.nuts:nuts#" + v);
        }

        public NutsId getRuntimeId() {
            String v = DefaultNutsWorkspaceConfigModel.this.getStoredConfigApi().getRuntimeId();
            NutsWorkspace ws = NutsWorkspaceUtils.defaultSession(DefaultNutsWorkspaceConfigModel.this.ws).getWorkspace();
            return v == null ? null : (v.contains("#") ? ws.id().parser().parse(v) : ws.id().parser().parse("net.thevpc.nuts:nuts-runtime#" + v));
        }

        public String getRuntimeDependencies() {
            return DefaultNutsWorkspaceConfigModel.this.getStoredConfigRuntime().getDependencies();
        }

        public String getBootRepositories() {
            return DefaultNutsWorkspaceConfigModel.this.getStoredConfigBoot().getBootRepositories();
        }

        public String getJavaCommand() {
            return DefaultNutsWorkspaceConfigModel.this.getStoredConfigApi().getJavaCommand();
        }

        public String getJavaOptions() {
            return DefaultNutsWorkspaceConfigModel.this.getStoredConfigApi().getJavaOptions();
        }

        public boolean isGlobal() {
            return DefaultNutsWorkspaceConfigModel.this.getStoredConfigBoot().isGlobal();
        }
    }
}

