/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.config;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsUtilPlatforms;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceBootConfig;
import net.thevpc.nuts.NutsWorkspaceConfigManager;
import net.thevpc.nuts.NutsWorkspaceListManager;
import net.thevpc.nuts.NutsWorkspaceOptions;
import net.thevpc.nuts.NutsWorkspaceOptionsBuilder;
import net.thevpc.nuts.NutsWorkspaceStoredConfig;
import net.thevpc.nuts.runtime.core.config.NutsWorkspaceConfigManagerExt;
import net.thevpc.nuts.runtime.core.model.CoreNutsWorkspaceOptions;
import net.thevpc.nuts.runtime.core.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.standalone.config.DefaultNutsWorkspaceConfigModel;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsIndexStoreFactory;

public class DefaultNutsWorkspaceConfigManager
implements NutsWorkspaceConfigManager,
NutsWorkspaceConfigManagerExt {
    private DefaultNutsWorkspaceConfigModel model;
    private NutsSession session;

    public DefaultNutsWorkspaceConfigManager(DefaultNutsWorkspaceConfigModel model) {
        this.model = model;
    }

    @Override
    public DefaultNutsWorkspaceConfigModel getModel() {
        return this.model;
    }

    public NutsWorkspaceStoredConfig stored() {
        this.checkSession();
        return this.model.stored();
    }

    public boolean isReadOnly() {
        this.checkSession();
        return this.model.isReadOnly();
    }

    public boolean save(boolean force) {
        this.checkSession();
        return this.model.save(force, this.session);
    }

    public boolean save() {
        this.checkSession();
        return this.model.save(this.session);
    }

    public NutsWorkspaceBootConfig loadBootConfig(String _ws, boolean global, boolean followLinks) {
        this.checkSession();
        return this.model.loadBootConfig(_ws, global, followLinks, this.session);
    }

    public NutsWorkspaceOptionsBuilder optionsBuilder() {
        this.checkSession();
        return new CoreNutsWorkspaceOptions(this.session);
    }

    public boolean isExcludedExtension(String extensionId, NutsWorkspaceOptions options) {
        this.checkSession();
        return this.model.isExcludedExtension(extensionId, options, this.session);
    }

    public NutsId createContentFaceId(NutsId id, NutsDescriptor desc) {
        this.checkSession();
        return this.model.createContentFaceId(id, desc);
    }

    public NutsWorkspaceListManager createWorkspaceListManager(String name) {
        this.checkSession();
        return this.model.createWorkspaceListManager(name, this.session);
    }

    public boolean isSupportedRepositoryType(String repositoryType) {
        this.checkSession();
        return this.model.isSupportedRepositoryType(repositoryType, this.session);
    }

    public NutsAddRepositoryOptions[] getDefaultRepositories() {
        this.checkSession();
        return this.model.getDefaultRepositories(this.session);
    }

    public Set<String> getAvailableArchetypes() {
        this.checkSession();
        return this.model.getAvailableArchetypes(this.session);
    }

    public String resolveRepositoryPath(String repositoryLocation) {
        this.checkSession();
        return this.model.resolveRepositoryPath(repositoryLocation, this.session);
    }

    public NutsIndexStoreFactory getIndexStoreClientFactory() {
        this.checkSession();
        return this.model.getIndexStoreClientFactory();
    }

    public String getJavaCommand() {
        this.checkSession();
        return this.model.getJavaCommand();
    }

    public String getJavaOptions() {
        this.checkSession();
        return this.model.getJavaOptions();
    }

    public boolean isGlobal() {
        this.checkSession();
        return this.model.isGlobal();
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsWorkspaceConfigManager setSession(NutsSession session) {
        this.session = session;
        return this;
    }

    protected void checkSession() {
        NutsWorkspaceUtils.checkSession(this.model.getWorkspace(), this.session);
    }

    public String getHashName(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof String && o.toString().isEmpty()) {
            return "empty";
        }
        if (o instanceof NutsWorkspace) {
            return this.getWorkspaceHashName(((NutsWorkspace)o).getLocation());
        }
        if (o instanceof NutsSession) {
            return this.getWorkspaceHashName(((NutsSession)o).getWorkspace().getLocation());
        }
        if (o instanceof Integer) {
            int i = (Integer)o;
            return CoreNutsUtils.COLOR_NAMES[Math.abs(i) % CoreNutsUtils.COLOR_NAMES.length];
        }
        return this.getHashName(o.hashCode());
    }

    public String getWorkspaceHashName() {
        return this.getHashName(this.model.getWorkspace());
    }

    public String getWorkspaceHashName(String path) {
        String p;
        String n;
        if (path == null) {
            path = "";
        }
        if (path.contains("\\") || path.contains("/")) {
            Path pp = Paths.get(path, new String[0]).toAbsolutePath().normalize();
            n = pp.getFileName().toString();
            p = pp.getParent() == null ? null : pp.getParent().toString();
        } else {
            n = path;
            p = "";
        }
        if (p == null) {
            return ("Root " + n).trim();
        }
        Path root = Paths.get(NutsUtilPlatforms.getPlatformHomeFolder(null, (NutsStoreLocation)NutsStoreLocation.CONFIG, null, (boolean)false, null), new String[0]).getParent().getParent();
        if (p.equals(root.toString())) {
            return n;
        }
        return (this.getHashName(p) + " " + n).trim();
    }

    public String toString() {
        String s1 = "NULL";
        String s2 = "NULL";
        s1 = String.valueOf(this.model.getWorkspace().getApiId());
        s2 = String.valueOf(this.model.getWorkspace().getRuntimeId());
        return "NutsWorkspaceConfig{workspaceBootId=" + s1 + ", workspaceRuntimeId=" + s2 + ", workspace=" + (this.model.getCurrentConfig() == null ? "NULL" : "'" + this.model.getWorkspace().locations().getWorkspaceLocation() + '\'') + '}';
    }
}

