/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.config;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSdkLocation;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextStyles;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsVersionFilter;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.config.NutsWorkspaceConfigManagerExt;
import net.thevpc.nuts.runtime.standalone.config.ConfigEventType;
import net.thevpc.nuts.runtime.standalone.config.NutsSdkLocationSelectComparator;
import net.thevpc.nuts.runtime.standalone.util.NutsJavaSdkUtils;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public class DefaultNutsSdkModel {
    private final Map<String, List<NutsSdkLocation>> configSdks = new LinkedHashMap<String, List<NutsSdkLocation>>();
    private NutsWorkspace workspace;

    public DefaultNutsSdkModel(NutsWorkspace ws) {
        this.workspace = ws;
    }

    public NutsWorkspace getWorkspace() {
        return this.workspace;
    }

    public String[] findSdkTypes() {
        Set<String> s = this.getSdk().keySet();
        return s.toArray(new String[0]);
    }

    public boolean add(NutsSdkLocation location, NutsSession session) {
        return this.add0(location, session, true);
    }

    public boolean add0(NutsSdkLocation location, NutsSession session, boolean notify) {
        if (location != null) {
            if (NutsUtilStrings.isBlank((CharSequence)location.getProduct())) {
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"sdk type should not be null", (Object[])new Object[0]));
            }
            if (NutsUtilStrings.isBlank((CharSequence)location.getName())) {
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"sdk name should not be null", (Object[])new Object[0]));
            }
            if (NutsUtilStrings.isBlank((CharSequence)location.getVersion())) {
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"sdk version should not be null", (Object[])new Object[0]));
            }
            if (NutsUtilStrings.isBlank((CharSequence)location.getPath())) {
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"sdk path should not be null", (Object[])new Object[0]));
            }
            List<NutsSdkLocation> list = this.getSdk().get(location.getProduct());
            if (list == null) {
                list = new ArrayList<NutsSdkLocation>();
                this.configSdks.put(location.getProduct(), list);
            }
            NutsSdkLocation old = null;
            for (NutsSdkLocation nutsSdkLocation : list) {
                if (!Objects.equals(nutsSdkLocation.getPackaging(), location.getPackaging()) || !Objects.equals(nutsSdkLocation.getProduct(), location.getProduct()) || !nutsSdkLocation.getName().equals(location.getName()) && !nutsSdkLocation.getPath().equals(location.getPath())) continue;
                old = nutsSdkLocation;
                break;
            }
            if (old != null) {
                return false;
            }
            list.add(location);
            if (notify) {
                if (session.isPlainTrace()) {
                    session.out().resetLine().printf("%s %s %s (%s) %s at %s%n", new Object[]{session.getWorkspace().text().forStyled("install", NutsTextStyles.of((NutsTextStyle)NutsTextStyle.success())), location.getId().getShortName(), location.getPackaging(), location.getProduct(), session.getWorkspace().version().parser().parse(location.getVersion()), session.getWorkspace().io().path(location.getPath())});
                }
                NutsWorkspaceConfigManagerExt.of(this.workspace.config()).getModel().fireConfigurationChanged("sdk", session, ConfigEventType.MAIN);
            }
            return true;
        }
        return false;
    }

    public boolean update(NutsSdkLocation oldLocation, NutsSdkLocation newLocation, NutsSession session) {
        boolean updated = false;
        updated |= this.remove(oldLocation, session);
        updated |= this.remove(newLocation, session);
        return updated |= this.add(newLocation, session);
    }

    public boolean remove(NutsSdkLocation location, NutsSession session) {
        List<NutsSdkLocation> list;
        if (location != null && (list = this.getSdk().get(location.getProduct())) != null && list.remove(location)) {
            NutsWorkspaceConfigManagerExt.of(session.getWorkspace().config()).getModel().fireConfigurationChanged("sdk", session, ConfigEventType.MAIN);
            return true;
        }
        return false;
    }

    public NutsSdkLocation findByName(String type, String locationName, NutsSession session) {
        return this.findOne(type, location -> location.getName().equals(locationName), session);
    }

    public NutsSdkLocation findByPath(String type, String path, NutsSession session) {
        return this.findOne(type, location -> location.getPath() != null && location.getPath().equals(path.toString()), session);
    }

    public NutsSdkLocation findByVersion(String type, String version, NutsSession session) {
        return this.findOne(type, location -> location.getVersion().equals(version), session);
    }

    public NutsSdkLocation find(NutsSdkLocation location, NutsSession session) {
        if (location == null) {
            return null;
        }
        String type = location.getId().getArtifactId();
        type = this.toValidSdkName(type);
        List<NutsSdkLocation> list = this.getSdk().get(type);
        if (list != null) {
            for (NutsSdkLocation location2 : list) {
                if (!location2.equals((Object)location)) continue;
                return location2;
            }
        }
        return null;
    }

    public NutsSdkLocation findByVersion(String type, NutsVersionFilter javaVersionFilter, NutsSession session) {
        return this.findOne(type, location -> javaVersionFilter == null || javaVersionFilter.acceptVersion(session.getWorkspace().version().parser().parse(location.getVersion()), session), session);
    }

    public NutsSdkLocation[] searchSystem(String sdkType, NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.workspace, session);
        if ("java".equals(sdkType)) {
            try {
                NutsSdkLocation[] nutsSdkLocations = NutsJavaSdkUtils.of(session.getWorkspace()).searchJdkLocationsFuture(session).get();
                return nutsSdkLocations;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return new NutsSdkLocation[0];
    }

    public NutsSdkLocation[] searchSystem(String sdkType, String path, NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.workspace, session);
        if ("java".equals(sdkType)) {
            return NutsJavaSdkUtils.of(session.getWorkspace()).searchJdkLocations(path, session);
        }
        return new NutsSdkLocation[0];
    }

    public NutsSdkLocation resolve(String sdkType, String path, String preferredName, NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.workspace, session);
        if ("java".equals(sdkType)) {
            return NutsJavaSdkUtils.of(session.getWorkspace()).resolveJdkLocation(path, null, session);
        }
        return null;
    }

    public void setSdks(NutsSdkLocation[] locations, NutsSession session) {
        this.configSdks.clear();
        for (NutsSdkLocation sdk : locations) {
            this.add0(sdk, session, false);
        }
    }

    public NutsSdkLocation findOne(String type, Predicate<NutsSdkLocation> filter, NutsSession session) {
        NutsSdkLocation[] a = this.find(type, filter, session);
        return a.length == 0 ? null : a[0];
    }

    public NutsSdkLocation[] find(String type, Predicate<NutsSdkLocation> filter, NutsSession session) {
        if (filter == null) {
            if (type == null) {
                ArrayList<NutsSdkLocation> all = new ArrayList<NutsSdkLocation>();
                for (List<NutsSdkLocation> value : this.configSdks.values()) {
                    all.addAll(value);
                }
                return all.toArray(new NutsSdkLocation[0]);
            }
            type = this.toValidSdkName(type);
            List<NutsSdkLocation> list = this.getSdk().get(type);
            if (list == null) {
                return new NutsSdkLocation[0];
            }
            return list.toArray(new NutsSdkLocation[0]);
        }
        ArrayList<NutsSdkLocation> ret = new ArrayList<NutsSdkLocation>();
        if (type == null) {
            for (List<NutsSdkLocation> found : this.getSdk().values()) {
                for (NutsSdkLocation location : found) {
                    if (!filter.test(location)) continue;
                    ret.add(location);
                }
            }
        } else {
            type = this.toValidSdkName(type);
            List<NutsSdkLocation> found = this.getSdk().get(type);
            if (found != null) {
                for (NutsSdkLocation location : found) {
                    if (!filter.test(location)) continue;
                    ret.add(location);
                }
            }
        }
        if (!ret.isEmpty()) {
            ret.sort(new NutsSdkLocationSelectComparator(session.getWorkspace()));
        }
        return ret.toArray(new NutsSdkLocation[0]);
    }

    private String toValidSdkName(String type) {
        type = NutsUtilStrings.isBlank((CharSequence)type) ? "java" : NutsUtilStrings.trim((String)type);
        return type;
    }

    public Map<String, List<NutsSdkLocation>> getSdk() {
        return this.configSdks;
    }
}

