/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.config;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsIndexStore;
import net.thevpc.nuts.NutsIndexerNotAccessibleException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPredicates;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUnsupportedOperationException;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.bundles.iter.IteratorUtils;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.config.AbstractNutsIndexStore;
import net.thevpc.nuts.runtime.standalone.config.NutsIdFilterToNutsIdPredicate;
import net.thevpc.nuts.spi.NutsTransportConnection;

public class DefaultNutsIndexStore
extends AbstractNutsIndexStore {
    public DefaultNutsIndexStore(NutsRepository repository) {
        super(repository);
    }

    public Iterator<NutsId> searchVersions(NutsId id, NutsSession session) {
        return IteratorUtils.supplier(() -> {
            if (this.isInaccessible()) {
                return IteratorUtils.emptyIterator();
            }
            String URL2 = "http://localhost:7070/indexer/id/allVersions" + String.format("?repositoryUuid=%s&name=%s&repo=%s&group=%s&os=%s&osdist=%s&arch=%s&face=%s&", this.getRepository().getUuid(), NutsUtilStrings.trim((String)id.getArtifactId()), NutsUtilStrings.trim((String)id.getRepository()), NutsUtilStrings.trim((String)id.getGroupId()), NutsUtilStrings.trim((String)id.getOs()), NutsUtilStrings.trim((String)id.getOsdist()), NutsUtilStrings.trim((String)id.getArch()), NutsUtilStrings.trim((String)id.getFace()));
            try {
                NutsTransportConnection clientFacade = CoreIOUtils.getHttpClientFacade(session, URL2);
                Map[] array = (Map[])session.getWorkspace().elem().setContentType(NutsContentType.JSON).parse((Reader)new InputStreamReader(clientFacade.open()), Map[].class);
                return Arrays.stream(array).map(s -> session.getWorkspace().id().parser().parse(s.get("stringId").toString())).collect(Collectors.toList()).iterator();
            }
            catch (UncheckedIOException | NutsIOException e) {
                this.setInaccessible();
                return IteratorUtils.emptyIterator();
            }
        }, "searchIndex");
    }

    public Iterator<NutsId> search(NutsIdFilter filter, NutsSession session) {
        return IteratorUtils.supplier(() -> {
            if (this.isInaccessible()) {
                throw new NutsIndexerNotAccessibleException(session, NutsMessage.cstyle((String)"index search failed for %s", (Object[])new Object[]{this.getRepository().getName()}));
            }
            String URL2 = "http://localhost:7070/indexer/id?repositoryUuid=" + this.getRepository().getUuid();
            try {
                NutsTransportConnection clientFacade = CoreIOUtils.getHttpClientFacade(session, URL2);
                Map[] array = (Map[])session.getWorkspace().elem().setContentType(NutsContentType.JSON).parse((Reader)new InputStreamReader(clientFacade.open()), Map[].class);
                return Arrays.stream(array).map(s -> session.getWorkspace().id().parser().parse(s.get("stringId").toString())).filter((Predicate<NutsId>)(filter != null ? new NutsIdFilterToNutsIdPredicate(filter, session) : NutsPredicates.always())).iterator();
            }
            catch (UncheckedIOException | NutsIOException e) {
                this.setInaccessible();
                throw new NutsIndexerNotAccessibleException(session, NutsMessage.cstyle((String)"index search failed for %s", (Object[])new Object[]{this.getRepository().getName()}));
            }
        }, "searchIndex");
    }

    public NutsIndexStore invalidate(NutsId id, NutsSession session) {
        if (this.isInaccessible()) {
            return this;
        }
        String URL2 = "http://localhost:7070/indexer/id/delete" + String.format("?repositoryUuid=%s&name=%s&repo=%s&group=%s&version=%s&os=%s&osdist=%s&arch=%s&face=%s", this.getRepository().getUuid(), NutsUtilStrings.trim((String)id.getArtifactId()), NutsUtilStrings.trim((String)id.getRepository()), NutsUtilStrings.trim((String)id.getGroupId()), NutsUtilStrings.trim((String)id.getVersion().toString()), NutsUtilStrings.trim((String)id.getOs()), NutsUtilStrings.trim((String)id.getOsdist()), NutsUtilStrings.trim((String)id.getArch()), NutsUtilStrings.trim((String)id.getFace()));
        try {
            NutsTransportConnection clientFacade = CoreIOUtils.getHttpClientFacade(session, URL2);
            clientFacade.open();
        }
        catch (UncheckedIOException | NutsIOException e) {
            this.setInaccessible();
        }
        return this;
    }

    public NutsIndexStore revalidate(NutsId id, NutsSession session) {
        if (this.isInaccessible()) {
            return this;
        }
        String URL2 = "http://localhost:7070/indexer/id/addData" + String.format("?repositoryUuid=%s&name=%s&repo=%s&group=%s&version=%s&os=%s&osdist=%s&arch=%s&face=%s", this.getRepository().getUuid(), NutsUtilStrings.trim((String)id.getArtifactId()), NutsUtilStrings.trim((String)id.getRepository()), NutsUtilStrings.trim((String)id.getGroupId()), NutsUtilStrings.trim((String)id.getVersion().toString()), NutsUtilStrings.trim((String)id.getOs()), NutsUtilStrings.trim((String)id.getOsdist()), NutsUtilStrings.trim((String)id.getArch()), NutsUtilStrings.trim((String)id.getFace()));
        try {
            NutsTransportConnection clientFacade = CoreIOUtils.getHttpClientFacade(session, URL2);
            clientFacade.open();
        }
        catch (UncheckedIOException | NutsIOException e) {
            this.setInaccessible();
        }
        return this;
    }

    public NutsIndexStore subscribe(NutsSession session) {
        String URL2 = "http://localhost:7070/indexer/subscription/subscribe?workspaceLocation=" + CoreIOUtils.urlEncodeString(session.getWorkspace().locations().getWorkspaceLocation().toString()) + "&repositoryUuid=" + CoreIOUtils.urlEncodeString(this.getRepository().getUuid());
        try {
            NutsTransportConnection clientFacade = CoreIOUtils.getHttpClientFacade(session, URL2);
            clientFacade.open();
        }
        catch (UncheckedIOException | NutsIOException e) {
            throw new NutsUnsupportedOperationException(session, NutsMessage.cstyle((String)"unable to subscribe for repository%s", (Object[])new Object[]{this.getRepository().getName()}), e);
        }
        return this;
    }

    public NutsIndexStore unsubscribe(NutsSession session) {
        String URL2 = "http://localhost:7070/indexer/subscription/unsubscribe?workspaceLocation=" + CoreIOUtils.urlEncodeString(session.getWorkspace().locations().getWorkspaceLocation().toString()) + "&repositoryUuid=" + CoreIOUtils.urlEncodeString(this.getRepository().getUuid());
        try {
            NutsTransportConnection clientFacade = CoreIOUtils.getHttpClientFacade(session, URL2);
            clientFacade.open();
        }
        catch (UncheckedIOException | NutsIOException e) {
            throw new NutsUnsupportedOperationException(session, NutsMessage.cstyle((String)"unable to unsubscribe for repository %s", (Object[])new Object[]{this.getRepository().getName()}), e);
        }
        return this;
    }

    public boolean isSubscribed(NutsSession session) {
        String URL2 = "http://localhost:7070/indexer/subscription/isSubscribed?workspaceLocation=" + CoreIOUtils.urlEncodeString(session.getWorkspace().locations().getWorkspaceLocation().toString()) + "&repositoryUuid=" + CoreIOUtils.urlEncodeString(this.getRepository().getUuid());
        try {
            NutsTransportConnection clientFacade = CoreIOUtils.getHttpClientFacade(session, URL2);
            return new Scanner(clientFacade.open()).nextBoolean();
        }
        catch (UncheckedIOException | NutsIOException e) {
            return false;
        }
    }
}

