/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.bridges.maven;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Map;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsInput;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryConfig;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSingleton;
import net.thevpc.nuts.NutsSupportLevelContext;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.core.repos.NutsRepositorySelector;
import net.thevpc.nuts.runtime.core.repos.NutsRepositoryType;
import net.thevpc.nuts.runtime.core.repos.NutsRepositoryURL;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.bridges.maven.MavenFolderRepository;
import net.thevpc.nuts.runtime.standalone.bridges.maven.MavenRemoteRepository;
import net.thevpc.nuts.runtime.standalone.repos.FilesFoldersApi;
import net.thevpc.nuts.runtime.standalone.repos.RemoteRepoApi;
import net.thevpc.nuts.spi.NutsRepositoryFactoryComponent;

@NutsSingleton
public class MavenRepositoryFactoryComponent
implements NutsRepositoryFactoryComponent {
    public NutsAddRepositoryOptions[] getDefaultRepositories(NutsSession session) {
        return new NutsAddRepositoryOptions[]{NutsRepositorySelector.createRepositoryOptions(NutsRepositorySelector.parseSelection("maven-local"), true, session), NutsRepositorySelector.createRepositoryOptions(NutsRepositorySelector.parseSelection("maven-central"), true, session)};
    }

    public NutsRepository create(NutsAddRepositoryOptions options, NutsSession session, NutsRepository parentRepository) {
        NutsRepositoryConfig config = options.getConfig();
        String type = config.getType();
        if (type == null) {
            return null;
        }
        if (CoreIOUtils.isPathHttp(config.getLocation())) {
            return new MavenRemoteRepository(options, session, parentRepository, type);
        }
        if (CoreIOUtils.isPathFile(config.getLocation())) {
            return new MavenFolderRepository(options, session, parentRepository);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getSupportLevel(NutsSupportLevelContext<NutsRepositoryConfig> criteria) {
        if (criteria == null) {
            return -1;
        }
        String repositoryType = ((NutsRepositoryConfig)criteria.getConstraints()).getType();
        String location = ((NutsRepositoryConfig)criteria.getConstraints()).getLocation();
        if (NutsUtilStrings.isBlank((CharSequence)repositoryType)) {
            if (NutsUtilStrings.isBlank((CharSequence)location)) return -1;
            NutsRepositoryURL nru = new NutsRepositoryURL(location);
            if (nru.getRepositoryType().isMaven()) {
                ((NutsRepositoryConfig)criteria.getConstraints()).setType(nru.getRepositoryType().toString());
                ((NutsRepositoryConfig)criteria.getConstraints()).setLocation(nru.getLocation());
                return 10;
            }
            if (nru.isHttp()) {
                NutsInput in = criteria.getWorkspace().io().input().setTypeName("nuts-repository.json").of(nru.getLocation() + "/nuts-repository.json");
                try (InputStream s2222 = in.open();){
                    Map m = (Map)criteria.getWorkspace().elem().setContentType(NutsContentType.JSON).parse(s2222, Map.class);
                    if (m != null) {
                        String type = (String)m.get("type");
                        NutsRepositoryType nrt = new NutsRepositoryType(type);
                        if (nrt.isMaven()) {
                            ((NutsRepositoryConfig)criteria.getConstraints()).setType(type);
                            int n = 10;
                            return n;
                        }
                    }
                }
                catch (Exception s2222) {
                    // empty catch block
                }
                FilesFoldersApi.Item[] dirList = FilesFoldersApi.getDirItems(true, true, RemoteRepoApi.DIR_LIST, location, criteria.getWorkspace().createSession());
                if (dirList != null) {
                    ((NutsRepositoryConfig)criteria.getConstraints()).setType("maven+dirlist");
                    return 10;
                }
                dirList = FilesFoldersApi.getDirItems(true, true, RemoteRepoApi.DIR_TEXT, location, criteria.getWorkspace().createSession());
                if (dirList != null) {
                    ((NutsRepositoryConfig)criteria.getConstraints()).setType("maven+dirtext");
                    return 10;
                }
                in = criteria.getWorkspace().io().input().setTypeName("archetype-catalog.xml").of(location + "/archetype-catalog.xml");
                boolean exists = false;
                try (InputStream s = in.open();){
                    exists = true;
                }
                catch (Exception ex) {
                    exists = false;
                }
                if (!exists) return -1;
                ((NutsRepositoryConfig)criteria.getConstraints()).setType("maven");
                return 10;
            }
            if (nru.getPathProtocol().equals("file")) {
                File file = CoreIOUtils.toFile(nru.getLocation());
                if (file == null) return -1;
                if (!Files.exists(file.toPath().resolve("repository.xml"), new LinkOption[0])) return -1;
                ((NutsRepositoryConfig)criteria.getConstraints()).setType("maven");
                return 10;
            }
            if (!nru.getProtocols().isEmpty()) return -1;
            if (!Files.exists(Paths.get(location, new String[0]).resolve("repository.xml"), new LinkOption[0])) return -1;
            ((NutsRepositoryConfig)criteria.getConstraints()).setType("maven");
            return 10;
        }
        switch (repositoryType) {
            case "maven": 
            case "maven+dirlist": 
            case "maven+dirtext": 
            case "maven+github": {
                return 10;
            }
        }
        return -1;
    }
}

