/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.bridges.maven;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.logging.Level;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsInput;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUnsupportedArgumentException;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.bridges.maven.MavenUtils;
import net.thevpc.nuts.runtime.standalone.io.NamedByteArrayInputStream;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public abstract class AbstractMavenRepositoryHelper {
    private NutsLogger LOG;
    private NutsRepository repository;

    public AbstractMavenRepositoryHelper(NutsRepository repository) {
        this.repository = repository;
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = this.repository.getWorkspace().log().setSession(session).of(AbstractMavenRepositoryHelper.class);
        }
        return this.LOG;
    }

    protected abstract String getIdPath(NutsId var1, NutsSession var2);

    protected NutsInput getStream(NutsId id, String typeName, String action, NutsSession session) {
        String url = this.getIdPath(id, session);
        return this.openStream(id, url, id, typeName, action, session);
    }

    protected String getStreamAsString(NutsId id, String typeName, String action, NutsSession session) {
        String url = this.getIdPath(id, session);
        return CoreIOUtils.loadString(this.openStream(id, url, id, typeName, action, session).open(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSHA1Hash(NutsId id, InputStream stream, String typeName, NutsSession session) throws IOException {
        switch (NutsUtilStrings.trim((String)id.getFace())) {
            case "content-hash": 
            case "descriptor-hash": {
                break;
            }
            default: {
                this._LOGOP(session).level(Level.SEVERE).error((Throwable)new IllegalArgumentException("unsupported Hash Type " + id.getFace())).log("[BUG] Unsupported Hash Type {0}", new Object[]{id.getFace()});
                throw new IOException("unsupported hash type " + id.getFace());
            }
        }
        try {
            String rhash = null;
            try {
                rhash = this.getStreamSHA1(id, session, typeName);
            }
            catch (UncheckedIOException | NutsIOException ex) {
                stream.close();
                return;
            }
            String lhash = CoreIOUtils.evalSHA1Hex(stream, true);
            if (!rhash.equalsIgnoreCase(lhash)) {
                throw new IOException("invalid file hash " + id);
            }
        }
        finally {
            stream.close();
        }
    }

    protected String getStreamSHA1(NutsId id, NutsSession session, String typeName) {
        String hash = this.getStreamAsString(id, typeName + " SHA1", "verify", session).toUpperCase();
        for (String s : hash.split("[ \n\r]")) {
            if (s.length() <= 0) continue;
            return s;
        }
        return hash.split("[ \n\r]")[0];
    }

    protected abstract boolean exists(NutsId var1, String var2, Object var3, String var4, NutsSession var5);

    protected abstract NutsInput openStream(NutsId var1, String var2, Object var3, String var4, String var5, NutsSession var6);

    private void checkSession(NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.repository.getWorkspace(), session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NutsDescriptor fetchDescriptorImpl(NutsId id, NutsFetchMode fetchMode, NutsSession session) {
        this.checkSession(session);
        NutsInput stream = null;
        try {
            NutsDescriptor nutsDescriptor = null;
            byte[] bytes = null;
            String name = null;
            NutsId idDesc = id.builder().setFaceDescriptor().build();
            try {
                stream = this.getStream(idDesc, "artifact descriptor", "retrieve", session);
                bytes = CoreIOUtils.loadByteArray(stream.open(), true);
                name = stream.getName();
                nutsDescriptor = MavenUtils.of(session).parsePomXml(new NamedByteArrayInputStream(bytes, name), fetchMode, this.getIdPath(id, session), this.repository);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
            this.checkSHA1Hash(id.builder().setFace("descriptor-hash").build(), new NamedByteArrayInputStream(bytes, name), "artifact descriptor", session);
            return nutsDescriptor;
        }
        catch (IOException | UncheckedIOException | NutsIOException ex) {
            throw new NutsNotFoundException(session, id, ex);
        }
    }

    protected String getIdExtension(NutsId id, NutsSession session) {
        String f;
        this.checkSession(session);
        Map q = id.getProperties();
        switch (f = NutsUtilStrings.trim((String)((String)q.get("face")))) {
            case "descriptor": {
                return ".pom";
            }
            case "descriptor-hash": {
                return ".pom.sha1";
            }
            case "catalog": {
                return ".catalog";
            }
            case "content-hash": {
                return this.getIdExtension(id.builder().setFaceContent().build(), session) + ".sha1";
            }
            case "content": {
                String packaging = (String)q.get("packaging");
                return session.getWorkspace().locations().getDefaultIdContentExtension(packaging);
            }
        }
        throw new NutsUnsupportedArgumentException(session, NutsMessage.cstyle((String)"unsupported fact %s", (Object[])new Object[]{f}));
    }
}

