/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.boot;

import java.io.InputStream;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSessionTerminal;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.NutsUtilPlatforms;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceInitInformation;
import net.thevpc.nuts.runtime.bundles.common.CorePlatformUtils;
import net.thevpc.nuts.runtime.core.DefaultNutsSession;
import net.thevpc.nuts.runtime.core.terminals.DefaultNutsSessionTerminal;
import net.thevpc.nuts.runtime.core.terminals.DefaultNutsSystemTerminalBaseBoot;
import net.thevpc.nuts.runtime.core.terminals.DefaultSystemTerminal;
import net.thevpc.nuts.runtime.optional.jansi.OptionalJansi;
import net.thevpc.nuts.runtime.standalone.boot.NutsBootModel;
import net.thevpc.nuts.runtime.standalone.boot.StdFd;
import net.thevpc.nuts.runtime.standalone.io.NutsPrintStreamSystem;
import net.thevpc.nuts.spi.NutsSystemTerminalBase;

public class DefaultNutsBootModel
implements NutsBootModel {
    protected NutsWorkspace workspace;
    protected NutsWorkspaceInitInformation workspaceInitInformation;
    protected NutsSession bootSession;
    private NutsPrintStream stdout;
    private NutsPrintStream stderr;
    private InputStream stdin;

    public DefaultNutsBootModel(NutsWorkspace workspace, NutsWorkspaceInitInformation workspaceInitInformation) {
        this.workspace = workspace;
        this.workspaceInitInformation = workspaceInitInformation;
        this.bootSession = new DefaultNutsSession(workspace, workspaceInitInformation.getOptions());
        StdFd std = DefaultNutsBootModel.detectAnsiTerminalSupport(NutsUtilPlatforms.getPlatformOsFamily());
        NutsTerminalMode terminalMode = workspaceInitInformation.getOptions().getTerminalMode();
        if (terminalMode == null) {
            terminalMode = workspaceInitInformation.getOptions().isBot() ? NutsTerminalMode.FILTERED : (std.ansiSupport ? NutsTerminalMode.FORMATTED : NutsTerminalMode.FILTERED);
        }
        this.stdout = new NutsPrintStreamSystem(std.out, null, null, std.ansiSupport, this.bootSession).convertMode(terminalMode);
        this.stderr = new NutsPrintStreamSystem(std.err, null, null, std.ansiSupport, this.bootSession).convertMode(terminalMode);
        this.stdin = System.in;
        DefaultSystemTerminal sys = new DefaultSystemTerminal(new DefaultNutsSystemTerminalBaseBoot(this));
        this.bootSession.setTerminal((NutsSessionTerminal)new DefaultNutsSessionTerminal(this.bootSession, (NutsSystemTerminalBase)sys));
    }

    public NutsPrintStream stdout() {
        return this.stdout;
    }

    public NutsPrintStream stderr() {
        return this.stderr;
    }

    public InputStream stdin() {
        return this.stdin;
    }

    public NutsSession bootSession() {
        return this.bootSession;
    }

    public NutsWorkspace getWorkspace() {
        return this.workspace;
    }

    public NutsWorkspaceInitInformation getWorkspaceInitInformation() {
        return this.workspaceInitInformation;
    }

    public static StdFd detectAnsiTerminalSupport(NutsOsFamily os) {
        if (System.console() != null) {
            switch (os) {
                case LINUX: 
                case MACOS: 
                case UNIX: {
                    return new StdFd(System.in, System.out, System.err, true);
                }
                case WINDOWS: {
                    if (CorePlatformUtils.IS_CYGWIN || CorePlatformUtils.IS_MINGW_XTERM) {
                        return new StdFd(System.in, System.out, System.err, true);
                    }
                    if (OptionalJansi.isAvailable()) {
                        return OptionalJansi.resolveStdFd();
                    }
                    return new StdFd(System.in, System.out, System.err, false);
                }
            }
            if (OptionalJansi.isAvailable()) {
                return OptionalJansi.resolveStdFd();
            }
            return new StdFd(System.in, System.out, System.err, false);
        }
        return new StdFd(System.in, System.out, System.err, false);
    }
}

