/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.archetypes;

import java.util.HashMap;
import net.thevpc.nuts.NutsRepositoryManager;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSingleton;
import net.thevpc.nuts.NutsSupportLevelContext;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceSecurityManager;
import net.thevpc.nuts.runtime.core.repos.NutsRepositorySelector;
import net.thevpc.nuts.runtime.standalone.config.DefaultNutsWorkspaceConfigManager;
import net.thevpc.nuts.spi.NutsWorkspaceArchetypeComponent;

@NutsSingleton
public class ServerNutsWorkspaceArchetypeComponent
implements NutsWorkspaceArchetypeComponent {
    public String getName() {
        return "server";
    }

    public int getSupportLevel(NutsSupportLevelContext<String> criteria) {
        return 10;
    }

    public void initializeWorkspace(NutsSession session) {
        NutsWorkspace ws = session.getWorkspace();
        DefaultNutsWorkspaceConfigManager rm = (DefaultNutsWorkspaceConfigManager)ws.config();
        HashMap<String, String> defaults = new HashMap<String, String>();
        defaults.put("maven-local", null);
        defaults.put("maven-central", null);
        defaults.put("local", null);
        NutsRepositorySelector.Selection[] br = rm.getModel().resolveBootRepositoriesList().resolveSelectors(defaults);
        NutsRepositoryManager repos = ws.repos().setSession(session);
        for (NutsRepositorySelector.Selection s : br) {
            repos.addRepository(s.toString());
        }
        NutsWorkspaceSecurityManager sec = session.getWorkspace().security().setSession(session);
        sec.addUser("guest").setCredentials("user".toCharArray()).addPermissions(new String[]{"fetch-desc", "fetch-content", "deploy"}).run();
        sec = session.getWorkspace().security().setSession(session);
        sec.addUser("contributor").setCredentials("user".toCharArray()).addPermissions(new String[]{"fetch-desc", "fetch-content", "deploy", "undeploy"}).run();
    }
}

