/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.archetypes;

import java.util.HashMap;
import java.util.LinkedHashMap;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSingleton;
import net.thevpc.nuts.NutsSupportLevelContext;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.repos.NutsRepositorySelector;
import net.thevpc.nuts.runtime.standalone.config.DefaultNutsWorkspaceConfigManager;
import net.thevpc.nuts.spi.NutsWorkspaceArchetypeComponent;

@NutsSingleton
public class DefaultNutsWorkspaceArchetypeComponent
implements NutsWorkspaceArchetypeComponent {
    public String getName() {
        return "default";
    }

    public int getSupportLevel(NutsSupportLevelContext<String> criteria) {
        return 12;
    }

    public void initializeWorkspace(NutsSession session) {
        NutsRepositorySelector.Selection[] br;
        NutsWorkspace ws = session.getWorkspace();
        DefaultNutsWorkspaceConfigManager rm = (DefaultNutsWorkspaceConfigManager)ws.config().setSession(session);
        LinkedHashMap<String, NutsAddRepositoryOptions> def = new LinkedHashMap<String, NutsAddRepositoryOptions>();
        HashMap<String, String> defaults = new HashMap<String, String>();
        for (NutsAddRepositoryOptions d : rm.getDefaultRepositories()) {
            if (d.getConfig() != null) {
                def.put(ws.io().expandPath(d.getConfig().getLocation(), null), d);
            } else {
                def.put(ws.io().expandPath(d.getLocation(), null), d);
            }
            defaults.put(d.getName(), null);
        }
        defaults.put("local", null);
        for (NutsRepositorySelector.Selection s : br = rm.getModel().resolveBootRepositoriesList().resolveSelectors(defaults)) {
            NutsAddRepositoryOptions oo = NutsRepositorySelector.createRepositoryOptions(s, false, session);
            String sloc = ws.io().setSession(session).expandPath(oo.getConfig().getLocation(), null);
            if (def.containsKey(sloc)) {
                ws.repos().addRepository((NutsAddRepositoryOptions)def.get(sloc));
                def.remove(sloc);
                continue;
            }
            ws.repos().addRepository(oo);
        }
        ws.imports().setSession(session).add(new String[]{"net.thevpc.nuts.toolbox", "net.thevpc"});
        ws.security().setSession(session).updateUser("anonymous").resetPermissions().run();
        ws.security().setSession(session).addUser("user").setCredentials("user".toCharArray()).addPermissions(new String[]{"fetch-desc", "fetch-content", "deploy", "undeploy", "push", "save"}).setRemoteIdentity("contributor").run();
    }
}

