/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone;

import java.util.HashMap;
import java.util.Map;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsUtilStrings;

public class NutsStoreLocationsMap {
    private Map<String, String> locations;

    public NutsStoreLocationsMap(Map<String, String> locations) {
        this.locations = locations;
    }

    public String get(NutsStoreLocation location) {
        if (this.locations != null && location != null) {
            return this.locations.get(location.id());
        }
        return null;
    }

    public NutsStoreLocationsMap set(Map<String, String> locations) {
        this.set(new NutsStoreLocationsMap(locations));
        return this;
    }

    public NutsStoreLocationsMap set(NutsStoreLocationsMap other) {
        if (other != null) {
            for (NutsStoreLocation location : NutsStoreLocation.values()) {
                String v = other.get(location);
                if (NutsUtilStrings.isBlank((CharSequence)v)) continue;
                this.set(location, v);
            }
        }
        return this;
    }

    public NutsStoreLocationsMap set(NutsStoreLocation location, String value) {
        if (location != null) {
            if (NutsUtilStrings.isBlank((CharSequence)value)) {
                if (this.locations != null) {
                    this.locations.remove(location.id());
                }
            } else {
                if (this.locations == null) {
                    this.locations = new HashMap<String, String>();
                }
                this.locations.put(location.id(), value);
            }
        }
        return this;
    }

    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.locations != null) {
            for (NutsStoreLocation location : NutsStoreLocation.values()) {
                String v = this.get(location);
                if (NutsUtilStrings.isBlank((CharSequence)v)) continue;
                map.put(location.id(), v);
            }
        }
        return map;
    }

    public Map<String, String> toMapOrNull() {
        Map<String, String> m = this.toMap();
        if (m.isEmpty()) {
            return null;
        }
        return m;
    }
}

