/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone;

import java.util.HashMap;
import java.util.Map;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsUtilPlatforms;
import net.thevpc.nuts.NutsUtilStrings;

public class NutsHomeLocationsMap {
    private Map<String, String> locations;

    public NutsHomeLocationsMap(Map<String, String> locations) {
        this.locations = locations;
    }

    public String get(NutsOsFamily osFamily, NutsStoreLocation location) {
        if (this.locations != null && location != null) {
            return this.locations.get(NutsUtilPlatforms.createHomeLocationKey((NutsOsFamily)osFamily, (NutsStoreLocation)location));
        }
        return null;
    }

    public NutsHomeLocationsMap set(Map<String, String> locations) {
        return this.set(new NutsHomeLocationsMap(locations));
    }

    public NutsHomeLocationsMap set(NutsHomeLocationsMap other) {
        if (other != null) {
            for (NutsStoreLocation location : NutsStoreLocation.values()) {
                String v = other.get(null, location);
                if (NutsUtilStrings.isBlank((CharSequence)v)) continue;
                this.set(null, location, v);
            }
            for (NutsStoreLocation location : NutsStoreLocation.values()) {
                for (NutsOsFamily osFamily : NutsOsFamily.values()) {
                    String v = other.get(osFamily, location);
                    if (NutsUtilStrings.isBlank((CharSequence)v)) continue;
                    this.set(osFamily, location, v);
                }
            }
        }
        return this;
    }

    public NutsHomeLocationsMap set(NutsOsFamily osFamily, NutsStoreLocation location, String value) {
        if (location != null) {
            if (NutsUtilStrings.isBlank((CharSequence)value)) {
                if (this.locations != null) {
                    this.locations.remove(NutsUtilPlatforms.createHomeLocationKey((NutsOsFamily)osFamily, (NutsStoreLocation)location));
                }
            } else {
                if (this.locations == null) {
                    this.locations = new HashMap<String, String>();
                }
                this.locations.put(NutsUtilPlatforms.createHomeLocationKey((NutsOsFamily)osFamily, (NutsStoreLocation)location), value);
            }
        }
        return this;
    }

    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.locations != null) {
            for (NutsStoreLocation location : NutsStoreLocation.values()) {
                String v = this.get(null, location);
                if (NutsUtilStrings.isBlank((CharSequence)v)) continue;
                map.put(NutsUtilPlatforms.createHomeLocationKey(null, (NutsStoreLocation)location), v);
            }
            for (NutsStoreLocation location : NutsStoreLocation.values()) {
                for (NutsOsFamily osFamily : NutsOsFamily.values()) {
                    String v = this.get(osFamily, location);
                    if (NutsUtilStrings.isBlank((CharSequence)v)) continue;
                    map.put(NutsUtilPlatforms.createHomeLocationKey((NutsOsFamily)osFamily, (NutsStoreLocation)location), v);
                }
            }
        }
        return map;
    }

    public Map<String, String> toMapOrNull() {
        Map<String, String> m = this.toMap();
        if (m.isEmpty()) {
            return null;
        }
        return m;
    }
}

