/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone;

import java.util.ArrayList;
import java.util.Arrays;
import net.thevpc.nuts.NutsUpdateResult;
import net.thevpc.nuts.NutsWorkspaceUpdateResult;

public class DefaultNutsWorkspaceUpdateResult
implements NutsWorkspaceUpdateResult {
    private final NutsUpdateResult api;
    private final NutsUpdateResult runtime;
    private final NutsUpdateResult[] extensions;
    private final NutsUpdateResult[] artifacts;

    public DefaultNutsWorkspaceUpdateResult(NutsUpdateResult api, NutsUpdateResult runtime, NutsUpdateResult[] extensions, NutsUpdateResult[] components) {
        this.api = api;
        this.runtime = runtime;
        this.extensions = extensions;
        this.artifacts = components;
    }

    public NutsUpdateResult getApi() {
        return this.api;
    }

    public NutsUpdateResult getRuntime() {
        return this.runtime;
    }

    public NutsUpdateResult[] getExtensions() {
        return Arrays.copyOf(this.extensions, this.extensions.length);
    }

    public NutsUpdateResult[] getArtifacts() {
        return Arrays.copyOf(this.artifacts, this.artifacts.length);
    }

    public boolean isUpdatableApi() {
        return this.api != null && this.api.isUpdateAvailable();
    }

    public boolean isUpdatableRuntime() {
        return this.runtime != null && this.runtime.isUpdateAvailable();
    }

    public boolean isUpdatableExtensions() {
        for (NutsUpdateResult r : this.extensions) {
            if (!r.isUpdateAvailable()) continue;
            return true;
        }
        return false;
    }

    public boolean isUpdateAvailable() {
        return this.getUpdatesCount() > 0;
    }

    public NutsUpdateResult[] getAllUpdates() {
        ArrayList<NutsUpdateResult> all = new ArrayList<NutsUpdateResult>();
        if (this.api != null && this.api.isUpdateAvailable()) {
            all.add(this.api);
        }
        if (this.runtime != null && this.runtime.isUpdateAvailable()) {
            all.add(this.runtime);
        }
        for (NutsUpdateResult r : this.extensions) {
            if (!r.isUpdateAvailable()) continue;
            all.add(r);
        }
        for (NutsUpdateResult r : this.artifacts) {
            if (!r.isUpdateAvailable()) continue;
            all.add(r);
        }
        return all.toArray(new NutsUpdateResult[0]);
    }

    public NutsUpdateResult[] getAllResults() {
        ArrayList<NutsUpdateResult> all = new ArrayList<NutsUpdateResult>();
        if (this.api != null) {
            all.add(this.api);
        }
        if (this.runtime != null) {
            all.add(this.runtime);
        }
        all.addAll(Arrays.asList(this.extensions));
        all.addAll(Arrays.asList(this.artifacts));
        return all.toArray(new NutsUpdateResult[0]);
    }

    public int getUpdatesCount() {
        int c = 0;
        if (this.api != null && this.api.isUpdateAvailable()) {
            ++c;
        }
        if (this.runtime != null && this.runtime.isUpdateAvailable()) {
            ++c;
        }
        for (NutsUpdateResult r : this.extensions) {
            if (!r.isUpdateAvailable()) continue;
            ++c;
        }
        for (NutsUpdateResult r : this.artifacts) {
            if (!r.isUpdateAvailable()) continue;
            ++c;
        }
        return c;
    }
}

