/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.thevpc.nuts.Nuts;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsOpenMode;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceListConfig;
import net.thevpc.nuts.NutsWorkspaceListManager;
import net.thevpc.nuts.NutsWorkspaceLocation;
import net.thevpc.nuts.NutsWorkspaceOptions;

public class DefaultNutsWorkspaceListManager
implements NutsWorkspaceListManager {
    private final NutsWorkspace defaultWorkspace;
    private final String name;
    private Map<String, NutsWorkspaceLocation> workspaces = new LinkedHashMap<String, NutsWorkspaceLocation>();
    private NutsWorkspaceListConfig config;

    public DefaultNutsWorkspaceListManager(NutsWorkspace ws, NutsSession session, String name) {
        this.defaultWorkspace = ws;
        if (NutsUtilStrings.isBlank((CharSequence)name)) {
            name = "default";
        }
        this.name = name.trim();
        Path file = this.getConfigFile(session);
        if (Files.exists(file, new LinkOption[0])) {
            this.config = (NutsWorkspaceListConfig)this.defaultWorkspace.elem().setContentType(NutsContentType.JSON).parse(file, NutsWorkspaceListConfig.class);
            for (NutsWorkspaceLocation var : this.config.getWorkspaces()) {
                this.workspaces.put(var.getUuid(), var);
            }
        } else {
            this.config = new NutsWorkspaceListConfig().setUuid(UUID.randomUUID().toString()).setName("default-config");
            this.workspaces.put(ws.getUuid(), new NutsWorkspaceLocation().setUuid(ws.getUuid()).setName("default-workspace").setLocation(this.defaultWorkspace.locations().getWorkspaceLocation()));
            this.save(session);
        }
    }

    private Path getConfigFile(NutsSession session) {
        return Paths.get(this.defaultWorkspace.locations().getStoreLocation(this.defaultWorkspace.id().setSession(session).resolveId(DefaultNutsWorkspaceListManager.class), NutsStoreLocation.CONFIG), new String[0]).resolve(this.name + "-nuts-workspace-list.json");
    }

    public List<NutsWorkspaceLocation> getWorkspaces() {
        return new ArrayList<NutsWorkspaceLocation>(this.workspaces.values());
    }

    public NutsWorkspaceLocation getWorkspaceLocation(String uuid) {
        return this.workspaces.get(uuid);
    }

    public NutsWorkspaceListConfig getConfig() {
        return this.config;
    }

    public DefaultNutsWorkspaceListManager setConfig(NutsWorkspaceListConfig config) {
        this.config = config;
        return this;
    }

    public NutsWorkspace addWorkspace(String path, NutsSession session) {
        NutsWorkspace workspace = this.createWorkspace(path).getWorkspace();
        NutsWorkspaceLocation workspaceLocation = new NutsWorkspaceLocation().setUuid(workspace.getUuid()).setName(Paths.get(workspace.locations().getWorkspaceLocation(), new String[0]).getFileName().toString()).setLocation(workspace.locations().getWorkspaceLocation());
        this.workspaces.put(workspace.getUuid(), workspaceLocation);
        this.save(session);
        return workspace;
    }

    public boolean removeWorkspace(String uuid, NutsSession session) {
        boolean b;
        boolean bl = b = this.workspaces.remove(uuid) != null;
        if (b) {
            this.save(session);
        }
        return b;
    }

    public void save(NutsSession session) {
        this.config.setWorkspaces((List)(this.workspaces.isEmpty() ? null : new ArrayList<NutsWorkspaceLocation>(this.workspaces.values())));
        Path file = this.getConfigFile(session);
        this.defaultWorkspace.elem().setContentType(NutsContentType.JSON).setValue((Object)this.config).setNtf(false).print(file);
    }

    public DefaultNutsWorkspaceListManager setWorkspaces(Map<String, NutsWorkspaceLocation> workspaces) {
        this.workspaces = workspaces;
        return this;
    }

    private NutsSession createWorkspace(String path) {
        return Nuts.openWorkspace((NutsWorkspaceOptions)this.defaultWorkspace.config().optionsBuilder().setWorkspace(path).setOpenMode(NutsOpenMode.OPEN_OR_CREATE).setSkipCompanions(Boolean.valueOf(true)).build());
    }
}

