/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.thevpc.nuts.Nuts;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsArtifactCall;
import net.thevpc.nuts.NutsBootManager;
import net.thevpc.nuts.NutsCommandFactoryConfig;
import net.thevpc.nuts.NutsCommandLineManager;
import net.thevpc.nuts.NutsCommandlineFamily;
import net.thevpc.nuts.NutsConcurrentManager;
import net.thevpc.nuts.NutsConfirmationMode;
import net.thevpc.nuts.NutsCustomCommandManager;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyFilter;
import net.thevpc.nuts.NutsDependencyManager;
import net.thevpc.nuts.NutsDependencyScope;
import net.thevpc.nuts.NutsDeployCommand;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorManager;
import net.thevpc.nuts.NutsElementFormat;
import net.thevpc.nuts.NutsElementNotFoundException;
import net.thevpc.nuts.NutsEnum;
import net.thevpc.nuts.NutsException;
import net.thevpc.nuts.NutsExecCommand;
import net.thevpc.nuts.NutsExecutionContext;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsExtensionNotFoundException;
import net.thevpc.nuts.NutsFetchCommand;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsFetchStrategy;
import net.thevpc.nuts.NutsFilterManager;
import net.thevpc.nuts.NutsFormatManager;
import net.thevpc.nuts.NutsIOManager;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdManager;
import net.thevpc.nuts.NutsIdParser;
import net.thevpc.nuts.NutsIdType;
import net.thevpc.nuts.NutsImportManager;
import net.thevpc.nuts.NutsInfoFormat;
import net.thevpc.nuts.NutsInstallCommand;
import net.thevpc.nuts.NutsInstallException;
import net.thevpc.nuts.NutsInstallInformation;
import net.thevpc.nuts.NutsInstallStatus;
import net.thevpc.nuts.NutsInstallerComponent;
import net.thevpc.nuts.NutsLauncherOptions;
import net.thevpc.nuts.NutsLogManager;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsOpenMode;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsPrototype;
import net.thevpc.nuts.NutsPushCommand;
import net.thevpc.nuts.NutsReadOnlyException;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryManager;
import net.thevpc.nuts.NutsRunAs;
import net.thevpc.nuts.NutsSdkLocation;
import net.thevpc.nuts.NutsSdkManager;
import net.thevpc.nuts.NutsSearchCommand;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsStoreLocationStrategy;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsSupportCondition;
import net.thevpc.nuts.NutsSupportLevelContext;
import net.thevpc.nuts.NutsTableModel;
import net.thevpc.nuts.NutsTerminalManager;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextFormatTheme;
import net.thevpc.nuts.NutsTextManager;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextStyles;
import net.thevpc.nuts.NutsUndeployCommand;
import net.thevpc.nuts.NutsUninstallCommand;
import net.thevpc.nuts.NutsUpdateCommand;
import net.thevpc.nuts.NutsUpdateStatisticsCommand;
import net.thevpc.nuts.NutsUserConfig;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsVersionManager;
import net.thevpc.nuts.NutsWorkspaceAlreadyExistsException;
import net.thevpc.nuts.NutsWorkspaceAppsManager;
import net.thevpc.nuts.NutsWorkspaceConfigManager;
import net.thevpc.nuts.NutsWorkspaceCustomCommand;
import net.thevpc.nuts.NutsWorkspaceEnvManager;
import net.thevpc.nuts.NutsWorkspaceEvent;
import net.thevpc.nuts.NutsWorkspaceEventManager;
import net.thevpc.nuts.NutsWorkspaceExtensionManager;
import net.thevpc.nuts.NutsWorkspaceInitInformation;
import net.thevpc.nuts.NutsWorkspaceListener;
import net.thevpc.nuts.NutsWorkspaceLocationManager;
import net.thevpc.nuts.NutsWorkspaceNotFoundException;
import net.thevpc.nuts.NutsWorkspaceOptions;
import net.thevpc.nuts.NutsWorkspaceSecurityManager;
import net.thevpc.nuts.boot.NutsApiUtils;
import net.thevpc.nuts.boot.NutsBootDescriptor;
import net.thevpc.nuts.boot.NutsBootId;
import net.thevpc.nuts.boot.NutsBootVersion;
import net.thevpc.nuts.runtime.bundles.common.MapToFunction;
import net.thevpc.nuts.runtime.core.AbstractNutsWorkspace;
import net.thevpc.nuts.runtime.core.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.core.app.DefaultNutsCommandLineManager;
import net.thevpc.nuts.runtime.core.app.DefaultNutsWorkspaceLocationManager;
import net.thevpc.nuts.runtime.core.app.DefaultNutsWorkspaceLocationModel;
import net.thevpc.nuts.runtime.core.commands.ws.DefaultNutsExecutionContextBuilder;
import net.thevpc.nuts.runtime.core.commands.ws.NutsExecutionContextBuilder;
import net.thevpc.nuts.runtime.core.config.NutsWorkspaceConfigManagerExt;
import net.thevpc.nuts.runtime.core.events.DefaultNutsInstallEvent;
import net.thevpc.nuts.runtime.core.events.DefaultNutsUpdateEvent;
import net.thevpc.nuts.runtime.core.events.DefaultNutsWorkspaceEvent;
import net.thevpc.nuts.runtime.core.filters.DefaultNutsFilterManager;
import net.thevpc.nuts.runtime.core.filters.DefaultNutsFilterModel;
import net.thevpc.nuts.runtime.core.format.DefaultNutsInfoFormat;
import net.thevpc.nuts.runtime.core.format.elem.DefaultNutsElementFormat;
import net.thevpc.nuts.runtime.core.format.text.DefaultNutsTextManager;
import net.thevpc.nuts.runtime.core.format.text.DefaultNutsTextManagerModel;
import net.thevpc.nuts.runtime.core.log.DefaultNutsLogManager;
import net.thevpc.nuts.runtime.core.log.DefaultNutsLogModel;
import net.thevpc.nuts.runtime.core.log.DefaultNutsLogger;
import net.thevpc.nuts.runtime.core.model.DefaultNutsId;
import net.thevpc.nuts.runtime.core.model.DefaultNutsVersion;
import net.thevpc.nuts.runtime.core.repos.DefaultNutsRepositoryManager;
import net.thevpc.nuts.runtime.core.repos.DefaultNutsRepositoryModel;
import net.thevpc.nuts.runtime.core.repos.NutsInstalledRepository;
import net.thevpc.nuts.runtime.core.repos.NutsRepositorySelector;
import net.thevpc.nuts.runtime.core.util.CoreBooleanUtils;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.core.util.CoreNutsDependencyUtils;
import net.thevpc.nuts.runtime.core.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;
import net.thevpc.nuts.runtime.core.util.CoreTimeUtils;
import net.thevpc.nuts.runtime.standalone.CoreNutsWorkspaceInitInformation;
import net.thevpc.nuts.runtime.standalone.DefaultNutsConcurrentManager;
import net.thevpc.nuts.runtime.standalone.DefaultNutsConcurrentModel;
import net.thevpc.nuts.runtime.standalone.DefaultNutsFormatManager;
import net.thevpc.nuts.runtime.standalone.DefaultNutsWorkspaceAppsManager;
import net.thevpc.nuts.runtime.standalone.DefaultNutsWorkspaceEventManager;
import net.thevpc.nuts.runtime.standalone.DefaultNutsWorkspaceEventModel;
import net.thevpc.nuts.runtime.standalone.NutsExtensionListHelper;
import net.thevpc.nuts.runtime.standalone.NutsHomeLocationsMap;
import net.thevpc.nuts.runtime.standalone.NutsStoreLocationsMap;
import net.thevpc.nuts.runtime.standalone.boot.DefaultNutsBootManager;
import net.thevpc.nuts.runtime.standalone.boot.DefaultNutsBootModel;
import net.thevpc.nuts.runtime.standalone.config.ConfigEventType;
import net.thevpc.nuts.runtime.standalone.config.DefaultCustomCommandManager;
import net.thevpc.nuts.runtime.standalone.config.DefaultCustomCommandsModel;
import net.thevpc.nuts.runtime.standalone.config.DefaultImportManager;
import net.thevpc.nuts.runtime.standalone.config.DefaultImportModel;
import net.thevpc.nuts.runtime.standalone.config.DefaultNutsSdkManager;
import net.thevpc.nuts.runtime.standalone.config.DefaultNutsSdkModel;
import net.thevpc.nuts.runtime.standalone.config.DefaultNutsWorkspaceConfigManager;
import net.thevpc.nuts.runtime.standalone.config.DefaultNutsWorkspaceConfigModel;
import net.thevpc.nuts.runtime.standalone.config.DefaultNutsWorkspaceCurrentConfig;
import net.thevpc.nuts.runtime.standalone.config.DefaultNutsWorkspaceEnvManager;
import net.thevpc.nuts.runtime.standalone.config.DefaultNutsWorkspaceEnvManagerModel;
import net.thevpc.nuts.runtime.standalone.config.NutsBootConfig;
import net.thevpc.nuts.runtime.standalone.config.NutsWorkspaceConfigApi;
import net.thevpc.nuts.runtime.standalone.config.NutsWorkspaceConfigBoot;
import net.thevpc.nuts.runtime.standalone.config.NutsWorkspaceConfigRuntime;
import net.thevpc.nuts.runtime.standalone.ext.DefaultNutsWorkspaceExtensionManager;
import net.thevpc.nuts.runtime.standalone.ext.DefaultNutsWorkspaceExtensionModel;
import net.thevpc.nuts.runtime.standalone.installers.CommandForIdNutsInstallerComponent;
import net.thevpc.nuts.runtime.standalone.io.DefaultNutsIOManager;
import net.thevpc.nuts.runtime.standalone.io.DefaultNutsIOModel;
import net.thevpc.nuts.runtime.standalone.io.DefaultNutsTerminalManager;
import net.thevpc.nuts.runtime.standalone.io.DefaultNutsTerminalModel;
import net.thevpc.nuts.runtime.standalone.manager.DefaultNutsDependencyManager;
import net.thevpc.nuts.runtime.standalone.manager.DefaultNutsDescriptorManager;
import net.thevpc.nuts.runtime.standalone.manager.DefaultNutsIdManager;
import net.thevpc.nuts.runtime.standalone.manager.DefaultNutsVersionManager;
import net.thevpc.nuts.runtime.standalone.repos.DefaultNutsInstalledRepository;
import net.thevpc.nuts.runtime.standalone.security.DefaultNutsWorkspaceSecurityManager;
import net.thevpc.nuts.runtime.standalone.security.DefaultNutsWorkspaceSecurityModel;
import net.thevpc.nuts.runtime.standalone.security.ReadOnlyNutsWorkspaceOptions;
import net.thevpc.nuts.runtime.standalone.util.CoreDigestHelper;
import net.thevpc.nuts.runtime.standalone.util.NutsClassLoaderUtils;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.wscommands.DefaultNutsDeployCommand;
import net.thevpc.nuts.runtime.standalone.wscommands.DefaultNutsExecCommand;
import net.thevpc.nuts.runtime.standalone.wscommands.DefaultNutsFetchCommand;
import net.thevpc.nuts.runtime.standalone.wscommands.DefaultNutsInstallCommand;
import net.thevpc.nuts.runtime.standalone.wscommands.DefaultNutsPushCommand;
import net.thevpc.nuts.runtime.standalone.wscommands.DefaultNutsSearchCommand;
import net.thevpc.nuts.runtime.standalone.wscommands.DefaultNutsUndeployCommand;
import net.thevpc.nuts.runtime.standalone.wscommands.DefaultNutsUninstallCommand;
import net.thevpc.nuts.runtime.standalone.wscommands.DefaultNutsUpdateCommand;
import net.thevpc.nuts.runtime.standalone.wscommands.DefaultNutsUpdateStatisticsCommand;
import net.thevpc.nuts.spi.NutsBootWorkspaceFactory;
import net.thevpc.nuts.spi.NutsDeployRepositoryCommand;
import net.thevpc.nuts.spi.NutsRepositorySPI;
import net.thevpc.nuts.spi.NutsSystemTerminalBase;
import net.thevpc.nuts.spi.NutsWorkspaceArchetypeComponent;

@NutsPrototype
public class DefaultNutsWorkspace
extends AbstractNutsWorkspace
implements NutsWorkspaceExt {
    public static final String VERSION_INSTALL_INFO_CONFIG = "0.8.0";
    public static final String VERSION_SDK_LOCATION = "0.8.0";
    public static final String VERSION_REPOSITORY_CONFIG = "0.8.0";
    public static final String VERSION_REPOSITORY_REF = "0.8.0";
    public static final String VERSION_WS_CONFIG_API = "0.8.0";
    public static final String VERSION_WS_CONFIG_BOOT = "0.8.0";
    public static final String VERSION_WS_CONFIG_MAIN = "0.8.0";
    public static final String VERSION_WS_CONFIG_RUNTIME = "0.8.0";
    public static final String VERSION_WS_CONFIG_SECURITY = "0.8.0";
    public static final String VERSION_COMMAND_ALIAS_CONFIG = "0.8.0";
    public static final String VERSION_COMMAND_ALIAS_CONFIG_FACTORY = "0.8.0";
    public static final String VERSION_USER_CONFIG = "0.8.0";
    public NutsLogger LOG;
    protected DefaultNutsWorkspaceSecurityModel securityModel;
    protected DefaultNutsFilterModel filtersModel;
    protected DefaultNutsWorkspaceConfigModel configModel;
    protected DefaultNutsWorkspaceLocationModel locationsModel;
    protected DefaultNutsRepositoryModel repositoryModel;
    protected DefaultNutsWorkspaceEventModel eventsModel;
    protected DefaultNutsTextManagerModel textModel;
    protected DefaultNutsIOModel ioModel;
    protected DefaultNutsSdkModel sdkModel;
    protected DefaultNutsTerminalModel termModel;
    protected String uuid;
    protected String location;
    protected String name;
    protected NutsVersion apiVersion;
    protected NutsId apiId;
    protected NutsId runtimeId;
    private DefaultNutsInstalledRepository installedRepository;
    private DefaultNutsLogModel logModel;
    private DefaultNutsWorkspaceEnvManagerModel envModel;
    private DefaultNutsWorkspaceExtensionModel extensionModel;
    private DefaultCustomCommandsModel aliasesModel;
    private DefaultImportModel importModel;
    private DefaultNutsConcurrentModel concurrentModel;

    public DefaultNutsWorkspace(NutsWorkspaceInitInformation info) {
        this.initWorkspace(info);
    }

    private static Set<NutsBootId> toIds(NutsBootDescriptor[] all) {
        LinkedHashSet<NutsBootId> set = new LinkedHashSet<NutsBootId>();
        for (NutsBootDescriptor i : all) {
            set.add(i.getId());
            Collections.addAll(set, i.getDependencies());
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initWorkspace(NutsWorkspaceInitInformation info) {
        info = new CoreNutsWorkspaceInitInformation(info, null);
        this.uuid = info.getUuid();
        this.bootModel = new DefaultNutsBootModel(this, info);
        ((CoreNutsWorkspaceInitInformation)info).setSession(this.defaultSession());
        this.ioModel = new DefaultNutsIOModel(this, this.bootModel);
        this.logModel = new DefaultNutsLogModel(this, info);
        this.logModel.setDefaultSession(this.defaultSession());
        this.LOG = this.log().setSession(this.defaultSession()).of(DefaultNutsWorkspace.class);
        ((DefaultNutsLogger)this.LOG).suspendTerminal();
        this.name = Paths.get(info.getWorkspaceLocation(), new String[0]).getFileName().toString();
        this.termModel = new DefaultNutsTerminalModel(this);
        this.concurrentModel = new DefaultNutsConcurrentModel(this);
        this.sdkModel = new DefaultNutsSdkModel(this);
        this.filtersModel = new DefaultNutsFilterModel(this);
        this.installedRepository = new DefaultNutsInstalledRepository(this, info);
        this.repositoryModel = new DefaultNutsRepositoryModel(this);
        this.configModel = new DefaultNutsWorkspaceConfigModel(this, info);
        this.envModel = new DefaultNutsWorkspaceEnvManagerModel(this, info, this.defaultSession());
        this.aliasesModel = new DefaultCustomCommandsModel(this);
        this.importModel = new DefaultImportModel(this);
        this.locationsModel = new DefaultNutsWorkspaceLocationModel(this, info, Paths.get(info.getWorkspaceLocation(), new String[0]).toString());
        this.eventsModel = new DefaultNutsWorkspaceEventModel(this);
        this.textModel = new DefaultNutsTextManagerModel(this, info);
        this.location = info.getWorkspaceLocation();
        this.apiVersion = DefaultNutsVersion.valueOf(Nuts.getVersion(), this.defaultSession());
        this.apiId = new DefaultNutsId("net.thevpc.nuts", "nuts", this.apiVersion.toString(), this.defaultSession());
        this.runtimeId = new DefaultNutsId(info.getRuntimeId().getGroupId(), info.getRuntimeId().getArtifactId(), info.getRuntimeId().getVersion().toString(), this.defaultSession());
        boolean errorTheme = false;
        NutsTextManager text = this.text().setSession(this.defaultSession());
        try {
            NutsTextFormatTheme nutsTextFormatTheme = text.getTheme();
        }
        catch (Exception ex) {
            errorTheme = true;
            text.setTheme("");
        }
        NutsLoggerOp LOGCRF = this.LOG.with().level(Level.CONFIG).verb(NutsLogVerb.READ).formatted().session(this.defaultSession());
        NutsLoggerOp LOGCSF = this.LOG.with().level(Level.CONFIG).verb(NutsLogVerb.START).formatted().session(this.defaultSession());
        if (errorTheme) {
            this.LOG.with().level(Level.CONFIG).verb(NutsLogVerb.FAIL).formatted().session(this.defaultSession()).log("unable to load theme {0}. Reset to default!", new Object[]{info.getOptions().getTheme()});
        }
        if (this.LOG.isLoggable(Level.CONFIG)) {
            LOGCSF.log(" ===============================================================================", new Object[0]);
            String s = CoreIOUtils.loadString(this.getClass().getResourceAsStream("/net/thevpc/nuts/runtime/includes/standard-header.ntf"), true);
            s = s.replace("${nuts.workspace-runtime.version}", Nuts.getVersion());
            for (String s1 : s.split("\n")) {
                LOGCSF.log(s1, new Object[0]);
            }
            LOGCSF.log(" ", new Object[0]);
            LOGCSF.log(" = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =", new Object[0]);
            LOGCSF.log(" ", new Object[0]);
            LOGCSF.log("start ```sh nuts``` ```primary3 {0}``` at {1}", new Object[]{Nuts.getVersion(), CoreNutsUtils.DEFAULT_DATE_TIME_FORMATTER.format(Instant.ofEpochMilli(info.getOptions().getCreationTime()))});
            NutsCommandLineManager commandLine = this.commandLine().setSession(this.defaultSession());
            LOGCRF.log("open Nuts Workspace               : {0}", new Object[]{info.getOptions().formatter().getBootCommandLine()});
            LOGCRF.log("open Nuts Workspace (compact)     : {0}", new Object[]{info.getOptions().formatter().setCompact(true).getBootCommandLine()});
            LOGCRF.log("open Workspace with config        : ", new Object[0]);
            LOGCRF.log("   nuts-workspace-uuid            : {0}", new Object[]{CoreNutsUtils.desc(info.getUuid(), text)});
            LOGCRF.log("   nuts-workspace-name            : {0}", new Object[]{CoreNutsUtils.desc(info.getName(), text)});
            LOGCRF.log("   nuts-api-version               : {0}", new Object[]{this.version().setSession(this.defaultSession()).parser().parse(Nuts.getVersion())});
            LOGCRF.log("   nuts-api-url                   : {0}", new Object[]{this.io().setSession(this.defaultSession()).path(this.getApiURL())});
            LOGCRF.log("   nuts-api-digest                : {0}", new Object[]{text.forStyled(this.getApiDigest(), NutsTextStyle.version())});
            LOGCRF.log("   nuts-boot-repositories         : {0}", new Object[]{CoreNutsUtils.desc(info.getBootRepositories(), text)});
            LOGCRF.log("   nuts-runtime                   : {0}", new Object[]{this.getRuntimeId()});
            LOGCRF.log("   nuts-runtime-digest            : {0}", new Object[]{text.forStyled(new CoreDigestHelper().append(info.getClassWorldURLs()).getDigest(), NutsTextStyle.version())});
            LOGCRF.log("   nuts-runtime-dependencies      : {0}", new Object[]{text.builder().appendJoined((Object)text.forStyled(";", NutsTextStyle.separator()), (Collection)Arrays.stream(info.getRuntimeBootDescriptor().getDependencies()).map(x -> this.id().setSession(this.defaultSession()).parser().parse(x.toString())).collect(Collectors.toList()))});
            NutsIOManager io = this.io().setSession(this.defaultSession());
            LOGCRF.log("   nuts-runtime-urls              : {0}", new Object[]{text.builder().appendJoined((Object)text.forStyled(";", NutsTextStyle.separator()), (Collection)Arrays.stream(info.getClassWorldURLs()).map(x -> io.path(x.toString())).collect(Collectors.toList()))});
            LOGCRF.log("   nuts-extension-dependencies    : {0}", new Object[]{text.builder().appendJoined((Object)text.forStyled(";", NutsTextStyle.separator()), (Collection)DefaultNutsWorkspace.toIds(info.getExtensionBootDescriptors()).stream().map(x -> this.id().setSession(this.defaultSession()).parser().parse(x.toString())).collect(Collectors.toList()))});
            LOGCRF.log("   nuts-workspace                 : {0}", new Object[]{CoreNutsUtils.formatLogValue(text, info.getOptions().getWorkspace(), info.getWorkspaceLocation())});
            LOGCRF.log("   nuts-hash-name                 : {0}", new Object[]{CoreNutsUtils.formatLogValue(text, this.getHashName(), info.getWorkspaceLocation())});
            LOGCRF.log("   nuts-store-apps                : {0}", new Object[]{CoreNutsUtils.formatLogValue(text, info.getOptions().getStoreLocation(NutsStoreLocation.APPS), info.getStoreLocation(NutsStoreLocation.APPS))});
            LOGCRF.log("   nuts-store-config              : {0}", new Object[]{CoreNutsUtils.formatLogValue(text, info.getOptions().getStoreLocation(NutsStoreLocation.CONFIG), info.getStoreLocation(NutsStoreLocation.CONFIG))});
            LOGCRF.log("   nuts-store-var                 : {0}", new Object[]{CoreNutsUtils.formatLogValue(text, info.getOptions().getStoreLocation(NutsStoreLocation.VAR), info.getStoreLocation(NutsStoreLocation.VAR))});
            LOGCRF.log("   nuts-store-log                 : {0}", new Object[]{CoreNutsUtils.formatLogValue(text, info.getOptions().getStoreLocation(NutsStoreLocation.LOG), info.getStoreLocation(NutsStoreLocation.LOG))});
            LOGCRF.log("   nuts-store-temp                : {0}", new Object[]{CoreNutsUtils.formatLogValue(text, info.getOptions().getStoreLocation(NutsStoreLocation.TEMP), info.getStoreLocation(NutsStoreLocation.TEMP))});
            LOGCRF.log("   nuts-store-cache               : {0}", new Object[]{CoreNutsUtils.formatLogValue(text, info.getOptions().getStoreLocation(NutsStoreLocation.CACHE), info.getStoreLocation(NutsStoreLocation.CACHE))});
            LOGCRF.log("   nuts-store-run                 : {0}", new Object[]{CoreNutsUtils.formatLogValue(text, info.getOptions().getStoreLocation(NutsStoreLocation.RUN), info.getStoreLocation(NutsStoreLocation.RUN))});
            LOGCRF.log("   nuts-store-lib                 : {0}", new Object[]{CoreNutsUtils.formatLogValue(text, info.getOptions().getStoreLocation(NutsStoreLocation.LIB), info.getStoreLocation(NutsStoreLocation.LIB))});
            LOGCRF.log("   nuts-store-strategy            : {0}", new Object[]{CoreNutsUtils.formatLogValue(text, info.getOptions().getStoreLocationStrategy(), info.getStoreLocationStrategy())});
            LOGCRF.log("   nuts-repos-store-strategy      : {0}", new Object[]{CoreNutsUtils.formatLogValue(text, info.getOptions().getRepositoryStoreLocationStrategy(), info.getRepositoryStoreLocationStrategy())});
            LOGCRF.log("   nuts-store-layout              : {0}", new Object[]{CoreNutsUtils.formatLogValue(text, info.getOptions().getStoreLocationLayout(), info.getStoreLocationLayout() == null ? "system" : info.getStoreLocationLayout())});
            LOGCRF.log("   option-read-only               : {0}", new Object[]{info.getOptions().isReadOnly()});
            LOGCRF.log("   option-trace                   : {0}", new Object[]{info.getOptions().isTrace()});
            LOGCRF.log("   option-progress                : {0}", new Object[]{CoreNutsUtils.desc(info.getOptions().getProgressOptions(), text)});
            LOGCRF.log("   inherited                      : {0}", new Object[]{info.getOptions().isInherited()});
            LOGCRF.log("   inherited-nuts-boot-args       : {0}", new Object[]{System.getProperty("nuts.boot.args") == null ? CoreNutsUtils.desc(null, text) : CoreNutsUtils.desc(commandLine.setCommandlineFamily(NutsCommandlineFamily.BASH).parse(System.getProperty("nuts.boot.args")), text)});
            LOGCRF.log("   inherited-nuts-args            : {0}", new Object[]{System.getProperty("nuts.args") == null ? CoreNutsUtils.desc(null, text) : CoreNutsUtils.desc(text.toText((Object)commandLine.setCommandlineFamily(NutsCommandlineFamily.BASH).parse(System.getProperty("nuts.args"))), text)});
            LOGCRF.log("   option-open-mode               : {0}", new Object[]{CoreNutsUtils.formatLogValue(text, info.getOptions().getOpenMode(), info.getOptions().getOpenMode() == null ? NutsOpenMode.OPEN_OR_CREATE : info.getOptions().getOpenMode())});
            LOGCRF.log("   java-home                      : {0}", new Object[]{System.getProperty("java.home")});
            LOGCRF.log("   java-classpath                 : {0}", new Object[]{System.getProperty("java.class.path")});
            LOGCRF.log("   java-library-path              : {0}", new Object[]{System.getProperty("java.library.path")});
            LOGCRF.log("   os-name                        : {0}", new Object[]{System.getProperty("os.name")});
            NutsWorkspaceEnvManager senv = this.env().setSession(this.defaultSession());
            LOGCRF.log("   os-dist                        : {0}", new Object[]{senv.getOsDist().getArtifactId()});
            LOGCRF.log("   os-arch                        : {0}", new Object[]{System.getProperty("os.arch")});
            LOGCRF.log("   os-version                     : {0}", new Object[]{senv.getOsDist().getVersion()});
            LOGCRF.log("   user-name                      : {0}", new Object[]{System.getProperty("user.name")});
            LOGCRF.log("   user-dir                       : {0}", new Object[]{io.path(System.getProperty("user.dir"))});
            LOGCRF.log("   user-home                      : {0}", new Object[]{io.path(System.getProperty("user.home"))});
        }
        this.securityModel = new DefaultNutsWorkspaceSecurityModel(this);
        String workspaceLocation = info.getWorkspaceLocation();
        String apiVersion = info.getApiVersion();
        NutsBootId runtimeId = info.getRuntimeId();
        String repositories = info.getBootRepositories();
        NutsWorkspaceOptions uoptions = info.getOptions();
        NutsBootWorkspaceFactory bootFactory = info.getBootWorkspaceFactory();
        ClassLoader bootClassLoader = info.getClassWorldLoader();
        NutsWorkspaceConfigManager _config = this.config().setSession(this.defaultSession());
        NutsWorkspaceEnvManager _env = this.env().setSession(this.defaultSession());
        if ((uoptions = uoptions == null ? new ReadOnlyNutsWorkspaceOptions(_config.optionsBuilder().build(), this.defaultSession()) : new ReadOnlyNutsWorkspaceOptions(uoptions.builder().build(), this.defaultSession())).getCreationTime() == 0L) {
            this.configModel.setStartCreateTimeMillis(System.currentTimeMillis());
        }
        NutsBootConfig cfg = new NutsBootConfig();
        cfg.setWorkspace(workspaceLocation);
        cfg.setApiVersion(apiVersion);
        cfg.setRuntimeId(runtimeId == null ? null : runtimeId.toString());
        cfg.setRuntimeBootDescriptor(info.getRuntimeBootDescriptor());
        cfg.setExtensionBootDescriptors(info.getExtensionBootDescriptors());
        this.extensionModel = new DefaultNutsWorkspaceExtensionModel(this, bootFactory, uoptions.getExcludedExtensions(), this.defaultSession());
        boolean exists = NutsWorkspaceConfigManagerExt.of(_config).getModel().isValidWorkspaceFolder(this.defaultSession());
        NutsOpenMode openMode = uoptions.getOpenMode();
        if (openMode != null) {
            switch (openMode) {
                case OPEN_OR_ERROR: {
                    if (exists) break;
                    throw new NutsWorkspaceNotFoundException(workspaceLocation);
                }
                case CREATE_OR_ERROR: {
                    if (!exists) break;
                    throw new NutsWorkspaceAlreadyExistsException(workspaceLocation);
                }
            }
        }
        this.extensionModel.onInitializeWorkspace(info, bootClassLoader, this.defaultSession());
        NutsSystemTerminalBase termb = (NutsSystemTerminalBase)this.extensions().setSession(this.defaultSession()).createSupported(NutsSystemTerminalBase.class, null);
        if (termb == null) {
            throw new NutsExtensionNotFoundException(this.defaultSession(), NutsSystemTerminalBase.class, "SystemTerminalBase");
        }
        NutsTerminalManager _term = this.term().setSession(this.defaultSession());
        _term.setSystemTerminal(termb).setTerminal(_term.createTerminal());
        this.bootModel.bootSession().setTerminal(this.term().setSession(this.bootModel.bootSession()).createTerminal());
        ((DefaultNutsLogger)this.LOG).resumeTerminal(this.defaultSession());
        this.configModel.onExtensionsPrepared(this.defaultSession());
        this.initializing = true;
        boolean justInstalled = false;
        try {
            if (!this.loadWorkspace(this.defaultSession(), uoptions.getExcludedExtensions(), null)) {
                if (this.uuid == null) {
                    this.uuid = UUID.randomUUID().toString();
                }
                justInstalled = true;
                NutsWorkspaceUtils.of(this.defaultSession()).checkReadOnly();
                this.LOG.with().session(this.defaultSession()).level(Level.CONFIG).verb(NutsLogVerb.SUCCESS).log("creating NEW workspace at {0}", new Object[]{this.locations().getWorkspaceLocation()});
                NutsWorkspaceConfigBoot bconfig = new NutsWorkspaceConfigBoot();
                bconfig.setUuid(this.uuid);
                NutsWorkspaceConfigApi aconfig = new NutsWorkspaceConfigApi();
                aconfig.setApiVersion(apiVersion);
                aconfig.setRuntimeId(runtimeId == null ? null : runtimeId.toString());
                aconfig.setJavaCommand(uoptions.getJavaCommand());
                aconfig.setJavaOptions(uoptions.getJavaOptions());
                NutsWorkspaceConfigRuntime rconfig = new NutsWorkspaceConfigRuntime();
                rconfig.setDependencies(Arrays.stream(info.getRuntimeBootDescriptor().getDependencies()).map(x -> x.toString()).collect(Collectors.joining(";")));
                rconfig.setId(runtimeId == null ? null : runtimeId.toString());
                bconfig.setBootRepositories(repositories);
                bconfig.setStoreLocationStrategy(uoptions.getStoreLocationStrategy());
                bconfig.setRepositoryStoreLocationStrategy(uoptions.getRepositoryStoreLocationStrategy());
                bconfig.setStoreLocationLayout(uoptions.getStoreLocationLayout());
                bconfig.setGlobal(uoptions.isGlobal());
                bconfig.setStoreLocations(new NutsStoreLocationsMap(uoptions.getStoreLocations()).toMapOrNull());
                bconfig.setHomeLocations(new NutsHomeLocationsMap(uoptions.getHomeLocations()).toMapOrNull());
                boolean namedWorkspace = CoreNutsUtils.isValidWorkspaceName(uoptions.getWorkspace());
                if (bconfig.getStoreLocationStrategy() == null) {
                    bconfig.setStoreLocationStrategy(namedWorkspace ? NutsStoreLocationStrategy.EXPLODED : NutsStoreLocationStrategy.STANDALONE);
                }
                if (bconfig.getRepositoryStoreLocationStrategy() == null) {
                    bconfig.setRepositoryStoreLocationStrategy(NutsStoreLocationStrategy.EXPLODED);
                }
                bconfig.setName(CoreNutsUtils.resolveValidWorkspaceName(uoptions.getWorkspace()));
                this.configModel.setCurrentConfig(new DefaultNutsWorkspaceCurrentConfig(this).merge(aconfig, this.defaultSession()).merge(bconfig, this.defaultSession()).build(this.locations().getWorkspaceLocation(), this.defaultSession()));
                this.configModel.setConfigBoot(bconfig, this.defaultSession());
                this.configModel.setConfigApi(aconfig, this.defaultSession());
                this.configModel.setConfigRuntime(rconfig, this.defaultSession());
                this.initializeWorkspace(uoptions.getArchetype(), this.defaultSession());
                if (!_config.isReadOnly()) {
                    _config.save();
                }
                NutsVersion nutsVersion = this.getRuntimeId().getVersion();
                if (this.LOG.isLoggable(Level.CONFIG)) {
                    this.LOG.with().session(this.defaultSession()).level(Level.CONFIG).verb(NutsLogVerb.SUCCESS).log("nuts workspace v{0} created.", new Object[]{nutsVersion});
                }
                if (this.defaultSession().isPlainTrace() && !_env.getBootOptions().isSkipWelcome()) {
                    NutsPrintStream out = this.defaultSession().out();
                    out.resetLine();
                    StringBuilder version = new StringBuilder(nutsVersion.toString());
                    CoreStringUtils.fillString(' ', 25 - version.length(), version);
                    NutsTextManager txt = text.setSession(this.defaultSession());
                    NutsText n = txt.parser().parseResource("/net/thevpc/nuts/runtime/includes/standard-header.ntf", txt.parser().createLoader(this.getClass().getClassLoader()));
                    out.println(n == null ? "no help found" : n.toString().trim());
                    out.println((NutsString)txt.builder().append((Object)"location", NutsTextStyle.underlined()).append((Object)":").append((Object)this.locations().getWorkspaceLocation(), NutsTextStyle.path()).append((Object)" ").append((Object)" (").append((Object)this.getHashName()).append((Object)")"));
                    this.formats().setSession(this.defaultSession()).table().setValue((Object)NutsTableModel.of((NutsSession)this.defaultSession()).addCell((Object)txt.builder().append((Object)" This is the very first time ").appendCode("sh", "nuts").append((Object)" has been started for this workspace "))).println(out);
                    out.println();
                }
                for (NutsPrintStream bootClassWorldURL : _env.getBootClassWorldURLs()) {
                    NutsInstalledRepository repo = this.getInstalledRepository();
                    NutsRepositorySPI repoSPI = NutsWorkspaceUtils.of(this.defaultSession()).repoSPI(repo);
                    NutsDeployRepositoryCommand desc = repoSPI.deploy().setContent((URL)bootClassWorldURL).setSession(this.defaultSession().copy().setConfirm(NutsConfirmationMode.YES)).run();
                    if (desc.getId().getLongNameId().equals(this.getApiId().getLongNameId()) || desc.getId().getLongNameId().equals(this.getRuntimeId().getLongNameId())) {
                        repo.install(desc.getId(), this.defaultSession(), null);
                        continue;
                    }
                    repo.install(desc.getId(), this.defaultSession(), this.getRuntimeId());
                }
            } else {
                this.uuid = this.configModel.getStoreModelBoot().getUuid();
                if (NutsUtilStrings.isBlank((CharSequence)this.uuid)) {
                    this.uuid = UUID.randomUUID().toString();
                    this.configModel.getStoreModelBoot().setUuid(this.uuid);
                }
                if (uoptions.isRecover()) {
                    this.configModel.setBootApiVersion(cfg.getApiVersion(), this.defaultSession());
                    this.configModel.setBootRuntimeId(cfg.getRuntimeId(), this.defaultSession());
                    this.configModel.setBootRuntimeDependencies(Arrays.stream(info.getRuntimeBootDescriptor().getDependencies()).map(x -> x.toString()).collect(Collectors.joining(";")), this.defaultSession());
                    this.configModel.setBootRepositories(cfg.getBootRepositories(), this.defaultSession());
                    try {
                        this.install().setInstalled(true).setSession(this.defaultSession()).getResult();
                    }
                    catch (Exception ex) {
                        this.LOG.with().session(this.defaultSession()).level(Level.SEVERE).verb(NutsLogVerb.FAIL).log("reinstall artifacts failed : " + CoreStringUtils.exceptionToString(ex), new Object[0]);
                        this.LOG.with().session(this.defaultSession()).level(Level.FINEST).verb(NutsLogVerb.FAIL).log("reinstall artifacts failed : " + CoreStringUtils.exceptionToString(ex), new Object[]{ex});
                    }
                }
                if (this.repos().setSession(this.defaultSession()).getRepositories().length == 0) {
                    this.LOG.with().session(this.defaultSession()).level(Level.CONFIG).verb(NutsLogVerb.FAIL).log("workspace has no repositories. Will re-create defaults", new Object[0]);
                    this.initializeWorkspace(uoptions.getArchetype(), this.defaultSession());
                }
                ArrayList transientRepositoriesSet = uoptions.getRepositories() == null ? new ArrayList() : new ArrayList<String>(Arrays.asList(uoptions.getRepositories()));
                NutsRepositorySelector.SelectorList expected = NutsRepositorySelector.parse(transientRepositoriesSet.toArray(new String[0]));
                NutsRepositorySelector.Selection[] selectionArray = expected.resolveSelectors(null);
                int n = selectionArray.length;
                for (int nutsVersion = 0; nutsVersion < n; ++nutsVersion) {
                    NutsRepositorySelector.Selection loc = selectionArray[nutsVersion];
                    NutsAddRepositoryOptions d = NutsRepositorySelector.createRepositoryOptions(loc, false, this.defaultSession());
                    String n2 = d.getName();
                    String ruuid = (NutsUtilStrings.isBlank((CharSequence)n2) ? "temporary" : n2) + "_" + UUID.randomUUID().toString().replace("-", "");
                    d.setName(ruuid);
                    d.setTemporary(true);
                    d.setEnabled(true);
                    d.setFailSafe(false);
                    if (d.getConfig() != null) {
                        d.getConfig().setName(NutsUtilStrings.isBlank((CharSequence)n2) ? ruuid : n2);
                        d.getConfig().setStoreLocationStrategy(NutsStoreLocationStrategy.STANDALONE);
                    }
                    this.repos().setSession(this.defaultSession()).addRepository(d);
                }
            }
            this.configModel.prepareBoot(false, this.defaultSession());
            if (!_config.isReadOnly()) {
                _config.save(false);
            }
            this.configModel.setStartCreateTimeMillis(uoptions.getCreationTime());
            this.configModel.setEndCreateTimeMillis(System.currentTimeMillis());
            if (justInstalled) {
                this.installSettings(this.defaultSession());
                if (!_env.getBootOptions().isSkipCompanions()) {
                    this.installCompanions(this.defaultSession());
                }
                DefaultNutsWorkspaceEvent workspaceCreatedEvent = new DefaultNutsWorkspaceEvent(this.defaultSession(), null, null, null, null);
                for (NutsWorkspaceListener workspaceListener : this.events().getWorkspaceListeners()) {
                    workspaceListener.onCreateWorkspace((NutsWorkspaceEvent)workspaceCreatedEvent);
                }
            }
            if (uoptions.getUserName() != null && uoptions.getUserName().trim().length() > 0) {
                char[] password = uoptions.getCredentials();
                if (password == null || NutsUtilStrings.isBlank((CharSequence)new String(password))) {
                    password = this.term().setSession(this.defaultSession()).getTerminal().readPassword("Password : ", new Object[0]);
                }
                this.security().setSession(this.defaultSession()).login(uoptions.getUserName(), password);
            }
            this.LOG.with().session(this.defaultSession()).level(Level.FINE).verb(NutsLogVerb.SUCCESS).formatted().log("```sh nuts``` workspace loaded in ```error {0}```", new Object[]{CoreTimeUtils.formatPeriodMilli(_env.getCreationFinishTimeMillis() - _env.getCreationStartTimeMillis())});
            if (CoreBooleanUtils.getSysBoolNutsProperty("perf", false)) {
                this.defaultSession().out().printf("```sh nuts``` workspace loaded in %s%n", new Object[]{this.configModel.getWorkspace().text().forStyled(CoreTimeUtils.formatPeriodMilli(_env.getCreationFinishTimeMillis() - _env.getCreationStartTimeMillis()), NutsTextStyle.error())});
            }
        }
        finally {
            this.initializing = false;
        }
    }

    private URL getApiURL() {
        NutsBootId nid = new NutsBootId("net.thevpc.nuts", "nuts", NutsBootVersion.parse((String)Nuts.getVersion()));
        return NutsApiUtils.findClassLoaderJar((NutsBootId)nid, (URL[])NutsClassLoaderUtils.resolveClasspathURLs(Thread.currentThread().getContextClassLoader()));
    }

    private String getApiDigest() {
        return new CoreDigestHelper().append(this.getApiURL()).getDigest();
    }

    private void installSettings(NutsSession session) {
        if (session.isPlainTrace()) {
            session.out().resetLine().println("looking for java installations in default locations...");
        }
        NutsSdkLocation[] found = session.getWorkspace().sdks().setSession(session.copy().setTrace(Boolean.valueOf(false))).searchSystem("java");
        int someAdded = 0;
        for (NutsSdkLocation java : found) {
            if (!session.getWorkspace().sdks().add(java)) continue;
            ++someAdded;
        }
        NutsTextManager factory = session.getWorkspace().text();
        if (session.isPlainTrace()) {
            if (someAdded == 0) {
                session.out().print("```error no new``` java installation locations found...\n");
            } else if (someAdded == 1) {
                session.out().printf("%s new java installation location added...\n", new Object[]{factory.forStyled("1", NutsTextStyle.primary2())});
            } else {
                session.out().printf("%s new java installation locations added...\n", new Object[]{factory.forStyled("" + someAdded, NutsTextStyle.primary2())});
            }
            session.out().println("you can always add another installation manually using 'nuts settings add java' command.");
        }
        if (!session.getWorkspace().config().isReadOnly()) {
            session.getWorkspace().config().save();
        }
        session.getWorkspace().env().addLauncher(new NutsLauncherOptions().setId(this.getApiId()).setCreateScript(true).setCreateDesktopShortcut(NutsSupportCondition.PREFERRED).setCreateMenuShortcut(NutsSupportCondition.SUPPORTED));
    }

    public void installCompanions(NutsSession session) {
        block4: {
            NutsWorkspaceUtils.checkSession(this, session);
            NutsTextManager text = this.text().setSession(session);
            Set<NutsId> companionIds = this.getCompanionIds(session);
            if (companionIds.isEmpty()) {
                return;
            }
            if (session.isPlainTrace()) {
                NutsPrintStream out = session.out();
                out.resetLine();
                out.printf("looking for recommended companion tools to install... detected : %s%n", new Object[]{text.builder().appendJoined((Object)text.forPlain(","), companionIds)});
            }
            try {
                this.install().companions().setSession(session.copy().setTrace(Boolean.valueOf(session.isTrace() && session.isPlainOut()))).run();
            }
            catch (Exception ex) {
                this.LOG.with().session(session).level(Level.FINEST).verb(NutsLogVerb.WARNING).error((Throwable)ex).log("unable to install companions : " + ex, new Object[0]);
                if (!session.isPlainTrace()) break block4;
                NutsPrintStream out = session.out();
                out.resetLine();
                out.printf("```error unable to install companion tools``` :  %s \nthis happens when none of the following repositories are able to locate them : %s\n", new Object[]{ex, text.builder().appendJoined((Object)text.forPlain(", "), (Collection)Arrays.stream(this.repos().setSession(session).getRepositories()).map(x -> text.builder().append((Object)x.getName(), NutsTextStyle.primary3())).collect(Collectors.toList()))});
            }
        }
    }

    protected NutsDescriptor _resolveEffectiveDescriptor(NutsDescriptor descriptor, NutsSession session) {
        this.LOG.with().session(session).level(Level.FINEST).verb(NutsLogVerb.START).formatted().log("resolve effective {0}", new Object[]{descriptor.getId()});
        this.checkSession(session);
        NutsId[] parents = descriptor.getParents();
        NutsDescriptor[] parentDescriptors = new NutsDescriptor[parents.length];
        for (int i = 0; i < parentDescriptors.length; ++i) {
            parentDescriptors[i] = this.resolveEffectiveDescriptor(this.fetch().setId(parents[i]).setEffective(false).setSession(session).getResultDescriptor(), session);
        }
        NutsDescriptor effectiveDescriptor = descriptor.builder().applyParents(parentDescriptors).applyProperties().build();
        NutsDependency[] oldDependencies = effectiveDescriptor.getDependencies();
        ArrayList<NutsDependency> newDeps = new ArrayList<NutsDependency>();
        boolean someChange = false;
        for (NutsDependency d : oldDependencies) {
            if (NutsUtilStrings.isBlank((CharSequence)d.getScope()) || d.getVersion().isBlank() || NutsUtilStrings.isBlank((CharSequence)d.getOptional())) {
                NutsDependency standardDependencyOk = null;
                for (NutsDependency standardDependency : effectiveDescriptor.getStandardDependencies()) {
                    if (!standardDependency.getSimpleName().equals(d.toId().getShortName())) continue;
                    standardDependencyOk = standardDependency;
                    break;
                }
                if (standardDependencyOk != null) {
                    if (NutsUtilStrings.isBlank((CharSequence)d.getScope()) && !NutsUtilStrings.isBlank((CharSequence)standardDependencyOk.getScope())) {
                        someChange = true;
                        d = d.builder().setScope(standardDependencyOk.getScope()).build();
                    }
                    if (NutsUtilStrings.isBlank((CharSequence)d.getOptional()) && !NutsUtilStrings.isBlank((CharSequence)standardDependencyOk.getOptional())) {
                        someChange = true;
                        d = d.builder().setOptional(standardDependencyOk.getOptional()).build();
                    }
                    if (d.getVersion().isBlank() && !standardDependencyOk.getVersion().isBlank()) {
                        someChange = true;
                        d = d.builder().setVersion(standardDependencyOk.getVersion()).build();
                    }
                }
            }
            if ("import".equals(d.getScope())) {
                someChange = true;
                newDeps.addAll(Arrays.asList(this.fetch().setId(d.toId()).setEffective(true).setSession(session).getResultDescriptor().getDependencies()));
                continue;
            }
            newDeps.add(d);
        }
        if (someChange) {
            effectiveDescriptor = effectiveDescriptor.builder().setDependencies(newDeps.toArray(new NutsDependency[0])).build();
        }
        return effectiveDescriptor;
    }

    @Override
    public int getSupportLevel(NutsSupportLevelContext<NutsWorkspaceOptions> criteria) {
        return 10;
    }

    @Override
    public String toString() {
        return "NutsWorkspace{" + this.configModel + '}';
    }

    protected void initializeWorkspace(String archetype, NutsSession session) {
        this.checkSession(session);
        if (NutsUtilStrings.isBlank((CharSequence)archetype)) {
            archetype = "default";
        }
        NutsWorkspaceArchetypeComponent instance = null;
        TreeSet<String> validValues = new TreeSet<String>();
        for (NutsWorkspaceArchetypeComponent ac : this.extensions().setSession(session).createAllSupported(NutsWorkspaceArchetypeComponent.class, (Object)archetype)) {
            if (archetype.equals(ac.getName())) {
                instance = ac;
                break;
            }
            validValues.add(ac.getName());
        }
        if (instance == null) {
            throw new NutsException(session, NutsMessage.cstyle((String)"invalid archetype %s. Valid values are : %s", (Object[])new Object[]{archetype, validValues}));
        }
        this.security().setSession(session).updateUser("admin").setCredentials("admin".toCharArray()).run();
        instance.initializeWorkspace(session);
    }

    private void checkSession(NutsSession session) {
        NutsWorkspaceUtils.checkSession(this, session);
    }

    public void installOrUpdateImpl(NutsDefinition def, String[] args, NutsInstallerComponent installerComponent, NutsSession session, boolean resolveInstaller, boolean updateDefaultVersion, InstallStrategy0 strategy0, boolean requireDependencies, NutsId[] forIds, NutsDependencyScope scope) {
        this.checkSession(session);
        if (def == null) {
            return;
        }
        NutsDependencyFilter ndf = CoreNutsDependencyUtils.createJavaRunDependencyFilter(session);
        if (!def.isSetEffectiveDescriptor() || def.getContent() == null) {
            NutsFetchCommand fetch2 = this.fetch().setSession(session).setId(def.getId()).setContent(true).setRepositoryFilter(this.repos().filter().setSession(session).installedRepo()).setFailFast(true);
            if (def.isSetDependencies()) {
                fetch2.setDependencyFilter(def.getDependencies().filter());
                fetch2.setDependencies(true);
            }
            def = fetch2.getResultDefinition();
        }
        boolean reinstall = false;
        NutsInstalledRepository installedRepository = this.getInstalledRepository();
        NutsWorkspaceUtils wu = NutsWorkspaceUtils.of(session);
        if (session.isPlainTrace()) {
            NutsTextManager text = session.getWorkspace().text();
            if (strategy0 == InstallStrategy0.UPDATE) {
                session.out().resetLine().printf("%s %s ...%n", new Object[]{text.forStyled("update", NutsTextStyle.warn()), def.getId().getLongNameId()});
            } else if (strategy0 == InstallStrategy0.REQUIRE) {
                reinstall = def.getInstallInformation().getInstallStatus().isRequired();
                if (reinstall) {
                    // empty if block
                }
            } else {
                reinstall = def.getInstallInformation().getInstallStatus().isInstalled();
                if (reinstall) {
                    session.out().resetLine().printf("%s %s ...%n", new Object[]{text.forStyled("re-install", NutsTextStyles.of((NutsTextStyle[])new NutsTextStyle[]{NutsTextStyle.success(), NutsTextStyle.underlined()})), def.getId().getLongNameId()});
                } else {
                    session.out().resetLine().printf("%s %s ...%n", new Object[]{text.forStyled("install", NutsTextStyle.success()), def.getId().getLongNameId()});
                }
            }
        }
        NutsRepositorySPI installedRepositorySPI = wu.repoSPI(installedRepository);
        boolean remoteRepo = true;
        if (resolveInstaller && installerComponent == null && def.getPath() != null) {
            installerComponent = this.getInstaller(def, session);
        }
        NutsDefinition oldDef = null;
        if (strategy0 == InstallStrategy0.UPDATE) {
            switch (def.getType()) {
                case API: {
                    oldDef = this.fetch().setSession(CoreNutsUtils.silent(session).copy().setFetchStrategy(NutsFetchStrategy.ONLINE)).setId("net.thevpc.nuts:nuts#" + Nuts.getVersion()).setFailFast(false).getResultDefinition();
                    break;
                }
                case RUNTIME: {
                    oldDef = this.fetch().setSession(CoreNutsUtils.silent(session).copy().setFetchStrategy(NutsFetchStrategy.ONLINE)).setId(this.getRuntimeId()).setFailFast(false).getResultDefinition();
                    break;
                }
                default: {
                    oldDef = (NutsDefinition)this.search().setSession(CoreNutsUtils.silent(session)).addId(def.getId().getShortNameId()).setInstallStatus(this.filters().setSession(session).installStatus().byDeployed(true)).setFailFast(false).getResultDefinitions().first();
                }
            }
        }
        NutsPrintStream out = session.out();
        out.flush();
        switch (def.getType()) {
            case API: {
                this.configModel.prepareBootApi(def.getId(), null, true, session);
                break;
            }
            case RUNTIME: {
                this.configModel.prepareBootRuntime(def.getId(), true, session);
                break;
            }
            case EXTENSION: {
                this.configModel.prepareBootExtension(def.getId(), true, session);
            }
        }
        NutsInstallInformation newNutsInstallInformation = null;
        NutsWorkspaceConfigManager config = this.config().setSession(session);
        if (def.getPath() != null) {
            if (requireDependencies) {
                def.getDependencies();
                ArrayList<NutsDefinition> requiredDefinitions = new ArrayList<NutsDefinition>();
                for (NutsDependency dependency : def.getDependencies()) {
                    NutsDefinition dd;
                    if (ndf != null && !ndf.acceptDependency(def.getId(), dependency, session) || installedRepositorySPI.searchVersions().setId(dependency.toId()).setFetchMode(NutsFetchMode.LOCAL).setSession(session).getResult().hasNext() || (dd = (NutsDefinition)this.search().addId(dependency.toId()).setContent(true).setLatest(true).setEffective(true).setSession(session).getResultDefinitions().first()) == null) continue;
                    if (dd.getPath() == null) {
                        throw new NutsInstallException(session, def.getId(), NutsMessage.cstyle((String)"unable to install %s. required dependency content is missing for %s", (Object[])new Object[]{def.getId(), dependency.toId()}), null);
                    }
                    requiredDefinitions.add(dd);
                }
                for (NutsDefinition dd : requiredDefinitions) {
                    this.requireImpl(dd, session, false, new NutsId[]{def.getId()});
                }
            }
            NutsExecutionContextBuilder cc = this.createExecutionContext().setTraceSession(session.copy()).setExecSession(session.copy()).setDefinition(def).setArguments(args).setFailFast(true).setTemporary(false).setExecutionType(this.env().setSession(session).getBootOptions().getExecutionType()).setRunAs(NutsRunAs.currentUser());
            NutsArtifactCall installer = def.getDescriptor().getInstaller();
            if (installer != null) {
                cc.addExecutorArguments(installer.getArguments());
                cc.addExecutorProperties(installer.getProperties());
            }
            cc.setWorkspace(cc.getTraceSession().getWorkspace());
            NutsExecutionContext executionContext = cc.build();
            if (strategy0 == InstallStrategy0.REQUIRE) {
                newNutsInstallInformation = installedRepository.require(executionContext.getDefinition(), true, forIds, scope, session);
            } else if (strategy0 == InstallStrategy0.UPDATE) {
                newNutsInstallInformation = installedRepository.install(executionContext.getDefinition(), session);
            } else if (strategy0 == InstallStrategy0.INSTALL) {
                newNutsInstallInformation = installedRepository.install(executionContext.getDefinition(), session);
            }
            if (updateDefaultVersion) {
                installedRepository.setDefaultVersion(def.getId(), session);
            }
            NutsFetchCommand fetch2 = this.fetch().setSession(session).setId(executionContext.getDefinition().getId()).setContent(true).setRepositoryFilter(this.repos().filter().setSession(session).installedRepo()).setFailFast(true);
            if (def.isSetDependencies()) {
                fetch2.setDependencyFilter(def.getDependencies().filter());
                fetch2.setDependencies(true);
            }
            NutsDefinition def2 = fetch2.getResultDefinition();
            cc.setDefinition(def2);
            executionContext = cc.build();
            NutsRepository rep = this.repos().setSession(session).findRepository(def.getRepositoryUuid());
            boolean bl = remoteRepo = rep == null || rep.isRemote();
            if (strategy0 != InstallStrategy0.REQUIRE) {
                if (strategy0 == InstallStrategy0.UPDATE) {
                    if (installerComponent != null) {
                        try {
                            installerComponent.update(executionContext);
                        }
                        catch (NutsReadOnlyException ex) {
                            throw ex;
                        }
                        catch (Exception ex) {
                            if (session.isPlainTrace()) {
                                out.resetLine().printf("%s ```error failed``` to update : %s.%n", new Object[]{def.getId(), ex});
                            }
                            throw new NutsExecutionException(session, NutsMessage.cstyle((String)"unable to update %s", (Object[])new Object[]{def.getId()}), (Throwable)ex);
                        }
                    }
                } else if (strategy0 == InstallStrategy0.INSTALL && installerComponent != null) {
                    try {
                        installerComponent.install(executionContext);
                    }
                    catch (NutsReadOnlyException ex) {
                        throw ex;
                    }
                    catch (Exception ex) {
                        if (session.isPlainTrace()) {
                            out.resetLine().printf("```error error: failed to install``` %s: %s.%n", new Object[]{def.getId(), ex});
                        }
                        try {
                            installedRepository.uninstall(executionContext.getDefinition(), session);
                        }
                        catch (Exception ex2) {
                            this.LOG.with().session(session).level(Level.FINE).error((Throwable)ex).formatted().log("failed to uninstall  {0}", new Object[]{executionContext.getDefinition().getId()});
                        }
                        throw new NutsExecutionException(session, NutsMessage.cstyle((String)"unable to install %s", (Object[])new Object[]{def.getId()}), (Throwable)ex);
                    }
                }
            }
        } else {
            throw new NutsExecutionException(session, NutsMessage.cstyle((String)"unable to install %s: unable to locate content", (Object[])new Object[]{def.getId()}), 101);
        }
        if (strategy0 == InstallStrategy0.UPDATE) {
            wu.events().fireOnUpdate(new DefaultNutsUpdateEvent(oldDef, def, session, reinstall));
        } else if (strategy0 == InstallStrategy0.REQUIRE) {
            wu.events().fireOnRequire(new DefaultNutsInstallEvent(def, session, forIds, reinstall));
        } else if (strategy0 == InstallStrategy0.INSTALL) {
            wu.events().fireOnInstall(new DefaultNutsInstallEvent(def, session, new NutsId[0], reinstall));
        }
        if (def.getType() == NutsIdType.EXTENSION) {
            NutsWorkspaceConfigManagerExt wcfg = NutsWorkspaceConfigManagerExt.of(config);
            NutsExtensionListHelper h = new NutsExtensionListHelper(wcfg.getModel().getStoredConfigBoot().getExtensions()).save();
            h.add(def.getId());
            wcfg.getModel().getStoredConfigBoot().setExtensions(h.getConfs());
            wcfg.getModel().fireConfigurationChanged("extensions", session, ConfigEventType.BOOT);
            wcfg.getModel().prepareBootExtension(def.getId(), true, session);
        }
        if (session.isPlainTrace()) {
            String installedString;
            String setAsDefaultString = "";
            NutsTextManager text = this.text().setSession(session);
            if (updateDefaultVersion) {
                setAsDefaultString = " set as " + text.builder().append((Object)"default", NutsTextStyle.primary1()) + ".";
            }
            if (newNutsInstallInformation != null && (newNutsInstallInformation.isJustInstalled() || newNutsInstallInformation.isJustRequired())) {
                installedString = null;
                if (newNutsInstallInformation != null) {
                    if (newNutsInstallInformation.isJustReInstalled()) {
                        installedString = text.forStyled("re-install", NutsTextStyles.of((NutsTextStyle[])new NutsTextStyle[]{NutsTextStyle.success(), NutsTextStyle.underlined()}));
                    } else if (newNutsInstallInformation.isJustInstalled()) {
                        installedString = text.forStyled("install", NutsTextStyle.success());
                    } else if (newNutsInstallInformation.isJustReRequired()) {
                        installedString = text.forStyled("re-require", NutsTextStyles.of((NutsTextStyle[])new NutsTextStyle[]{NutsTextStyle.info(), NutsTextStyle.underlined()}));
                    } else if (newNutsInstallInformation.isJustRequired()) {
                        installedString = text.forStyled("require", NutsTextStyle.info());
                    }
                }
                if (installedString != null) {
                    if (!def.getContent().isCached()) {
                        if (def.getContent().isTemporary()) {
                            if (session.isPlainTrace()) {
                                out.resetLine().printf("%s %s from %s repository (%s) temporarily file %s.%s%n", new Object[]{installedString, def.getId().getLongNameId(), remoteRepo ? "remote" : "local", def.getRepositoryName(), def.getLocation(), text.parse(setAsDefaultString)});
                            }
                        } else if (session.isPlainTrace()) {
                            out.resetLine().printf("%s %s from %s repository (%s).%s%n", new Object[]{installedString, def.getId().getLongNameId(), remoteRepo ? "remote" : "local", def.getRepositoryName(), text.parse(setAsDefaultString)});
                        }
                    } else if (def.getContent().isTemporary()) {
                        if (session.isPlainTrace()) {
                            out.resetLine().printf("%s %s from %s repository (%s) temporarily file %s.%s%n", new Object[]{installedString, def.getId().getLongNameId(), remoteRepo ? "remote" : "local", def.getRepositoryName(), def.getLocation(), text.parse(setAsDefaultString)});
                        }
                    } else if (session.isPlainTrace()) {
                        out.resetLine().printf("%s %s from %s repository (%s).%s%n", new Object[]{installedString, def.getId().getLongNameId(), remoteRepo ? "remote" : "local", def.getRepositoryName(), text.parse(setAsDefaultString)});
                    }
                }
            } else {
                installedString = null;
                if (newNutsInstallInformation != null) {
                    if (newNutsInstallInformation.isJustReInstalled()) {
                        installedString = "re-installed";
                    } else if (newNutsInstallInformation.isJustInstalled()) {
                        installedString = "installed";
                    } else if (newNutsInstallInformation.isJustReRequired()) {
                        installedString = "re-required";
                    } else if (newNutsInstallInformation.isJustRequired()) {
                        installedString = "required";
                    }
                }
                if (installedString != null && session.isPlainTrace()) {
                    out.resetLine().printf("%s  %s %s.%s%n", new Object[]{installedString, def.getId().getLongNameId(), text.forStyled("successfully", NutsTextStyle.success()), text.parse(setAsDefaultString)});
                }
            }
        }
    }

    public String resolveCommandName(NutsId id, NutsSession session) {
        this.checkSession(session);
        String nn = id.getArtifactId();
        NutsCustomCommandManager aliases = this.commands().setSession(session);
        NutsWorkspaceCustomCommand c = aliases.findCommand(nn);
        if (c != null) {
            if (CoreNutsUtils.matchesSimpleNameStaticVersion(c.getOwner(), id)) {
                return nn;
            }
        } else {
            return nn;
        }
        nn = id.getArtifactId() + "-" + id.getVersion();
        c = aliases.findCommand(nn);
        if (c != null) {
            if (CoreNutsUtils.matchesSimpleNameStaticVersion(c.getOwner(), id)) {
                return nn;
            }
        } else {
            return nn;
        }
        nn = id.getGroupId() + "." + id.getArtifactId() + "-" + id.getVersion();
        c = aliases.findCommand(nn);
        if (c != null) {
            if (CoreNutsUtils.matchesSimpleNameStaticVersion(c.getOwner(), id)) {
                return nn;
            }
        } else {
            return nn;
        }
        throw new NutsElementNotFoundException(session, NutsMessage.cstyle((String)"unable to resolve command name for %s", (Object[])new Object[]{id}));
    }

    protected boolean loadWorkspace(NutsSession session, String[] excludedExtensions, String[] excludedRepositories) {
        this.checkSession(session);
        if (this.configModel.loadWorkspace(session)) {
            for (NutsCommandFactoryConfig[] extensionId : this.extensions().setSession(session).getConfigExtensions()) {
                if (this.extensionModel.isExcludedExtension((NutsId)extensionId)) continue;
                NutsSession sessionCopy = session.copy();
                this.extensionModel.wireExtension((NutsId)extensionId, this.fetch().setSession(sessionCopy.copy().setFetchStrategy(NutsFetchStrategy.ONLINE).setTransitive(Boolean.valueOf(true))));
                if (sessionCopy.getTerminal() == session.getTerminal()) continue;
                session.setTerminal(sessionCopy.getTerminal());
            }
            NutsUserConfig adminSecurity = NutsWorkspaceConfigManagerExt.of(this.config()).getModel().getUser("admin", session);
            if (adminSecurity == null || NutsUtilStrings.isBlank((CharSequence)adminSecurity.getCredentials())) {
                if (this.LOG.isLoggable(Level.CONFIG)) {
                    this.LOG.with().session(session).level(Level.CONFIG).verb(NutsLogVerb.FAIL).log("admin user has no credentials. reset to default", new Object[0]);
                }
                this.security().setSession(session).updateUser("admin").credentials("admin".toCharArray()).run();
            }
            for (NutsCommandFactoryConfig commandFactory : this.commands().setSession(session).getCommandFactories()) {
                try {
                    this.commands().setSession(session).addCommandFactory(commandFactory);
                }
                catch (Exception e) {
                    this.LOG.with().session(session).level(Level.SEVERE).verb(NutsLogVerb.FAIL).log("unable to instantiate Command Factory {0}", new Object[]{commandFactory});
                }
            }
            DefaultNutsWorkspaceEvent worksppaeReloadedEvent = new DefaultNutsWorkspaceEvent(session, null, null, null, null);
            for (NutsWorkspaceListener listener : this.events().getWorkspaceListeners()) {
                listener.onReloadWorkspace((NutsWorkspaceEvent)worksppaeReloadedEvent);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getWelcomeText(NutsSession session) {
        NutsTextManager txt = this.text().setSession(session);
        NutsText n = txt.parser().parseResource("/net/thevpc/nuts/runtime/nuts-welcome.ntf", txt.parser().createLoader(this.getClass().getClassLoader()));
        return n == null ? "no welcome found" : n.toString();
    }

    @Override
    public String getHelpText(NutsSession session) {
        NutsTextManager txt = this.text().setSession(session);
        NutsText n = txt.parser().parseResource("/net/thevpc/nuts/runtime/nuts-help.ntf", txt.parser().createLoader(this.getClass().getClassLoader()));
        return n == null ? "no help found" : n.toString();
    }

    @Override
    public String getLicenseText(NutsSession session) {
        NutsTextManager txt = this.text().setSession(session);
        NutsText n = txt.parser().parseResource("/net/thevpc/nuts/runtime/nuts-license.ntf", txt.parser().createLoader(this.getClass().getClassLoader()));
        return n == null ? "no license found" : n.toString();
    }

    @Override
    public String resolveDefaultHelp(Class clazz, NutsSession session) {
        NutsId nutsId = this.id().setSession(session).resolveId(clazz);
        if (nutsId != null) {
            String urlPath = "/" + nutsId.getGroupId().replace('.', '/') + "/" + nutsId.getArtifactId() + ".ntf";
            NutsTextManager txt = this.text().setSession(session);
            NutsText n = txt.parser().parseResource(urlPath, txt.parser().createLoader(this.getClass().getClassLoader()));
            return n == null ? "no license found" : n.toString();
        }
        return null;
    }

    @Override
    public NutsId resolveEffectiveId(NutsDescriptor descriptor, NutsSession session) {
        this.checkSession(session);
        if (descriptor == null) {
            throw new NutsNotFoundException(session, null);
        }
        NutsId thisId = descriptor.getId();
        String a = thisId.getArtifactId();
        String g = thisId.getGroupId();
        String v = thisId.getVersion().getValue();
        if (NutsUtilStrings.isBlank((CharSequence)g) || NutsUtilStrings.isBlank((CharSequence)v)) {
            NutsId[] parents;
            for (NutsId parent : parents = descriptor.getParents()) {
                NutsId p = this.fetch().setSession(session).setId(parent).setEffective(true).getResultId();
                if (NutsUtilStrings.isBlank((CharSequence)g)) {
                    g = p.getGroupId();
                }
                if (NutsUtilStrings.isBlank((CharSequence)v)) {
                    v = p.getVersion().getValue();
                }
                if (!NutsUtilStrings.isBlank((CharSequence)g) && !NutsUtilStrings.isBlank((CharSequence)v)) break;
            }
            if (NutsUtilStrings.isBlank((CharSequence)g) || NutsUtilStrings.isBlank((CharSequence)v)) {
                throw new NutsNotFoundException(session, thisId, NutsMessage.cstyle((String)"unable to fetchEffective for %s. best Result is %s", (Object[])new Object[]{thisId, thisId}), null);
            }
        }
        if (CoreStringUtils.containsVars(g) || CoreStringUtils.containsVars(v) || CoreStringUtils.containsVars(a)) {
            Map p = descriptor.getProperties();
            NutsId bestId = this.id().builder().setGroupId(g).setArtifactId(thisId.getArtifactId()).setVersion(v).build();
            if (CoreNutsUtils.isEffectiveId(bestId = bestId.builder().apply(new MapToFunction(p)).build())) {
                return bestId;
            }
            Stack<NutsId> all = new Stack<NutsId>();
            NutsId[] parents = descriptor.getParents();
            all.addAll(Arrays.asList(parents));
            while (!all.isEmpty()) {
                NutsId parent;
                parent = (NutsId)all.pop();
                NutsDescriptor dd = this.fetch().setSession(session).setId(parent).setEffective(true).getResultDescriptor();
                if (CoreNutsUtils.isEffectiveId(bestId = bestId.builder().apply(new MapToFunction(dd.getProperties())).build())) {
                    return bestId;
                }
                all.addAll(Arrays.asList(dd.getParents()));
            }
            throw new NutsNotFoundException(session, bestId, NutsMessage.cstyle((String)"unable to fetchEffective for %s. best Result is %s", (Object[])new Object[]{bestId, bestId}), null);
        }
        NutsId bestId = this.id().setSession(session).builder().setGroupId(g).setArtifactId(thisId.getArtifactId()).setVersion(v).build();
        if (!CoreNutsUtils.isEffectiveId(bestId)) {
            throw new NutsNotFoundException(session, bestId, NutsMessage.cstyle((String)"unable to fetchEffective for %s. best Result is %s", (Object[])new Object[]{thisId, bestId}), null);
        }
        return bestId;
    }

    @Override
    public NutsIdType resolveNutsIdType(NutsId id, NutsSession session) {
        NutsIdType idType = NutsIdType.REGULAR;
        String shortName = id.getShortName();
        if (shortName.equals("net.thevpc.nuts:nuts")) {
            idType = NutsIdType.API;
        } else if (shortName.equals("net.thevpc.nuts:nuts-runtime")) {
            idType = NutsIdType.RUNTIME;
        } else {
            for (NutsId companionTool : this.getCompanionIds(session)) {
                if (!companionTool.getShortName().equals(shortName)) continue;
                idType = NutsIdType.COMPANION;
            }
        }
        return idType;
    }

    @Override
    public NutsInstallerComponent getInstaller(NutsDefinition nutToInstall, NutsSession session) {
        this.checkSession(session);
        if (nutToInstall != null && nutToInstall.getPath() != null) {
            NutsInstallerComponent best;
            NutsDescriptor descriptor = nutToInstall.getDescriptor();
            NutsArtifactCall installerDescriptor = descriptor.getInstaller();
            NutsDefinition runnerFile = nutToInstall;
            if (installerDescriptor != null && installerDescriptor.getId() != null && installerDescriptor.getId() != null) {
                runnerFile = this.fetch().setId(installerDescriptor.getId()).setSession(session.copy().setTransitive(Boolean.valueOf(false))).setOptional(Boolean.valueOf(false)).setContent(true).setDependencies(true).getResultDefinition();
            }
            if (runnerFile == null) {
                runnerFile = nutToInstall;
            }
            if ((best = (NutsInstallerComponent)this.extensions().setSession(session).createSupported(NutsInstallerComponent.class, (Object)runnerFile)) != null) {
                return best;
            }
        }
        return new CommandForIdNutsInstallerComponent();
    }

    @Override
    public void requireImpl(NutsDefinition def, NutsSession session, boolean withDependencies, NutsId[] forId) {
        this.installOrUpdateImpl(def, new String[0], null, session, true, false, InstallStrategy0.REQUIRE, withDependencies, forId, null);
    }

    @Override
    public void installImpl(NutsDefinition def, String[] args, NutsInstallerComponent installerComponent, NutsSession session, boolean updateDefaultVersion) {
        this.installOrUpdateImpl(def, args, installerComponent, session, true, updateDefaultVersion, InstallStrategy0.INSTALL, true, null, null);
    }

    @Override
    public void updateImpl(NutsDefinition def, String[] args, NutsInstallerComponent installerComponent, NutsSession session, boolean updateDefaultVersion) {
        this.installOrUpdateImpl(def, args, installerComponent, session, true, updateDefaultVersion, InstallStrategy0.UPDATE, true, null, null);
    }

    @Override
    public boolean requiresRuntimeExtension(NutsSession session) {
        boolean coreFound = false;
        for (NutsId ext : this.extensions().setSession(session).getConfigExtensions()) {
            if (!ext.equalsShortName(this.getRuntimeId())) continue;
            coreFound = true;
            break;
        }
        return !coreFound;
    }

    @Override
    public NutsDescriptor resolveEffectiveDescriptor(NutsDescriptor descriptor, NutsSession session) {
        String nn;
        Path l;
        Path eff = null;
        NutsWorkspaceLocationManager loc = this.locations().setSession(session);
        if (!descriptor.getId().getVersion().isBlank() && descriptor.getId().getVersion().isSingleValue() && descriptor.getId().toString().indexOf(36) < 0 && Files.isRegularFile(eff = (l = Paths.get(loc.getStoreLocation(descriptor.getId(), NutsStoreLocation.CACHE), new String[0])).resolve(nn = loc.getDefaultIdFilename(descriptor.getId().builder().setFace("eff-nuts.cache").build())), new LinkOption[0])) {
            try {
                NutsDescriptor d = this.descriptor().setSession(session).parser().setSession(session).parse(eff);
                if (d != null) {
                    return d;
                }
            }
            catch (Exception ex) {
                this.LOG.with().session(session).level(Level.FINE).error((Throwable)ex).log("failed to parse {0}", new Object[]{eff});
            }
        }
        NutsDescriptor effectiveDescriptor = this._resolveEffectiveDescriptor(descriptor, session);
        if (eff == null) {
            Path l2 = Paths.get(this.locations().getStoreLocation(effectiveDescriptor.getId(), NutsStoreLocation.CACHE), new String[0]);
            String nn2 = loc.getDefaultIdFilename(effectiveDescriptor.getId().builder().setFace("eff-nuts.cache").build());
            eff = l2.resolve(nn2);
        }
        try {
            this.descriptor().setSession(session).formatter(effectiveDescriptor).setNtf(false).print(eff);
        }
        catch (Exception ex) {
            this.LOG.with().session(session).level(Level.FINE).error((Throwable)ex).log("failed to print {0}", new Object[]{eff});
        }
        return effectiveDescriptor;
    }

    @Override
    public NutsInstalledRepository getInstalledRepository() {
        return this.installedRepository;
    }

    @Override
    public NutsInstallStatus getInstallStatus(NutsId id, boolean checkDependencies, NutsSession session) {
        NutsDefinition nutToInstall;
        session = NutsWorkspaceUtils.of(session).validateSilentSession(session);
        try {
            nutToInstall = (NutsDefinition)this.search().addId(id).setSession(session.copy().setTransitive(Boolean.valueOf(false))).setInlineDependencies(checkDependencies).setInstallStatus(this.filters().installStatus().byDeployed(true)).setOptional(Boolean.valueOf(false)).getResultDefinitions().first();
            if (nutToInstall == null) {
                return NutsInstallStatus.NONE;
            }
        }
        catch (NutsNotFoundException e) {
            return NutsInstallStatus.NONE;
        }
        catch (Exception ex) {
            this.LOG.with().session(session).level(Level.SEVERE).error((Throwable)ex).log("error: %s", new Object[]{ex});
            return NutsInstallStatus.NONE;
        }
        return this.getInstalledRepository().getInstallStatus(nutToInstall.getId(), session);
    }

    @Override
    public NutsExecutionContextBuilder createExecutionContext() {
        return new DefaultNutsExecutionContextBuilder().setWorkspace(this);
    }

    @Override
    public void deployBoot(NutsSession session, NutsId id, boolean withDependencies) {
        HashMap<NutsId, NutsDefinition> defs = new HashMap<NutsId, NutsDefinition>();
        NutsDefinition m = this.fetch().setId(id).setContent(true).setDependencies(true).setFailFast(false).getResultDefinition();
        LinkedHashMap<String, String> a = new LinkedHashMap<String, String>();
        a.put("configVersion", Nuts.getVersion());
        a.put("id", id.getLongName());
        a.put("dependencies", m.getDependencies().stream().map(NutsDependency::getLongName).collect(Collectors.joining(";")));
        defs.put(m.getId().getLongNameId(), m);
        if (withDependencies) {
            for (NutsDependency dependency : m.getDependencies()) {
                if (defs.containsKey(dependency.toId().getLongNameId())) continue;
                m = this.fetch().setId(id).setContent(true).setDependencies(true).setFailFast(false).getResultDefinition();
                defs.put(m.getId().getLongNameId(), m);
            }
        }
        for (NutsDefinition def : defs.values()) {
            Path bootstrapFolder = Paths.get(this.locations().getStoreLocation(NutsStoreLocation.LIB), new String[0]).resolve("id");
            NutsId id2 = def.getId();
            this.io().copy().setSession(session).from(def.getPath()).to(bootstrapFolder.resolve(this.locations().getDefaultIdBasedir(id2)).resolve(this.locations().getDefaultIdFilename(id2.builder().setFaceContent().setPackaging("jar").build()))).run();
            this.descriptor().formatter(this.fetch().setId(id2).getResultDescriptor()).setNtf(false).print(bootstrapFolder.resolve(this.locations().getDefaultIdBasedir(id2)).resolve(this.locations().getDefaultIdFilename(id2.builder().setFaceDescriptor().build())));
            LinkedHashMap<String, String> pr = new LinkedHashMap<String, String>();
            pr.put("file.updated.date", Instant.now().toString());
            pr.put("project.id", def.getId().getShortNameId().toString());
            pr.put("project.name", def.getId().getShortNameId().toString());
            pr.put("project.version", def.getId().getVersion().toString());
            pr.put("repositories", "~/.m2/repository;" + NutsRepositorySelector.createRepositoryOptions(NutsRepositorySelector.parseSelection("vpc-public-maven"), true, session).getConfig().getLocation() + ";" + NutsRepositorySelector.createRepositoryOptions(NutsRepositorySelector.parseSelection("maven-central"), true, session).getConfig().getLocation() + ";" + NutsRepositorySelector.createRepositoryOptions(NutsRepositorySelector.parseSelection("vpc-public-nuts"), true, session).getConfig().getLocation());
            pr.put("project.dependencies.compile", String.join((CharSequence)";", def.getDependencies().stream().filter(x -> !x.isOptional() && CoreNutsDependencyUtils.createJavaRunDependencyFilter(session).acceptDependency(def.getId(), x, session)).map(x -> x.toId().getLongName()).collect(Collectors.toList())));
            try {
                BufferedWriter writer = Files.newBufferedWriter(bootstrapFolder.resolve(this.locations().getDefaultIdBasedir(def.getId().getLongNameId())).resolve("nuts.properties"), new OpenOption[0]);
                Throwable throwable = null;
                try {
                    CoreIOUtils.storeProperties(pr, writer, false);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            ((Writer)writer).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((Writer)writer).close();
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public String getHashName() {
        return this.config().getHashName((Object)this);
    }

    public NutsVersion getApiVersion() {
        return this.apiVersion;
    }

    public NutsId getApiId() {
        return this.apiId;
    }

    public NutsId getRuntimeId() {
        return this.runtimeId;
    }

    public String getLocation() {
        return this.location;
    }

    public Set<NutsId> getCompanionIds(NutsSession session) {
        NutsWorkspaceUtils.checkSession(this, session);
        NutsIdParser parser = this.id().setSession(session).parser();
        return Collections.unmodifiableSet(new HashSet<NutsId>(Arrays.asList(parser.parse("net.thevpc.nuts.toolbox:nsh"))));
    }

    public NutsSearchCommand search() {
        return new DefaultNutsSearchCommand(this);
    }

    public NutsFetchCommand fetch() {
        return new DefaultNutsFetchCommand(this);
    }

    public NutsDeployCommand deploy() {
        return new DefaultNutsDeployCommand(this);
    }

    public NutsUndeployCommand undeploy() {
        return new DefaultNutsUndeployCommand(this);
    }

    public NutsExecCommand exec() {
        return new DefaultNutsExecCommand(this);
    }

    public NutsInstallCommand install() {
        return new DefaultNutsInstallCommand(this);
    }

    public NutsUninstallCommand uninstall() {
        return new DefaultNutsUninstallCommand(this);
    }

    public NutsUpdateCommand update() {
        return new DefaultNutsUpdateCommand(this);
    }

    public NutsPushCommand push() {
        return new DefaultNutsPushCommand(this);
    }

    public NutsUpdateStatisticsCommand updateStatistics() {
        return new DefaultNutsUpdateStatisticsCommand(this);
    }

    public NutsWorkspaceAppsManager apps() {
        return new DefaultNutsWorkspaceAppsManager(this);
    }

    public NutsWorkspaceExtensionManager extensions() {
        return new DefaultNutsWorkspaceExtensionManager(this.extensionModel);
    }

    public NutsWorkspaceConfigManager config() {
        return new DefaultNutsWorkspaceConfigManager(this.configModel);
    }

    public NutsRepositoryManager repos() {
        return new DefaultNutsRepositoryManager(this.repositoryModel);
    }

    public NutsWorkspaceSecurityManager security() {
        return new DefaultNutsWorkspaceSecurityManager(this.securityModel);
    }

    public NutsFilterManager filters() {
        return new DefaultNutsFilterManager(this.filtersModel);
    }

    public NutsIOManager io() {
        return new DefaultNutsIOManager(this.ioModel);
    }

    public NutsLogManager log() {
        return new DefaultNutsLogManager(this.logModel);
    }

    public NutsWorkspaceEventManager events() {
        return new DefaultNutsWorkspaceEventManager(this.eventsModel);
    }

    public NutsCommandLineManager commandLine() {
        return new DefaultNutsCommandLineManager(this);
    }

    public NutsIdManager id() {
        return new DefaultNutsIdManager(this);
    }

    public NutsVersionManager version() {
        return new DefaultNutsVersionManager(this);
    }

    public NutsInfoFormat info() {
        return new DefaultNutsInfoFormat(this);
    }

    public NutsDescriptorManager descriptor() {
        return new DefaultNutsDescriptorManager(this);
    }

    public NutsDependencyManager dependency() {
        return new DefaultNutsDependencyManager(this);
    }

    public NutsFormatManager formats() {
        return new DefaultNutsFormatManager(this, this.textModel);
    }

    public NutsConcurrentManager concurrent() {
        return new DefaultNutsConcurrentManager(this.concurrentModel);
    }

    public NutsSdkManager sdks() {
        return new DefaultNutsSdkManager(this.sdkModel);
    }

    public NutsImportManager imports() {
        return new DefaultImportManager(this.importModel);
    }

    public NutsCustomCommandManager commands() {
        return new DefaultCustomCommandManager(this.aliasesModel);
    }

    public NutsWorkspaceLocationManager locations() {
        return new DefaultNutsWorkspaceLocationManager(this.locationsModel);
    }

    public NutsWorkspaceEnvManager env() {
        return new DefaultNutsWorkspaceEnvManager(this.envModel);
    }

    public NutsBootManager boot() {
        return new DefaultNutsBootManager(this.bootModel);
    }

    public NutsTerminalManager term() {
        return new DefaultNutsTerminalManager(this.termModel);
    }

    public NutsTextManager text() {
        return new DefaultNutsTextManager(this, this.textModel);
    }

    public NutsElementFormat elem() {
        return new DefaultNutsElementFormat(this.textModel);
    }

    public DefaultNutsWorkspaceEnvManagerModel getEnvModel() {
        return this.envModel;
    }

    public DefaultCustomCommandsModel getAliasesModel() {
        return this.aliasesModel;
    }

    public DefaultNutsWorkspaceConfigModel getConfigModel() {
        return this.configModel;
    }

    public DefaultImportModel getImportModel() {
        return this.importModel;
    }

    public static enum InstallStrategy0 implements NutsEnum
    {
        INSTALL,
        UPDATE,
        REQUIRE;

        private final String id = this.name().toLowerCase().replace('_', '-');

        public static InstallStrategy0 parseLenient(String value) {
            return InstallStrategy0.parseLenient(value, null);
        }

        public static InstallStrategy0 parseLenient(String value, InstallStrategy0 emptyOrErrorValue) {
            return InstallStrategy0.parseLenient(value, emptyOrErrorValue, emptyOrErrorValue);
        }

        public static InstallStrategy0 parseLenient(String value, InstallStrategy0 emptyValue, InstallStrategy0 errorValue) {
            if ((value = value == null ? "" : value.toUpperCase().trim().replace('-', '_')).isEmpty()) {
                return emptyValue;
            }
            try {
                return InstallStrategy0.valueOf(value.toUpperCase());
            }
            catch (Exception notFound) {
                return errorValue;
            }
        }

        public String id() {
            return this.id;
        }
    }
}

