/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.optional.mslink;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import mslinks.ShellLink;
import mslinks.extra.ConsoleData;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;

public class OptionalMsLinkHelper {
    private NutsSession session;
    private String command;
    private String wd;
    private String icon;
    private String filePath;

    public OptionalMsLinkHelper(String command, String wd, String icon, String filePath, NutsSession session) {
        this.session = session;
        this.command = command;
        this.wd = wd;
        this.icon = icon;
        this.filePath = filePath;
    }

    public static boolean isSupported() {
        try {
            Class.forName("mslinks.ShellLink");
        }
        catch (Exception e) {
            return false;
        }
        try {
            Iterator<Path> a = FileSystems.getDefault().getRootDirectories().iterator();
            Path someRoot = null;
            if (a.hasNext()) {
                someRoot = a.next();
                ShellLink.createLink((String)someRoot.resolve("anyName").toString());
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public void write() {
        String[] cmd = this.session.getWorkspace().commandLine().parse(this.command).toStringArray();
        ShellLink se = ShellLink.createLink((String)cmd[0]).setWorkingDir(this.wd).setCMDArgs(this.session.getWorkspace().commandLine().create(Arrays.copyOfRange(cmd, 1, cmd.length)).toString());
        if (NutsUtilStrings.isBlank((CharSequence)this.icon)) {
            se.setIconLocation("%SystemRoot%\\system32\\SHELL32.dll");
            se.getHeader().setIconIndex(148);
        } else {
            se.setIconLocation(this.icon.trim());
        }
        se.getConsoleData().setFont(ConsoleData.Font.Consolas);
        try {
            se.saveTo(this.filePath);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

