/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.function.Function;
import java.util.logging.Level;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDesktopEnvironmentFamily;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsRunAs;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSessionTerminal;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTerminalCommand;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.io.IProcessExecHelper;
import net.thevpc.nuts.runtime.bundles.io.ProcessBuilder2;
import net.thevpc.nuts.runtime.bundles.parsers.StringPlaceHolderParser;
import net.thevpc.nuts.runtime.core.util.CoreBooleanUtils;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.core.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.standalone.util.NutsJavaSdkUtils;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public class ProcessExecHelper
implements IProcessExecHelper {
    ProcessBuilder2 pb;
    NutsSession session;
    NutsPrintStream out;

    public ProcessExecHelper(ProcessBuilder2 pb, NutsSession session, NutsPrintStream out) {
        this.pb = pb;
        this.session = session;
        this.out = out;
    }

    public static ProcessExecHelper ofArgs(String[] args, Map<String, String> env, Path directory, NutsSessionTerminal prepareTerminal, NutsSessionTerminal execTerminal, boolean showCommand, boolean failFast, long sleep, boolean inheritSystemIO, boolean redirectErr, File outputFile, File inputFile, NutsRunAs runAs, NutsSession session) {
        NutsLogger _LL;
        NutsWorkspace ws = session.getWorkspace();
        List<String> newCommands = ProcessExecHelper.buildEffectiveCommand(args, runAs, session);
        NutsPrintStream out = null;
        NutsPrintStream err = null;
        InputStream in = null;
        ProcessBuilder2 pb = new ProcessBuilder2(session);
        pb.setCommand(newCommands).setEnv(env).setDirectory(directory == null ? null : directory.toFile()).setSleepMillis(sleep).setFailFast(failFast);
        if (!inheritSystemIO) {
            if (inputFile == null) {
                in = execTerminal.in();
                if (ws.io().setSession(session).isStandardInputStream(in)) {
                    in = null;
                }
            }
            if (outputFile == null) {
                out = execTerminal.out();
                if (ws.io().setSession(session).isStandardOutputStream(out)) {
                    out = null;
                }
            }
            err = execTerminal.err();
            if (ws.io().setSession(session).isStandardErrorStream(err)) {
                err = null;
            }
            if (out != null) {
                out.run(NutsTerminalCommand.MOVE_LINE_START);
            }
        }
        if (out == null && err == null && in == null && inputFile == null && outputFile == null) {
            pb.inheritIO();
            if (redirectErr) {
                pb.setRedirectErrorStream();
            }
        } else {
            if (inputFile == null) {
                pb.setIn(in);
            } else {
                pb.setRedirectFileInput(inputFile);
            }
            if (outputFile == null) {
                pb.setOutput(out == null ? null : out.asPrintStream());
            } else {
                pb.setRedirectFileOutput(outputFile);
            }
            if (redirectErr) {
                pb.setRedirectErrorStream();
            } else {
                pb.setErr(err == null ? null : err.asPrintStream());
            }
        }
        if ((_LL = session.getWorkspace().log().setSession(session).of(NutsWorkspaceUtils.class)).isLoggable(Level.FINEST)) {
            _LL.with().level(Level.FINE).verb(NutsLogVerb.START).formatted().log("[exec] {0}", new Object[]{ws.text().forCode("sh", pb.getCommandString())});
        }
        if (showCommand || CoreBooleanUtils.getSysBoolNutsProperty("show-command", false)) {
            if (prepareTerminal.out().mode() == NutsTerminalMode.FORMATTED) {
                prepareTerminal.out().printf("%s ", new Object[]{ws.text().forStyled("[exec]", NutsTextStyle.primary4())});
                prepareTerminal.out().println((NutsString)ws.text().forCode("sh", pb.getCommandString()));
            } else {
                prepareTerminal.out().print("exec ");
                prepareTerminal.out().printf("%s%n", new Object[]{pb.getCommandString()});
            }
        }
        return new ProcessExecHelper(pb, session, out == null ? execTerminal.out() : out);
    }

    public static ProcessExecHelper ofDefinition(NutsDefinition nutMainFile, String[] args, Map<String, String> env, String directory, Map<String, String> execProperties, boolean showCommand, boolean failFast, long sleep, boolean inheritSystemIO, boolean redirectErr, File outputFile, File inputFile, NutsRunAs runAs, final NutsSession session, final NutsSession execSession) throws NutsExecutionException {
        final NutsWorkspace workspace = execSession.getWorkspace();
        NutsId id = nutMainFile.getId();
        Path installerFile = nutMainFile.getPath();
        String storeFolder = nutMainFile.getInstallInformation().getInstallFolder();
        final HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> envmap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : execProperties.entrySet()) {
            map.put(entry.getKey(), entry.getValue());
        }
        Path nutsJarFile = workspace.fetch().setNutsApi().setSession(CoreNutsUtils.silent(session)).getResultPath();
        if (nutsJarFile != null) {
            map.put("nuts.jar", nutsJarFile.toAbsolutePath().normalize().toString());
        }
        map.put("nuts.id", id.getLongName());
        map.put("nuts.id.version", id.getVersion().getValue());
        map.put("nuts.id.name", id.getArtifactId());
        map.put("nuts.id.simpleName", id.getShortName());
        map.put("nuts.id.group", id.getGroupId());
        map.put("nuts.file", nutMainFile.getPath().toString());
        final String defaultJavaCommand = NutsJavaSdkUtils.of(execSession.getWorkspace()).resolveJavaCommandByVersion("", false, session);
        map.put("nuts.java", defaultJavaCommand);
        if (map.containsKey("nuts.jar")) {
            map.put("nuts.cmd", (String)map.get("nuts.java") + " -jar " + (String)map.get("nuts.jar"));
        }
        map.put("nuts.workspace", workspace.locations().getWorkspaceLocation());
        map.put("nuts.version", id.getVersion().getValue());
        map.put("nuts.name", id.getArtifactId());
        map.put("nuts.group", id.getGroupId());
        map.put("nuts.face", id.getFace());
        map.put("nuts.repo", id.getRepository());
        map.put("nuts.id", id.toString());
        if (installerFile != null) {
            map.put("nuts.installer", installerFile.toString());
        }
        if (storeFolder == null && installerFile != null) {
            map.put("nuts.store", installerFile.getParent().toString());
        } else if (storeFolder != null) {
            map.put("nuts.store", storeFolder);
        }
        if (env != null) {
            map.putAll(env);
        }
        Function<String, String> mapper = new Function<String, String>(){

            @Override
            public String apply(String skey) {
                if (skey.equals("java") || skey.startsWith("java#")) {
                    String javaVer = skey.substring(4);
                    if (NutsUtilStrings.isBlank((CharSequence)javaVer)) {
                        return defaultJavaCommand;
                    }
                    return NutsJavaSdkUtils.of(execSession.getWorkspace()).resolveJavaCommandByVersion(javaVer, false, session);
                }
                if (skey.equals("javaw") || skey.startsWith("javaw#")) {
                    String javaVer = skey.substring(4);
                    if (NutsUtilStrings.isBlank((CharSequence)javaVer)) {
                        return defaultJavaCommand;
                    }
                    return NutsJavaSdkUtils.of(execSession.getWorkspace()).resolveJavaCommandByVersion(javaVer, true, session);
                }
                if (skey.equals("nuts")) {
                    NutsDefinition nutsDefinition = workspace.fetch().setId("net.thevpc.nuts:nuts").setSession(session).getResultDefinition();
                    if (nutsDefinition.getPath() != null) {
                        return "<::expand::> " + this.apply("java") + " -jar " + nutsDefinition.getPath();
                    }
                    return null;
                }
                return (String)map.get(skey);
            }
        };
        for (Map.Entry entry : map.entrySet()) {
            String k = (String)entry.getKey();
            if (NutsUtilStrings.isBlank((CharSequence)k)) continue;
            k = k.replace('.', '_');
            if (NutsUtilStrings.isBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
            envmap.put(k, (String)entry.getValue());
        }
        ArrayList<String> args2 = new ArrayList<String>();
        for (String arg : args) {
            String s = NutsUtilStrings.trim((String)StringPlaceHolderParser.replaceDollarPlaceHolders(arg, mapper));
            if (s.startsWith("<::expand::>")) {
                Collections.addAll(args2, workspace.commandLine().parse(s).toStringArray());
                continue;
            }
            args2.add(s);
        }
        args = args2.toArray(new String[0]);
        Path path = Paths.get(workspace.locations().getWorkspaceLocation(), new String[0]).resolve(args[0]).normalize();
        if (Files.exists(path, new LinkOption[0])) {
            CoreIOUtils.setExecutable(path);
        }
        Path pdirectory = null;
        pdirectory = NutsUtilStrings.isBlank((CharSequence)directory) ? Paths.get(workspace.locations().getWorkspaceLocation(), new String[0]) : Paths.get(workspace.locations().getWorkspaceLocation(), new String[0]).resolve(directory);
        return ProcessExecHelper.ofArgs(args, envmap, pdirectory, session.getTerminal(), execSession.getTerminal(), showCommand, failFast, sleep, inheritSystemIO, redirectErr, inputFile, outputFile, runAs, session);
    }

    private static String resolveRootUserName(NutsSession session) {
        NutsOsFamily sysFamily = session.getWorkspace().env().getOsFamily();
        switch (sysFamily) {
            case WINDOWS: {
                String s = (String)session.getProperty("WINDOWS_ROOT_USER");
                if (s == null) {
                    s = session.getWorkspace().env().getEnv("WINDOWS_ROOT_USER", null);
                }
                if (NutsUtilStrings.isBlank((CharSequence)s)) {
                    s = "Administrator";
                }
                return s;
            }
        }
        return "root";
    }

    private static List<String> buildEffectiveCommand(String[] cmd, NutsRunAs runAsMode, NutsSession session) {
        NutsOsFamily sysFamily = session.getWorkspace().env().getOsFamily();
        ArrayList<String> command = new ArrayList<String>(Arrays.asList(cmd));
        if (runAsMode == null) {
            runAsMode = NutsRunAs.CURRENT_USER;
        }
        boolean runWithGui = session.isGui() && session.getWorkspace().env().isGraphicalDesktopEnvironment();
        String rootUserName = ProcessExecHelper.resolveRootUserName(session);
        String currentUserName = System.getProperty("user.name");
        switch (runAsMode.getMode()) {
            case ROOT: {
                if (!rootUserName.equals(currentUserName)) break;
                runAsMode = NutsRunAs.currentUser();
                break;
            }
            case USER: {
                String s = runAsMode.getUser();
                s = s.trim();
                if (currentUserName.equals(s)) {
                    runAsMode = NutsRunAs.currentUser();
                }
                if (s.equals(runAsMode.getUser())) break;
                runAsMode = NutsRunAs.user((String)s);
                break;
            }
        }
        switch (runAsMode.getMode()) {
            case CURRENT_USER: {
                ArrayList<String> cc = new ArrayList<String>();
                cc.addAll(command);
                return cc;
            }
            case ROOT: 
            case USER: {
                String runAsEffective = runAsMode.getMode() == NutsRunAs.Mode.USER ? runAsMode.getUser() : rootUserName;
                ArrayList<String> cc = new ArrayList<String>();
                switch (sysFamily) {
                    case LINUX: 
                    case MACOS: 
                    case UNIX: {
                        if (runWithGui) {
                            NutsDesktopEnvironmentFamily[] de = session.getWorkspace().env().getDesktopEnvironmentFamilies();
                            Path kdesu = CoreIOUtils.sysWhich("kdesu");
                            Path gksu = CoreIOUtils.sysWhich("gksu");
                            String currSu = null;
                            if (Arrays.stream(de).anyMatch(x -> x == NutsDesktopEnvironmentFamily.KDE)) {
                                if (kdesu != null) {
                                    currSu = kdesu.toString();
                                }
                            } else if (Arrays.stream(de).anyMatch(x -> x == NutsDesktopEnvironmentFamily.KDE) && gksu != null) {
                                currSu = gksu.toString();
                            }
                            if (currSu == null && gksu != null) {
                                currSu = gksu.toString();
                            }
                            if (currSu == null && kdesu != null) {
                                currSu = kdesu.toString();
                            }
                            if (currSu == null) {
                                throw new NutsIllegalArgumentException(session, NutsMessage.plain((String)"unable to resolve gui su application (kdesu,gksu,...)"));
                            }
                            cc.add(currSu);
                            cc.add(runAsEffective);
                            break;
                        }
                        Path su = CoreIOUtils.sysWhich("su");
                        if (su == null) {
                            throw new NutsIllegalArgumentException(session, NutsMessage.plain((String)"unable to resolve su application"));
                        }
                        cc.add(su.toString());
                        cc.add("-c");
                        cc.add(runAsEffective);
                        break;
                    }
                    case WINDOWS: {
                        cc.addAll(Arrays.asList("runas", "/noprofile", "/user:" + runAsEffective));
                        break;
                    }
                    default: {
                        throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"cannot run as %s on unknown system OS family", (Object[])new Object[]{runAsEffective}));
                    }
                }
                cc.addAll(command);
                return cc;
            }
            case SUDO: {
                ArrayList<String> cc = new ArrayList();
                switch (sysFamily) {
                    case LINUX: 
                    case MACOS: 
                    case UNIX: {
                        if (runWithGui) {
                            NutsDesktopEnvironmentFamily[] de = session.getWorkspace().env().getDesktopEnvironmentFamilies();
                            Path kdesu = CoreIOUtils.sysWhich("kdesudo");
                            Path gksu = CoreIOUtils.sysWhich("gksudo");
                            String currSu = null;
                            if (Arrays.stream(de).anyMatch(x -> x == NutsDesktopEnvironmentFamily.KDE)) {
                                if (kdesu != null) {
                                    currSu = kdesu.toString();
                                }
                            } else if (Arrays.stream(de).anyMatch(x -> x == NutsDesktopEnvironmentFamily.KDE) && gksu != null) {
                                currSu = gksu.toString();
                            }
                            if (currSu == null && gksu != null) {
                                currSu = gksu.toString();
                            }
                            if (currSu == null && kdesu != null) {
                                currSu = kdesu.toString();
                            }
                            if (currSu == null) {
                                throw new NutsIllegalArgumentException(session, NutsMessage.plain((String)"unable to resolve gui su application (kdesu,gksu,...)"));
                            }
                            cc.add(currSu);
                            break;
                        }
                        Path su = CoreIOUtils.sysWhich("sudo");
                        if (su == null) {
                            throw new NutsIllegalArgumentException(session, NutsMessage.plain((String)"unable to resolve su application"));
                        }
                        cc.add(su.toString());
                        break;
                    }
                    case WINDOWS: {
                        cc.addAll(Arrays.asList("runas", "/noprofile", "/user:" + rootUserName));
                        break;
                    }
                    default: {
                        throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"cannot run sudo %s on unknown system OS family", (Object[])new Object[]{currentUserName}));
                    }
                }
                cc.addAll(command);
                return cc;
            }
        }
        throw new NutsIllegalArgumentException(session, NutsMessage.plain((String)"cannot run as admin/root on unknown system OS family"));
    }

    @Override
    public void dryExec() {
        if (this.out.mode() == NutsTerminalMode.FORMATTED) {
            this.out.print("[dry] ==[exec]== ");
            this.out.println(this.pb.getFormattedCommandString(this.session));
        } else {
            this.out.print("[dry] exec ");
            this.out.printf("%s%n", new Object[]{this.pb.getCommandString()});
        }
    }

    @Override
    public int exec() {
        try {
            if (this.out != null) {
                this.out.resetLine();
            }
            ProcessBuilder2 p = this.pb.start();
            return p.waitFor().getResult();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public Future<Integer> execAsync() {
        try {
            if (this.out != null) {
                this.out.run(NutsTerminalCommand.MOVE_LINE_START);
            }
            ProcessBuilder2 p = this.pb.start();
            return new FutureTask<Integer>(() -> p.waitFor().getResult());
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

