/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsInput;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsParseException;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsProgressFactory;
import net.thevpc.nuts.NutsProgressMonitor;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsUnsupportedOperationException;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.io.CoreInput;
import net.thevpc.nuts.runtime.bundles.io.FixedInputStreamMetadata;
import net.thevpc.nuts.runtime.bundles.io.InputStreamExt;
import net.thevpc.nuts.runtime.bundles.io.InputStreamMetadataAware;
import net.thevpc.nuts.runtime.bundles.io.InputStreamMetadataAwareImpl;
import net.thevpc.nuts.runtime.bundles.io.InputStreamTee;
import net.thevpc.nuts.runtime.bundles.io.Interruptible;
import net.thevpc.nuts.runtime.bundles.io.MultiInput;
import net.thevpc.nuts.runtime.bundles.nanodb.NanoDB;
import net.thevpc.nuts.runtime.bundles.nanodb.NanoDBTableFile;
import net.thevpc.nuts.runtime.core.format.text.ExtendedFormatAware;
import net.thevpc.nuts.runtime.core.format.text.ExtendedFormatAwarePrintWriter;
import net.thevpc.nuts.runtime.core.format.text.RawOutputStream;
import net.thevpc.nuts.runtime.core.io.NutsFormattedPrintStream;
import net.thevpc.nuts.runtime.core.terminals.NutsTerminalModeOp;
import net.thevpc.nuts.runtime.core.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.DefaultNutsDescriptorContentParserContext;
import net.thevpc.nuts.runtime.standalone.index.CacheDB;
import net.thevpc.nuts.runtime.standalone.io.DefaultHttpTransportComponent;
import net.thevpc.nuts.runtime.standalone.io.DefaultNutsInputStreamProgressFactory;
import net.thevpc.nuts.runtime.standalone.io.DefaultNutsProgressFactory;
import net.thevpc.nuts.runtime.standalone.io.NamedByteArrayInputStream;
import net.thevpc.nuts.runtime.standalone.io.progress.MonitoredInputStream;
import net.thevpc.nuts.runtime.standalone.io.progress.NutsProgressMonitorList;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsDescriptorContentParserComponent;
import net.thevpc.nuts.spi.NutsDescriptorContentParserContext;
import net.thevpc.nuts.spi.NutsTransportComponent;
import net.thevpc.nuts.spi.NutsTransportConnection;

public class CoreIOUtils {
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    public static final DirectoryStream.Filter<Path> DIR_FILTER = new DirectoryStream.Filter<Path>(){

        @Override
        public boolean accept(Path pathname) {
            try {
                return Files.isDirectory(pathname, new LinkOption[0]);
            }
            catch (Exception e) {
                return false;
            }
        }
    };
    public static String newLineString = null;

    public static PrintWriter toPrintWriter(Writer writer, NutsSession session) {
        if (writer == null) {
            return null;
        }
        if (writer instanceof ExtendedFormatAware && writer instanceof PrintWriter) {
            return (PrintWriter)writer;
        }
        ExtendedFormatAwarePrintWriter s = new ExtendedFormatAwarePrintWriter(writer);
        NutsWorkspaceUtils.setSession(s, session);
        return s;
    }

    public static PrintWriter toPrintWriter(OutputStream writer, NutsSession session) {
        if (writer == null) {
            return null;
        }
        ExtendedFormatAwarePrintWriter s = new ExtendedFormatAwarePrintWriter(writer);
        NutsWorkspaceUtils.setSession(s, session);
        return s;
    }

    public static OutputStream convertOutputStream(OutputStream out, NutsTerminalMode expected, NutsSession session) {
        ExtendedFormatAware a = CoreIOUtils.convertOutputStreamToExtendedFormatAware(out, expected, session);
        return (OutputStream)((Object)a);
    }

    public static ExtendedFormatAware convertOutputStreamToExtendedFormatAware(OutputStream out, NutsTerminalMode expected, NutsSession session) {
        if (out == null) {
            return null;
        }
        ExtendedFormatAware aw = null;
        aw = out instanceof ExtendedFormatAware ? (ExtendedFormatAware)((Object)out) : new RawOutputStream(out, session);
        switch (expected) {
            case INHERITED: {
                return aw.convert(NutsTerminalModeOp.NOP);
            }
            case FORMATTED: {
                return aw.convert(NutsTerminalModeOp.FORMAT);
            }
            case FILTERED: {
                return aw.convert(NutsTerminalModeOp.FILTER);
            }
        }
        throw new IllegalArgumentException("unsupported terminal mode " + expected);
    }

    public static URL asURL(String s) {
        if (s == null || s.trim().isEmpty()) {
            return null;
        }
        try {
            return new URL(s);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static URL[] toURL(String[] all) {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (all != null) {
            for (String s : all) {
                if (NutsUtilStrings.isBlank((CharSequence)s)) continue;
                try {
                    URL u = new URL(s);
                    urls.add(u);
                }
                catch (MalformedURLException e) {
                    try {
                        urls.add(new File(s).toURI().toURL());
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                }
            }
        }
        return urls.toArray(new URL[0]);
    }

    public static URL[] toURL(File[] all) {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (all != null) {
            for (File s : all) {
                if (s == null) continue;
                try {
                    urls.add(s.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
        return urls.toArray(new URL[0]);
    }

    public static File toFile(String url) {
        if (NutsUtilStrings.isBlank((CharSequence)url)) {
            return null;
        }
        try {
            URL u = new URL(url);
            return CoreIOUtils.toFile(u);
        }
        catch (MalformedURLException e) {
            return new File(url);
        }
    }

    public static String urlTrimLastSlash(String url) {
        char c;
        int x = url.length() - 1;
        if (x == 0) {
            return "";
        }
        while (x > 0 && (c = url.charAt(x)) == '/') {
            --x;
        }
        return url.substring(0, x);
    }

    public static String urlTrimFirstSlash(String url) {
        char c;
        int x;
        int len = url.length();
        if (len == 0) {
            return "";
        }
        for (x = 0; x < len && (c = url.charAt(x)) == '/'; ++x) {
        }
        return url.substring(x);
    }

    public static String getURLParent(String url) {
        char c;
        int x = url.length() - 1;
        if (x == 0) {
            return "";
        }
        while (x > 0 && (c = url.charAt(x)) == '/') {
            --x;
        }
        while (x > 0 && (c = url.charAt(x)) != '/') {
            --x;
        }
        return url.substring(0, x);
    }

    public static File toFile(URL url) {
        if (url == null) {
            return null;
        }
        if ("file".equals(url.getProtocol())) {
            try {
                return Paths.get(url.toURI()).toFile();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean setExecutable(Path path) {
        PosixFileAttributeView p;
        if (Files.exists(path, new LinkOption[0]) && !Files.isExecutable(path) && (p = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0])) != null) {
            try {
                HashSet<PosixFilePermission> old = new HashSet<PosixFilePermission>(p.readAttributes().permissions());
                old.add(PosixFilePermission.OWNER_EXECUTE);
                Files.setPosixFilePermissions(path, old);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            return true;
        }
        return false;
    }

    public static boolean mkdirs(Path p) {
        if (p != null) {
            try {
                if (!Files.isDirectory(p, new LinkOption[0])) {
                    Files.createDirectories(p, new FileAttribute[0]);
                }
                return true;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        return false;
    }

    public static Path toPathFile(String s, NutsSession session) {
        if (NutsUtilStrings.isBlank((CharSequence)s)) {
            return null;
        }
        if (s.startsWith("file:")) {
            try {
                URI uri = new URL(s).toURI();
                if (uri.getAuthority() != null && uri.getAuthority().length() > 0) {
                    uri = new URL("file://" + s.substring("file:".length())).toURI();
                }
                return Paths.get(uri);
            }
            catch (URISyntaxException ex) {
                throw new NutsParseException(session, NutsMessage.cstyle((String)"not a file path : %s", (Object[])new Object[]{s}));
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        if (s.startsWith("http://") || s.startsWith("https://") || s.startsWith("ftp://") || s.startsWith("jar:") || s.startsWith("zip:") || s.startsWith("ssh:")) {
            throw new NutsParseException(session, NutsMessage.cstyle((String)"not a file path : %s", (Object[])new Object[]{s}));
        }
        if (CoreIOUtils.isURL(s)) {
            throw new NutsParseException(session, NutsMessage.cstyle((String)"not a file path : %s", (Object[])new Object[]{s}));
        }
        return Paths.get(s, new String[0]);
    }

    public static boolean isPathFile(String s) {
        if (NutsUtilStrings.isBlank((CharSequence)s)) {
            return false;
        }
        if (s.startsWith("file:")) {
            return true;
        }
        if (s.startsWith("http://") || s.startsWith("https://") || s.startsWith("ftp://") || s.startsWith("jar:") || s.startsWith("zip:") || s.startsWith("ssh:")) {
            return false;
        }
        return !CoreIOUtils.isURL(s);
    }

    public static boolean isPathLocal(String s) {
        if (NutsUtilStrings.isBlank((CharSequence)s)) {
            return false;
        }
        if (s.startsWith("file:") || s.startsWith("jar:") || s.startsWith("zip:")) {
            return true;
        }
        if (s.startsWith("http://") || s.startsWith("https://") || s.startsWith("ftp://") || s.startsWith("ssh://")) {
            return false;
        }
        return !CoreIOUtils.isURL(s);
    }

    public static boolean isPathHttp(String s) {
        if (NutsUtilStrings.isBlank((CharSequence)s)) {
            return false;
        }
        return s.startsWith("http://") || s.startsWith("https://");
    }

    public static boolean isPathURL(String s) {
        if (NutsUtilStrings.isBlank((CharSequence)s)) {
            return false;
        }
        if (NutsUtilStrings.isBlank((CharSequence)s) || s.startsWith("file:") || s.startsWith("jar:") || s.startsWith("zip:")) {
            return true;
        }
        if (s.startsWith("http://") || s.startsWith("https://") || s.startsWith("ftp://") || s.startsWith("ssh://")) {
            return true;
        }
        return CoreIOUtils.isURL(s);
    }

    public static String syspath(String s) {
        return s.replace('/', File.separatorChar);
    }

    public static String resolveRepositoryPath(NutsAddRepositoryOptions options, Path rootFolder, NutsSession session) {
        NutsWorkspace ws = session.getWorkspace();
        String loc = options.getLocation();
        String goodName = options.getName();
        if (NutsUtilStrings.isBlank((CharSequence)goodName)) {
            goodName = options.getConfig().getName();
        }
        if (NutsUtilStrings.isBlank((CharSequence)goodName)) {
            goodName = options.getName();
        }
        if (NutsUtilStrings.isBlank((CharSequence)goodName)) {
            goodName = options.isTemporary() ? "temp-" + UUID.randomUUID().toString() : "repo-" + UUID.randomUUID().toString();
        }
        if (NutsUtilStrings.isBlank((CharSequence)loc)) {
            if (options.isTemporary()) {
                if (NutsUtilStrings.isBlank((CharSequence)goodName)) {
                    goodName = "temp";
                }
                if (goodName.length() < 3) {
                    goodName = goodName + "-repo";
                }
                loc = ws.io().tmp().setSession(session).createTempFolder(goodName + "-");
            } else if (NutsUtilStrings.isBlank((CharSequence)loc)) {
                if (NutsUtilStrings.isBlank((CharSequence)goodName)) {
                    goodName = CoreNutsUtils.randomColorName() + "-repo";
                }
                loc = goodName;
            }
        }
        return ws.io().expandPath(loc, rootFolder.toString());
    }

    public static String trimSlashes(String repositoryIdPath) {
        StringBuilder sb = new StringBuilder(repositoryIdPath);
        boolean updated = true;
        while (updated) {
            updated = false;
            if (sb.length() <= 0) continue;
            if (sb.charAt(0) == '/' || sb.charAt(0) == '\\') {
                sb.delete(0, 1);
                updated = true;
                continue;
            }
            if (sb.charAt(sb.length() - 1) != '/' && sb.charAt(sb.length() - 1) != '\\') continue;
            sb.delete(sb.length() - 1, sb.length());
            updated = true;
        }
        return sb.toString();
    }

    public static NutsPrintStream resolveOut(NutsSession session) {
        return session.getTerminal() == null ? session.getWorkspace().io().nullPrintStream() : session.getTerminal().out();
    }

    public static NutsDescriptor resolveNutsDescriptorFromFileContent(NutsInput localPath, String[] parseOptions, NutsSession session) {
        List allParsers;
        if (parseOptions == null) {
            parseOptions = new String[]{};
        }
        NutsWorkspace ws = session.getWorkspace();
        if (localPath != null && (allParsers = ws.extensions().setSession(session).createAllSupported(NutsDescriptorContentParserComponent.class, null)).size() > 0) {
            String fileExtension = CoreIOUtils.getFileExtension(localPath.getName());
            DefaultNutsDescriptorContentParserContext ctx = new DefaultNutsDescriptorContentParserContext(session, localPath, fileExtension, null, parseOptions);
            for (NutsDescriptorContentParserComponent parser : allParsers) {
                NutsDescriptor desc = null;
                try {
                    desc = parser.parse((NutsDescriptorContentParserContext)ctx);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (desc == null) continue;
                return desc;
            }
        }
        return null;
    }

    public static String getPath(NutsId id, String ext, char sep) {
        StringBuilder sb = new StringBuilder();
        sb.append(id.getGroupId().replace('.', sep));
        sb.append(sep);
        sb.append(id.getArtifactId());
        sb.append(sep);
        sb.append(id.getVersion().toString());
        sb.append(sep);
        String name = id.getArtifactId() + "-" + id.getVersion().getValue();
        sb.append(name);
        sb.append(ext);
        return sb.toString();
    }

    public static void copy(Reader in, Writer out) {
        CoreIOUtils.copy(in, out, 1024);
    }

    public static long copy(java.io.InputStream in, OutputStream out) {
        return CoreIOUtils.copy(in, out, 1024);
    }

    public static long copy(java.io.InputStream in, OutputStream out, int bufferSize) {
        byte[] buffer = new byte[bufferSize];
        long count = 0L;
        try {
            int len;
            while ((len = in.read(buffer)) > 0) {
                count += (long)len;
                out.write(buffer, 0, len);
            }
            return len;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static void copy(Reader in, Writer out, int bufferSize) {
        char[] buffer = new char[bufferSize];
        try {
            int len;
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadString(java.io.InputStream is, boolean close) {
        String string;
        block6: {
            try {
                byte[] bytes = CoreIOUtils.loadByteArray(is);
                string = new String(bytes);
                if (is == null || !close) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null && close) {
                        is.close();
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            is.close();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadString(Reader is, boolean close) {
        String string;
        block6: {
            try {
                char[] bytes = CoreIOUtils.loadCharArray(is);
                string = new String(bytes);
                if (is == null || !close) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null && close) {
                        is.close();
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            is.close();
        }
        return string;
    }

    public static char[] loadCharArray(Reader r) {
        try (CharArrayWriter out = null;){
            out = new CharArrayWriter();
            CoreIOUtils.copy(r, out);
            out.flush();
            char[] cArray = out.toCharArray();
            return cArray;
        }
    }

    public static byte[] loadByteArray(java.io.InputStream r) {
        byte[] byArray;
        block6: {
            ByteArrayOutputStream out = null;
            try {
                out = new ByteArrayOutputStream();
                CoreIOUtils.copy(r, out);
                out.flush();
                byArray = out.toByteArray();
                if (out == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (out != null) {
                        out.close();
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            out.close();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadByteArray(java.io.InputStream r, boolean close) {
        byte[] byArray;
        block8: {
            ByteArrayOutputStream out = null;
            try {
                out = new ByteArrayOutputStream();
                CoreIOUtils.copy(r, out);
                out.flush();
                byArray = out.toByteArray();
                if (out == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (out != null) {
                        out.close();
                    }
                    if (r != null && close) {
                        r.close();
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            out.close();
        }
        if (r != null && close) {
            r.close();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] loadByteArray(java.io.InputStream stream, int maxSize, boolean close) {
        try {
            try {
                if (maxSize > 0) {
                    int count;
                    ByteArrayOutputStream to = new ByteArrayOutputStream();
                    byte[] bytes = new byte[Math.max(maxSize, 10240)];
                    int all = 0;
                    while ((count = stream.read(bytes)) > 0) {
                        if (all + count < maxSize) {
                            to.write(bytes, 0, count);
                            all += count;
                            continue;
                        }
                        int count2 = maxSize - all;
                        to.write(bytes, 0, count2);
                        all += count2;
                        break;
                    }
                    byte[] byArray2 = to.toByteArray();
                    return byArray2;
                }
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                CoreIOUtils.copy(stream, os, close, true);
                byte[] byArray = os.toByteArray();
                return byArray;
            }
            finally {
                if (close) {
                    stream.close();
                }
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static long copy(java.io.InputStream from, OutputStream to, boolean closeInput, boolean closeOutput) {
        byte[] bytes = new byte[1024];
        long all = 0L;
        try {
            try {
                long l;
                block11: {
                    try {
                        int count;
                        while ((count = from.read(bytes)) > 0) {
                            to.write(bytes, 0, count);
                            all += (long)count;
                        }
                        l = all;
                        if (!closeInput) break block11;
                    }
                    catch (Throwable throwable) {
                        if (closeInput) {
                            from.close();
                        }
                        throw throwable;
                    }
                    from.close();
                }
                return l;
            }
            finally {
                if (closeOutput) {
                    to.close();
                }
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static java.io.InputStream monitor(URL from, NutsProgressMonitor monitor, NutsSession session) {
        return CoreIOUtils.monitor(NutsWorkspaceUtils.of(session).openURL(from), from, (NutsString)session.getWorkspace().text().forStyled(CoreIOUtils.getURLName(from), NutsTextStyle.path()), session.getWorkspace().io().path(from).getContentLength(), monitor, session);
    }

    public static java.io.InputStream monitor(java.io.InputStream from, Object source, NutsString sourceName, long length, NutsProgressMonitor monitor, NutsSession session) {
        return new MonitoredInputStream(from, source, sourceName, length, monitor, session);
    }

    public static java.io.InputStream monitor(java.io.InputStream from, Object source, NutsProgressMonitor monitor, NutsSession session) {
        NutsText sourceName = null;
        long length = -1L;
        if (from instanceof InputStreamMetadataAware) {
            InputStreamMetadataAware m = (InputStreamMetadataAware)((Object)from);
            sourceName = session.getWorkspace().text().toText((Object)m.getMetaData().getName());
            length = m.getMetaData().getLength();
        }
        return new MonitoredInputStream(from, source, (NutsString)sourceName, length, monitor, session);
    }

    public static void delete(NutsSession session, File file) {
        CoreIOUtils.delete(session, file.toPath());
    }

    public static void delete(final NutsSession session, Path file) {
        if (!Files.exists(file, new LinkOption[0])) {
            return;
        }
        if (Files.isRegularFile(file, new LinkOption[0])) {
            try {
                Files.delete(file);
            }
            catch (IOException e) {
                return;
            }
        }
        final int[] deleted = new int[]{0, 0, 0};
        final NutsLogger LOG = session == null ? null : session.getWorkspace().log().of(CoreIOUtils.class);
        try {
            Files.walkFileTree(file, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        Files.delete(file);
                        if (LOG != null) {
                            LOG.with().session(session).level(Level.FINEST).verb(NutsLogVerb.WARNING).log("delete file " + file, new Object[0]);
                        }
                        deleted[0] = deleted[0] + 1;
                    }
                    catch (IOException e) {
                        if (LOG != null) {
                            LOG.with().session(session).level(Level.FINEST).verb(NutsLogVerb.WARNING).log("failed deleting file : " + file, new Object[0]);
                        }
                        deleted[2] = deleted[2] + 1;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    try {
                        Files.delete(dir);
                        if (LOG != null) {
                            LOG.with().session(session).level(Level.FINEST).verb(NutsLogVerb.WARNING).log("delete folder " + dir, new Object[0]);
                        }
                        deleted[1] = deleted[1] + 1;
                    }
                    catch (IOException e) {
                        if (LOG != null) {
                            LOG.with().session(session).level(Level.FINEST).verb(NutsLogVerb.WARNING).log("failed deleting folder: " + dir, new Object[0]);
                        }
                        deleted[2] = deleted[2] + 1;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static String getNativePath(String path) {
        return path.replace('/', File.separatorChar);
    }

    public static String getFileExtension(String s) {
        int i = s.lastIndexOf(46);
        if (i == 0) {
            return s.substring(1);
        }
        if (i > 0) {
            if (i < s.length() - 1) {
                return s.substring(i + 1);
            }
            return "";
        }
        return "";
    }

    public static String getFileExtension(String s, boolean longest, boolean includeDot) {
        int i;
        int n = i = longest ? s.indexOf(46) : s.lastIndexOf(46);
        if (i == 0) {
            return includeDot ? s : s.substring(1);
        }
        if (i > 0) {
            if (i < s.length() - 1) {
                return s.substring(includeDot ? i : i + 1);
            }
            return "";
        }
        return "";
    }

    public static String buildUrl(String url, String path) {
        if (!url.endsWith("/")) {
            if (path.startsWith("/")) {
                return url + path;
            }
            return url + "/" + path;
        }
        if (path.startsWith("/")) {
            return url + path.substring(1);
        }
        return url + path;
    }

    public static boolean isURL(String url) {
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException ex) {
            return false;
        }
    }

    public static String getURLName(URL url) {
        return CoreIOUtils.getURLName(url.getFile());
    }

    public static String getURLName(String path) {
        int index = path.lastIndexOf(47);
        String name = index < 0 ? path : path.substring(index + 1);
        index = name.indexOf(63);
        if (index >= 0) {
            name = name.substring(0, index);
        }
        name = name.trim();
        return name;
    }

    public static CoreInput createInputSource(byte[] source, String name, NutsString formattedString, String typeName, NutsSession session) {
        if (source == null) {
            return null;
        }
        if (name == null && formattedString != null) {
            name = formattedString.filteredText();
        }
        if (name == null) {
            name = String.valueOf(source);
        }
        if (formattedString == null) {
            formattedString = session.getWorkspace().text().forPlain(name);
        }
        return new ByteArrayInput(name, formattedString, source, typeName, session);
    }

    public static boolean isValidInputStreamSource(Class type) {
        return URL.class.isAssignableFrom(type) || File.class.isAssignableFrom(type) || Path.class.isAssignableFrom(type) || byte[].class.isAssignableFrom(type) || java.io.InputStream.class.isAssignableFrom(type) || String.class.isAssignableFrom(type) || CoreInput.class.isAssignableFrom(type);
    }

    public static NutsTransportConnection getHttpClientFacade(NutsSession session, String url) {
        NutsTransportComponent best = (NutsTransportComponent)session.getWorkspace().extensions().setSession(session).createSupported(NutsTransportComponent.class, (Object)url);
        if (best == null) {
            best = DefaultHttpTransportComponent.INSTANCE;
        }
        return best.open(url);
    }

    public static String urlEncodeString(String s) {
        if (s == null || s.trim().length() == 0) {
            return "";
        }
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Path resolveLocalPathFromURL(URL url) {
        try {
            return new File(url.toURI()).toPath();
        }
        catch (URISyntaxException e) {
            return new File(url.getPath()).toPath();
        }
    }

    public static URL resolveURLFromResource(Class cls, String urlPath, NutsSession session) {
        if (!urlPath.startsWith("/")) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unable to resolve url from %s", (Object[])new Object[]{urlPath}));
        }
        URL url = cls.getResource(urlPath);
        String urlFile = url.getFile();
        int separatorIndex = urlFile.indexOf("!/");
        if (separatorIndex != -1) {
            String jarFile = urlFile.substring(0, separatorIndex);
            try {
                return new URL(jarFile);
            }
            catch (MalformedURLException ex) {
                if (!jarFile.startsWith("/")) {
                    jarFile = "/" + jarFile;
                }
                try {
                    return new URL("file:" + jarFile);
                }
                catch (IOException ex2) {
                    throw new UncheckedIOException(ex2);
                }
            }
        }
        String encoded = CoreIOUtils.encodePath(urlPath, session);
        String url_tostring = url.toString();
        if (url_tostring.endsWith(encoded)) {
            try {
                return new URL(url_tostring.substring(0, url_tostring.length() - encoded.length()));
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unable to resolve url from %s", (Object[])new Object[]{urlPath}));
    }

    private static String encodePath(String path, NutsSession session) {
        StringTokenizer st = new StringTokenizer(path, "/", true);
        StringBuilder encoded = new StringBuilder();
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (t.equals("/")) {
                encoded.append(t);
                continue;
            }
            try {
                encoded.append(URLEncoder.encode(t, "UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unable to encode %s", (Object[])new Object[]{t}), (Throwable)ex);
            }
        }
        return encoded.toString();
    }

    public static File resolveLocalFileFromResource(Class cls, String url, NutsSession session) {
        return CoreIOUtils.resolveLocalFileFromURL(CoreIOUtils.resolveURLFromResource(cls, url, session));
    }

    public static File resolveLocalFileFromURL(URL url) {
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            return new File(url.getPath());
        }
    }

    public static byte[] evalMD5(String input) {
        try {
            byte[] bytesOfMessage = input.getBytes("UTF-8");
            return CoreIOUtils.evalMD5(bytesOfMessage);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String evalMD5Hex(Path path) {
        return NutsUtilStrings.toHexString((byte[])CoreIOUtils.evalMD5(path));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] evalMD5(Path path) {
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
            byte[] byArray = CoreIOUtils.evalMD5(is);
            return byArray;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static String evalMD5Hex(java.io.InputStream input) {
        return NutsUtilStrings.toHexString((byte[])CoreIOUtils.evalMD5(input));
    }

    public static byte[] evalHash(java.io.InputStream input, String algo) {
        try {
            MessageDigest md = MessageDigest.getInstance(algo);
            byte[] buffer = new byte[8192];
            int len = 0;
            try {
                len = input.read(buffer);
                while (len != -1) {
                    md.update(buffer, 0, len);
                    len = input.read(buffer);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new UncheckedIOException(new IOException(e));
        }
    }

    public static byte[] evalMD5(java.io.InputStream input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[8192];
            int len = 0;
            try {
                len = input.read(buffer);
                while (len != -1) {
                    md.update(buffer, 0, len);
                    len = input.read(buffer);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new UncheckedIOException(new IOException(e));
        }
    }

    public static byte[] evalMD5(byte[] bytesOfMessage) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return md.digest(bytesOfMessage);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UncheckedIOException(new IOException(e));
        }
    }

    public static String evalSHA1Hex(Path file) {
        try {
            return CoreIOUtils.evalSHA1Hex(Files.newInputStream(file, new OpenOption[0]), true);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String evalSHA1(File file) {
        try {
            return CoreIOUtils.evalSHA1Hex(new FileInputStream(file), true);
        }
        catch (FileNotFoundException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static byte[] charsToBytes(char[] chars) {
        CharBuffer charBuffer = CharBuffer.wrap(chars);
        ByteBuffer byteBuffer = Charset.forName("UTF-8").encode(charBuffer);
        byte[] bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        Arrays.fill(byteBuffer.array(), (byte)0);
        return bytes;
    }

    public static char[] bytesToChars(byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        CharBuffer charBuffer = Charset.forName("UTF-8").decode(byteBuffer);
        char[] chars = Arrays.copyOfRange(charBuffer.array(), charBuffer.position(), charBuffer.limit());
        Arrays.fill(charBuffer.array(), '\u0000');
        return chars;
    }

    public static char[] evalSHA1(char[] input) {
        byte[] bytes = CoreIOUtils.charsToBytes(input);
        char[] r = CoreIOUtils.evalSHA1HexChars(new ByteArrayInputStream(bytes), true);
        Arrays.fill(bytes, (byte)0);
        return r;
    }

    public static String evalSHA1(String input) {
        return CoreIOUtils.evalSHA1Hex(new ByteArrayInputStream(input.getBytes()), true);
    }

    public static String evalSHA1Hex(java.io.InputStream input, boolean closeStream) {
        return NutsUtilStrings.toHexString((byte[])CoreIOUtils.evalSHA1(input, closeStream));
    }

    public static char[] evalSHA1HexChars(java.io.InputStream input, boolean closeStream) {
        return NutsUtilStrings.toHexString((byte[])CoreIOUtils.evalSHA1(input, closeStream)).toCharArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] evalSHA1(java.io.InputStream input, boolean closeStream) {
        try {
            MessageDigest sha1 = null;
            try {
                sha1 = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException ex) {
                throw new UncheckedIOException(new IOException(ex));
            }
            byte[] buffer = new byte[8192];
            int len = 0;
            try {
                len = input.read(buffer);
                while (len != -1) {
                    sha1.update(buffer, 0, len);
                    len = input.read(buffer);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            byte[] byArray = sha1.digest();
            return byArray;
        }
        finally {
            if (closeStream && input != null) {
                try {
                    input.close();
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
        }
    }

    public static NutsInput getCachedUrlWithSHA1(NutsWorkspace ws, String path, String sourceTypeName, boolean ignoreSha1NotFound, NutsSession session) {
        Path p;
        String cachedID;
        String sha1;
        Path urlContent;
        block9: {
            Path cacheBasePath = Paths.get(ws.locations().getStoreLocation(ws.getRuntimeId(), NutsStoreLocation.CACHE), new String[0]);
            urlContent = cacheBasePath.resolve("urls-content");
            sha1 = null;
            try {
                ByteArrayOutputStream t = new ByteArrayOutputStream();
                ws.io().copy().setSession(session).from(path + ".sha1").to((OutputStream)t).run();
                sha1 = t.toString().trim();
            }
            catch (NutsIOException ex) {
                if (ignoreSha1NotFound) break block9;
                throw ex;
            }
        }
        NanoDB cachedDB = CacheDB.of(ws);
        NanoDBTableFile<CachedURL> cacheTable = cachedDB.createTable(cachedDB.createBeanDefinition(CachedURL.class, false, "url"), true);
        CachedURL old = cacheTable.findByIndex("path", path).findFirst().orElse(null);
        if (sha1 != null && old != null && sha1.equalsIgnoreCase(old.sha1) && (cachedID = old.path) != null && Files.exists(p = urlContent.resolve(cachedID), new LinkOption[0])) {
            return ws.io().input().of(p);
        }
        try {
            Path p2;
            String cachedID2;
            NutsPath header = null;
            long size = -1L;
            long lastModified = -1L;
            NutsTransportConnection f = CoreIOUtils.getHttpClientFacade(session, path);
            try {
                header = f.getPath();
                size = header.getContentLength();
                Instant lastModifiedInstant = header.getLastModifiedInstant();
                if (lastModifiedInstant != null) {
                    lastModified = lastModifiedInstant.toEpochMilli();
                }
            }
            catch (Exception lastModifiedInstant) {
                // empty catch block
            }
            if (sha1 == null && old != null && old.lastModified != -1L && old.lastModified == lastModified && old != null && old.size == size && (cachedID2 = old.path) != null && Files.exists(p2 = urlContent.resolve(cachedID2), new LinkOption[0])) {
                return ws.io().input().of(p2);
            }
            String s = UUID.randomUUID().toString();
            Path outPath = urlContent.resolve(s + "~");
            CoreIOUtils.mkdirs(urlContent);
            OutputStream p3 = Files.newOutputStream(outPath, new OpenOption[0]);
            long finalLastModified = lastModified;
            InputStreamTee ist = new InputStreamTee(f.open(), p3, () -> {
                if (Files.exists(outPath, new LinkOption[0])) {
                    CachedURL ccu = new CachedURL();
                    ccu.url = path;
                    ccu.path = s;
                    ccu.sha1 = CoreIOUtils.evalSHA1Hex(outPath);
                    long newSize = -1L;
                    try {
                        newSize = Files.size(outPath);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ccu.size = newSize;
                    ccu.lastModified = finalLastModified;
                    Path newLocalPath = urlContent.resolve(s);
                    try {
                        Files.move(outPath, newLocalPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                    cacheTable.add(ccu);
                    cacheTable.flush();
                }
            });
            return ws.io().input().setName((NutsString)session.getWorkspace().text().forStyled(path, NutsTextStyle.path())).setTypeName(sourceTypeName).of((java.io.InputStream)new InputStreamMetadataAwareImpl(ist, new FixedInputStreamMetadata(path, size)));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static void storeProperties(Map<String, String> props, OutputStream out, boolean sort) {
        CoreIOUtils.storeProperties(props, new OutputStreamWriter(out), sort);
    }

    public static void storeProperties(Map<String, String> props, Writer w, boolean sort) {
        try {
            Set<String> keys = props.keySet();
            if (sort) {
                keys = new TreeSet<String>(keys);
            }
            for (String key : keys) {
                String value = props.get(key);
                w.write(CoreIOUtils.escapePropsString(key, true));
                w.write("=");
                w.write(CoreIOUtils.escapePropsString(value, false));
                w.write("\n");
                w.flush();
            }
            w.flush();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static String escapePropsString(String theString, boolean escapeSpace) {
        if (theString == null) {
            theString = "";
        }
        char[] chars = theString.toCharArray();
        StringBuilder buffer = new StringBuilder(chars.length);
        block9: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '\\': {
                    buffer.append("\\\\");
                    continue block9;
                }
                case ' ': {
                    if (i == 0 || escapeSpace) {
                        buffer.append('\\');
                    }
                    buffer.append(' ');
                    continue block9;
                }
                case '\t': {
                    buffer.append("\\t");
                    continue block9;
                }
                case '\n': {
                    buffer.append("\\n");
                    continue block9;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block9;
                }
                case '\f': {
                    buffer.append("\\f");
                    continue block9;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    buffer.append('\\');
                    buffer.append(c);
                    continue block9;
                }
                default: {
                    if (c > '=' && c < '\u007f') {
                        buffer.append(c);
                        continue block9;
                    }
                    if (c < ' ' || c > '~') {
                        buffer.append('\\');
                        buffer.append('u');
                        buffer.append(NutsUtilStrings.toHexChar((int)(c >> 12 & 0xF)));
                        buffer.append(NutsUtilStrings.toHexChar((int)(c >> 8 & 0xF)));
                        buffer.append(NutsUtilStrings.toHexChar((int)(c >> 4 & 0xF)));
                        buffer.append(NutsUtilStrings.toHexChar((int)(c & 0xF)));
                        continue block9;
                    }
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    public static NutsInput toPathInputSource(NutsInput is, List<Path> tempPaths, NutsSession session) {
        NutsWorkspace ws = session.getWorkspace();
        if (is.isFile()) {
            return is;
        }
        Path temp = Paths.get(ws.io().tmp().setSession(session).createTempFile(CoreIOUtils.getURLName(is.getName())), new String[0]);
        ws.io().copy().setSafe(false).from(is).to(temp).setSession(session).run();
        tempPaths.add(temp);
        return ws.io().input().setMultiRead(true).of(temp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getNewLine() {
        if (newLineString != null) return newLineString;
        Class<CoreIOUtils> clazz = CoreIOUtils.class;
        synchronized (CoreIOUtils.class) {
            newLineString = System.getProperty("line.separator");
            // ** MonitorExit[var0] (shouldn't be in output)
            return newLineString;
        }
    }

    public static boolean isAbsolutePath(String location) {
        return new File(location).isAbsolute();
    }

    public static String getAbsolutePath(String path) {
        return new File(path).toPath().toAbsolutePath().normalize().toString();
    }

    public static void copyFolder(Path src, Path dest) {
        try {
            Files.walk(src, new FileVisitOption[0]).forEach(source -> CoreIOUtils.copy(source, dest.resolve(src.relativize((Path)source))));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void copy(Path source, Path dest) {
        try {
            Files.copy(source, dest, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            throw new RuntimeException(CoreStringUtils.exceptionToString(e), e);
        }
    }

    public static Path toPath(Object lockedObject) {
        if (lockedObject instanceof Path) {
            return (Path)lockedObject;
        }
        if (lockedObject instanceof File) {
            return ((File)lockedObject).toPath();
        }
        if (lockedObject instanceof String) {
            return Paths.get((String)lockedObject, new String[0]);
        }
        return null;
    }

    public static NutsProgressFactory createLogProgressMonitorFactory(MonitorType mt) {
        switch (mt) {
            case STREAM: {
                return new DefaultNutsInputStreamProgressFactory();
            }
            case DEFAULT: {
                return new DefaultNutsProgressFactory();
            }
        }
        return new DefaultNutsProgressFactory();
    }

    public static NutsProgressMonitor createProgressMonitor(MonitorType mt, Object source, Object sourceOrigin, NutsSession session, boolean logProgress, NutsProgressFactory progressFactory) {
        NutsProgressMonitor m0 = null;
        NutsProgressMonitor m1 = null;
        if (logProgress) {
            m0 = CoreIOUtils.createLogProgressMonitorFactory(mt).create(source, sourceOrigin, session);
        }
        if (progressFactory != null) {
            m1 = progressFactory.create(source, sourceOrigin, session);
        }
        if (m1 == null) {
            return m0;
        }
        if (m0 == null) {
            return m1;
        }
        return new NutsProgressMonitorList(new NutsProgressMonitor[]{m0, m1});
    }

    public static Path toPath(String path) {
        return NutsUtilStrings.isBlank((CharSequence)path) ? null : Paths.get(path, new String[0]);
    }

    public static java.io.InputStream interruptible(java.io.InputStream in) {
        if (in == null) {
            return in;
        }
        if (in instanceof Interruptible) {
            return in;
        }
        return new InputStreamExt(in, null);
    }

    public static NutsTerminalModeOp resolveNutsTerminalModeOp(OutputStream out) {
        if (out == null) {
            return NutsTerminalModeOp.NOP;
        }
        if (out instanceof ExtendedFormatAware) {
            ExtendedFormatAware a = (ExtendedFormatAware)((Object)out);
            return a.getModeOp();
        }
        if (out instanceof NutsFormattedPrintStream) {
            return NutsTerminalModeOp.FORMAT;
        }
        return NutsTerminalModeOp.NOP;
    }

    public static boolean isObsoletePath(NutsSession session, Path path) {
        try {
            return CoreIOUtils.isObsoleteInstant(session, Files.getLastModifiedTime(path, new LinkOption[0]).toInstant());
        }
        catch (IOException e) {
            return true;
        }
    }

    public static boolean isObsoleteInstant(NutsSession session, Instant instant) {
        return session.getExpireTime() != null && (instant == null || instant.isBefore(session.getExpireTime()));
    }

    public static List<String> headFrom(NutsInput input, int count) {
        return input.lines().limit(count).collect(Collectors.toList());
    }

    public static List<String> tailFrom(NutsInput input, int max) {
        LinkedList<String> lines = new LinkedList<String>();
        BufferedReader br = new BufferedReader(new InputStreamReader(input.open()));
        try {
            String line;
            int count = 0;
            while ((line = br.readLine()) != null) {
                lines.add(line);
                if (++count <= max) continue;
                lines.remove();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return lines;
    }

    public static Stream<String> linesFrom(NutsInput input) {
        final BufferedReader br = new BufferedReader(new InputStreamReader(input.open()));
        Iterator<String> sourceIterator = new Iterator<String>(){
            String line = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                boolean hasNext = false;
                try {
                    try {
                        this.line = br.readLine();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    boolean bl = hasNext = this.line != null;
                    return bl;
                }
                finally {
                    if (!hasNext) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                }
            }

            @Override
            public String next() {
                return this.line;
            }
        };
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(sourceIterator, 16), false);
    }

    public static Path sysWhich(String commandName) {
        Path[] p = CoreIOUtils.sysWhichAll(commandName);
        if (p.length > 0) {
            return p[0];
        }
        return null;
    }

    public static Path[] sysWhichAll(String commandName) {
        if (commandName == null || commandName.isEmpty()) {
            return new Path[0];
        }
        ArrayList<Path> all = new ArrayList<Path>();
        String p = System.getenv("PATH");
        if (p != null) {
            for (String s : p.split(File.pathSeparator)) {
                try {
                    Path c;
                    if (s.trim().isEmpty() || !Files.isRegularFile(c = Paths.get(s, commandName), new LinkOption[0]) || !Files.isExecutable(c)) continue;
                    all.add(c);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return all.toArray(new Path[0]);
    }

    public static final int readFully(byte[] b, int off, int len, java.io.InputStream in) {
        int n;
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (n = 0; n < len; n += count) {
            count = 0;
            try {
                count = in.read(b, off + n, len - n);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            if (count < 0) break;
        }
        return n;
    }

    public static boolean Arrays_equals(byte[] a, int aFromIndex, int aToIndex, byte[] b, int bFromIndex, int bToIndex) {
        int aLength = aToIndex - aFromIndex;
        int bLength = bToIndex - bFromIndex;
        if (aLength != bLength) {
            return false;
        }
        for (int i = 0; i < aLength; ++i) {
            if (a[aFromIndex + i] == b[bFromIndex + i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean compareContent(Path file1, Path file2) {
        if (Files.isRegularFile(file1, new LinkOption[0]) == false) return false;
        if (Files.isRegularFile(file2, new LinkOption[0]) == false) return false;
        try {
            if (Files.size(file1) != Files.size(file2)) return false;
            max = 2048;
            b1 = new byte[max];
            b2 = new byte[max];
            in1 = Files.newInputStream(file1, new OpenOption[0]);
            var6_7 = null;
            try {
                in2 = Files.newInputStream(file1, new OpenOption[0]);
                var8_10 = null;
                while (true) {
                    c1 = CoreIOUtils.readFully(b1, 0, b1.length, in1);
                    c2 = CoreIOUtils.readFully(b2, 0, b2.length, in2);
                    if (c1 == c2) ** GOTO lbl-1000
                    var11_14 = false;
                    if (in2 == null) return var11_14;
                    if (var8_10 != null) {
                    }
                    ** GOTO lbl43
                    {
                        block47: {
                            block48: {
                                block46: {
                                    block45: {
                                        catch (Throwable var9_12) {
                                            var8_10 = var9_12;
                                            throw var9_12;
                                        }
                                        catch (Throwable var13_26) {
                                            if (in2 == null) throw var13_26;
                                            if (var8_10 == null) {
                                                in2.close();
                                                throw var13_26;
                                            }
                                            try {
                                                in2.close();
                                                throw var13_26;
                                            }
                                            catch (Throwable var14_27) {
                                                var8_10.addSuppressed(var14_27);
                                                throw var13_26;
                                            }
                                        }
                                        try {
                                            in2.close();
                                            return var11_14;
                                        }
                                        catch (Throwable var12_18) {
                                            var8_10.addSuppressed(var12_18);
                                            return var11_14;
                                        }
lbl43:
                                        // 1 sources

                                        in2.close();
                                        return var11_14;
lbl-1000:
                                        // 1 sources

                                        {
                                            if (c1 != 0) ** GOTO lbl-1000
                                            var11_15 = true;
                                            if (in2 == null) return var11_15;
                                            if (var8_10 == null) break block45;
                                        }
                                        try {
                                            in2.close();
                                            return var11_15;
                                        }
                                        catch (Throwable var12_20) {
                                            var8_10.addSuppressed(var12_20);
                                            return var11_15;
                                        }
                                    }
                                    in2.close();
                                    return var11_15;
lbl-1000:
                                    // 1 sources

                                    {
                                        if (CoreIOUtils.Arrays_equals(b1, 0, c1, b2, 0, c1)) ** GOTO lbl-1000
                                        var11_16 = false;
                                        if (in2 == null) return var11_16;
                                        if (var8_10 == null) break block46;
                                    }
                                    try {
                                        in2.close();
                                        return var11_16;
                                    }
                                    catch (Throwable var12_22) {
                                        var8_10.addSuppressed(var12_22);
                                        return var11_16;
                                    }
                                }
                                in2.close();
                                return var11_16;
lbl-1000:
                                // 1 sources

                                {
                                    if (c1 >= max) break block47;
                                    var11_17 = true;
                                    if (in2 == null) return var11_17;
                                    if (var8_10 == null) break block48;
                                }
                                try {
                                    in2.close();
                                    return var11_17;
                                }
                                catch (Throwable var12_24) {
                                    var8_10.addSuppressed(var12_24);
                                    return var11_17;
                                }
                            }
                            in2.close();
                            return var11_17;
                        }
                        ** try [egrp 18[TRYBLOCK] [23 : 434->486)] { 
lbl-1000:
                        // 1 sources

                        {
                            continue;
                        }
                    }
                    break;
                }
            }
lbl87:
            // 2 sources

            catch (Throwable var7_9) {
                var6_7 = var7_9;
                throw var7_9;
            }
            finally {
                if (in1 != null) {
                    if (var6_7 != null) {
                        try {
                            in1.close();
                        }
                        catch (Throwable var12_19) {
                            var6_7.addSuppressed(var12_19);
                        }
                    } else {
                        in1.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static class InputStream
    extends AbstractItem {
        public InputStream(String name, NutsString formattedName, java.io.InputStream value, String typeName, NutsSession session) {
            super(name, formattedName, value, false, false, typeName, session);
        }

        @Override
        public java.io.InputStream open() {
            return (java.io.InputStream)this.getSource();
        }

        @Override
        public void copyTo(Path path) {
            try (java.io.InputStream o = this.open();){
                Files.copy(o, path, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }

        public long length() {
            return -1L;
        }

        public String getContentType() {
            return null;
        }

        public String getContentEncoding() {
            return null;
        }

        public Instant getLastModifiedInstant() {
            return null;
        }

        public String toString() {
            return "input-stream://" + this.getSource();
        }
    }

    private static class PathInput
    extends AbstractMultiReadItem {
        public PathInput(String name, NutsString formattedName, Path value, String typeName, NutsSession session) {
            super(name, formattedName, value, true, true, typeName, session);
        }

        @Override
        public java.io.InputStream open() {
            try {
                Path p = this.getFilePath();
                return new InputStreamMetadataAwareImpl(Files.newInputStream(p, new OpenOption[0]), new FixedInputStreamMetadata(p.toString(), Files.size(p)));
            }
            catch (IOException ex) {
                throw this.createOpenError(ex);
            }
        }

        @Override
        public Path getFilePath() {
            return (Path)this.getSource();
        }

        @Override
        public URL getURL() {
            try {
                return this.getFilePath().toUri().toURL();
            }
            catch (MalformedURLException ex) {
                throw new UncheckedIOException(ex);
            }
        }

        @Override
        public void copyTo(Path path) {
            if (!Files.isRegularFile(this.getFilePath(), new LinkOption[0])) {
                throw this.createOpenError(new FileNotFoundException(this.getFilePath().toString()));
            }
            try {
                Files.copy(this.getFilePath(), path, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }

        public long length() {
            try {
                return Files.size(this.getFilePath());
            }
            catch (IOException e) {
                return -1L;
            }
        }

        public String getContentType() {
            return null;
        }

        public String getContentEncoding() {
            return null;
        }

        public Instant getLastModifiedInstant() {
            FileTime r = null;
            try {
                r = Files.getLastModifiedTime(this.getFilePath(), new LinkOption[0]);
                if (r != null) {
                    return r.toInstant();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }

        public String toString() {
            return this.getFilePath().toString();
        }
    }

    public static class URLInput
    extends AbstractItem {
        private NutsPath cachedNutsURLHeader = null;

        public URLInput(String name, NutsString formattedName, URL value, String typeName, NutsSession session) {
            super(name, formattedName, value, false, true, typeName, session);
        }

        @Override
        public java.io.InputStream open() {
            try {
                URL u = this.getURL();
                if (CoreIOUtils.isPathHttp(u.toString())) {
                    try {
                        NutsPath uh = this.getPath();
                        return new InputStreamMetadataAwareImpl(NutsWorkspaceUtils.of(this.session).openURL(u), new FixedInputStreamMetadata(u.toString(), uh == null ? -1L : uh.getContentLength()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return NutsWorkspaceUtils.of(this.session).openURL(u);
            }
            catch (Exception ex) {
                throw this.createOpenError(ex);
            }
        }

        @Override
        public URL getURL() {
            return (URL)this.getSource();
        }

        protected NutsPath getPath() {
            URL u;
            if (this.cachedNutsURLHeader == null && CoreIOUtils.isPathHttp((u = this.getURL()).toString())) {
                try {
                    NutsTransportConnection hf = DefaultHttpTransportComponent.INSTANCE.open(u.toString());
                    this.cachedNutsURLHeader = hf.getPath();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.cachedNutsURLHeader;
        }

        public long length() {
            File file;
            URL u = this.getURL();
            if (CoreIOUtils.isPathHttp(u.toString())) {
                try {
                    NutsPath uh = this.getPath();
                    return uh == null ? -1L : uh.getContentLength();
                }
                catch (Exception uh) {
                    // empty catch block
                }
            }
            if ((file = CoreIOUtils.toFile(u)) != null) {
                return file.length();
            }
            return -1L;
        }

        public String getContentType() {
            NutsPath r = null;
            try {
                r = this.getPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (r != null) {
                return r.getContentType();
            }
            return null;
        }

        public String getContentEncoding() {
            NutsPath r = null;
            try {
                r = this.getPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (r != null) {
                return r.getContentEncoding();
            }
            return null;
        }

        public Instant getLastModifiedInstant() {
            NutsPath r = null;
            try {
                r = this.getPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (r != null) {
                return r.getLastModifiedInstant();
            }
            return null;
        }

        public String toString() {
            return this.getURL().toString();
        }
    }

    private static class ByteArrayInput
    extends AbstractMultiReadItem {
        public ByteArrayInput(String name, NutsString formattedName, byte[] value, String typeName, NutsSession session) {
            super(name, formattedName, value, false, false, typeName, session);
        }

        @Override
        public java.io.InputStream open() {
            byte[] bytes = (byte[])this.getSource();
            return new InputStreamMetadataAwareImpl(new NamedByteArrayInputStream(bytes, this.name), new FixedInputStreamMetadata(this.name, bytes.length));
        }

        public long length() {
            byte[] bytes = (byte[])this.getSource();
            return bytes.length;
        }

        public String getContentType() {
            return null;
        }

        public String getContentEncoding() {
            return null;
        }

        public Instant getLastModifiedInstant() {
            return null;
        }

        public String toString() {
            return "bytes://" + ((byte[])this.getSource()).length;
        }
    }

    public static abstract class AbstractItem
    implements CoreInput {
        Object value;
        boolean path;
        boolean url;
        String name;
        NutsString formattedName;
        String typeName;
        NutsSession session;

        public AbstractItem(String name, NutsString formattedName, Object value, boolean path, boolean url, String typeName, NutsSession session) {
            this.name = name;
            this.value = value;
            this.path = path;
            this.formattedName = formattedName;
            this.url = url;
            this.typeName = typeName;
            this.session = session;
        }

        public NutsString getFormattedName() {
            return this.formattedName;
        }

        public String getName() {
            return this.name;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public void close() {
        }

        public abstract java.io.InputStream open();

        public Object getSource() {
            return this.value;
        }

        public boolean isFile() {
            return this.path;
        }

        public Path getFilePath() {
            throw new NutsUnsupportedOperationException(this.session, NutsMessage.cstyle((String)"unsupported operation '%s'", (Object[])new Object[]{"getFilePath"}));
        }

        public boolean isURL() {
            return this.url;
        }

        public URL getURL() {
            throw new NutsUnsupportedOperationException(this.session, NutsMessage.cstyle((String)"unsupported operation '%s'", (Object[])new Object[]{"getURL"}));
        }

        public Stream<String> lines() {
            return CoreIOUtils.linesFrom(this);
        }

        public List<String> head(int count) {
            return CoreIOUtils.headFrom(this, count);
        }

        public List<String> tail(int count) {
            return CoreIOUtils.tailFrom(this, count);
        }

        protected NutsIOException createOpenError(Exception ex) {
            String s;
            String n = this.getTypeName();
            if (n == null) {
                n = this.getName();
            }
            if ((s = this.toString()).equals(n)) {
                return new NutsIOException(this.session, NutsMessage.cstyle((String)"%s not found", (Object[])new Object[]{n}), (Throwable)ex);
            }
            return new NutsIOException(this.session, NutsMessage.cstyle((String)"%s not found : %s", (Object[])new Object[]{n, this.toString()}), (Throwable)ex);
        }

        @Override
        public void copyTo(Path path) {
            try {
                Files.copy(this.open(), path, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }

        @Override
        public MultiInput multi() {
            if (this instanceof MultiInput) {
                return (MultiInput)((Object)this);
            }
            return new DefaultMultiReadItem(this, this.getTypeName());
        }
    }

    public static abstract class AbstractMultiReadItem
    extends AbstractItem
    implements MultiInput {
        public AbstractMultiReadItem(String name, NutsString formattedName, Object value, boolean path, boolean url, String typeName, NutsSession session) {
            super(name, formattedName, value, path, url, typeName, session);
        }
    }

    public static class DefaultMultiReadItem
    implements MultiInput {
        private CoreInput base;
        private byte[] content;
        private String typeName;

        public DefaultMultiReadItem(CoreInput base, String typeName) {
            this.base = base;
            this.content = CoreIOUtils.loadByteArray(base.open());
            this.typeName = typeName;
        }

        public NutsString getFormattedName() {
            return this.base.getFormattedName();
        }

        public String getName() {
            return this.base.getName();
        }

        public String getTypeName() {
            return this.typeName;
        }

        public void close() {
            this.base.close();
        }

        public java.io.InputStream open() {
            return new NamedByteArrayInputStream(this.content, this.base.getName());
        }

        public long length() {
            return this.content.length;
        }

        public Object getSource() {
            return this.base.getSource();
        }

        public boolean isFile() {
            return this.base.isFile();
        }

        public Path getFilePath() {
            return this.base.getFilePath();
        }

        public boolean isURL() {
            return this.base.isURL();
        }

        public URL getURL() {
            return this.base.getURL();
        }

        public String getContentType() {
            return this.base.getContentType();
        }

        public String getContentEncoding() {
            return this.base.getContentEncoding();
        }

        public Instant getLastModifiedInstant() {
            return this.base.getLastModifiedInstant();
        }

        public Stream<String> lines() {
            return CoreIOUtils.linesFrom(this);
        }

        public List<String> head(int count) {
            return CoreIOUtils.headFrom(this, count);
        }

        public List<String> tail(int count) {
            return CoreIOUtils.tailFrom(this, count);
        }

        @Override
        public void copyTo(Path path) {
            this.base.copyTo(path);
        }

        @Override
        public MultiInput multi() {
            return this;
        }

        public String toString() {
            return this.base.toString();
        }
    }

    public static class CachedURL {
        String url;
        String path;
        String sha1;
        long lastModified;
        long size;
    }

    public static enum MonitorType {
        STREAM,
        DEFAULT;

    }
}

