/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import net.thevpc.nuts.NutsClassifierMapping;
import net.thevpc.nuts.NutsIdLocation;
import net.thevpc.nuts.runtime.core.util.CoreCollectionUtils;

public class CoreArrayUtils {
    public static String[] concatArrays(String[] ... arrays) {
        return CoreArrayUtils.concatArrays(String.class, arrays);
    }

    public static <T> T[] concatArrays(Class<T> cls, T[] ... arrays) {
        ArrayList<T> all = new ArrayList<T>();
        if (arrays != null) {
            for (T[] v : arrays) {
                if (v == null) continue;
                all.addAll(Arrays.asList(v));
            }
        }
        return all.toArray((Object[])Array.newInstance(cls, all.size()));
    }

    public static String[] toArraySet(String[] values0, String[] ... values) {
        Set<String> set = CoreCollectionUtils.toSet(values0);
        if (values != null) {
            for (String[] value : values) {
                set.addAll(CoreCollectionUtils.toSet(value));
            }
        }
        return set.toArray(new String[0]);
    }

    public static NutsClassifierMapping[] toArraySet(NutsClassifierMapping[] classifierMappings) {
        Set<NutsClassifierMapping> set = CoreCollectionUtils.toSet(classifierMappings);
        return set.toArray(new NutsClassifierMapping[0]);
    }

    public static NutsIdLocation[] toArraySet(NutsIdLocation[] classifierMappings) {
        Set<NutsIdLocation> set = CoreCollectionUtils.toSet(classifierMappings);
        return set.toArray(new NutsIdLocation[0]);
    }
}

