/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.terminals;

import java.io.InputStream;
import java.util.Scanner;
import net.thevpc.nuts.NutsCommandAutoCompleteResolver;
import net.thevpc.nuts.NutsCommandHistory;
import net.thevpc.nuts.NutsCommandReadHighlighter;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsPrototype;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSupportLevelContext;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.NutsTerminalSpec;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceOptions;
import net.thevpc.nuts.spi.NutsSystemTerminalBase;

@NutsPrototype
public class DefaultNutsSystemTerminalBase
implements NutsSystemTerminalBase {
    private NutsLogger LOG;
    private Scanner scanner;
    private NutsTerminalMode outMode = NutsTerminalMode.FORMATTED;
    private NutsTerminalMode errMode = NutsTerminalMode.FORMATTED;
    private NutsPrintStream out;
    private NutsPrintStream err;
    private InputStream in;
    private NutsWorkspace workspace;
    private NutsSession session;

    private NutsLogger _LOG() {
        if (this.LOG == null && this.session != null) {
            this.LOG = this.workspace.log().setSession(this.session).of(NutsSystemTerminalBase.class);
        }
        return this.LOG;
    }

    public int getSupportLevel(NutsSupportLevelContext<NutsTerminalSpec> criteria) {
        this.session = criteria.getSession();
        this.workspace = this.session.getWorkspace();
        if (this.workspace != null) {
            NutsWorkspaceOptions options = this.session.getWorkspace().env().getBootOptions();
            NutsTerminalMode terminalMode = options.getTerminalMode();
            if (terminalMode == null) {
                terminalMode = options.isBot() ? NutsTerminalMode.FILTERED : NutsTerminalMode.FORMATTED;
            }
            this.out = this.workspace.io().stdout().convertMode(terminalMode);
            this.err = this.workspace.io().stderr().convertMode(terminalMode);
            this.in = this.workspace.io().stdin();
            this.scanner = new Scanner(this.in);
        }
        return 10;
    }

    public String readLine(NutsPrintStream out, NutsMessage message, NutsSession session) {
        if (out == null) {
            out = this.getOut();
        }
        if (out == null) {
            out = this.workspace.io().stdout();
        }
        if (message != null) {
            out.printf("%s", new Object[]{message});
            out.flush();
        }
        return this.scanner.nextLine();
    }

    public char[] readPassword(NutsPrintStream out, NutsMessage message, NutsSession session) {
        if (out == null) {
            out = this.getOut();
        }
        if (out == null) {
            out = this.workspace.io().stdout();
        }
        if (message != null) {
            out.printf("%s", new Object[]{message});
            out.flush();
        }
        return this.scanner.nextLine().toCharArray();
    }

    public InputStream getIn() {
        return this.in;
    }

    public NutsPrintStream getOut() {
        return this.out;
    }

    public NutsPrintStream getErr() {
        return this.err;
    }

    public NutsCommandAutoCompleteResolver getAutoCompleteResolver() {
        return null;
    }

    public boolean isAutoCompleteSupported() {
        return false;
    }

    public NutsSystemTerminalBase setCommandAutoCompleteResolver(NutsCommandAutoCompleteResolver autoCompleteResolver) {
        return this;
    }

    public NutsSystemTerminalBase setCommandHistory(NutsCommandHistory history) {
        return this;
    }

    public NutsCommandHistory getCommandHistory() {
        return null;
    }

    public NutsCommandReadHighlighter getCommandReadHighlighter() {
        return null;
    }

    public NutsSystemTerminalBase setCommandReadHighlighter(NutsCommandReadHighlighter commandReadHighlighter) {
        return this;
    }
}

