/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.repos;

import java.util.Map;
import java.util.logging.Level;
import net.thevpc.nuts.NutsContentEvent;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryEvent;
import net.thevpc.nuts.NutsRepositoryListener;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.core.commands.repo.NutsRepositorySupportedAction;
import net.thevpc.nuts.runtime.core.repos.NutsInstalledRepository;
import net.thevpc.nuts.runtime.core.repos.NutsRepositoryExt;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;

public class NutsRepositoryUtils {
    private NutsLogger LOG;
    private NutsRepository repo;

    public static NutsRepositoryUtils of(NutsRepository repo) {
        Map up = repo.getUserProperties();
        NutsRepositoryUtils wp = (NutsRepositoryUtils)up.get(NutsRepositoryUtils.class.getName());
        if (wp == null) {
            wp = new NutsRepositoryUtils(repo);
            up.put(NutsRepositoryUtils.class.getName(), wp);
        }
        return wp;
    }

    private NutsRepositoryUtils(NutsRepository repo) {
        this.repo = repo;
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = this.repo.getWorkspace().log().setSession(session).of(NutsRepositoryUtils.class);
        }
        return this.LOG;
    }

    public static int getSupportSpeedLevel(NutsRepository repository, NutsRepositorySupportedAction supportedAction, NutsId id, NutsFetchMode mode, boolean transitive, NutsSession session) {
        int r;
        if (repository instanceof NutsInstalledRepository) {
            return 0;
        }
        NutsRepositoryExt xrepo = NutsRepositoryExt.of(repository);
        double result = 0.0;
        if (xrepo.acceptAction(id, supportedAction, mode, session) && (r = repository.config().getSpeed()) > 0) {
            result += 1.0 / (double)r;
        }
        if (transitive) {
            for (NutsRepository remote : repository.config().setSession(session).getMirrors()) {
                int r2 = NutsRepositoryUtils.getSupportSpeedLevel(remote, supportedAction, id, mode, transitive, session);
                if (r2 <= 0) continue;
                result += 1.0 / (double)r2;
            }
        }
        int intResult = 0;
        if (result != 0.0 && (intResult = (int)(1.0 / result)) < 0) {
            intResult = Integer.MAX_VALUE;
        }
        return intResult;
    }

    public static int getSupportDeployLevel(NutsRepository repository, NutsRepositorySupportedAction supportedAction, NutsId id, NutsFetchMode mode, boolean transitive, NutsSession session) {
        int r;
        if (repository instanceof NutsInstalledRepository) {
            return 0;
        }
        NutsRepositoryExt xrepo = NutsRepositoryExt.of(repository);
        int result = 0;
        if (xrepo.acceptAction(id, supportedAction, mode, session) && (r = repository.config().getDeployOrder()) > 0) {
            result += r;
        }
        if (transitive) {
            for (NutsRepository remote : repository.config().setSession(session).getMirrors()) {
                int r2 = NutsRepositoryUtils.getSupportSpeedLevel(remote, supportedAction, id, mode, transitive, session);
                if (r2 <= 0) continue;
                result += r2;
            }
        }
        return result;
    }

    public Events events() {
        return new Events(this);
    }

    public static class Events {
        private NutsRepositoryUtils u;

        public Events(NutsRepositoryUtils u) {
            this.u = u;
        }

        public void fireOnUndeploy(NutsContentEvent evt) {
            for (NutsRepositoryListener listener : this.u.repo.getRepositoryListeners()) {
                listener.onUndeploy(evt);
            }
            for (NutsRepositoryListener listener : this.u.repo.getWorkspace().events().getRepositoryListeners()) {
                listener.onUndeploy(evt);
            }
        }

        public void fireOnDeploy(NutsContentEvent file) {
            for (NutsRepositoryListener listener : this.u.repo.getRepositoryListeners()) {
                listener.onDeploy(file);
            }
            for (NutsRepositoryListener listener : this.u.repo.getWorkspace().events().getRepositoryListeners()) {
                listener.onDeploy(file);
            }
        }

        public void fireOnPush(NutsContentEvent event) {
            for (NutsRepositoryListener listener : this.u.repo.getRepositoryListeners()) {
                listener.onPush(event);
            }
            for (NutsRepositoryListener listener : this.u.repo.getWorkspace().events().getRepositoryListeners()) {
                listener.onPush(event);
            }
            for (NutsRepositoryListener listener : (NutsRepositoryListener[])event.getSession().getListeners(NutsRepositoryListener.class)) {
                listener.onPush(event);
            }
        }

        public void fireOnAddRepository(NutsRepositoryEvent event) {
            if (this.u._LOG(event.getSession()).isLoggable(Level.FINEST)) {
                this.u._LOGOP(event.getSession()).level(Level.FINEST).verb(NutsLogVerb.UPDATE).formatted().log("{0} add    repo {1}", new Object[]{CoreStringUtils.alignLeft(this.u.repo.getName(), 20), event.getRepository().getName()});
            }
            for (NutsRepositoryListener listener : this.u.repo.getRepositoryListeners()) {
                listener.onAddRepository(event);
            }
            for (NutsRepositoryListener listener : this.u.repo.getWorkspace().events().getRepositoryListeners()) {
                listener.onAddRepository(event);
            }
            for (NutsRepositoryListener listener : (NutsRepositoryListener[])event.getSession().getListeners(NutsRepositoryListener.class)) {
                listener.onAddRepository(event);
            }
        }

        public void fireOnRemoveRepository(NutsRepositoryEvent event) {
            if (this.u._LOG(event.getSession()).isLoggable(Level.FINEST)) {
                this.u._LOGOP(event.getSession()).level(Level.FINEST).verb(NutsLogVerb.UPDATE).formatted().log("{0} remove repo {1}", new Object[]{CoreStringUtils.alignLeft(this.u.repo.getName(), 20), event.getRepository().getName()});
            }
            for (NutsRepositoryListener listener : this.u.repo.getRepositoryListeners()) {
                listener.onRemoveRepository(event);
            }
            for (NutsRepositoryListener listener : this.u.repo.getWorkspace().events().getRepositoryListeners()) {
                listener.onRemoveRepository(event);
            }
            for (NutsRepositoryListener listener : (NutsRepositoryListener[])event.getSession().getListeners(NutsRepositoryListener.class)) {
                listener.onRemoveRepository(event);
            }
        }
    }
}

