/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.parser;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorParser;
import net.thevpc.nuts.NutsDescriptorStyle;
import net.thevpc.nuts.NutsException;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsParseException;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUnsupportedEnumException;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.bridges.maven.MavenUtils;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public class DefaultNutsDescriptorParser
implements NutsDescriptorParser {
    private NutsWorkspace ws;
    private NutsSession session;
    private boolean lenient = true;
    private NutsDescriptorStyle descriptorStyle;
    private String format;

    public DefaultNutsDescriptorParser(NutsWorkspace ws) {
        this.ws = ws;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NutsDescriptor parse(URL url) {
        this.checkSession();
        try {
            try (InputStream is = NutsWorkspaceUtils.of(this.getSession()).openURL(url);){
                NutsDescriptor nutsDescriptor = this.parse(is, true);
                return nutsDescriptor;
            }
            catch (NutsException ex) {
                throw ex;
            }
            catch (RuntimeException ex) {
                throw new NutsParseException(this.getSession(), NutsMessage.cstyle((String)"unable to parse url %s", (Object[])new Object[]{url}), (Throwable)ex);
            }
        }
        catch (IOException ex) {
            throw new NutsParseException(this.getSession(), NutsMessage.cstyle((String)"unable to parse url %s", (Object[])new Object[]{url}), (Throwable)ex);
        }
    }

    public NutsDescriptor parse(byte[] bytes) {
        return this.parse(new ByteArrayInputStream(bytes), true);
    }

    public NutsDescriptor parse(Path path) {
        this.checkSession();
        if (!Files.exists(path, new LinkOption[0])) {
            throw new NutsNotFoundException(this.getSession(), null, NutsMessage.cstyle((String)"at file %s", (Object[])new Object[]{path}), null);
        }
        try {
            return this.parse(Files.newInputStream(path, new OpenOption[0]), true);
        }
        catch (NutsException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new NutsParseException(this.getSession(), NutsMessage.cstyle((String)"unable to parse file %s", (Object[])new Object[]{path}), (Throwable)ex);
        }
    }

    public NutsDescriptor parse(File file) {
        this.checkSession();
        return this.parse(file.toPath());
    }

    public NutsDescriptor parse(InputStream stream) {
        this.checkSession();
        return this.parse(stream, false);
    }

    public NutsDescriptor parse(String str) {
        this.checkSession();
        if (NutsUtilStrings.isBlank((CharSequence)str)) {
            return null;
        }
        return this.parse(new ByteArrayInputStream(str.getBytes()), true);
    }

    public NutsDescriptorParser setLenient(boolean lenient) {
        this.lenient = lenient;
        return this;
    }

    private void checkSession() {
        NutsWorkspaceUtils.checkSession(this.getWorkspace(), this.getSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NutsDescriptor parse(InputStream in, boolean closeStream) {
        this.checkSession();
        NutsDescriptorStyle style = this.getDescriptorStyle();
        if (style == null) {
            style = NutsDescriptorStyle.NUTS;
        }
        switch (style) {
            case MAVEN: {
                try {
                    NutsDescriptor nutsDescriptor = MavenUtils.of(this.session).parsePomXml0(in, NutsFetchMode.LOCAL, "descriptor", null);
                    return nutsDescriptor;
                }
                finally {
                    if (closeStream) {
                        try {
                            in.close();
                        }
                        catch (IOException ex) {
                            throw new UncheckedIOException(ex);
                        }
                    }
                }
            }
            case NUTS: {
                try {
                    InputStreamReader rr = new InputStreamReader(in);
                    NutsDescriptor nutsDescriptor = (NutsDescriptor)this.getWorkspace().elem().setSession(this.session).setContentType(NutsContentType.JSON).parse((Reader)rr, NutsDescriptor.class);
                    return nutsDescriptor;
                }
                finally {
                    if (closeStream) {
                        try {
                            in.close();
                        }
                        catch (IOException ex) {
                            throw new UncheckedIOException(ex);
                        }
                    }
                }
            }
        }
        throw new NutsUnsupportedEnumException(this.getSession(), (Enum)style);
    }

    public NutsWorkspace getWorkspace() {
        return this.ws;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsDescriptorParser setSession(NutsSession session) {
        this.session = session;
        return this;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public NutsDescriptorStyle getDescriptorStyle() {
        return this.descriptorStyle;
    }

    public DefaultNutsDescriptorParser setDescriptorStyle(NutsDescriptorStyle descriptorStyle) {
        this.descriptorStyle = descriptorStyle;
        return this;
    }
}

