/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.parser;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyParser;
import net.thevpc.nuts.NutsDependencyScope;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsParseException;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.bundles.parsers.StringMapParser;
import net.thevpc.nuts.runtime.standalone.util.NutsDependencyScopes;

public class DefaultNutsDependencyParser
implements NutsDependencyParser {
    private static final StringMapParser QPARSER = new StringMapParser("=", "&");
    private NutsSession session;
    private boolean lenient = false;
    public static final Pattern DEPENDENCY_NUTS_DESCRIPTOR_PATTERN = Pattern.compile("^(?<group>[a-zA-Z0-9_.${}-]+)(:(?<artifact>[a-zA-Z0-9_.${}-]+))?(#(?<version>[^?]+))?(\\?(?<face>.+))?$");

    public DefaultNutsDependencyParser(NutsSession session) {
        this.session = session;
    }

    public NutsDependencyParser setLenient(boolean lenient) {
        this.lenient = lenient;
        return this;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public NutsDependency parseDependency(String dependency) {
        if (dependency == null) {
            return null;
        }
        Matcher m = DEPENDENCY_NUTS_DESCRIPTOR_PATTERN.matcher(dependency);
        if (m.find()) {
            String group = m.group("group");
            String name = m.group("artifact");
            String version = m.group("version");
            String face = NutsUtilStrings.trim((String)m.group("face"));
            Map<String, String> queryMap = QPARSER.parseMap(face);
            if (name == null) {
                name = group;
                group = null;
            }
            return this.session.getWorkspace().dependency().builder().setGroupId(group).setArtifactId(name).setVersion(version).setProperties(queryMap).build();
        }
        if (!this.isLenient()) {
            throw new NutsParseException(this.session, NutsMessage.cstyle((String)"invalid dependency format : %s", (Object[])new Object[]{dependency}));
        }
        return null;
    }

    public NutsDependencyScope parseScope(String scope) {
        return NutsDependencyScopes.parseScope(scope, this.isLenient());
    }

    public boolean parseOptional(String optional) {
        if (NutsUtilStrings.isBlank((CharSequence)optional)) {
            return false;
        }
        return "true".equals(optional.trim());
    }
}

