/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.model;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.NutsFormat;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsVersionFilter;
import net.thevpc.nuts.NutsVersionInterval;
import net.thevpc.nuts.runtime.core.filters.DefaultNutsTokenFilter;
import net.thevpc.nuts.runtime.core.filters.version.DefaultNutsVersionFilter;
import net.thevpc.nuts.runtime.core.util.CoreNumberUtils;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;

public class DefaultNutsVersion
extends DefaultNutsTokenFilter
implements NutsVersion {
    private static final long serialVersionUID = 1L;
    private VersionParts parts;
    private transient NutsSession session;

    public static NutsVersion valueOf(String value, NutsSession session) {
        if ((value = NutsUtilStrings.trim((String)value)).isEmpty()) {
            return new DefaultNutsVersion("", session);
        }
        return new DefaultNutsVersion(value, session);
    }

    private DefaultNutsVersion(String expression, NutsSession session) {
        super(NutsUtilStrings.trim((String)expression));
        this.session = session;
    }

    public NutsFormat formatter() {
        return this.session.getWorkspace().version().formatter().setVersion((NutsVersion)this);
    }

    public String getValue() {
        return this.expression;
    }

    public int compareTo(String other) {
        return DefaultNutsVersion.compareVersions(this.expression, other);
    }

    public int compareTo(NutsVersion other) {
        return this.compareTo(other == null ? null : other.getValue());
    }

    public NutsVersionFilter filter() {
        return DefaultNutsVersionFilter.parse(this.expression, this.session);
    }

    public NutsVersionInterval[] intervals() {
        NutsVersionFilter s = this.filter();
        if (s instanceof DefaultNutsVersionFilter) {
            return ((DefaultNutsVersionFilter)s).getIntervals();
        }
        return new NutsVersionInterval[0];
    }

    public boolean isSingleValue() {
        NutsVersionInterval[] nutsVersionIntervals = this.intervals();
        return nutsVersionIntervals.length != 0 && nutsVersionIntervals.length <= 1 && nutsVersionIntervals[0].isFixedValue();
    }

    public NutsVersion inc() {
        return this.inc(-1);
    }

    public NutsVersion inc(int position) {
        return this.inc(position, 1L);
    }

    public int size() {
        VersionParts parts = this.getParts();
        return parts.size();
    }

    public int numberSize() {
        return this.getParts().getDigitCount();
    }

    private VersionParts getParts() {
        if (this.parts == null) {
            this.parts = DefaultNutsVersion.splitVersionParts2(this.getValue());
        }
        return this.parts;
    }

    public String get(int level) {
        VersionParts parts = this.getParts();
        int size = parts.size();
        if (level >= 0) {
            return parts.get((int)level).string;
        }
        int x = size + level;
        return parts.get((int)x).string;
    }

    public BigInteger getNumber(int level) {
        VersionParts parts = this.getParts();
        int size = parts.getDigitCount();
        if (level >= 0) {
            return new BigInteger(parts.getDigit((int)level).string);
        }
        int x = size + level;
        return new BigInteger(parts.getDigit((int)x).string);
    }

    public BigInteger getNumber(int index, long defaultValue) {
        return this.getNumber(index, BigInteger.valueOf(defaultValue));
    }

    public BigInteger getNumber(int level, BigInteger defaultValue) {
        VersionParts parts = this.getParts();
        int size = parts.getDigitCount();
        if (level >= 0) {
            if (level < size) {
                return new BigInteger(parts.getDigit((int)level).string);
            }
        } else {
            int x = size + level;
            if (x < size) {
                return new BigInteger(parts.getDigit((int)x).string);
            }
        }
        return defaultValue;
    }

    public NutsVersion inc(int position, long amount) {
        return new DefaultNutsVersion(DefaultNutsVersion.incVersion(this.getValue(), position, amount), this.session);
    }

    public NutsVersion inc(int position, BigInteger amount) {
        return new DefaultNutsVersion(DefaultNutsVersion.incVersion(this.getValue(), position, amount), this.session);
    }

    public String toString() {
        return this.expression == null ? "" : String.valueOf(this.expression);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNutsVersion version = (DefaultNutsVersion)o;
        return this.expression != null ? this.expression.equals(version.expression) : version.expression == null;
    }

    public int hashCode() {
        return this.expression != null ? this.expression.hashCode() : 0;
    }

    @Override
    public boolean matches(String expression) {
        if (NutsUtilStrings.isBlank((CharSequence)expression)) {
            return true;
        }
        return DefaultNutsVersionFilter.parse(expression, this.session).acceptVersion((NutsVersion)this, this.session);
    }

    public static boolean versionMatches(String version, String pattern) {
        if (DefaultNutsVersion.isBlankVersion(pattern)) {
            return true;
        }
        return pattern.equals(version);
    }

    public static String incVersion(String oldVersion, int level, long count) {
        return DefaultNutsVersion.incVersion(oldVersion, level, BigInteger.valueOf(count));
    }

    public static String incVersion(String oldVersion, int level, BigInteger count) {
        VersionParts parts;
        int digitCount;
        if (count == null) {
            count = BigInteger.ZERO;
        }
        if ((digitCount = (parts = DefaultNutsVersion.splitVersionParts2(oldVersion)).getDigitCount()) == 0) {
            parts.addDigit(BigInteger.ZERO, ".");
        }
        digitCount = parts.getDigitCount();
        if (level < 0) {
            for (level = digitCount - 1; level < 0; ++level) {
                parts.addDigit(BigInteger.ZERO, ".");
            }
            VersionPart digit = parts.getDigit(level);
            digit.string = String.valueOf(new BigInteger(digit.string).add(count));
            return parts.toString();
        }
        for (int i = digitCount; i < level; ++i) {
            parts.addDigit(BigInteger.ZERO, ".");
        }
        VersionPart digit = parts.getDigit(level);
        digit.string = String.valueOf(new BigInteger(digit.string).add(count));
        return parts.toString();
    }

    public static int compareVersions(String v1, String v2) {
        if ((v1 = NutsUtilStrings.trim((String)v1)).equals(v2 = NutsUtilStrings.trim((String)v2))) {
            return 0;
        }
        if ("LATEST".equals(v1)) {
            return 1;
        }
        if ("LATEST".equals(v2)) {
            return -1;
        }
        if ("RELEASE".equals(v1)) {
            return 1;
        }
        if ("RELEASE".equals(v2)) {
            return -1;
        }
        String[] v1arr = DefaultNutsVersion.splitVersionParts(v1);
        String[] v2arr = DefaultNutsVersion.splitVersionParts(v2);
        for (int i = 0; i < Math.max(v1arr.length, v2arr.length); ++i) {
            if (i >= v1arr.length) {
                if (v2arr[i].equalsIgnoreCase("SNAPSHOT")) {
                    return 1;
                }
                return -1;
            }
            if (i >= v2arr.length) {
                if (v1arr[i].equalsIgnoreCase("SNAPSHOT")) {
                    return -1;
                }
                return 1;
            }
            int x = DefaultNutsVersion.compareVersionItem(v1arr[i], v2arr[i]);
            if (x == 0) continue;
            return x;
        }
        return 0;
    }

    private static VersionParts splitVersionParts2(String v1) {
        v1 = NutsUtilStrings.trim((String)v1);
        ArrayList<VersionPart> parts = new ArrayList<VersionPart>();
        StringBuilder last = new StringBuilder();
        boolean digit = false;
        for (char c : v1.toCharArray()) {
            if (Character.isDigit(c)) {
                if (last.length() == 0 || digit) {
                    digit = true;
                    last.append(c);
                    continue;
                }
                parts.add(new VersionPart(last.toString(), false));
                CoreStringUtils.clear(last);
                digit = true;
                last.append(c);
                continue;
            }
            if (last.length() == 0) {
                digit = false;
                last.append(c);
                continue;
            }
            if (!digit) {
                last.append(c);
                continue;
            }
            parts.add(new VersionPart(last.toString(), true));
            CoreStringUtils.clear(last);
            digit = false;
            last.append(c);
        }
        if (last.length() > 0) {
            parts.add(new VersionPart(last.toString(), digit));
        }
        return new VersionParts(parts);
    }

    private static String[] splitVersionParts(String v1) {
        v1 = NutsUtilStrings.trim((String)v1);
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder last = new StringBuilder();
        for (char c : v1.toCharArray()) {
            if (last.length() == 0) {
                last.append(c);
                continue;
            }
            if (Character.isDigit(last.charAt(0)) == Character.isDigit(c)) {
                last.append(c);
                continue;
            }
            parts.add(last.toString());
            CoreStringUtils.clear(last);
        }
        if (last.length() > 0) {
            parts.add(last.toString());
        }
        return parts.toArray(new String[0]);
    }

    private static int compareVersionItem(String v1, String v2) {
        BigInteger i1 = null;
        BigInteger i2 = null;
        if (v1.equals(v2)) {
            return 0;
        }
        i1 = CoreNumberUtils.convertToBigInteger(v1, null);
        if (i1 != null && (i2 = CoreNumberUtils.convertToBigInteger(v2, null)) != null) {
            return i1.compareTo(i2);
        }
        if ("SNAPSHOT".equalsIgnoreCase(v1)) {
            return -1;
        }
        if ("SNAPSHOT".equalsIgnoreCase(v2)) {
            return 1;
        }
        BigInteger a = CoreNumberUtils.getStartingBigInteger(v1);
        BigInteger b = CoreNumberUtils.getStartingBigInteger(v2);
        if (a != null && b != null && !a.equals(b)) {
            return a.compareTo(b);
        }
        return v1.compareTo(v2);
    }

    public static boolean isBlankVersion(String pattern) {
        if (NutsUtilStrings.isBlank((CharSequence)pattern)) {
            return true;
        }
        return "LATEST".equals(pattern) || "RELEASE".equals(pattern);
    }

    public static boolean isStaticVersionPattern(String pattern) {
        if (DefaultNutsVersion.isBlankVersion(pattern)) {
            return false;
        }
        return !pattern.contains("[") && !pattern.contains("]") && !pattern.contains(",") && !pattern.contains("*");
    }

    private static class VersionParts {
        List<VersionPart> all;

        public VersionParts(List<VersionPart> all) {
            this.all = all;
        }

        public VersionPart get(int index) {
            return this.all.get(index);
        }

        public int size() {
            return this.all.size();
        }

        public int getDigitCount() {
            int c = 0;
            for (VersionPart s : this.all) {
                if (!s.digit) continue;
                ++c;
            }
            return c;
        }

        public VersionPart getDigit(int index) {
            int c = 0;
            for (VersionPart s : this.all) {
                if (!s.digit) continue;
                if (c == index) {
                    return s;
                }
                ++c;
            }
            return null;
        }

        public void insertDigit(long val, String sep) {
            if (this.all.size() == 0) {
                this.all.add(new VersionPart(String.valueOf(val), true));
            } else if (this.all.get((int)0).digit) {
                this.all.add(0, new VersionPart(sep, false));
                this.all.add(0, new VersionPart(String.valueOf(val), true));
            } else {
                this.all.add(0, new VersionPart(String.valueOf(val), true));
            }
        }

        public void addDigit(BigInteger val, String sep) {
            if (this.all.size() == 0) {
                this.all.add(new VersionPart(String.valueOf(val), true));
            } else if (this.all.get((int)(this.all.size() - 1)).digit) {
                this.all.add(new VersionPart(sep, false));
                this.all.add(new VersionPart(String.valueOf(val), true));
            } else {
                this.all.add(new VersionPart(String.valueOf(val), true));
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (VersionPart versionPart : this.all) {
                sb.append(versionPart.string);
            }
            return sb.toString();
        }
    }

    private static class VersionPart {
        String string;
        boolean digit;

        public VersionPart(String string, boolean digit) {
            this.string = string;
            this.digit = digit;
        }

        public String toString() {
            String name = this.digit ? "digit" : "sep";
            return name + "(" + this.string + ")";
        }
    }
}

