/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsArtifactCall;
import net.thevpc.nuts.NutsClassifierMapping;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorBuilder;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdLocation;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.bundles.common.MapToFunction;
import net.thevpc.nuts.runtime.core.model.DefaultNutsDescriptor;
import net.thevpc.nuts.runtime.core.util.CoreArrayUtils;
import net.thevpc.nuts.runtime.core.util.CoreNutsUtils;

public class DefaultNutsDescriptorBuilder
implements NutsDescriptorBuilder {
    private static final long serialVersionUID = 1L;
    private NutsId id;
    private NutsId[] parents = new NutsId[0];
    private String packaging;
    private boolean executable;
    private boolean application;
    private NutsArtifactCall executor;
    private NutsArtifactCall installer;
    private String name;
    private List<String> icons = new ArrayList<String>();
    private List<String> categories;
    private String genericName;
    private String description;
    private List<String> arch = new ArrayList<String>();
    private List<String> os = new ArrayList<String>();
    private List<String> osdist = new ArrayList<String>();
    private List<String> platform = new ArrayList<String>();
    private List<String> desktopEnvironment = new ArrayList<String>();
    private List<NutsIdLocation> locations = new ArrayList<NutsIdLocation>();
    private List<NutsClassifierMapping> classifierMappings = new ArrayList<NutsClassifierMapping>();
    private List<NutsDependency> dependencies = new ArrayList<NutsDependency>();
    private List<NutsDependency> standardDependencies = new ArrayList<NutsDependency>();
    private Map<String, String> properties = new HashMap<String, String>();
    private transient NutsSession session;

    public DefaultNutsDescriptorBuilder() {
    }

    public DefaultNutsDescriptorBuilder(NutsSession session) {
        this.session = session;
    }

    public DefaultNutsDescriptorBuilder(NutsDescriptor other, NutsSession session) {
        this.session = session;
        this.set(other);
    }

    public NutsDescriptorBuilder clear() {
        this.setId((NutsId)null);
        this.setPackaging(null);
        this.setParents(null);
        this.setExecutable(false);
        this.setApplication(false);
        this.setDescription(null);
        this.setName(null);
        this.setExecutor(null);
        this.setInstaller(null);
        this.setClassifierMappings(null);
        this.setArch(null);
        this.setOs(null);
        this.setOsdist(null);
        this.setPlatform(null);
        this.setDesktopEnvironment(null);
        this.setLocations(null);
        this.setDependencies(null);
        this.setStandardDependencies(null);
        this.setProperties(null);
        this.setIcons(new ArrayList<String>());
        this.setCategories(null);
        this.setGenericName(null);
        return this;
    }

    public NutsDescriptorBuilder set(NutsDescriptorBuilder other) {
        if (other != null) {
            this.setId(other.getId());
            this.setPackaging(other.getPackaging());
            this.setParents(other.getParents());
            this.setExecutable(other.isExecutable());
            this.setApplication(other.isApplication());
            this.setDescription(other.getDescription());
            this.setName(other.getName());
            this.setExecutor(other.getExecutor());
            this.setInstaller(other.getInstaller());
            this.setArch(other.getArch());
            this.setOs(other.getOs());
            this.setOsdist(other.getOsdist());
            this.setPlatform(other.getPlatform());
            this.setDesktopEnvironment(other.getDesktopEnvironment());
            this.setLocations(other.getLocations());
            this.setDependencies(other.getDependencies());
            this.setStandardDependencies(other.getStandardDependencies());
            this.setProperties(other.getProperties());
            this.setIcons(new ArrayList<String>(other.getIcons()));
            this.setCategories(other.getCategories());
            this.setGenericName(other.getGenericName());
        } else {
            this.clear();
        }
        return this;
    }

    public NutsDescriptorBuilder set(NutsDescriptor other) {
        if (other != null) {
            this.setId(other.getId());
            this.setPackaging(other.getPackaging());
            this.setParents(other.getParents());
            this.setExecutable(other.isExecutable());
            this.setApplication(other.isApplication());
            this.setDescription(other.getDescription());
            this.setName(other.getName());
            this.setExecutor(other.getExecutor());
            this.setInstaller(other.getInstaller());
            this.setClassifierMappings(other.getClassifierMappings());
            this.setArch(other.getArch());
            this.setOs(other.getOs());
            this.setOsdist(other.getOsdist());
            this.setPlatform(other.getPlatform());
            this.setDesktopEnvironment(other.getDesktopEnvironment());
            this.setLocations(other.getLocations());
            this.setDependencies(other.getDependencies());
            this.setStandardDependencies(other.getStandardDependencies());
            this.setProperties(other.getProperties());
            this.setIcons(new ArrayList<String>(Arrays.asList(other.getIcons())));
            this.setGenericName(other.getGenericName());
            this.setCategories(new ArrayList<String>(Arrays.asList(other.getCategories())));
        } else {
            this.clear();
        }
        return this;
    }

    public NutsDescriptorBuilder setId(String id) {
        this.id = this.session.getWorkspace().id().parser().setLenient(false).parse(id);
        return this;
    }

    public NutsDescriptorBuilder setId(NutsId id) {
        this.id = id;
        return this;
    }

    public NutsDescriptorBuilder setName(String name) {
        this.name = NutsUtilStrings.trim((String)name);
        return this;
    }

    public NutsDescriptorBuilder setExecutor(NutsArtifactCall executor) {
        this.executor = executor;
        return this;
    }

    public NutsDescriptorBuilder setInstaller(NutsArtifactCall installer) {
        this.installer = installer;
        return this;
    }

    public NutsDescriptorBuilder setDescription(String description) {
        this.description = NutsUtilStrings.trim((String)description);
        return this;
    }

    public NutsDescriptorBuilder setExecutable(boolean executable) {
        this.executable = executable;
        return this;
    }

    public NutsDescriptorBuilder setApplication(boolean nutsApp) {
        this.application = nutsApp;
        return this;
    }

    public NutsDescriptorBuilder addPlatform(String platform) {
        if (platform != null) {
            if (this.platform == null) {
                this.platform = new ArrayList<String>();
            }
            this.platform.add(platform);
        }
        return this;
    }

    public NutsDescriptorBuilder setPlatform(String[] platform) {
        this.platform = new ArrayList<String>(Arrays.asList(CoreArrayUtils.toArraySet(platform, new String[0][])));
        return this;
    }

    public NutsDescriptorBuilder addDesktopEnvironment(String desktopEnvironment) {
        if (desktopEnvironment != null) {
            if (this.desktopEnvironment == null) {
                this.desktopEnvironment = new ArrayList<String>();
            }
            this.desktopEnvironment.add(desktopEnvironment);
        }
        return this;
    }

    public NutsDescriptorBuilder setDesktopEnvironment(String[] desktopEnvironment) {
        this.desktopEnvironment = new ArrayList<String>(Arrays.asList(CoreArrayUtils.toArraySet(desktopEnvironment, new String[0][])));
        return this;
    }

    public NutsDescriptorBuilder setOs(String[] os) {
        this.os = new ArrayList<String>(Arrays.asList(CoreArrayUtils.toArraySet(os, new String[0][])));
        return this;
    }

    public NutsDescriptorBuilder setOsdist(String[] osdist) {
        this.osdist = new ArrayList<String>(Arrays.asList(CoreArrayUtils.toArraySet(osdist, new String[0][])));
        return this;
    }

    public NutsDescriptorBuilder setArch(String[] arch) {
        this.arch = new ArrayList<String>(Arrays.asList(CoreArrayUtils.toArraySet(arch, new String[0][])));
        return this;
    }

    public NutsDescriptorBuilder setProperties(Map<String, String> properties) {
        this.properties = properties == null || properties.isEmpty() ? null : new HashMap<String, String>(properties);
        return this;
    }

    public NutsDescriptorBuilder addProperties(Map<String, String> properties) {
        if (properties != null && !properties.isEmpty()) {
            HashMap<String, String> p = new HashMap<String, String>();
            if (this.properties != null) {
                p.putAll(this.properties);
            }
            p.putAll(properties);
            this.properties = p;
        }
        return this;
    }

    public NutsDescriptorBuilder addLocation(NutsIdLocation location) {
        if (this.locations == null) {
            this.locations = new ArrayList<NutsIdLocation>();
        }
        this.locations.add(location);
        return this;
    }

    public NutsDescriptorBuilder setLocations(NutsIdLocation[] locations) {
        this.locations = locations == null ? new ArrayList<NutsIdLocation>() : new ArrayList<NutsIdLocation>(Arrays.asList(locations));
        return this;
    }

    public NutsDescriptorBuilder addClassifierMapping(NutsClassifierMapping mapping) {
        if (this.classifierMappings == null) {
            this.classifierMappings = new ArrayList<NutsClassifierMapping>();
        }
        this.classifierMappings.add(mapping);
        return this;
    }

    public NutsDescriptorBuilder setClassifierMappings(NutsClassifierMapping[] value) {
        this.classifierMappings = value == null ? new ArrayList<NutsClassifierMapping>() : new ArrayList<NutsClassifierMapping>(Arrays.asList(value));
        return this;
    }

    public NutsDescriptorBuilder setPackaging(String packaging) {
        this.packaging = NutsUtilStrings.trim((String)packaging);
        return this;
    }

    public NutsDescriptorBuilder setParents(NutsId[] parents) {
        NutsId[] nutsIdArray = this.parents = parents == null ? new NutsId[]{} : new NutsId[parents.length];
        if (parents != null) {
            System.arraycopy(parents, 0, this.parents, 0, this.parents.length);
        }
        return this;
    }

    public NutsArtifactCall getInstaller() {
        return this.installer;
    }

    public Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        return this.properties;
    }

    public NutsId[] getParents() {
        return this.parents;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isExecutable() {
        return this.executable;
    }

    public boolean isApplication() {
        return this.application;
    }

    public NutsArtifactCall getExecutor() {
        return this.executor;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public NutsId getId() {
        return this.id;
    }

    public NutsDependency[] getDependencies() {
        return this.dependencies == null ? new NutsDependency[]{} : this.dependencies.toArray(new NutsDependency[0]);
    }

    public NutsDependency[] getStandardDependencies() {
        return this.standardDependencies == null ? new NutsDependency[]{} : this.standardDependencies.toArray(new NutsDependency[0]);
    }

    public String[] getArch() {
        return this.arch == null ? new String[]{} : this.arch.toArray(new String[0]);
    }

    public String[] getOs() {
        return this.os == null ? new String[]{} : this.os.toArray(new String[0]);
    }

    public String[] getOsdist() {
        return this.osdist == null ? new String[]{} : this.osdist.toArray(new String[0]);
    }

    public String[] getPlatform() {
        return this.platform == null ? new String[]{} : this.platform.toArray(new String[0]);
    }

    public String[] getDesktopEnvironment() {
        return this.desktopEnvironment == null ? new String[]{} : this.desktopEnvironment.toArray(new String[0]);
    }

    public NutsDescriptorBuilder setDependencies(NutsDependency[] dependencies) {
        this.dependencies = new ArrayList<NutsDependency>();
        if (dependencies != null) {
            for (NutsDependency dependency : dependencies) {
                if (dependency == null) {
                    throw new NullPointerException();
                }
                this.dependencies.add(dependency);
            }
        }
        return this;
    }

    public NutsDescriptorBuilder setStandardDependencies(NutsDependency[] dependencies) {
        this.standardDependencies = new ArrayList<NutsDependency>();
        if (dependencies != null) {
            for (NutsDependency dependency : dependencies) {
                if (dependency == null) {
                    throw new NullPointerException();
                }
                this.standardDependencies.add(dependency);
            }
        }
        return this;
    }

    public NutsDescriptor build() {
        return new DefaultNutsDescriptor(this.getId(), this.getParents(), this.getPackaging(), this.isExecutable(), this.isApplication(), this.getExecutor(), this.getInstaller(), this.getName(), this.getDescription(), this.getArch(), this.getOs(), this.getOsdist(), this.getPlatform(), this.getDesktopEnvironment(), this.getDependencies(), this.getStandardDependencies(), this.getLocations(), this.getProperties(), this.getClassifierMappings(), this.genericName, this.categories == null ? new String[]{} : this.categories.toArray(new String[0]), this.icons == null ? new String[]{} : this.icons.toArray(new String[0]), this.session);
    }

    public NutsIdLocation[] getLocations() {
        return this.locations == null ? new NutsIdLocation[]{} : this.locations.toArray(new NutsIdLocation[0]);
    }

    public NutsClassifierMapping[] getClassifierMappings() {
        return this.classifierMappings == null ? new NutsClassifierMapping[]{} : this.classifierMappings.toArray(new NutsClassifierMapping[0]);
    }

    public NutsDescriptorBuilder setProperty(String name, String value) {
        if (value == null) {
            if (this.properties != null) {
                this.properties.remove(name);
            }
        } else {
            if (this.properties == null) {
                this.properties = new HashMap<String, String>();
            }
            this.properties.put(name, value);
        }
        return this;
    }

    public NutsDescriptorBuilder addOs(String os) {
        if (this.os == null) {
            this.os = new ArrayList<String>();
        }
        this.os.add(os);
        return this;
    }

    public NutsDescriptorBuilder addOsdist(String osdist) {
        if (this.osdist == null) {
            this.osdist = new ArrayList<String>();
        }
        this.osdist.add(osdist);
        return this;
    }

    public NutsDescriptorBuilder addArch(String arch) {
        if (this.arch == null) {
            this.arch = new ArrayList<String>();
        }
        this.arch.add(arch);
        return this;
    }

    public NutsDescriptorBuilder removeOs(String os) {
        if (this.os != null) {
            this.os.remove(os);
        }
        return this;
    }

    public NutsDescriptorBuilder removeOsdist(String osdist) {
        if (this.osdist != null) {
            this.osdist.remove(osdist);
        }
        return this;
    }

    public NutsDescriptorBuilder removeArch(String arch) {
        if (this.arch != null) {
            this.arch.remove(arch);
        }
        return this;
    }

    public NutsDescriptorBuilder removePlatform(String platform) {
        if (this.platform != null) {
            this.platform.remove(platform);
        }
        return this;
    }

    public NutsDescriptorBuilder removeDesktopEnvironment(String desktopEnvironment) {
        if (this.desktopEnvironment != null) {
            this.desktopEnvironment.remove(desktopEnvironment);
        }
        return this;
    }

    public NutsDescriptorBuilder removeDependency(NutsDependency dependency) {
        if (this.dependencies != null) {
            this.dependencies.remove(dependency);
        }
        return this;
    }

    public NutsDescriptorBuilder removeStandardDependency(NutsDependency dependency) {
        if (this.standardDependencies != null) {
            this.standardDependencies.remove(dependency);
        }
        return this;
    }

    public NutsDescriptorBuilder addDependency(NutsDependency dependency) {
        if (dependency == null) {
            throw new NullPointerException();
        }
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<NutsDependency>();
        }
        this.dependencies.add(dependency);
        return this;
    }

    public NutsDescriptorBuilder addStandardDependency(NutsDependency dependency) {
        if (this.standardDependencies == null) {
            this.standardDependencies = new ArrayList<NutsDependency>();
        }
        this.standardDependencies.add(dependency);
        return this;
    }

    public NutsDescriptorBuilder addDependencies(NutsDependency[] dependencies) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<NutsDependency>();
        }
        this.dependencies.addAll(Arrays.asList(dependencies));
        return this;
    }

    public NutsDescriptorBuilder addStandardDependencies(NutsDependency[] dependencies) {
        if (this.standardDependencies == null) {
            this.standardDependencies = new ArrayList<NutsDependency>();
        }
        this.standardDependencies.addAll(Arrays.asList(dependencies));
        return this;
    }

    public NutsDescriptorBuilder applyProperties() {
        return this.applyProperties(this.getProperties());
    }

    public NutsDescriptorBuilder replaceProperty(Predicate<Map.Entry<String, String>> filter, Function<Map.Entry<String, String>, String> converter) {
        if (converter == null) {
            return this;
        }
        LinkedHashMap<String, String> p = new LinkedHashMap<String, String>();
        boolean someUpdate = false;
        Iterator<Map.Entry<String, String>> it = this.getProperties().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            if (filter != null && !filter.test(entry)) continue;
            String v = converter.apply(entry);
            if (v != null) {
                p.put(entry.getKey(), entry.getValue());
                if (Objects.equals(v, entry.getValue())) continue;
                someUpdate = true;
                continue;
            }
            it.remove();
        }
        if (someUpdate) {
            for (Map.Entry entry : p.entrySet()) {
                this.getProperties().replace((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return this;
    }

    public NutsDescriptorBuilder applyParents(NutsDescriptor[] parentDescriptors) {
        NutsId n_id = this.getId();
        String n_packaging = this.getPackaging();
        boolean n_executable = this.isExecutable();
        String n_name = this.getName();
        List<String> n_categories = this.getCategories();
        n_categories = n_categories == null ? new ArrayList<String>() : new ArrayList<String>(n_categories);
        List<String> n_icons = this.getIcons();
        n_icons = n_icons == null ? new ArrayList<String>() : new ArrayList<String>(n_icons);
        String n_genericName = this.getGenericName();
        String n_desc = this.getDescription();
        NutsArtifactCall n_executor = this.getExecutor();
        NutsArtifactCall n_installer = this.getInstaller();
        HashMap<String, String> n_props = new HashMap<String, String>();
        for (NutsDescriptor parentDescriptor : parentDescriptors) {
            n_props.putAll(parentDescriptor.getProperties());
        }
        Map<String, String> properties = this.getProperties();
        if (properties != null) {
            n_props.putAll(properties);
        }
        LinkedHashSet<NutsDependency> n_deps = new LinkedHashSet<NutsDependency>();
        LinkedHashSet<NutsDependency> n_sdeps = new LinkedHashSet<NutsDependency>();
        LinkedHashSet<String> n_archs = new LinkedHashSet<String>();
        LinkedHashSet<String> n_os = new LinkedHashSet<String>();
        LinkedHashSet<String> n_osdist = new LinkedHashSet<String>();
        LinkedHashSet<String> n_platform = new LinkedHashSet<String>();
        LinkedHashSet<String> n_desktopEnvironment = new LinkedHashSet<String>();
        for (NutsDescriptor parentDescriptor : parentDescriptors) {
            n_id = CoreNutsUtils.applyNutsIdInheritance(n_id, parentDescriptor.getId(), this.session.getWorkspace());
            if (!n_executable && parentDescriptor.isExecutable()) {
                n_executable = true;
            }
            if (n_executor == null) {
                n_executor = parentDescriptor.getExecutor();
            }
            if (n_executor == null) {
                n_installer = parentDescriptor.getInstaller();
            }
            n_name = CoreNutsUtils.applyStringInheritance(n_name, parentDescriptor.getName());
            n_genericName = CoreNutsUtils.applyStringInheritance(n_genericName, parentDescriptor.getGenericName());
            n_desc = CoreNutsUtils.applyStringInheritance(n_desc, parentDescriptor.getDescription());
            n_deps.addAll(Arrays.asList(parentDescriptor.getDependencies()));
            n_sdeps.addAll(Arrays.asList(parentDescriptor.getStandardDependencies()));
            n_archs.addAll(Arrays.asList(parentDescriptor.getArch()));
            n_icons.addAll(Arrays.asList(parentDescriptor.getIcons()));
            n_categories.addAll(Arrays.asList(parentDescriptor.getCategories()));
            n_os.addAll(Arrays.asList(parentDescriptor.getOs()));
            n_osdist.addAll(Arrays.asList(parentDescriptor.getOsdist()));
            n_platform.addAll(Arrays.asList(parentDescriptor.getPlatform()));
            n_desktopEnvironment.addAll(Arrays.asList(parentDescriptor.getDesktopEnvironment()));
        }
        n_deps.addAll(Arrays.asList(this.getDependencies()));
        n_sdeps.addAll(Arrays.asList(this.getStandardDependencies()));
        n_archs.addAll(Arrays.asList(this.getArch()));
        n_os.addAll(Arrays.asList(this.getOs()));
        n_osdist.addAll(Arrays.asList(this.getOsdist()));
        n_platform.addAll(Arrays.asList(this.getPlatform()));
        n_desktopEnvironment.addAll(Arrays.asList(this.getDesktopEnvironment()));
        NutsId[] n_parents = new NutsId[]{};
        this.setId(n_id);
        this.setParents(n_parents);
        this.setPackaging(n_packaging);
        this.setExecutable(n_executable);
        this.setExecutor(n_executor);
        this.setInstaller(n_installer);
        this.setName(n_name);
        this.setGenericName(n_genericName);
        this.setCategories(n_categories);
        this.setIcons(n_icons);
        this.setDescription(n_desc);
        this.setArch(n_archs.toArray(new String[0]));
        this.setOs(n_os.toArray(new String[0]));
        this.setOsdist(n_osdist.toArray(new String[0]));
        this.setPlatform(n_platform.toArray(new String[0]));
        this.setDesktopEnvironment(n_desktopEnvironment.toArray(new String[0]));
        this.setDependencies(n_deps.toArray(new NutsDependency[0]));
        this.setStandardDependencies(n_sdeps.toArray(new NutsDependency[0]));
        this.setProperties(n_props);
        return this;
    }

    public NutsDescriptorBuilder applyProperties(Map<String, String> properties) {
        MapToFunction<String, String> map = new MapToFunction<String, String>(properties);
        NutsId n_id = this.getId().builder().apply(map).build();
        String n_packaging = CoreNutsUtils.applyStringProperties(this.getPackaging(), map);
        String n_name = CoreNutsUtils.applyStringProperties(this.getName(), map);
        String n_desc = CoreNutsUtils.applyStringProperties(this.getDescription(), map);
        NutsArtifactCall n_executor = this.getExecutor();
        NutsArtifactCall n_installer = this.getInstaller();
        HashMap<String, String> n_props = new HashMap<String, String>();
        Map<String, String> properties1 = this.getProperties();
        if (properties1 != null) {
            for (Map.Entry<String, String> entry : properties1.entrySet()) {
                n_props.put(CoreNutsUtils.applyStringProperties(entry.getKey(), map), CoreNutsUtils.applyStringProperties(entry.getValue(), map));
            }
        }
        LinkedHashSet<NutsDependency> n_deps = new LinkedHashSet<NutsDependency>();
        for (NutsDependency d2 : this.getDependencies()) {
            n_deps.add(this.applyNutsDependencyProperties(d2, map));
        }
        LinkedHashSet<NutsDependency> linkedHashSet = new LinkedHashSet<NutsDependency>();
        for (NutsDependency d2 : this.getStandardDependencies()) {
            linkedHashSet.add(this.applyNutsDependencyProperties(d2, map));
        }
        this.setId(n_id);
        this.setParents(this.getParents());
        this.setPackaging(n_packaging);
        this.setExecutable(this.isExecutable());
        this.setExecutor(n_executor);
        this.setInstaller(n_installer);
        this.setName(n_name);
        this.setDescription(n_desc);
        this.setGenericName(CoreNutsUtils.applyStringProperties(this.getGenericName(), map));
        this.setIcons(this.getIcons().stream().map(x -> CoreNutsUtils.applyStringProperties(x, (Function<String, String>)map)).collect(Collectors.toList()));
        this.setCategories(this.getCategories().stream().map(x -> CoreNutsUtils.applyStringProperties(x, (Function<String, String>)map)).collect(Collectors.toList()));
        this.setArch(CoreNutsUtils.applyStringProperties(this.getArch(), map));
        this.setOs(CoreNutsUtils.applyStringProperties(this.getOs(), map));
        this.setOsdist(CoreNutsUtils.applyStringProperties(this.getOsdist(), map));
        this.setPlatform(CoreNutsUtils.applyStringProperties(this.getPlatform(), map));
        this.setDesktopEnvironment(CoreNutsUtils.applyStringProperties(this.getDesktopEnvironment(), map));
        this.setDependencies(n_deps.toArray(new NutsDependency[0]));
        this.setStandardDependencies(linkedHashSet.toArray(new NutsDependency[0]));
        this.setProperties(n_props);
        return this;
    }

    private NutsId applyNutsIdProperties(NutsId child, Function<String, String> properties) {
        return this.session.getWorkspace().id().builder().setRepository(CoreNutsUtils.applyStringProperties(child.getRepository(), properties)).setGroupId(CoreNutsUtils.applyStringProperties(child.getGroupId(), properties)).setArtifactId(CoreNutsUtils.applyStringProperties(child.getArtifactId(), properties)).setVersion(CoreNutsUtils.applyStringProperties(child.getVersion().getValue(), properties)).setOs(CoreNutsUtils.applyStringProperties(child.getOs(), properties)).setOsdist(CoreNutsUtils.applyStringProperties(child.getOsdist(), properties)).setArch(CoreNutsUtils.applyStringProperties(child.getArch(), properties)).setClassifier(CoreNutsUtils.applyStringProperties(child.getClassifier(), properties)).setPackaging(CoreNutsUtils.applyStringProperties(child.getPackaging(), properties)).setProperties(CoreNutsUtils.applyMapProperties(child.getProperties(), properties)).build();
    }

    private NutsDependency applyNutsDependencyProperties(NutsDependency child, Function<String, String> properties) {
        NutsId[] exclusions = child.getExclusions();
        for (int i = 0; i < exclusions.length; ++i) {
            exclusions[i] = this.applyNutsIdProperties(exclusions[i], properties);
        }
        return this.session.getWorkspace().dependency().builder().setRepository(CoreNutsUtils.applyStringProperties(child.getRepository(), properties)).setGroupId(CoreNutsUtils.applyStringProperties(child.getGroupId(), properties)).setArtifactId(CoreNutsUtils.applyStringProperties(child.getArtifactId(), properties)).setVersion(CoreNutsUtils.applyStringProperties(child.getVersion(), properties, this.session.getWorkspace())).setClassifier(CoreNutsUtils.applyStringProperties(child.getClassifier(), properties)).setScope(CoreNutsUtils.applyStringProperties(child.getScope(), properties)).setOptional(CoreNutsUtils.applyStringProperties(child.getOptional(), properties)).setOs(CoreNutsUtils.applyStringProperties(child.getOs(), properties)).setArch(CoreNutsUtils.applyStringProperties(child.getArch(), properties)).setType(CoreNutsUtils.applyStringProperties(child.getType(), properties)).setExclusions(exclusions).setProperties(CoreNutsUtils.applyStringProperties(child.getPropertiesQuery(), properties)).build();
    }

    public NutsDescriptorBuilder replaceDependency(Predicate<NutsDependency> filter, UnaryOperator<NutsDependency> converter) {
        if (converter == null) {
            return this;
        }
        ArrayList<NutsDependency> dependenciesList = new ArrayList<NutsDependency>();
        for (NutsDependency d : this.getDependencies()) {
            if (filter == null || filter.test(d)) {
                if ((d = (NutsDependency)converter.apply(d)) == null) continue;
                dependenciesList.add(d);
                continue;
            }
            dependenciesList.add(d);
        }
        this.dependencies = dependenciesList;
        return this;
    }

    public NutsDescriptorBuilder removeDependency(Predicate<NutsDependency> dependency) {
        if (dependency == null) {
            return this;
        }
        Iterator<NutsDependency> it = this.dependencies.iterator();
        while (it.hasNext()) {
            NutsDependency d = it.next();
            if (!dependency.test(d)) continue;
            it.remove();
        }
        return this;
    }

    public String getGenericName() {
        return this.genericName;
    }

    public NutsDescriptorBuilder setGenericName(String name) {
        this.genericName = name;
        return this;
    }

    public List<String> getIcons() {
        return this.icons;
    }

    public NutsDescriptorBuilder setIcons(List<String> icons) {
        this.icons = icons == null ? new ArrayList<String>() : new ArrayList<String>(icons);
        return this;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public NutsDescriptorBuilder setCategories(List<String> categories) {
        this.categories = categories == null ? new ArrayList<String>() : new ArrayList<String>(categories);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNutsDescriptorBuilder that = (DefaultNutsDescriptorBuilder)o;
        return this.executable == that.executable && this.application == that.application && Objects.equals(this.id, that.id) && Arrays.equals(this.parents, that.parents) && Objects.equals(this.packaging, that.packaging) && Objects.equals(this.executor, that.executor) && Objects.equals(this.installer, that.installer) && Objects.equals(this.name, that.name) && Objects.equals(this.icons, that.icons) && Objects.equals(this.categories, that.categories) && Objects.equals(this.genericName, that.genericName) && Objects.equals(this.description, that.description) && Objects.equals(this.arch, that.arch) && Objects.equals(this.os, that.os) && Objects.equals(this.osdist, that.osdist) && Objects.equals(this.platform, that.platform) && Objects.equals(this.desktopEnvironment, that.desktopEnvironment) && Objects.equals(this.locations, that.locations) && Objects.equals(this.classifierMappings, that.classifierMappings) && Objects.equals(this.dependencies, that.dependencies) && Objects.equals(this.standardDependencies, that.standardDependencies) && Objects.equals(this.properties, that.properties) && Objects.equals(this.session, that.session);
    }

    public int hashCode() {
        int result = Objects.hash(this.id, this.packaging, this.executable, this.application, this.executor, this.installer, this.name, this.icons, this.categories, this.genericName, this.description, this.arch, this.os, this.osdist, this.platform, this.desktopEnvironment, this.locations, this.classifierMappings, this.dependencies, this.standardDependencies, this.properties, this.session);
        result = 31 * result + Arrays.hashCode(this.parents);
        return result;
    }
}

