/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.thevpc.nuts.NutsArtifactCall;
import net.thevpc.nuts.NutsId;

public class DefaultNutsArtifactCall
implements NutsArtifactCall,
Serializable {
    private static final long serialVersionUID = 1L;
    private final NutsId id;
    private final String[] arguments;
    private final Map<String, String> properties;

    public DefaultNutsArtifactCall(NutsArtifactCall other) {
        this.id = other.getId();
        this.arguments = other.getArguments();
        this.properties = other.getProperties();
    }

    public DefaultNutsArtifactCall(NutsId id) {
        this(id, null, null);
    }

    public DefaultNutsArtifactCall(NutsId id, String[] options) {
        this(id, options, null);
    }

    public DefaultNutsArtifactCall(NutsId id, String[] options, Map<String, String> properties) {
        this.id = id;
        this.arguments = options == null ? new String[]{} : options;
        this.properties = properties == null ? new HashMap() : properties;
    }

    public NutsId getId() {
        return this.id;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNutsArtifactCall that = (DefaultNutsArtifactCall)o;
        return Objects.equals(this.id, that.id) && Arrays.equals(this.arguments, that.arguments) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        int result = Objects.hash(this.id, this.properties);
        result = 31 * result + Arrays.hashCode(this.arguments);
        return result;
    }
}

