/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.log;

import java.time.Instant;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextBuilder;
import net.thevpc.nuts.NutsTextFormatStyle;
import net.thevpc.nuts.NutsTextManager;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.runtime.core.log.NutsLogRecord;
import net.thevpc.nuts.runtime.core.log.NutsLogUtils;
import net.thevpc.nuts.runtime.core.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.core.util.CoreTimeUtils;

public class NutsLogRichFormatter
extends Formatter {
    private long lastMillis = -1L;
    private NutsSession session;
    private boolean filtered;

    public NutsLogRichFormatter(NutsSession session, boolean filtered) {
        this.session = session;
        this.filtered = filtered;
    }

    @Override
    public String format(LogRecord record) {
        NutsLogRecord wRecord = NutsLogUtils.toNutsLogRecord(record, this.session);
        NutsTextFormatStyle style = wRecord.getFormatStyle();
        NutsTextManager tf = wRecord.getWorkspace().text().setSession(wRecord.getSession());
        NutsTextBuilder sb = tf.builder();
        String date = CoreNutsUtils.DEFAULT_DATE_TIME_FORMATTER.format(Instant.ofEpochMilli(wRecord.getMillis()));
        sb.append((NutsText)tf.forStyled(date, NutsTextStyle.pale()));
        boolean verboseLog = false;
        if (verboseLog) {
            sb.append((Object)" ");
            int len = date.length() + 5;
            StringBuilder sb2 = new StringBuilder(5);
            if (this.lastMillis > 0L) {
                sb2.append(String.valueOf(wRecord.getMillis() - this.lastMillis));
            }
            while (sb2.length() < 5) {
                sb2.append(' ');
            }
            sb.append((Object)sb.toString());
        }
        sb.append((Object)" ");
        switch (wRecord.getLevel().intValue()) {
            case 1000: {
                sb.append((Object)NutsLogUtils.logLevel(wRecord.getLevel()), NutsTextStyle.error());
                break;
            }
            case 900: {
                sb.append((Object)NutsLogUtils.logLevel(wRecord.getLevel()), NutsTextStyle.warn());
                break;
            }
            case 800: {
                sb.append((Object)NutsLogUtils.logLevel(wRecord.getLevel()), NutsTextStyle.info());
                break;
            }
            case 700: {
                sb.append((Object)NutsLogUtils.logLevel(wRecord.getLevel()), NutsTextStyle.config());
                break;
            }
            case 500: {
                sb.append((Object)NutsLogUtils.logLevel(wRecord.getLevel()), NutsTextStyle.primary4());
                break;
            }
            case 400: {
                sb.append((Object)NutsLogUtils.logLevel(wRecord.getLevel()), NutsTextStyle.pale());
                break;
            }
            case 300: {
                sb.append((Object)NutsLogUtils.logLevel(wRecord.getLevel()), NutsTextStyle.pale());
                break;
            }
            default: {
                sb.append((Object)NutsLogUtils.logLevel(wRecord.getLevel()));
            }
        }
        sb.append((Object)" ");
        switch (wRecord.getVerb() == null ? "" : wRecord.getVerb().name()) {
            case "FAIL": {
                sb.append((Object)NutsLogUtils.logVerb(wRecord.getVerb().name()), NutsTextStyle.error());
                break;
            }
            case "WARNING": {
                sb.append((Object)NutsLogUtils.logVerb(wRecord.getVerb().name()), NutsTextStyle.warn());
                break;
            }
            case "UPDATE": 
            case "START": {
                sb.append((Object)NutsLogUtils.logVerb(wRecord.getVerb().name()), NutsTextStyle.info());
                break;
            }
            case "SUCCESS": {
                sb.append((Object)NutsLogUtils.logVerb(wRecord.getVerb().name()), NutsTextStyle.success());
                break;
            }
            case "INFO": 
            case "READ": {
                sb.append((Object)NutsLogUtils.logVerb(wRecord.getVerb().name()), NutsTextStyle.option());
                break;
            }
            case "CACHE": 
            case "DEBUG": {
                sb.append((Object)NutsLogUtils.logVerb(wRecord.getVerb().name()), NutsTextStyle.pale());
                break;
            }
            default: {
                sb.append((Object)NutsLogUtils.logVerb(wRecord.getVerb() == null ? null : wRecord.getVerb().name()));
            }
        }
        sb.append((Object)(" " + NutsLogUtils.formatClassName(wRecord.getSourceClassName()) + ": "));
        Object[] parameters2 = wRecord.getParameters();
        if (parameters2 == null) {
            parameters2 = new Object[]{};
        }
        String message = wRecord.getMessage();
        if (!wRecord.isFormatted()) {
            message = wRecord.getSession().getWorkspace().text().forPlain(message).toString();
        }
        NutsText msgStr = wRecord.getWorkspace().text().setSession(wRecord.getSession()).toText((Object)new NutsMessage(style, message, parameters2));
        sb.append((Object)msgStr);
        if (wRecord.getTime() > 0L) {
            sb.append((Object)" (");
            sb.append((Object)CoreTimeUtils.formatPeriodMilli(wRecord.getTime()), NutsTextStyle.config());
            sb.append((Object)")");
        }
        sb.append((Object)NutsLogUtils.LINE_SEPARATOR);
        this.lastMillis = wRecord.getMillis();
        if (wRecord.getThrown() != null) {
            sb.append((Object)wRecord.getSession().getWorkspace().text().forPlain(NutsLogUtils.stacktrace(wRecord.getThrown())).toString());
        }
        if (this.filtered) {
            return sb.filteredText();
        }
        return sb.toString();
    }
}

