/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.log;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTextFormatStyle;
import net.thevpc.nuts.NutsWorkspace;

public class NutsLogRecord
extends LogRecord {
    private NutsSession session;
    private NutsLogVerb verb;
    private boolean formatted;
    private long time;
    private NutsTextFormatStyle formatStyle = NutsTextFormatStyle.JSTYLE;

    public NutsLogRecord(NutsSession session, Level level, NutsLogVerb verb, String msg, Object[] objects, boolean formatted, long time, NutsTextFormatStyle style) {
        super(level, msg);
        this.verb = verb;
        this.session = session;
        this.formatted = formatted;
        this.time = time;
        this.formatStyle = style == null ? NutsTextFormatStyle.CSTYLE : style;
        this.setParameters(objects);
    }

    public NutsTextFormatStyle getFormatStyle() {
        return this.formatStyle;
    }

    public long getTime() {
        return this.time;
    }

    public boolean isFormatted() {
        return this.formatted;
    }

    public NutsLogVerb getVerb() {
        return this.verb;
    }

    public NutsWorkspace getWorkspace() {
        return this.session == null ? null : this.session.getWorkspace();
    }

    public NutsSession getSession() {
        return this.session;
    }

    public void setSession(NutsSession session) {
        this.session = session;
    }
}

