/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.log;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.function.Supplier;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.thevpc.nuts.NutsLogManager;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTextFormatStyle;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.log.DefaultNutsLogManager;
import net.thevpc.nuts.runtime.core.log.DefaultNutsLoggerOp;
import net.thevpc.nuts.runtime.core.log.NutsLogRecord;

public class DefaultNutsLogger
implements NutsLogger {
    private NutsWorkspace workspace;
    private NutsSession session;
    private boolean defaultFormatted = true;
    private long defaultTime;
    private NutsTextFormatStyle defaultStyle = NutsTextFormatStyle.JSTYLE;
    private Logger log;
    private static final int offValue = Level.OFF.intValue();
    private LinkedList<LogRecord> suspendedTerminalRecords = new LinkedList();
    private int suspendedMax = 100;
    private boolean suspendTerminalMode = false;

    public DefaultNutsLogger(NutsWorkspace workspace, NutsSession session, Class log) {
        this(workspace, session, log.getName());
    }

    public DefaultNutsLogger(NutsWorkspace workspace, NutsSession session, String log) {
        this(workspace, session, Logger.getLogger(log));
    }

    public DefaultNutsLogger(NutsWorkspace workspace, NutsSession session, Logger log) {
        this.workspace = workspace;
        this.log = log;
        this.session = session;
    }

    public NutsWorkspace getWorkspace() {
        return this.workspace;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public Filter getFilter() {
        return null;
    }

    private boolean isLoggable(Level level, Level current) {
        int levelValue = current.intValue();
        return level.intValue() >= levelValue && levelValue != offValue;
    }

    public boolean isLoggable(Level level) {
        NutsLogManager _log = this.getSession().getWorkspace().log();
        if (this.isLoggable(level, _log.getTermLevel())) {
            return true;
        }
        if (this.isLoggable(level, _log.getFileLevel())) {
            return true;
        }
        for (Handler handler : _log.getHandlers()) {
            if (!this.isLoggable(level, handler.getLevel())) continue;
            return true;
        }
        return this.log.isLoggable(level);
    }

    public void log(Level level, String msg, Throwable thrown) {
        this.log(this.session, level, msg, thrown);
    }

    public void log(NutsSession session, Level level, String msg, Throwable thrown) {
        if (!this.isLoggable(level)) {
            return;
        }
        if (session == null) {
            session = this.session;
        }
        NutsLogRecord lr = new NutsLogRecord(session, level, NutsLogVerb.FAIL, msg, DefaultNutsLoggerOp.OBJECTS0, this.defaultFormatted, this.defaultTime, this.defaultStyle);
        lr.setThrown(thrown);
        this.doLog(lr);
    }

    public void log(Level level, NutsLogVerb verb, String msg) {
        this.log(this.session, level, verb, msg);
    }

    public void log(NutsSession session, Level level, NutsLogVerb verb, String msg) {
        if (!this.isLoggable(level)) {
            return;
        }
        if (session == null) {
            session = this.session;
        }
        NutsLogRecord lr = new NutsLogRecord(session, level, verb, msg, DefaultNutsLoggerOp.OBJECTS0, this.defaultFormatted, this.defaultTime, this.defaultStyle);
        this.doLog(lr);
    }

    public void log(Level level, NutsLogVerb verb, Supplier<String> msgSupplier) {
        this.log(this.session, level, verb, msgSupplier);
    }

    public void log(NutsSession session, Level level, NutsLogVerb verb, Supplier<String> msgSupplier) {
        if (!this.isLoggable(level)) {
            return;
        }
        if (session == null) {
            session = this.session;
        }
        NutsLogRecord lr = new NutsLogRecord(session, level, verb, msgSupplier.get(), DefaultNutsLoggerOp.OBJECTS0, this.defaultFormatted, this.defaultTime, this.defaultStyle);
        this.doLog(lr);
    }

    public void log(Level level, NutsLogVerb verb, String msg, Object[] params) {
        this.log(this.session, level, verb, msg, params);
    }

    public void log(NutsSession session, Level level, NutsLogVerb verb, String msg, Object[] params) {
        if (!this.isLoggable(level)) {
            return;
        }
        if (session == null) {
            session = this.session;
        }
        NutsLogRecord lr = new NutsLogRecord(session, level, verb, msg, params, this.defaultFormatted, this.defaultTime, this.defaultStyle);
        lr.setParameters(params);
        this.doLog(lr);
    }

    private void doLog(LogRecord record) {
        record.setLoggerName(this.log.getName());
        if (!this.isLoggable(record)) {
            return;
        }
        this.log0(record);
    }

    public NutsLoggerOp with() {
        return new DefaultNutsLoggerOp(this).session(this.getSession());
    }

    private boolean isLoggable(LogRecord record) {
        Filter theFilter = this.getFilter();
        return theFilter == null || theFilter.isLoggable(record);
    }

    public void log(LogRecord record) {
        if (!this.isLoggable(record.getLevel())) {
            return;
        }
        if (!this.isLoggable(record)) {
            return;
        }
        this.log0(record);
    }

    public void suspendTerminal() {
        this.suspendTerminalMode = true;
    }

    private void log0(LogRecord record) {
        Handler fh;
        DefaultNutsLogManager logManager = (DefaultNutsLogManager)this.getSession().getWorkspace().log();
        logManager.getModel().updateHandlers(record);
        Handler ch = logManager.getModel().getTermHandler();
        if (ch != null && ch.isLoggable(record)) {
            if (this.suspendTerminalMode) {
                this.suspendedTerminalRecords.add(record);
                if (this.suspendedTerminalRecords.size() > this.suspendedMax) {
                    LogRecord r = this.suspendedTerminalRecords.removeFirst();
                    logManager.getModel().updateTermHandler(r);
                    ch.publish(r);
                    ch.flush();
                }
            } else {
                ch.publish(record);
                ch.flush();
            }
        }
        if ((fh = logManager.getModel().getFileHandler()) != null && fh.isLoggable(record)) {
            fh.publish(record);
        }
        for (Handler handler : logManager.getModel().getHandlers()) {
            if (!handler.isLoggable(record)) continue;
            handler.publish(record);
        }
        this.log.log(record);
    }

    public void resumeTerminal(NutsSession session) {
        this.suspendTerminalMode = false;
        DefaultNutsLogManager logManager = (DefaultNutsLogManager)session.getWorkspace().log().setSession(session);
        Handler ch = logManager.getTermHandler();
        Iterator iterator = this.suspendedTerminalRecords.iterator();
        while (iterator.hasNext()) {
            LogRecord r = (LogRecord)iterator.next();
            iterator.remove();
            logManager.getModel().updateHandlers(r);
            if (ch == null) continue;
            ch.publish(r);
        }
        if (ch != null) {
            ch.flush();
        }
    }
}

