/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Objects;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsFormat;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsInput;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOutput;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.runtime.bundles.io.FixedInputStreamMetadata;
import net.thevpc.nuts.runtime.bundles.io.InputStreamMetadataAwareImpl;
import net.thevpc.nuts.runtime.core.format.DefaultFormatBase;
import net.thevpc.nuts.runtime.core.io.NutsCompressedPath;
import net.thevpc.nuts.runtime.core.io.NutsFormatSPIFromNutsFormat;
import net.thevpc.nuts.runtime.core.io.NutsPathBase;
import net.thevpc.nuts.runtime.core.io.NutsPathInput;
import net.thevpc.nuts.runtime.core.io.NutsPathOutput;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.spi.NutsFormatSPI;
import net.thevpc.nuts.spi.NutsPathSPI;

public class URLPath
extends NutsPathBase
implements NutsPathSPI {
    protected URL url;

    public URLPath(URL url, NutsSession session) {
        this(url, session, false);
    }

    protected URLPath(URL url, NutsSession session, boolean acceptNull) {
        super(session);
        if (url == null && !acceptNull) {
            throw new IllegalArgumentException("invalid url");
        }
        this.url = url;
    }

    public int hashCode() {
        return Objects.hash(this.url);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        URLPath urlPath = (URLPath)o;
        return Objects.equals(this.url, urlPath.url);
    }

    public String toString() {
        return this.url == null ? "broken-url" : this.url.toString();
    }

    public String getContentEncoding() {
        try {
            return this.url.openConnection().getContentEncoding();
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getContentType() {
        try {
            return this.url.openConnection().getContentType();
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getName() {
        return this.url == null ? "" : CoreIOUtils.getURLName(this.url);
    }

    public String asString() {
        return this.url == null ? "" : this.url.toString();
    }

    public String getLocation() {
        return this.url == null ? null : this.url.getFile();
    }

    public NutsPath toCompressedForm() {
        return new NutsCompressedPath(this);
    }

    public URL toURL() {
        if (this.url == null) {
            throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to resolve url %s", (Object[])new Object[]{this.toString()}));
        }
        return this.url;
    }

    public Path toFilePath() {
        File f = CoreIOUtils.toFile(this.toURL());
        if (f != null) {
            return f.toPath();
        }
        throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to resolve file %s", (Object[])new Object[]{this.toString()}));
    }

    public NutsInput input() {
        return new URLPathInput();
    }

    public NutsOutput output() {
        return new NutsPathOutput(null, this, this.getSession()){

            @Override
            public OutputStream open() {
                return URLPath.this.outputStream();
            }
        };
    }

    public void delete(boolean recurse) {
        throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to delete %s", (Object[])new Object[]{this.toString()}));
    }

    public void mkdir(boolean parents) {
        throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to mkdir %s", (Object[])new Object[]{this.toString()}));
    }

    public boolean exists() {
        if (this.url == null) {
            return false;
        }
        try {
            this.url.openConnection().getContentLengthLong();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public long getContentLength() {
        if (this.url == null) {
            return -1L;
        }
        try {
            return this.url.openConnection().getContentLengthLong();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public Instant getLastModifiedInstant() {
        if (this.url == null) {
            return null;
        }
        try {
            long z = this.url.openConnection().getLastModified();
            if (z == -1L) {
                return null;
            }
            return Instant.ofEpochMilli(z);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public NutsFormat formatter() {
        return (NutsFormat)new MyPathFormat(this).setSession(this.getSession());
    }

    public NutsFormatSPI getFormatterSPI() {
        return new NutsFormatSPIFromNutsFormat(this.formatter());
    }

    public InputStream inputStream() {
        try {
            if (this.url == null) {
                throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to resolve input stream %s", (Object[])new Object[]{this.toString()}));
            }
            return this.url.openStream();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public OutputStream outputStream() {
        try {
            if (this.url == null) {
                throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to resolve output stream %s", (Object[])new Object[]{this.toString()}));
            }
            return this.url.openConnection().getOutputStream();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private class URLPathInput
    extends NutsPathInput {
        public URLPathInput() {
            super(URLPath.this);
        }

        @Override
        public InputStream open() {
            return new InputStreamMetadataAwareImpl(URLPath.this.inputStream(), new FixedInputStreamMetadata(this.getNutsPath().toString(), this.getNutsPath().getContentLength()));
        }

        @Override
        public URL getURL() {
            return super.getURL();
        }
    }

    private static class MyPathFormat
    extends DefaultFormatBase<NutsFormat> {
        private URLPath p;

        public MyPathFormat(URLPath p) {
            super(p.getSession().getWorkspace(), "path");
            this.p = p;
        }

        public NutsString asFormattedString() {
            if (this.p.url == null) {
                return this.getSession().getWorkspace().text().forPlain("");
            }
            return this.getSession().getWorkspace().text().toText((Object)this.p.url);
        }

        @Override
        public void print(NutsPrintStream out) {
            out.print(this.asFormattedString());
        }

        public boolean configureFirst(NutsCommandLine commandLine) {
            return false;
        }
    }
}

