/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.io;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsDependencyScopePattern;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdParser;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextBuilder;
import net.thevpc.nuts.NutsTextManager;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.spi.NutsFormatSPI;
import net.thevpc.nuts.spi.NutsPathSPI;

public class NutsResourcePath
implements NutsPathSPI {
    private String path;
    private List<NutsId> ids;
    private String location;
    private boolean urlPathLookedUp = false;
    private NutsPath urlPath = null;
    private NutsSession session;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NutsResourcePath(String path, NutsSession session) {
        String idsStr;
        int x2;
        this.path = path;
        this.session = session;
        if (path.startsWith("nuts-resource://(")) {
            x2 = path.indexOf(41);
            if (x2 <= 0) throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid path %s", (Object[])new Object[]{path}));
            idsStr = path.substring("nuts-resource://(".length(), x2);
            this.location = path.substring(x2 + 1);
        } else {
            if (!path.startsWith("nuts-resource://")) throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid path %s", (Object[])new Object[]{path}));
            x2 = path.indexOf(47, "nuts-resource://".length());
            if (x2 <= 0) throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid path %s", (Object[])new Object[]{path}));
            idsStr = path.substring("nuts-resource://".length(), x2);
            this.location = path.substring(x2);
        }
        NutsIdParser nutsIdParser = session.getWorkspace().id().parser().setLenient(false);
        this.ids = Arrays.stream(idsStr.split(";")).map(x -> {
            if ((x = x.trim()).length() > 0) {
                return nutsIdParser.parse(x);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public String toString() {
        return String.valueOf(this.path);
    }

    public NutsPath toURLPath() {
        if (!this.urlPathLookedUp) {
            this.urlPathLookedUp = true;
            try {
                URL resource;
                String loc = this.location;
                ClassLoader resultClassLoader = this.getSession().getWorkspace().search().addIds(this.ids.toArray(new NutsId[0])).setLatest(true).setContent(true).setDependencies(true).setDependencyFilter(this.getSession().getWorkspace().filters().dependency().byScope(NutsDependencyScopePattern.RUN)).setOptional(Boolean.valueOf(false)).getResultClassLoader();
                if (loc.length() > 1 && loc.startsWith("/")) {
                    loc = loc.substring(1);
                }
                if ((resource = resultClassLoader.getResource(loc)) != null) {
                    this.urlPath = this.getSession().getWorkspace().io().path(resource);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.urlPath;
    }

    public NutsFormatSPI getFormatterSPI() {
        return new MyPathFormat(this);
    }

    public String getName() {
        return CoreIOUtils.getURLName(this.path);
    }

    public URL toURL() {
        NutsPath up = this.toURLPath();
        if (up == null) {
            throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to resolve url %s", (Object[])new Object[]{this.toString()}));
        }
        return up.toURL();
    }

    public Path toFilePath() {
        throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to resolve file %s", (Object[])new Object[]{this.toString()}));
    }

    public boolean exists() {
        NutsPath up = this.toURLPath();
        if (up == null) {
            return false;
        }
        return up.exists();
    }

    public long getContentLength() {
        NutsPath up = this.toURLPath();
        if (up == null) {
            return -1L;
        }
        return up.getContentLength();
    }

    public String getContentEncoding() {
        NutsPath up = this.toURLPath();
        if (up != null) {
            return up.getContentEncoding();
        }
        return null;
    }

    public String getContentType() {
        NutsPath up = this.toURLPath();
        if (up != null) {
            return up.getContentType();
        }
        return null;
    }

    public String asString() {
        return this.path;
    }

    public String getLocation() {
        return this.location;
    }

    public InputStream inputStream() {
        NutsPath up = this.toURLPath();
        if (up == null) {
            throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to resolve input stream %s", (Object[])new Object[]{this.toString()}));
        }
        return up.input().open();
    }

    public OutputStream outputStream() {
        NutsPath up = this.toURLPath();
        if (up == null) {
            throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to resolve output stream %s", (Object[])new Object[]{this.toString()}));
        }
        return up.output().open();
    }

    public NutsSession getSession() {
        return this.session;
    }

    public void delete(boolean recurse) {
        NutsPath up = this.toURLPath();
        if (up == null) {
            throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to delete %s", (Object[])new Object[]{this.toString()}));
        }
        up.delete(recurse);
    }

    public void mkdir(boolean parents) {
        NutsPath up = this.toURLPath();
        if (up == null) {
            throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to mkdir %s", (Object[])new Object[]{this.toString()}));
        }
        up.mkdir(parents);
    }

    public Instant getLastModifiedInstant() {
        NutsPath up = this.toURLPath();
        if (up == null) {
            return null;
        }
        return up.getLastModifiedInstant();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NutsResourcePath that = (NutsResourcePath)o;
        return this.urlPathLookedUp == that.urlPathLookedUp && Objects.equals(this.path, that.path) && Objects.equals(this.ids, that.ids) && Objects.equals(this.location, that.location) && Objects.equals(this.urlPath, that.urlPath) && Objects.equals(this.session, that.session);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.session);
    }

    private static class MyPathFormat
    implements NutsFormatSPI {
        private NutsResourcePath p;

        public MyPathFormat(NutsResourcePath p) {
            this.p = p;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public NutsString asFormattedString() {
            String path = this.p.path;
            NutsTextManager text = this.p.getSession().getWorkspace().text();
            NutsTextBuilder tb = text.builder();
            tb.append((Object)"nuts-resource://", NutsTextStyle.primary1());
            if (path.startsWith("nuts-resource://(")) {
                tb.append((Object)"(", NutsTextStyle.separator());
                int x = path.indexOf(41);
                if (x <= 0) return text.toText((Object)path);
                tb.append((Object)path.substring("nuts-resource://(".length(), x));
                tb.append((Object)")", NutsTextStyle.separator());
                tb.append((Object)path.substring(x + 1), NutsTextStyle.path());
                return text.toText((Object)path);
            } else {
                if (!path.startsWith("nuts-resource://")) return text.toText((Object)path);
                int x = path.indexOf(47, "nuts-resource://".length());
                if (x <= 0) return text.toText((Object)path);
                tb.append((Object)path.substring("nuts-resource://".length(), x));
                tb.append((Object)path.substring(x), NutsTextStyle.path());
            }
            return text.toText((Object)path);
        }

        public void print(NutsPrintStream out) {
            out.print(this.asFormattedString());
        }

        public boolean configureFirst(NutsCommandLine commandLine) {
            return false;
        }
    }
}

