/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.io;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Objects;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsFormat;
import net.thevpc.nuts.NutsInput;
import net.thevpc.nuts.NutsOutput;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.runtime.bundles.io.FixedInputStreamMetadata;
import net.thevpc.nuts.runtime.bundles.io.InputStreamMetadataAwareImpl;
import net.thevpc.nuts.runtime.core.format.DefaultFormatBase;
import net.thevpc.nuts.runtime.core.io.NutsCompressedPath;
import net.thevpc.nuts.runtime.core.io.NutsPathBase;
import net.thevpc.nuts.runtime.core.io.NutsPathInput;
import net.thevpc.nuts.runtime.core.io.NutsPathOutput;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.spi.NutsFormatSPI;
import net.thevpc.nuts.spi.NutsPathSPI;

public class NutsPathFromSPI
extends NutsPathBase {
    private NutsPathSPI base;

    public NutsPathFromSPI(NutsPathSPI base) {
        super(base.getSession());
        this.base = base;
    }

    public String getName() {
        String n = this.base.getName();
        if (n == null) {
            return CoreIOUtils.getURLName(this.asString());
        }
        return n;
    }

    public String getContentEncoding() {
        return this.base.getContentEncoding();
    }

    public String getContentType() {
        return this.base.getContentType();
    }

    public String asString() {
        return this.base.asString();
    }

    public String getLocation() {
        return this.base.getLocation();
    }

    public NutsPath toCompressedForm() {
        NutsPath n = this.base.toCompressedForm();
        if (n == null) {
            return new NutsCompressedPath(this);
        }
        return this;
    }

    public URL toURL() {
        return this.base.toURL();
    }

    public Path toFilePath() {
        return this.base.toFilePath();
    }

    public NutsInput input() {
        return new NutsPathFromSPIInput();
    }

    public NutsOutput output() {
        return new NutsPathOutput(null, this, this.getSession()){

            @Override
            public OutputStream open() {
                return NutsPathFromSPI.this.base.outputStream();
            }
        };
    }

    public void delete(boolean recurse) {
        this.base.delete(recurse);
    }

    public void mkdir(boolean parents) {
        this.base.mkdir(parents);
    }

    public boolean exists() {
        return this.base.exists();
    }

    public long getContentLength() {
        return this.base.getContentLength();
    }

    public Instant getLastModifiedInstant() {
        return this.base.getLastModifiedInstant();
    }

    @Override
    public NutsFormat formatter() {
        final NutsFormatSPI fspi = this.base.getFormatterSPI();
        if (fspi != null) {
            return (NutsFormat)new DefaultFormatBase<NutsFormat>(this.getSession().getWorkspace(), "path"){

                @Override
                public void print(NutsPrintStream out) {
                    fspi.print(out);
                }

                public boolean configureFirst(NutsCommandLine commandLine) {
                    return fspi.configureFirst(commandLine);
                }
            }.setSession(this.getSession());
        }
        return super.formatter();
    }

    public int hashCode() {
        return Objects.hash(this.base);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NutsPathFromSPI that = (NutsPathFromSPI)o;
        return this.base.equals(that.base);
    }

    public String toString() {
        return this.base.toString();
    }

    private class NutsPathFromSPIInput
    extends NutsPathInput {
        public NutsPathFromSPIInput() {
            super(NutsPathFromSPI.this);
        }

        @Override
        public InputStream open() {
            return new InputStreamMetadataAwareImpl(NutsPathFromSPI.this.base.inputStream(), new FixedInputStreamMetadata(this.getNutsPath().toString(), this.getNutsPath().getContentLength()));
        }
    }
}

