/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.io;

import java.net.URL;
import java.nio.file.Path;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsFormat;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.runtime.core.format.DefaultFormatBase;

public abstract class NutsPathBase
implements NutsPath {
    private NutsSession session;

    public NutsPathBase(NutsSession session) {
        if (session == null) {
            throw new IllegalArgumentException("invalid session");
        }
        this.session = session;
    }

    public String getBaseName() {
        String n = this.getName();
        int i = n.indexOf(46);
        if (i < 0) {
            return n;
        }
        if (i == n.length() - 1) {
            return n;
        }
        return n.substring(0, i);
    }

    public String getLastExtension() {
        String n = this.getName();
        int i = n.lastIndexOf(46);
        if (i < 0) {
            return "";
        }
        return n.substring(i + 1);
    }

    public String getFullExtension() {
        String n = this.getName();
        int i = n.indexOf(46);
        if (i < 0) {
            return "";
        }
        return n.substring(i + 1);
    }

    public NutsString getFormattedName() {
        return this.getSession().getWorkspace().text().forStyled(this.getName(), NutsTextStyle.path());
    }

    public boolean isURL() {
        return this.asURL() != null;
    }

    public boolean isFilePath() {
        return this.asFilePath() != null;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public URL asURL() {
        try {
            return this.toURL();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Path asFilePath() {
        try {
            return this.toFilePath();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public NutsString toNutsString() {
        return this.session.getWorkspace().text().forPlain(this.toString());
    }

    public NutsFormat formatter() {
        return (NutsFormat)new PathFormat(this).setSession(this.getSession());
    }

    private static class PathFormat
    extends DefaultFormatBase<NutsFormat> {
        private NutsPathBase p;

        public PathFormat(NutsPathBase p) {
            super(p.session.getWorkspace(), "path");
            this.p = p;
        }

        @Override
        public void print(NutsPrintStream out) {
            out.print((NutsString)this.p.session.getWorkspace().text().forStyled(this.p.toNutsString(), NutsTextStyle.path()));
        }

        public boolean configureFirst(NutsCommandLine commandLine) {
            return false;
        }
    }
}

