/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.format.tree.XNodeFormatter;

public class XNode {
    NutsString key;
    Object value;
    NutsString title;
    NutsSession session;
    NutsWorkspace ws;
    XNodeFormatter format;

    public static XNode root(Object destructedObject, NutsString title, NutsSession session, XNodeFormatter format) {
        return new XNode(null, destructedObject, (NutsString)(destructedObject instanceof List || destructedObject instanceof Map || destructedObject instanceof Map.Entry ? title : null), session, format);
    }

    public static XNode node(Object destructedObject, NutsSession session, XNodeFormatter format) {
        return new XNode(null, destructedObject, null, session, format);
    }

    public static XNode entryNode(NutsString key, Object destructedObject, NutsSession session, XNodeFormatter format) {
        return new XNode(key, destructedObject, null, session, format);
    }

    public XNode(NutsString key, Object destructedObject, NutsString title, NutsSession session, XNodeFormatter format) {
        this.value = destructedObject instanceof Map && ((Map)destructedObject).size() == 1 ? ((Map)destructedObject).entrySet().toArray()[0] : destructedObject;
        this.key = key;
        this.title = title;
        this.session = session;
        this.ws = session.getWorkspace();
        this.format = format;
    }

    public String toString() {
        return this.toNutsString().toString();
    }

    public NutsString toNutsString() {
        NutsString keyAsElement = this.format.stringValue(this.key, this.session);
        NutsString[] p = this.format.getMultilineArray(keyAsElement, this.value, this.session);
        if (p != null) {
            return keyAsElement;
        }
        NutsString _title = this.resolveTitle();
        NutsString titleOrValueAsElement = this.format.stringValue(_title != null ? _title : this.value, this.session);
        if (this.key == null) {
            return titleOrValueAsElement;
        }
        if (this.value instanceof List || this.value instanceof Map) {
            return this.ws.text().builder().append((Object)keyAsElement);
        }
        return this.ws.text().builder().append((Object)keyAsElement).append((Object)"=").append((Object)titleOrValueAsElement);
    }

    private NutsString resolveTitle() {
        if (this.title != null) {
            return this.title;
        }
        if (this.value instanceof List) {
            return null;
        }
        if (this.value instanceof Map.Entry) {
            return this.format.stringValue(((Map.Entry)this.value).getKey(), this.session);
        }
        if (this.value instanceof Map) {
            Object bestElement = null;
            int bestKeyOrder = -1;
            for (Map.Entry me : ((Map)this.value).entrySet()) {
                int keyOrder = -1;
                if (me.getKey() instanceof String) {
                    switch ((String)me.getKey()) {
                        case "id": {
                            keyOrder = 1;
                            break;
                        }
                        case "name": {
                            keyOrder = 10;
                            break;
                        }
                        case "title": {
                            keyOrder = 2;
                            break;
                        }
                        case "label": {
                            keyOrder = 3;
                        }
                    }
                }
                if (keyOrder <= bestKeyOrder) continue;
                bestKeyOrder = keyOrder;
                bestElement = me.getValue();
            }
            if (bestKeyOrder >= 0) {
                return this.format.stringValue(bestElement, this.session);
            }
        }
        return null;
    }

    public List getChildren() {
        if (this.value instanceof Map.Entry) {
            Object v = ((Map.Entry)this.value).getValue();
            return this.getAsList(v);
        }
        if (this.value instanceof List || this.value instanceof Map) {
            return this.getAsList(this.value);
        }
        return null;
    }

    private List getAsList(Object value) {
        if (value instanceof List) {
            return ((List)value).stream().map(me -> XNode.node(me, this.session, this.format)).collect(Collectors.toList());
        }
        if (value instanceof Map) {
            Map m = (Map)value;
            ArrayList<XNode> all = new ArrayList<XNode>();
            for (Map.Entry me2 : m.entrySet()) {
                NutsString keyStr = this.format.stringValue(me2.getKey(), this.session);
                NutsString[] map = this.format.getMultilineArray(keyStr, me2.getValue(), this.session);
                if (map == null) {
                    all.add(XNode.entryNode(keyStr, me2.getValue(), this.session, this.format));
                    continue;
                }
                all.add(XNode.entryNode(keyStr, this.ws.elem().setSession(this.session).toElement(Arrays.asList(map)), this.session, this.format));
            }
            return all;
        }
        return Arrays.asList(XNode.node(value, this.session, this.format));
    }
}

