/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.text.parser.steps;

import java.util.ArrayList;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextStyleType;
import net.thevpc.nuts.NutsTextStyles;
import net.thevpc.nuts.runtime.bundles.parsers.StringReaderExt;

public class StyledParserStepCommandParser {
    public boolean isCommandEnd(char c) {
        return c == ' ' || c == ':';
    }

    public boolean isCommandPart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '/' || c == '_' || c == '+' || c == '!' || c == '-' || c == '%';
    }

    public NutsTextStyles parse(String atStr) {
        StringReaderExt r = new StringReaderExt(atStr);
        ArrayList<NutsTextStyle> parsedStyles = new ArrayList<NutsTextStyle>();
        if (r.hasNext() && r.peekChar() == ':') {
            r.nextChar();
            while (!this.readEnd(r)) {
                NutsTextStyle s = this.readNext(r);
                if (s == null) {
                    return null;
                }
                parsedStyles.add(s);
            }
        } else {
            return null;
        }
        return NutsTextStyles.NONE.append(parsedStyles.toArray(new NutsTextStyle[0]));
    }

    private boolean isHexChar(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private boolean isDigitChar(char c) {
        return c >= '0' && c <= '9';
    }

    private String peekInt(StringReaderExt r, int from, int maxChars) {
        char c;
        int x = 0;
        StringBuilder s = new StringBuilder();
        while (r.hasNext(from + x) && this.isDigitChar(c = r.peekChar(from + x))) {
            s.append(c);
            if (++x != maxChars) continue;
            break;
        }
        if (!(x <= 0 || r.hasNext(from + x) && this.isDigitChar(r.peekChar(from + x)))) {
            try {
                Integer.parseInt(s.toString());
                return s.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean readEnd(StringReaderExt r) {
        if (!r.hasNext()) {
            return true;
        }
        if (r.peekChar() == ' ' || r.peekChar() == ':') {
            if (r.hasNext(1)) {
                return false;
            }
            r.nextChars(1);
            return true;
        }
        return false;
    }

    public NutsTextStyle parseSimpleNutsTextStyle(String str) {
        StringReaderExt e = new StringReaderExt(str);
        NutsTextStyle a = this.readNext(e);
        if (a == null) {
            return null;
        }
        if (e.hasNext()) {
            return null;
        }
        return a;
    }

    private Integer readNextPrefixedInt8(String prefix, StringReaderExt r) {
        String s;
        int len = prefix.length();
        String ss = r.peekChars(len);
        if (ss.equalsIgnoreCase(prefix) && (s = this.peekInt(r, len, len + 3)) != null && s.length() > 0) {
            r.nextChars(len);
            r.nextChars(s.length());
            return Integer.parseInt(s, 10);
        }
        return null;
    }

    private Integer readNextPrefixedHexString(String prefix, StringReaderExt r) {
        int len = prefix.length();
        String ss = r.peekChars(len);
        if (ss.equalsIgnoreCase(prefix) && r.hasNext(len + 5) && this.isHexChar(r.peekChar(len + 0)) && this.isHexChar(r.peekChar(len + 1)) && this.isHexChar(r.peekChar(len + 2)) && this.isHexChar(r.peekChar(len + 3)) && this.isHexChar(r.peekChar(len + 4)) && this.isHexChar(r.peekChar(len + 5))) {
            String s = r.nextChars(len);
            s = r.nextChars(8);
            return Integer.parseInt(s, 16);
        }
        return null;
    }

    private NutsTextStyle readNext(StringReaderExt r) {
        if (r.hasNext()) {
            char c = r.peekChar();
            switch (c) {
                case 'F': 
                case 'f': {
                    Integer ii = this.readNextPrefixedHexString("fx", r);
                    if (ii != null) {
                        return NutsTextStyle.foregroundTrueColor((int)ii);
                    }
                    ii = this.readNextPrefixedHexString("foregroundx", r);
                    if (ii != null) {
                        return NutsTextStyle.foregroundTrueColor((int)ii);
                    }
                    ii = this.readNextPrefixedInt8("f", r);
                    if (ii != null) {
                        return NutsTextStyle.foregroundColor((int)ii);
                    }
                    ii = this.readNextPrefixedInt8("foreground", r);
                    if (ii == null) break;
                    return NutsTextStyle.foregroundColor((int)ii);
                }
                case 'B': 
                case 'b': {
                    Integer ii = this.readNextPrefixedHexString("bx", r);
                    if (ii != null) {
                        return NutsTextStyle.backgroundTrueColor((int)ii);
                    }
                    ii = this.readNextPrefixedHexString("backgroundx", r);
                    if (ii != null) {
                        return NutsTextStyle.backgroundTrueColor((int)ii);
                    }
                    ii = this.readNextPrefixedInt8("b", r);
                    if (ii != null) {
                        return NutsTextStyle.backgroundColor((int)ii);
                    }
                    ii = this.readNextPrefixedInt8("background", r);
                    if (ii == null) break;
                    return NutsTextStyle.backgroundColor((int)ii);
                }
                case '/': {
                    r.nextChar();
                    return NutsTextStyle.italic();
                }
                case '+': {
                    r.nextChar();
                    return NutsTextStyle.bold();
                }
                case '%': {
                    r.nextChar();
                    return NutsTextStyle.blink();
                }
                case '_': {
                    r.nextChar();
                    return NutsTextStyle.underlined();
                }
                case '-': {
                    r.nextChar();
                    return NutsTextStyle.striked();
                }
                case '!': {
                    r.nextChar();
                    return NutsTextStyle.reversed();
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    String s = this.peekInt(r, 0, 3);
                    if (s == null) break;
                    r.nextChars(s.length());
                    return NutsTextStyle.primary((int)Integer.parseInt(s));
                }
            }
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                String s;
                int x = 0;
                StringBuilder n = new StringBuilder();
                boolean expectN = false;
                while (r.hasNext(x)) {
                    char c2 = r.peekChar(x);
                    if (this.isDigitChar(c2)) {
                        expectN = true;
                        break;
                    }
                    if (!(c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 == '_') && c2 != '-') break;
                    n.append(c2);
                    ++x;
                }
                String variantString = "";
                if (expectN && (s = this.peekInt(r, x, 3)) != null) {
                    variantString = s;
                }
                int variant = variantString.isEmpty() ? 0 : Integer.parseInt(variantString);
                int totLen = n.toString().length() + variantString.length();
                switch (n.toString().toLowerCase()) {
                    case "kw": {
                        r.nextChars(totLen);
                        return NutsTextStyle.keyword((int)variant);
                    }
                    case "p": {
                        r.nextChars(totLen);
                        return NutsTextStyle.primary((int)variant);
                    }
                    case "s": {
                        r.nextChars(totLen);
                        return NutsTextStyle.secondary((int)variant);
                    }
                    case "bool": {
                        r.nextChars(totLen);
                        return NutsTextStyle.bool((int)variant);
                    }
                }
                String sb2 = n.toString().toUpperCase();
                sb2 = sb2.replace('-', '_');
                NutsTextStyleType st = NutsTextStyleType.parseLenient((String)sb2, (NutsTextStyleType)NutsTextStyleType.ERROR);
                r.nextChars(totLen);
                return NutsTextStyle.of((NutsTextStyleType)st, (int)variant);
            }
        }
        return null;
    }
}

