/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.text.parser.steps;

import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.runtime.core.format.text.DefaultNutsTextManager;
import net.thevpc.nuts.runtime.core.format.text.parser.DefaultNutsTextNodeParser;
import net.thevpc.nuts.runtime.core.format.text.parser.steps.ParserStep;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;

public class NewLineParserStep
extends ParserStep {
    StringBuilder start = new StringBuilder();
    private NutsSession session;

    public NewLineParserStep(char c, NutsSession ws) {
        this.start.append(c);
        this.session = ws;
    }

    @Override
    public void consume(char c, DefaultNutsTextNodeParser.State state, boolean wasNewLine) {
        if (c == '\n') {
            this.start.append(c);
        } else {
            state.applyPopReplay(c);
        }
    }

    @Override
    public void appendChild(ParserStep tt) {
        throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"unsupported", (Object[])new Object[0]));
    }

    @Override
    public NutsText toText() {
        DefaultNutsTextManager factory0 = (DefaultNutsTextManager)this.session.getWorkspace().text();
        return factory0.forPlain(this.start.toString());
    }

    @Override
    public void end(DefaultNutsTextNodeParser.State p) {
        p.applyPop();
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NewLine(" + CoreStringUtils.dblQuote(this.start.toString()));
        return sb.append(")").toString();
    }
}

