/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.text.parser.steps;

import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTerminalCommand;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.runtime.core.format.text.DefaultNutsTextManager;
import net.thevpc.nuts.runtime.core.format.text.parser.DefaultNutsTextNodeParser;
import net.thevpc.nuts.runtime.core.format.text.parser.steps.ParserStep;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;

public class AntiQuote3ParserStep
extends ParserStep {
    boolean escape = false;
    StringBuilder start = new StringBuilder();
    StringBuilder end = new StringBuilder();
    StringBuilder value = new StringBuilder();
    int maxSize = 3;
    private static final int START_QUOTES = 0;
    private static final int CONTENT = 1;
    private static final int END_QUOTES = 2;
    private static final int COMPLETED = 3;
    int status = 0;
    char c0;
    boolean spreadLines;
    NutsSession session;
    boolean exitOnBrace;

    public AntiQuote3ParserStep(char c, boolean spreadLines, NutsSession session, boolean exitOnBrace) {
        this.c0 = c;
        this.start.append(this.c0);
        this.spreadLines = spreadLines;
        this.session = session;
        this.exitOnBrace = exitOnBrace;
    }

    @Override
    public void consume(char c, DefaultNutsTextNodeParser.State p, boolean wasNewLine) {
        switch (this.status) {
            case 0: {
                if (c == this.c0) {
                    if (this.start.length() < this.maxSize) {
                        this.start.append(c);
                    } else {
                        this.start.append(c);
                        p.applyDropReplacePreParsedPlain(this.start.toString(), this.exitOnBrace);
                    }
                } else if (this.start.length() == this.maxSize) {
                    switch (c) {
                        case '\\': {
                            this.escape = true;
                            break;
                        }
                        default: {
                            this.value.append(c);
                        }
                    }
                    this.status = 1;
                } else {
                    this.start.append(c);
                    p.applyDropReplacePreParsedPlain(this.start.toString(), this.exitOnBrace);
                }
                return;
            }
            case 1: {
                if (this.escape) {
                    this.escape = false;
                    this.value.append(c);
                } else if (c == this.c0) {
                    this.status = 2;
                    this.end.append(c);
                    if (this.end.length() >= this.start.length()) {
                        p.applyPop();
                        return;
                    }
                } else {
                    switch (c) {
                        case '\\': {
                            this.escape = true;
                            break;
                        }
                        default: {
                            this.value.append(c);
                        }
                    }
                }
                return;
            }
            case 2: {
                if (c == this.c0) {
                    this.end.append(c);
                } else if (this.end.length() == this.maxSize) {
                    p.applyPopReplay(c);
                } else {
                    this.value.append((CharSequence)this.end);
                    this.end.delete(0, this.end.length());
                    switch (c) {
                        case '\\': {
                            this.escape = true;
                            break;
                        }
                        default: {
                            this.value.append(c);
                        }
                    }
                    this.status = 1;
                }
                return;
            }
        }
        throw new IllegalArgumentException("Unexpected");
    }

    @Override
    public void appendChild(ParserStep tt) {
        throw new UnsupportedOperationException("unsupported operation: appendChild");
    }

    @Override
    public NutsText toText() {
        char[] dst = new char[this.value.length()];
        this.value.getChars(0, this.value.length(), dst, 0);
        DefaultNutsTextManager factory0 = (DefaultNutsTextManager)this.session.getWorkspace().text();
        int i = 0;
        int endOffset = -1;
        if (dst.length > 0 && dst[i] == '!') {
            ++i;
        }
        while (i < dst.length) {
            if (Character.isWhitespace(dst[i])) {
                endOffset = i;
                break;
            }
            if (!Character.isAlphabetic(dst[i]) && !Character.isDigit(dst[i]) && dst[i] != '-' && dst[i] != '_') {
                endOffset = i;
                break;
            }
            ++i;
        }
        if (endOffset == -1) {
            endOffset = dst.length;
        }
        StringBuilder w = new StringBuilder();
        for (i = endOffset; i < dst.length && Character.isWhitespace(dst[i]); ++i) {
            w.append(dst[i]);
        }
        String cmd = new String(dst, 0, endOffset);
        String value = new String(dst, i, dst.length - i);
        if (cmd.startsWith("!")) {
            String cmd0 = cmd.substring(1);
            String start2 = this.start.toString() + "!";
            switch (cmd) {
                case "!anchor": {
                    return factory0.createAnchor(start2, w.toString(), this.end.toString(), value);
                }
                case "!link": {
                    return factory0.createLink(start2, w.toString(), this.end.toString(), (NutsText)factory0.forPlain(value));
                }
            }
            NutsTerminalCommand ntc = NutsTerminalCommand.of((String)cmd0, (String)value);
            return factory0.createCommand(start2, ntc, w.toString(), this.end.toString());
        }
        if (value.isEmpty()) {
            if (w.length() > 0 && cmd.length() > 0) {
                return factory0.createCode(this.start.toString(), cmd, w.toString(), this.end.toString(), value);
            }
            return factory0.createCode(this.start.toString(), "", "", this.end.toString(), cmd + w.toString() + value);
        }
        return factory0.createCode(this.start.toString(), cmd, w.toString(), this.end.toString(), value);
    }

    @Override
    public void end(DefaultNutsTextNodeParser.State p) {
        if (!this.isComplete()) {
            while (this.end.length() < this.start.length()) {
                this.end.append(this.c0);
            }
        }
        p.applyPop();
    }

    @Override
    public boolean isComplete() {
        return this.status == 2 && this.end.length() == this.start.length();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Quoted(" + CoreStringUtils.dblQuote(this.start.toString()));
        sb.append(",");
        sb.append(CoreStringUtils.dblQuote(this.value.toString()));
        sb.append(",status=").append(this.status == 0 ? "EXPECT_START" : (this.status == 1 ? "EXPECT_CONTENT" : (this.status == 2 ? "EXPECT_END" : String.valueOf(this.status))));
        sb.append(",end=");
        sb.append((CharSequence)this.end);
        if (this.escape) {
            sb.append(",<ESCAPED>");
        }
        sb.append(this.isComplete() ? "" : ",incomplete");
        return sb.append(")").toString();
    }
}

