/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.text.parser;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextFormatLoader;
import net.thevpc.nuts.NutsTextList;
import net.thevpc.nuts.NutsTextParser;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextType;
import net.thevpc.nuts.runtime.bundles.parsers.StringPlaceHolderParser;
import net.thevpc.nuts.runtime.core.format.text.parser.DefaultNutsTextAnchor;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.io.NutsWorkspaceVarExpansionFunction;

public class DefaultNutsTextNodeResourceParserHelper {
    private NutsTextParser parser;
    private NutsSession session;
    private NutsWorkspaceVarExpansionFunction pathExpansionConverter;

    public DefaultNutsTextNodeResourceParserHelper(NutsTextParser parser, NutsSession session) {
        this.parser = parser;
        this.session = session;
        this.pathExpansionConverter = new NutsWorkspaceVarExpansionFunction(session.getWorkspace());
    }

    public NutsText parseResource(String resourceName, NutsTextFormatLoader loader) {
        if (loader == null) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"missing loader", (Object[])new Object[0]));
        }
        Reader reader = loader.forPath(resourceName);
        if (reader == null) {
            return null;
        }
        return this.parseResource(resourceName, reader, loader);
    }

    public NutsTextFormatLoader createClassPathLoader(ClassLoader loader) {
        return new NutsTextFormatLoaderClassPath(loader);
    }

    public NutsTextFormatLoader createFileLoader(File root) {
        return new NutsTextFormatLoaderFile(root);
    }

    public NutsText parseResource(String resourceName, Reader reader, NutsTextFormatLoader loader) {
        if (loader == null) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"missing loader", (Object[])new Object[0]));
        }
        if (reader == null) {
            reader = loader.forPath(resourceName);
        }
        if (reader == null) {
            return null;
        }
        return this.processHelp(CoreIOUtils.loadString(reader, true), loader, true, null);
    }

    private NutsText processHelp(String s, NutsTextFormatLoader classLoader, boolean vars, String anchor) {
        StringBuilder sb = new StringBuilder();
        if (s != null) {
            StringTokenizer st = new StringTokenizer(s, "\n\r", true);
            while (st.hasMoreElements()) {
                String e = st.nextToken();
                if (e.length() <= 0) continue;
                if (e.charAt(0) == '\n' || e.charAt(0) == '\r') {
                    sb.append(e);
                    continue;
                }
                if (e.startsWith("#!include<") && e.trim().endsWith(">")) {
                    e = e.trim();
                    e = e.substring("#!include<".length(), e.length() - 1);
                    NutsText other = null;
                    try {
                        other = this.parseResource(e, classLoader);
                    }
                    catch (Throwable t) {
                        other = this.session.getWorkspace().text().builder().append((Object)"NOT FOUND", NutsTextStyle.error()).append((Object)(" <" + e + ">")).toText();
                    }
                    sb.append(other);
                    continue;
                }
                sb.append(e);
            }
        }
        String help = sb.toString();
        if (vars) {
            help = StringPlaceHolderParser.replaceDollarPlaceHolders(help, this.pathExpansionConverter);
        }
        NutsText node = this.session.getWorkspace().text().parser().parse((Reader)new StringReader(help));
        if (anchor != null) {
            ArrayList<NutsText> ok = new ArrayList<NutsText>();
            boolean start = false;
            if (node.getType() == NutsTextType.LIST) {
                for (NutsText o : (NutsTextList)node) {
                    if (start) {
                        ok.add(o);
                        continue;
                    }
                    if (o.getType() != NutsTextType.ANCHOR || !anchor.equals(((DefaultNutsTextAnchor)o).getValue())) continue;
                    start = true;
                }
            }
            if (start) {
                node = this.session.getWorkspace().text().forList(ok).simplify();
            }
            return node;
        }
        return this.parser.parse((Reader)new StringReader(help));
    }

    private static class NutsTextFormatLoaderFile
    implements NutsTextFormatLoader {
        private final File root;

        public NutsTextFormatLoaderFile(File root) {
            this.root = root;
        }

        public Reader forPath(String path) {
            File r;
            File file = r = this.root == null ? new File(path) : new File(this.root, path);
            if (!r.isFile()) {
                return null;
            }
            try {
                return new FileReader(r);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static class NutsTextFormatLoaderClassPath
    implements NutsTextFormatLoader {
        private final ClassLoader loader;

        public NutsTextFormatLoaderClassPath(ClassLoader loader) {
            this.loader = loader;
        }

        public Reader forPath(String path) {
            URL r;
            ClassLoader classLoader = this.loader;
            if (classLoader == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            if ((r = classLoader.getResource(path)) == null && path.length() > 0 && path.startsWith("/")) {
                r = classLoader.getResource(path.substring(1));
            }
            if (r == null) {
                return null;
            }
            try {
                return new InputStreamReader(r.openStream());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

