/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.text.parser;

import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextVisitor;
import net.thevpc.nuts.NutsTextWriteConfiguration;
import net.thevpc.nuts.runtime.core.format.text.AbstractNutsTextNodeParser;
import net.thevpc.nuts.runtime.core.format.text.NutsTextNodeWriterStringer;
import net.thevpc.nuts.runtime.core.format.text.parser.steps.AntiQuote3ParserStep;
import net.thevpc.nuts.runtime.core.format.text.parser.steps.NewLineParserStep;
import net.thevpc.nuts.runtime.core.format.text.parser.steps.ParserStep;
import net.thevpc.nuts.runtime.core.format.text.parser.steps.PlainParserStep;
import net.thevpc.nuts.runtime.core.format.text.parser.steps.RootParserStep;
import net.thevpc.nuts.runtime.core.format.text.parser.steps.StyledParserStep;

public class DefaultNutsTextNodeParser
extends AbstractNutsTextNodeParser {
    private static final Logger LOG = Logger.getLogger(DefaultNutsTextNodeParser.class.getName());
    private State state = new State();

    public DefaultNutsTextNodeParser(NutsSession session) {
        super(session);
    }

    public static String escapeText0(String str) {
        if (str == null) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str.length());
        block3: for (char c : str.toCharArray()) {
            switch (c) {
                case '\u001e': 
                case '#': 
                case '\\': 
                case '`': {
                    sb.append('\\').append(c);
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public void reset() {
        this.state.reset();
    }

    public void write(char[] str) {
        this.write(str, 0, str.length);
    }

    public void write(char[] s, int offset, int len) {
        for (int i = offset; i < len; ++i) {
            this.write(s[i]);
        }
    }

    public void write(char s) {
        this.state().onNewChar(s);
    }

    public State state() {
        return this.state;
    }

    public String escapeText(String str) {
        return DefaultNutsTextNodeParser.escapeText0(str);
    }

    public String filterText(String text) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            NutsTextNodeWriterStringer s = new NutsTextNodeWriterStringer(out, this.getSession().getWorkspace());
            s.writeNode(this.parse(new StringReader(text)), new NutsTextWriteConfiguration().setFiltered(true));
            s.flush();
            return out.toString();
        }
        catch (Exception ex) {
            LOG.log(Level.FINEST, "error parsing : \n" + text, ex);
            return text;
        }
    }

    public long parseIncremental(byte[] buf, int off, int len, NutsTextVisitor visitor) {
        if (len == 0) {
            return 0L;
        }
        String raw = new String(buf, off, len);
        char[] c = raw.toCharArray();
        return this.parseIncremental(c, 0, c.length, visitor);
    }

    public long parseIncremental(char[] buf, int off, int len, NutsTextVisitor visitor) {
        if (len == 0) {
            return 0L;
        }
        this.write(buf, off, len);
        return this.state().consumeNodes(false, visitor);
    }

    public long parseRemaining(NutsTextVisitor visitor) {
        return this.state().consumeNodes(true, visitor);
    }

    public boolean isIncomplete() {
        return this.state().isIncomplete();
    }

    public String toString() {
        return "DefaultNutsTextNodeParser{" + this.state() + "}";
    }

    public class State {
        private Stack<ParserStep> statusStack = new Stack();
        private boolean lineMode = false;
        private boolean lineStart = true;

        public State() {
            this.statusStack.push(new RootParserStep(true, DefaultNutsTextNodeParser.this.getSession()));
        }

        public boolean isLineStart() {
            return this.lineStart;
        }

        public State setLineStart(boolean wasNewLine) {
            this.lineStart = wasNewLine;
            return this;
        }

        public boolean isSpreadLine() {
            return !this.lineStart;
        }

        public void applyPush(ParserStep r) {
            this.statusStack.push(r);
        }

        private void onNewChar(char c) {
            ParserStep st = this.statusStack.peek();
            boolean wasNewLine = false;
            if (st instanceof RootParserStep) {
                wasNewLine = ((RootParserStep)st).isEmpty();
            }
            st.consume(c, this, wasNewLine);
        }

        public ParserStep applyDrop() {
            return this.statusStack.pop();
        }

        public long consumeNodes(boolean greedy, NutsTextVisitor visitor) {
            long count = 0L;
            while (this.consumeNode(visitor) != null) {
                ++count;
            }
            if (greedy && this.forceEnding()) {
                while (this.consumeNode(visitor) != null) {
                    ++count;
                }
            }
            return count;
        }

        public ParserStep applyPop() {
            ParserStep tt = this.statusStack.pop();
            ParserStep parent = this.statusStack.peek();
            parent.appendChild(tt);
            return parent;
        }

        public void applyAppendSibling(ParserStep r) {
            int len = this.statusStack.size();
            ParserStep parent = (ParserStep)this.statusStack.elementAt(len - 2);
            parent.appendChild(r);
        }

        public void applyPopReplace(ParserStep r) {
            this.applyPop();
            this.statusStack.push(r);
        }

        public void applyDropReplacePreParsedPlain(String text, boolean exitOnBrace) {
            this.applyDropReplace(new PlainParserStep(text, this.lineStart, false, DefaultNutsTextNodeParser.this.session, DefaultNutsTextNodeParser.this.state, null, true, exitOnBrace));
        }

        public void applyDropReplace(ParserStep r) {
            ParserStep tt = this.statusStack.pop();
            this.statusStack.push(r);
        }

        public void applyNextChar(char c) {
            this.onNewChar(c);
        }

        public void applyPopReplay(char rejected) {
            ParserStep tt = this.statusStack.peek();
            ParserStep p = this.applyPop();
            boolean wasNewLine = tt instanceof NewLineParserStep;
            p.consume(rejected, this, wasNewLine);
        }

        public void applyPush(String c, boolean spreadLines, boolean lineStart, boolean exitOnBrace) {
            if (c.length() > 0) {
                this.applyPush(c.charAt(0), spreadLines, lineStart, exitOnBrace);
                for (int i = 1; i < c.length(); ++i) {
                    this.onNewChar(c.charAt(i));
                }
            }
        }

        public void applyPush(char c, boolean spreadLines, boolean lineStart, boolean exitOnBrace) {
            switch (c) {
                case '`': {
                    this.applyPush(new AntiQuote3ParserStep(c, spreadLines, DefaultNutsTextNodeParser.this.getSession(), exitOnBrace));
                    break;
                }
                case '#': {
                    this.applyPush(new StyledParserStep(c, lineStart, DefaultNutsTextNodeParser.this.getSession(), DefaultNutsTextNodeParser.this.state(), exitOnBrace));
                    break;
                }
                case '\u001e': {
                    break;
                }
                case '\n': 
                case '\r': {
                    this.applyPush(new NewLineParserStep(c, DefaultNutsTextNodeParser.this.getSession()));
                    if (!this.lineMode) break;
                    this.forceEnding();
                    break;
                }
                default: {
                    State state = DefaultNutsTextNodeParser.this.state();
                    this.applyPush(new PlainParserStep(c, lineStart, DefaultNutsTextNodeParser.this.getSession(), state, null, exitOnBrace));
                }
            }
        }

        public boolean isIncomplete() {
            if (this.root().isEmpty()) {
                return false;
            }
            ParserStep s = this.root().peek();
            if (s == null) {
                for (ParserStep parserStep : this.statusStack) {
                    if (parserStep.isComplete()) continue;
                    return true;
                }
                return false;
            }
            return false;
        }

        private RootParserStep root() {
            return (RootParserStep)this.statusStack.get(0);
        }

        public int size() {
            if (this.statusStack.isEmpty()) {
                return 0;
            }
            return this.statusStack.size() + this.root().size();
        }

        public boolean isEmpty() {
            return this.statusStack.isEmpty() || this.root().isEmpty();
        }

        public NutsText consumeFDocNode() {
            ParserStep s = this.root().poll();
            if (s == null) {
                return null;
            }
            return s.toText();
        }

        public NutsText consumeNode(NutsTextVisitor visitor) {
            ParserStep s = this.root().poll();
            if (s == null) {
                ParserStep s2;
                while (!this.statusStack.isEmpty() && !((s2 = this.statusStack.peek()) instanceof RootParserStep)) {
                    if (s2 != null && s2.isComplete()) {
                        ParserStep tt = this.statusStack.pop();
                        ParserStep parent = this.statusStack.peek();
                        parent.appendChild(tt);
                        continue;
                    }
                    if (s2 != null) break;
                    ParserStep parserStep = this.statusStack.pop();
                }
                s = this.root().poll();
            }
            if (s == null) {
                return null;
            }
            NutsText n = s.toText();
            if (visitor != null) {
                visitor.visit(n);
            }
            return n;
        }

        public boolean forceEnding() {
            ParserStep s;
            boolean ok = false;
            while (!((s = this.statusStack.peek()) instanceof RootParserStep)) {
                if (s != null) {
                    s.end(this);
                }
                ok = true;
            }
            return ok;
        }

        public String toString() {
            return "State{" + (this.isIncomplete() ? "incomplete" : (this.isEmpty() ? "empty" : String.valueOf(this.size()))) + (this.lineMode ? ",lineMode" : "") + "," + this.statusStack + "}";
        }

        public void reset() {
            this.statusStack.clear();
            this.lineMode = false;
            this.lineStart = true;
            this.statusStack.push(new RootParserStep(true, DefaultNutsTextNodeParser.this.getSession()));
        }
    }
}

