/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.text.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextList;
import net.thevpc.nuts.NutsTextPlain;
import net.thevpc.nuts.NutsTextType;
import net.thevpc.nuts.runtime.core.format.text.parser.AbstractNutsText;
import net.thevpc.nuts.runtime.core.format.text.parser.DefaultNutsTextPlain;

public class DefaultNutsTextList
extends AbstractNutsText
implements NutsTextList {
    private List<NutsText> children = new ArrayList<NutsText>();

    public DefaultNutsTextList(NutsSession session, NutsText ... children) {
        super(session);
        NutsTextPlain lastPlain = null;
        NutsTextPlain newPlain = null;
        if (children != null) {
            for (NutsText c : children) {
                if (c == null) continue;
                NutsTextPlain nutsTextPlain = newPlain = c instanceof NutsTextPlain ? (NutsTextPlain)c : null;
                if (lastPlain != null && newPlain != null) {
                    this.children.remove(this.children.size() - 1);
                    newPlain = new DefaultNutsTextPlain(session, lastPlain.getText() + newPlain.getText());
                    this.children.add((NutsText)newPlain);
                } else {
                    this.children.add(c);
                }
                lastPlain = newPlain;
            }
        }
    }

    public NutsText simplify() {
        if (this.isEmpty()) {
            return new DefaultNutsTextPlain(this.getSession(), "");
        }
        if (this.size() == 1) {
            return this.get(0);
        }
        return this;
    }

    @Override
    public boolean isEmpty() {
        for (NutsText child : this.children) {
            if (child.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public NutsTextType getType() {
        return NutsTextType.LIST;
    }

    public NutsText get(int index) {
        return this.children.get(index);
    }

    public int size() {
        return this.children.size();
    }

    public Iterator<NutsText> iterator() {
        return this.children.iterator();
    }
}

