/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.text.bloc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.thevpc.nuts.NutsCodeFormat;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSupportLevelContext;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextManager;
import net.thevpc.nuts.NutsTextPlain;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextStyled;
import net.thevpc.nuts.NutsTextType;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.parsers.StringReaderExt;
import net.thevpc.nuts.runtime.core.format.text.bloc.StringReaderExtUtils;
import net.thevpc.nuts.runtime.core.format.text.parser.DefaultNutsTextPlain;
import net.thevpc.nuts.runtime.core.format.text.parser.DefaultNutsTextStyled;

public class ShellBlocTextFormatter
implements NutsCodeFormat {
    private NutsWorkspace ws;
    private NutsTextManager factory;

    public ShellBlocTextFormatter(NutsWorkspace ws) {
        this.ws = ws;
        this.factory = ws.text();
    }

    public int getSupportLevel(NutsSupportLevelContext<String> criteria) {
        String s = (String)criteria.getConstraints();
        return "sh".equals(s) ? 10 : -1;
    }

    public NutsText tokenToText(String text, String nodeType, NutsSession session) {
        this.factory.setSession(session);
        return this.factory.forPlain(text);
    }

    private NutsText[] parseCommandLine_readSimpleQuotes(StringReaderExt ar, NutsSession session) {
        StringBuilder sb = new StringBuilder();
        sb.append(ar.nextChar());
        ArrayList<NutsTextStyled> ret = new ArrayList<NutsTextStyled>();
        while (ar.hasNext()) {
            char c = ar.peekChar();
            if (c == '\\') {
                StringBuilder sb2 = new StringBuilder();
                sb2.append(ar.nextChar());
                if (sb.length() > 0) {
                    ret.add(this.factory.forStyled(sb.toString(), NutsTextStyle.string((int)2)));
                    sb.setLength(0);
                }
                if (ar.hasNext()) {
                    sb2.append(ar.nextChar());
                }
                ret.add(this.factory.forStyled(sb2.toString(), NutsTextStyle.separator()));
                break;
            }
            if (c == '\'') {
                sb.append(ar.nextChar());
                break;
            }
            sb.append(ar.nextChar());
        }
        if (sb.length() > 0) {
            ret.add(this.factory.forStyled(sb.toString(), NutsTextStyle.string((int)2)));
            sb.setLength(0);
        }
        return ret.toArray(new NutsText[0]);
    }

    private NutsText[] parseCommandLine_readWord(StringReaderExt ar, NutsSession session) {
        StringBuilder sb = new StringBuilder();
        ArrayList<Object> ret = new ArrayList<Object>();
        boolean inLoop = true;
        boolean endsWithSep = false;
        block6: while (inLoop && ar.hasNext()) {
            char c = ar.peekChar();
            switch (c) {
                case '\\': {
                    if (sb.length() > 0) {
                        ret.add(this.factory.forPlain(sb.toString()));
                        sb.setLength(0);
                    }
                    ret.addAll(Arrays.asList(ShellBlocTextFormatter.parseCommandLine_readAntiSlash(ar, session)));
                    continue block6;
                }
                case ';': {
                    endsWithSep = true;
                    inLoop = false;
                    continue block6;
                }
                case ':': {
                    endsWithSep = true;
                    inLoop = false;
                    continue block6;
                }
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case ']': 
                case '`': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    inLoop = false;
                    continue block6;
                }
            }
            if (c <= ' ') {
                endsWithSep = true;
                inLoop = false;
                continue;
            }
            sb.append(ar.nextChar());
        }
        if (sb.length() > 0) {
            ret.add(this.factory.forPlain(sb.toString()));
            sb.setLength(0);
        }
        if (ret.isEmpty()) {
            throw new IllegalArgumentException("was not expecting " + ar.peekChar() + " as part of word");
        }
        if (((NutsText)ret.get(0)).getType() == NutsTextType.PLAIN && ShellBlocTextFormatter.isOption(((NutsTextPlain)ret.get(0)).getText())) {
            ret.set(0, this.factory.forStyled((NutsText)ret.get(0), NutsTextStyle.option()));
        }
        return ret.toArray(new NutsText[0]);
    }

    private static NutsText[] parseCommandLine_readAntiSlash(StringReaderExt ar, NutsSession session) {
        StringBuilder sb2 = new StringBuilder();
        sb2.append(ar.nextChar());
        if (ar.hasNext()) {
            sb2.append(ar.nextChar());
        }
        NutsTextManager factory = session.getWorkspace().text();
        return new NutsText[]{factory.forStyled(sb2.toString(), NutsTextStyle.separator())};
    }

    private NutsText[] parseCommandLine_readDollar(StringReaderExt ar, NutsSession session) {
        char c;
        if (ar.peekChars("$((")) {
            return this.parseCommandLine_readDollarPar2(ar, session);
        }
        StringBuilder sb2 = new StringBuilder();
        if (ar.hasNext(1)) {
            switch (ar.peekChar(1)) {
                case '(': {
                    return this.parseCommandLine_readDollarPar2(ar, session);
                }
                case '{': {
                    return this.parseCommandLine_readDollarCurlyBrackets(ar, session);
                }
                case '*': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case '?': 
                case '@': {
                    sb2.append(ar.nextChar());
                    sb2.append(ar.nextChar());
                    return new NutsText[]{this.factory.forStyled(sb2.toString(), NutsTextStyle.separator())};
                }
            }
        }
        ar.nextChar();
        while (ar.hasNext() && (Character.isAlphabetic(c = ar.peekChar()) || Character.isDigit(c) || c == '_')) {
            sb2.append(ar.nextChar());
        }
        if (sb2.length() > 0) {
            return new NutsText[]{this.factory.forStyled("$", NutsTextStyle.separator()), this.factory.forStyled(sb2.toString(), NutsTextStyle.keyword((int)4))};
        }
        return new NutsText[]{this.factory.forStyled("$", NutsTextStyle.separator())};
    }

    private NutsText[] parseCommandLine_readDoubleQuotes(StringReaderExt ar, NutsSession session) {
        ArrayList<Object> ret = new ArrayList<Object>();
        this.factory.setSession(session);
        StringBuilder sb = new StringBuilder();
        ret.add(this.factory.forStyled(String.valueOf(ar.nextChar()), NutsTextStyle.string()));
        while (ar.hasNext()) {
            char c = ar.peekChar();
            if (c == '\\') {
                if (sb.length() > 0) {
                    ret.add(this.factory.forStyled(sb.toString(), NutsTextStyle.string()));
                    sb.setLength(0);
                }
                ret.addAll(Arrays.asList(ShellBlocTextFormatter.parseCommandLine_readAntiSlash(ar, session)));
                continue;
            }
            if (c == '$') {
                if (sb.length() > 0) {
                    ret.add(this.factory.forStyled(sb.toString(), NutsTextStyle.string()));
                    sb.setLength(0);
                }
                ret.addAll(Arrays.asList(this.parseCommandLine_readDollar(ar, session)));
                continue;
            }
            if (c == '\"') {
                if (sb.length() > 0) {
                    ret.add(this.factory.forStyled(sb.toString(), NutsTextStyle.string()));
                    sb.setLength(0);
                }
                ret.add(this.factory.forStyled(String.valueOf(ar.nextChar()), NutsTextStyle.string()));
                break;
            }
            sb.append(ar.nextChar());
        }
        if (sb.length() > 0) {
            ret.add(this.factory.forStyled(sb.toString(), NutsTextStyle.string()));
            sb.setLength(0);
        }
        return ret.toArray(new NutsText[0]);
    }

    private static boolean isWord(NutsText n) {
        return n instanceof DefaultNutsTextPlain && Character.isAlphabetic(((DefaultNutsTextPlain)n).getText().charAt(0));
    }

    private static boolean isSeparator(NutsText n) {
        NutsText v;
        if (n instanceof DefaultNutsTextStyled && (v = ((DefaultNutsTextStyled)n).getChild()) instanceof DefaultNutsTextPlain) {
            String t = ((DefaultNutsTextPlain)v).getText();
            switch (t.charAt(0)) {
                case '&': 
                case ';': 
                case '|': {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isWhites(NutsText n) {
        return n instanceof DefaultNutsTextPlain && Character.isWhitespace(((DefaultNutsTextPlain)n).getText().charAt(0));
    }

    private static int indexOfFirstWord(List<NutsText> all, int from) {
        for (int i = from; i < all.size(); ++i) {
            NutsText n = all.get(i);
            if (!ShellBlocTextFormatter.isWord(n) || i != all.size() - 1 && !ShellBlocTextFormatter.isWhites(all.get(i + 1)) && !ShellBlocTextFormatter.isSeparator(all.get(i + 1))) continue;
            return i;
        }
        return -1;
    }

    private NutsText[] parseCommandLine_readAntiQuotes(StringReaderExt ar, NutsSession session) {
        ArrayList<NutsText> all = new ArrayList<NutsText>();
        this.factory.setSession(session);
        all.add((NutsText)this.factory.forStyled(String.valueOf(ar.nextChar()), NutsTextStyle.separator()));
        boolean inLoop = true;
        boolean wasSpace = true;
        block3: while (inLoop && ar.hasNext()) {
            char c = ar.peekChar();
            switch (c) {
                case '`': {
                    wasSpace = false;
                    all.add((NutsText)this.factory.forStyled(String.valueOf(ar.nextChar()), NutsTextStyle.separator()));
                    inLoop = false;
                    continue block3;
                }
            }
            wasSpace = this.parseCommandLineStep(ar, all, 1, wasSpace, session);
        }
        return all.toArray(new NutsText[0]);
    }

    private NutsText[] parseCommandLine_readDollarPar(NutsWorkspace ws, StringReaderExt ar, NutsSession session) {
        ArrayList<NutsText> all = new ArrayList<NutsText>();
        this.factory.setSession(session);
        all.add((NutsText)this.factory.forStyled(String.valueOf(ar.nextChar()) + ar.nextChar(), NutsTextStyle.separator()));
        boolean inLoop = true;
        boolean wasSpace = false;
        block3: while (inLoop && ar.hasNext()) {
            char c = ar.peekChar();
            switch (c) {
                case ')': {
                    all.add((NutsText)this.factory.forStyled(String.valueOf(ar.nextChar()), NutsTextStyle.separator()));
                    inLoop = false;
                    continue block3;
                }
            }
            wasSpace = this.parseCommandLineStep(ar, all, 2, wasSpace, session);
        }
        return all.toArray(new NutsText[0]);
    }

    private NutsText[] parseCommandLine_readDollarPar2(StringReaderExt ar, NutsSession session) {
        ArrayList<NutsText> all = new ArrayList<NutsText>();
        this.factory.setSession(session);
        all.add((NutsText)this.factory.forStyled(String.valueOf(ar.nextChar()) + ar.nextChar() + ar.nextChar(), NutsTextStyle.separator()));
        boolean inLoop = true;
        boolean wasSpace = true;
        block4: while (inLoop && ar.hasNext()) {
            char c = ar.peekChar();
            switch (c) {
                case '%': 
                case '*': 
                case '+': 
                case '-': 
                case '/': {
                    wasSpace = false;
                    all.add((NutsText)this.factory.forStyled(String.valueOf(ar.nextChars(2)), NutsTextStyle.operator()));
                    continue block4;
                }
                case ')': {
                    if (ar.peekChars(2).equals("))")) {
                        wasSpace = false;
                        all.add((NutsText)this.factory.forStyled(String.valueOf(ar.nextChars(2)), NutsTextStyle.separator()));
                        inLoop = false;
                        continue block4;
                    }
                    wasSpace = this.parseCommandLineStep(ar, all, 2, wasSpace, session);
                    continue block4;
                }
            }
            wasSpace = this.parseCommandLineStep(ar, all, 2, wasSpace, session);
        }
        return all.toArray(new NutsText[0]);
    }

    private NutsText[] parseCommandLine_readDollarCurlyBrackets(StringReaderExt ar, NutsSession session) {
        ArrayList<NutsText> all = new ArrayList<NutsText>();
        this.factory.setSession(session);
        all.add((NutsText)this.factory.forStyled(String.valueOf(ar.nextChar()) + ar.nextChar(), NutsTextStyle.separator()));
        boolean inLoop = true;
        int startIndex = 0;
        boolean expectedName = true;
        boolean wasSpace = true;
        block3: while (inLoop && ar.hasNext()) {
            char c = ar.peekChar();
            switch (c) {
                case '}': {
                    all.add((NutsText)this.factory.forStyled(String.valueOf(ar.nextChar()), NutsTextStyle.separator()));
                    inLoop = false;
                    continue block3;
                }
            }
            startIndex = all.size();
            wasSpace = this.parseCommandLineStep(ar, all, -1, wasSpace, session);
            if (!expectedName) continue;
            expectedName = false;
            if (all.size() <= startIndex || !ShellBlocTextFormatter.isWord((NutsText)all.get(startIndex))) continue;
            all.set(startIndex, (NutsText)this.factory.forStyled((NutsText)all.get(startIndex), NutsTextStyle.keyword((int)4)));
            wasSpace = false;
        }
        return all.toArray(new NutsText[0]);
    }

    private NutsText[] parseCommandLine_readPar2(StringReaderExt ar, NutsSession session) {
        ArrayList<NutsText> all = new ArrayList<NutsText>();
        this.factory.setSession(session);
        all.add((NutsText)this.factory.forStyled(String.valueOf(ar.nextChar()) + ar.nextChar(), NutsTextStyle.separator()));
        boolean inLoop = true;
        boolean wasSpace = true;
        block3: while (inLoop && ar.hasNext()) {
            char c = ar.peekChar();
            switch (c) {
                case ')': {
                    if (ar.peekChars(2).equals("))")) {
                        all.add((NutsText)this.factory.forStyled(String.valueOf(ar.nextChars(2)), NutsTextStyle.separator()));
                        inLoop = false;
                        continue block3;
                    }
                    wasSpace = this.parseCommandLineStep(ar, all, 2, wasSpace, session);
                    continue block3;
                }
            }
            wasSpace = this.parseCommandLineStep(ar, all, 2, wasSpace, session);
        }
        return all.toArray(new NutsText[0]);
    }

    private boolean parseCommandLineStep(StringReaderExt ar, List<NutsText> all, int startIndex, boolean wasSpace, NutsSession session) {
        char c = ar.peekChar();
        if (c <= ' ') {
            all.addAll(Arrays.asList(StringReaderExtUtils.readSpaces(session, ar)));
            return true;
        }
        switch (c) {
            case '\'': {
                all.addAll(Arrays.asList(this.parseCommandLine_readSimpleQuotes(ar, session)));
                break;
            }
            case '`': {
                all.addAll(Arrays.asList(this.parseCommandLine_readAntiQuotes(ar, session)));
                break;
            }
            case '\"': {
                all.addAll(Arrays.asList(this.parseCommandLine_readDoubleQuotes(ar, session)));
                break;
            }
            case '$': {
                all.addAll(Arrays.asList(this.parseCommandLine_readDollar(ar, session)));
                break;
            }
            case ';': {
                all.add((NutsText)this.factory.forStyled(String.valueOf(ar.nextChar()), NutsTextStyle.separator()));
                break;
            }
            case ':': {
                all.add((NutsText)this.factory.forStyled(String.valueOf(ar.nextChar()), NutsTextStyle.separator((int)2)));
                break;
            }
            case '|': {
                if (ar.peekChars(2).equals("||")) {
                    all.add((NutsText)this.factory.forStyled(ar.nextChars(2), NutsTextStyle.separator()));
                    break;
                }
                all.add((NutsText)this.factory.forStyled(String.valueOf(ar.nextChar()), NutsTextStyle.separator()));
                break;
            }
            case '&': {
                if (ar.peekChars(2).equals("&&")) {
                    all.add((NutsText)this.factory.forStyled(ar.nextChars(2), NutsTextStyle.separator()));
                    break;
                }
                if (ar.peekChars(3).equals("&>>")) {
                    all.add((NutsText)this.factory.forStyled(ar.nextChars(3), NutsTextStyle.separator()));
                    break;
                }
                if (ar.peekChars(2).equals("&>")) {
                    all.add((NutsText)this.factory.forStyled(ar.nextChars(2), NutsTextStyle.separator()));
                    break;
                }
                all.add((NutsText)this.factory.forStyled(String.valueOf(ar.nextChar()), NutsTextStyle.separator()));
                break;
            }
            case '>': {
                if (ar.peekChars(2).equals(">>")) {
                    all.add((NutsText)this.factory.forStyled(ar.nextChars(2), NutsTextStyle.separator()));
                    break;
                }
                if (ar.peekChars(2).equals(">&")) {
                    all.add((NutsText)this.factory.forStyled(ar.nextChars(2), NutsTextStyle.separator()));
                    break;
                }
                all.add((NutsText)this.factory.forStyled(String.valueOf(ar.nextChar()), NutsTextStyle.separator()));
                break;
            }
            case '<': {
                if (ar.peekChars(2).equals("<<")) {
                    all.add((NutsText)this.factory.forStyled(ar.nextChars(2), NutsTextStyle.separator()));
                    break;
                }
                StringBuilder sb = new StringBuilder();
                sb.append(ar.peekChar(0));
                boolean ok = true;
                int i = 1;
                while (ok && ar.isAvailable(i)) {
                    char c1 = ar.peekChar(i);
                    if (c1 == '>') {
                        sb.append(c1);
                        break;
                    }
                    if (c1 == '-' || c1 == '+' || Character.isAlphabetic(c1)) {
                        sb.append(c1);
                    } else {
                        ok = false;
                    }
                    ++i;
                }
                if (sb.charAt(sb.length() - 1) != '>') {
                    ok = false;
                }
                if (ok) {
                    String s = ar.nextChars(sb.length());
                    String s0 = s.substring(1, s.length() - 1);
                    if (ShellBlocTextFormatter.isSynopsysOption(s0)) {
                        all.add((NutsText)this.factory.forStyled("<", NutsTextStyle.input()));
                        all.add((NutsText)this.factory.forStyled(s0, NutsTextStyle.option()));
                        all.add((NutsText)this.factory.forStyled(">", NutsTextStyle.input()));
                        break;
                    }
                    if (ShellBlocTextFormatter.isSynopsysWord(s0)) {
                        all.add((NutsText)this.factory.forStyled("<", NutsTextStyle.input()));
                        all.add((NutsText)this.factory.forStyled(s0, NutsTextStyle.input()));
                        all.add((NutsText)this.factory.forStyled(">", NutsTextStyle.input()));
                        break;
                    }
                    all.add((NutsText)this.factory.forStyled(String.valueOf(ar.nextChar()), NutsTextStyle.separator()));
                    break;
                }
                all.add((NutsText)this.factory.forStyled(String.valueOf(ar.nextChar()), NutsTextStyle.separator()));
                break;
            }
            case '(': {
                if (ar.peekChars("((")) {
                    all.addAll(Arrays.asList(this.parseCommandLine_readPar2(ar, session)));
                } else {
                    all.add((NutsText)this.factory.forStyled(String.valueOf(ar.nextChar()), NutsTextStyle.separator()));
                }
            }
            case '!': 
            case ')': 
            case '{': 
            case '}': 
            case '~': {
                all.add((NutsText)this.factory.forStyled(String.valueOf(ar.nextChar()), NutsTextStyle.separator()));
                break;
            }
            case '*': 
            case '=': 
            case '?': 
            case '[': 
            case ']': {
                all.add((NutsText)this.factory.forStyled(String.valueOf(ar.nextChar()), NutsTextStyle.separator()));
                break;
            }
            case '#': {
                if (wasSpace) {
                    StringBuilder sb = new StringBuilder();
                    while (ar.hasNext() && (c = ar.peekChar()) != '\n' && c != '\r') {
                        sb.append(ar.nextChar());
                    }
                    all.add((NutsText)this.factory.forStyled(sb.toString(), NutsTextStyle.comments()));
                    break;
                }
                all.add((NutsText)this.factory.forStyled(String.valueOf(ar.nextChar()), NutsTextStyle.separator()));
                break;
            }
            default: {
                if (startIndex >= 0) {
                    int i;
                    boolean first = all.size() == startIndex;
                    all.addAll(Arrays.asList(this.parseCommandLine_readWord(ar, session)));
                    if (!first || (i = ShellBlocTextFormatter.indexOfFirstWord(all, startIndex)) < 0) break;
                    all.set(i, (NutsText)this.factory.forStyled(all.get(i), NutsTextStyle.keyword()));
                    break;
                }
                all.addAll(Arrays.asList(this.parseCommandLine_readWord(ar, session)));
            }
        }
        return false;
    }

    private NutsText[] parseCommandLine(String commandLineString, NutsSession session) {
        StringReaderExt ar = new StringReaderExt(commandLineString);
        ArrayList<NutsText> all = new ArrayList<NutsText>();
        boolean wasSpace = true;
        while (ar.hasNext()) {
            wasSpace = this.parseCommandLineStep(ar, all, 0, wasSpace, session);
        }
        return all.toArray(new NutsText[0]);
    }

    private static boolean isSynopsysOption(String s2) {
        return s2.startsWith("--") && ShellBlocTextFormatter.isSynopsysWord(s2.substring(2)) || s2.startsWith("++") && ShellBlocTextFormatter.isSynopsysWord(s2.substring(2)) || s2.startsWith("-") && ShellBlocTextFormatter.isSynopsysWord(s2.substring(1)) || s2.startsWith("+") && ShellBlocTextFormatter.isSynopsysWord(s2.substring(1)) || s2.startsWith("--!") && ShellBlocTextFormatter.isSynopsysWord(s2.substring(3)) || s2.startsWith("++!") && ShellBlocTextFormatter.isSynopsysWord(s2.substring(3)) || s2.startsWith("-!") && ShellBlocTextFormatter.isSynopsysWord(s2.substring(2)) || s2.startsWith("+!") && ShellBlocTextFormatter.isSynopsysWord(s2.substring(2)) || s2.startsWith("--~") && ShellBlocTextFormatter.isSynopsysWord(s2.substring(3)) || s2.startsWith("++~") && ShellBlocTextFormatter.isSynopsysWord(s2.substring(3)) || s2.startsWith("-~") && ShellBlocTextFormatter.isSynopsysWord(s2.substring(2)) || s2.startsWith("+~") && ShellBlocTextFormatter.isSynopsysWord(s2.substring(2));
    }

    private static boolean isOption(String s2) {
        return s2.startsWith("-") || s2.startsWith("+");
    }

    private static boolean isSynopsysWord(String s) {
        if (s.length() > 0) {
            if (!Character.isAlphabetic(s.charAt(0))) {
                return false;
            }
            if (!Character.isAlphabetic(s.charAt(0))) {
                return false;
            }
            for (int i = 0; i < s.length(); ++i) {
                if (Character.isAlphabetic(s.charAt(i))) continue;
                if (s.charAt(i) == '-') {
                    if (s.charAt(i - 1) != '-') continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return true;
    }

    public NutsText stringToText(String text, NutsSession session) {
        this.factory.setSession(session);
        ArrayList<Object> all = new ArrayList<Object>();
        BufferedReader reader = new BufferedReader(new StringReader(text));
        String line = null;
        boolean first = true;
        while (true) {
            try {
                line = reader.readLine();
                if (line == null) {
                    break;
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            if (first) {
                first = false;
            } else {
                all.add(this.factory.forPlain("\n"));
            }
            all.add(this.commandToNode(line, session));
        }
        return this.factory.forList(all).simplify();
    }

    public NutsText next(StringReaderExt reader, boolean exitOnClosedCurlBrace, boolean exitOnClosedPar, boolean exitOnDblQuote, boolean exitOnAntiQuote) {
        boolean lineStart = true;
        ArrayList<Object> all = new ArrayList<Object>();
        NutsTextManager factory = this.ws.text();
        boolean exit = false;
        block47: while (!exit && reader.hasNext()) {
            switch (reader.peekChar()) {
                case '}': {
                    lineStart = false;
                    if (exitOnClosedCurlBrace) {
                        exit = true;
                        continue block47;
                    }
                    all.add(factory.forStyled(reader.nextChars(1), NutsTextStyle.separator()));
                    continue block47;
                }
                case ')': {
                    lineStart = false;
                    if (exitOnClosedPar) {
                        exit = true;
                        continue block47;
                    }
                    all.add(factory.forStyled(reader.nextChars(1), NutsTextStyle.separator()));
                    continue block47;
                }
                case '>': {
                    lineStart = false;
                    if (reader.isAvailable(2) && reader.peekChar() == '>') {
                        all.add(factory.forStyled(reader.nextChars(2), NutsTextStyle.separator()));
                        continue block47;
                    }
                    all.add(factory.forStyled(reader.nextChars(1), NutsTextStyle.separator()));
                    continue block47;
                }
                case '&': {
                    lineStart = false;
                    if (reader.isAvailable(2) && reader.peekChar() == '&') {
                        all.add(factory.forStyled(reader.nextChars(2), NutsTextStyle.separator()));
                        continue block47;
                    }
                    if (reader.isAvailable(2) && reader.peekChar() == '>') {
                        all.add(factory.forStyled(reader.nextChars(2), NutsTextStyle.separator()));
                        continue block47;
                    }
                    if (reader.isAvailable(2) && reader.peekChar() == '<') {
                        all.add(factory.forStyled(reader.nextChars(2), NutsTextStyle.separator()));
                        continue block47;
                    }
                    all.add(factory.forStyled(reader.nextChars(1), NutsTextStyle.separator()));
                    continue block47;
                }
                case '|': {
                    lineStart = false;
                    if (reader.isAvailable(2) && reader.peekChar() == '|') {
                        all.add(factory.forStyled(reader.nextChars(2), NutsTextStyle.separator()));
                        continue block47;
                    }
                    all.add(factory.forStyled(reader.nextChars(1), NutsTextStyle.separator()));
                    continue block47;
                }
                case ';': {
                    all.add(factory.forStyled(reader.nextChars(1), NutsTextStyle.separator()));
                    lineStart = true;
                    continue block47;
                }
                case '\n': {
                    if (reader.isAvailable(2) && reader.peekChar() == '\r') {
                        all.add(factory.forStyled(reader.nextChars(2), NutsTextStyle.separator()));
                    } else {
                        all.add(factory.forStyled(reader.nextChars(1), NutsTextStyle.separator()));
                    }
                    lineStart = true;
                    continue block47;
                }
                case '<': {
                    lineStart = false;
                    StringBuilder sb = new StringBuilder();
                    if (reader.isAvailable(3)) {
                        int index = 0;
                        sb.append(reader.peekChar(index));
                        ++index;
                        boolean ok = false;
                        while (reader.isAvailable(index)) {
                            char c = reader.peekChar(index);
                            if (c == '>') {
                                sb.append(c);
                                ok = true;
                                break;
                            }
                            if (!Character.isAlphabetic(c) && c != '-') break;
                            sb.append(c);
                            ++index;
                        }
                        if (ok) {
                            reader.nextChars(sb.length());
                            all.add(factory.forStyled(sb.toString(), NutsTextStyle.input()));
                            continue block47;
                        }
                        all.add(factory.forStyled(reader.nextChars(1), NutsTextStyle.separator()));
                        continue block47;
                    }
                    if (reader.isAvailable(2) && reader.peekChar() == '<') {
                        all.add(factory.forStyled(reader.nextChars(2), NutsTextStyle.separator()));
                        continue block47;
                    }
                    all.add(factory.forStyled(reader.nextChars(1), NutsTextStyle.separator()));
                    continue block47;
                }
                case '\\': {
                    lineStart = false;
                    all.add(factory.forStyled(reader.nextChars(2), NutsTextStyle.separator((int)2)));
                    continue block47;
                }
                case '\"': {
                    lineStart = false;
                    all.add(this.nextDoubleQuotes(reader));
                    continue block47;
                }
                case '`': {
                    lineStart = false;
                    if (exitOnAntiQuote) {
                        exit = true;
                        continue block47;
                    }
                    ArrayList<Object> a = new ArrayList<Object>();
                    a.add(factory.forStyled(reader.nextChars(1), NutsTextStyle.string()));
                    a.add(this.next(reader, false, false, false, true));
                    if (reader.hasNext() && reader.peekChar() == '`') {
                        a.add(factory.forStyled(reader.nextChars(1), NutsTextStyle.string()));
                    } else {
                        exit = true;
                    }
                    all.add(factory.forList(a).simplify());
                    continue block47;
                }
                case '\'': {
                    lineStart = false;
                    StringBuilder sb = new StringBuilder();
                    sb.append(reader.nextChar());
                    boolean end = false;
                    block49: while (!end && reader.hasNext()) {
                        switch (reader.peekChar()) {
                            case '\\': {
                                sb.append(reader.nextChars(2));
                                continue block49;
                            }
                            case '\'': {
                                sb.append(reader.nextChar());
                                end = true;
                                continue block49;
                            }
                        }
                        sb.append(reader.nextChar());
                    }
                    all.add(factory.forStyled(sb.toString(), NutsTextStyle.string()));
                    continue block47;
                }
                case '$': {
                    lineStart = false;
                    if (reader.isAvailable(2)) {
                        char c = reader.peekChar(1);
                        switch (c) {
                            case '(': {
                                continue block47;
                            }
                            case '{': {
                                continue block47;
                            }
                            case '$': 
                            case '*': 
                            case '-': 
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': 
                            case '?': 
                            case '@': {
                                all.add(factory.forStyled(reader.nextChars(2), NutsTextStyle.string()));
                                continue block47;
                            }
                        }
                        if (Character.isAlphabetic(reader.peekChar(1))) {
                            StringBuilder sb = new StringBuilder();
                            sb.append(reader.nextChar());
                            while (reader.hasNext() && (Character.isAlphabetic(reader.peekChar()) || reader.peekChar() == '_')) {
                                sb.append(reader.nextChar());
                            }
                            all.add(factory.forStyled(sb.toString(), NutsTextStyle.variable()));
                            continue block47;
                        }
                        all.add(factory.forStyled(reader.nextChars(1), NutsTextStyle.separator()));
                        continue block47;
                    }
                    all.add(factory.forStyled(reader.nextChars(1), NutsTextStyle.string()));
                    continue block47;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\t': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': 
                case '!': {
                    StringBuilder whites = new StringBuilder();
                    while (reader.hasNext() && Character.isWhitespace(reader.peekChar())) {
                        whites.append(reader.nextChar());
                    }
                    all.add(factory.forPlain(whites.toString()));
                    continue block47;
                }
            }
            StringBuilder sb = new StringBuilder();
            sb.append(reader.nextChar());
            while (reader.hasNext()) {
                char c2 = reader.peekChar();
                boolean accept = true;
                switch (c2) {
                    case '$': 
                    case '&': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case '<': 
                    case '>': 
                    case '?': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '{': 
                    case '|': 
                    case '}': {
                        accept = false;
                        break;
                    }
                    default: {
                        if (c2 <= ' ') {
                            accept = false;
                            break;
                        }
                        sb.append(reader.nextChar());
                    }
                }
                if (accept) continue;
                break;
            }
            if (lineStart && !reader.hasNext() || Character.isWhitespace(reader.peekChar())) {
                NutsTextStyle keyword1 = NutsTextStyle.keyword((int)2);
                switch (sb.toString()) {
                    case "if": 
                    case "while": 
                    case "do": 
                    case "fi": 
                    case "elif": 
                    case "then": 
                    case "else": {
                        keyword1 = NutsTextStyle.keyword();
                        break;
                    }
                    case "cp": 
                    case "ls": 
                    case "ll": 
                    case "rm": 
                    case "pwd": 
                    case "echo": {
                        keyword1 = NutsTextStyle.keyword((int)3);
                    }
                }
                all.add(factory.forStyled(sb.toString(), keyword1));
            } else {
                all.add(factory.forPlain(sb.toString()));
            }
            lineStart = false;
        }
        return factory.forList(all).simplify();
    }

    private NutsText nextDollar(StringReaderExt reader) {
        NutsTextManager factory = this.ws.text();
        if (reader.isAvailable(2)) {
            char c = reader.peekChar(1);
            switch (c) {
                case '(': {
                    ArrayList<Object> a = new ArrayList<Object>();
                    a.add(factory.forStyled(reader.nextChars(1), NutsTextStyle.separator()));
                    a.add(this.next(reader, false, true, false, false));
                    if (reader.hasNext() && reader.peekChar() == ')') {
                        a.add(factory.forStyled(reader.nextChars(1), NutsTextStyle.separator()));
                    }
                    return factory.forList(a).simplify();
                }
                case '{': {
                    ArrayList<Object> a = new ArrayList<Object>();
                    a.add(factory.forStyled(reader.nextChars(1), NutsTextStyle.separator()));
                    a.add(this.next(reader, true, false, false, false));
                    if (reader.hasNext() && reader.peekChar() == ')') {
                        a.add(factory.forStyled(reader.nextChars(1), NutsTextStyle.separator()));
                    }
                    return factory.forList(a).simplify();
                }
                case '$': 
                case '*': 
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case '?': 
                case '@': {
                    return factory.forStyled(reader.nextChars(2), NutsTextStyle.string());
                }
            }
            if (Character.isAlphabetic(reader.peekChar(1))) {
                StringBuilder sb = new StringBuilder();
                sb.append(reader.nextChar());
                while (reader.hasNext() && (Character.isAlphabetic(reader.peekChar()) || reader.peekChar() == '_')) {
                    sb.append(reader.nextChar());
                }
                return factory.forStyled(sb.toString(), NutsTextStyle.variable());
            }
            return factory.forStyled(reader.nextChars(1), NutsTextStyle.separator());
        }
        return factory.forStyled(reader.nextChars(1), NutsTextStyle.string());
    }

    public NutsText nextDoubleQuotes(StringReaderExt reader) {
        ArrayList<Object> all = new ArrayList<Object>();
        NutsTextManager factory = this.ws.text();
        boolean exit = false;
        StringBuilder sb = new StringBuilder();
        sb.append(reader.nextChar());
        block6: while (!exit && reader.hasNext()) {
            switch (reader.peekChar()) {
                case '\\': {
                    sb.append(reader.nextChars(2));
                    continue block6;
                }
                case '\"': {
                    sb.append(reader.nextChars(1));
                    exit = true;
                    continue block6;
                }
                case '$': {
                    if (sb.length() > 0) {
                        all.add(factory.forStyled(sb.toString(), NutsTextStyle.string()));
                        sb.setLength(0);
                    }
                    all.add(this.nextDollar(reader));
                }
                case '`': {
                    if (sb.length() > 0) {
                        all.add(factory.forStyled(sb.toString(), NutsTextStyle.string()));
                        sb.setLength(0);
                    }
                    ArrayList<Object> a = new ArrayList<Object>();
                    a.add(factory.forStyled(reader.nextChars(1), NutsTextStyle.string()));
                    a.add(this.next(reader, false, false, false, true));
                    if (reader.hasNext() && reader.peekChar() == '`') {
                        a.add(factory.forStyled(reader.nextChars(1), NutsTextStyle.string()));
                    } else {
                        exit = true;
                    }
                    all.add(factory.forList(a).simplify());
                    continue block6;
                }
            }
            sb.append(reader.nextChars(1));
        }
        if (sb.length() > 0) {
            all.add(factory.forStyled(sb.toString(), NutsTextStyle.string()));
            sb.setLength(0);
        }
        return factory.forList(all).simplify();
    }

    public NutsText commandToNode(String text, NutsSession session) {
        this.factory.setSession(session);
        return this.factory.forList(this.parseCommandLine(text, session));
    }
}

