/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.text;

import java.io.IOException;
import java.io.OutputStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.NutsTextManager;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.format.text.ExtendedFormatAware;
import net.thevpc.nuts.runtime.core.format.text.FormatOutputStream;
import net.thevpc.nuts.runtime.core.format.text.RawOutputStream;
import net.thevpc.nuts.runtime.core.io.BaseTransparentFilterOutputStream;
import net.thevpc.nuts.runtime.core.terminals.NutsTerminalModeOp;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;

public class UnescapeOutputStream
extends BaseTransparentFilterOutputStream
implements ExtendedFormatAware {
    private NutsSession session;
    private NutsWorkspace ws;

    public UnescapeOutputStream(OutputStream out, NutsSession session) {
        super(out);
        this.session = session;
        this.ws = session.getWorkspace();
        NutsTerminalModeOp t = CoreIOUtils.resolveNutsTerminalModeOp(out);
        if (t.in() != NutsTerminalMode.FORMATTED && t.in() != NutsTerminalMode.FILTERED) {
            throw new IllegalArgumentException("Illegal Formatted");
        }
    }

    @Override
    public NutsTerminalModeOp getModeOp() {
        return NutsTerminalModeOp.UNESCAPE;
    }

    public OutputStream getOut() {
        return this.out;
    }

    private String filterThanEscape(String b) throws IOException {
        NutsTextManager txt = this.ws.text().setSession(this.session);
        String filtered = txt.builder().append((Object)b).filteredText();
        return txt.forPlain(filtered).toString();
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(this.filterThanEscape(Character.toString((char)b)).getBytes());
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        byte[] bytes = this.filterThanEscape(new String(b, off, len)).getBytes();
        this.out.write(bytes, 0, bytes.length);
    }

    @Override
    public ExtendedFormatAware convert(NutsTerminalModeOp other) {
        if (other == null || other == this.getModeOp()) {
            return this;
        }
        switch (other) {
            case NOP: {
                if (this.out instanceof ExtendedFormatAware) {
                    return ((ExtendedFormatAware)((Object)this.out)).convert(NutsTerminalModeOp.NOP);
                }
                return new RawOutputStream(this.out, this.session);
            }
            case FORMAT: {
                if (this.out instanceof ExtendedFormatAware) {
                    return ((ExtendedFormatAware)((Object)this.out)).convert(NutsTerminalModeOp.FORMAT);
                }
                return new FormatOutputStream(this.out, this.session);
            }
            case FILTER: {
                if (this.out instanceof ExtendedFormatAware) {
                    return ((ExtendedFormatAware)((Object)this.out)).convert(NutsTerminalModeOp.FILTER);
                }
                return this;
            }
            case ESCAPE: {
                return (ExtendedFormatAware)((Object)this.out);
            }
            case UNESCAPE: {
                return (ExtendedFormatAware)((Object)this.out);
            }
        }
        throw new IllegalArgumentException("Unsupported");
    }
}

