/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.text;

import java.io.OutputStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.core.format.text.EscapeOutputStream;
import net.thevpc.nuts.runtime.core.format.text.ExtendedFormatAware;
import net.thevpc.nuts.runtime.core.format.text.FPrint;
import net.thevpc.nuts.runtime.core.format.text.FormatOutputStream;
import net.thevpc.nuts.runtime.core.format.text.RawOutputStream;
import net.thevpc.nuts.runtime.core.format.text.RenderedOutputStream;
import net.thevpc.nuts.runtime.core.format.text.UnescapeOutputStream;
import net.thevpc.nuts.runtime.core.terminals.NutsTerminalModeOp;

public class FilterFormatOutputStream
extends RenderedOutputStream
implements ExtendedFormatAware {
    public FilterFormatOutputStream(OutputStream out, NutsSession session) {
        super(out, FPrint.RENDERER_ANSI_STRIPPER, session);
    }

    @Override
    public NutsTerminalModeOp getModeOp() {
        return NutsTerminalModeOp.FILTER;
    }

    @Override
    public ExtendedFormatAware convert(NutsTerminalModeOp other) {
        if (other == null || other == this.getModeOp()) {
            return this;
        }
        switch (other) {
            case NOP: {
                if (this.out instanceof ExtendedFormatAware) {
                    NutsTerminalModeOp m = ((ExtendedFormatAware)((Object)this.out)).getModeOp();
                    return (ExtendedFormatAware)((Object)this.out);
                }
                return new RawOutputStream(this.out, this.session);
            }
            case FORMAT: {
                return new FormatOutputStream(this.out, this.session);
            }
            case FILTER: {
                return this;
            }
            case ESCAPE: {
                return new EscapeOutputStream(this, this.session);
            }
            case UNESCAPE: {
                return new UnescapeOutputStream(this, this.session);
            }
        }
        throw new IllegalArgumentException("Unsupported");
    }
}

